/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.guifilters.ElementTextSet;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.guifilters.ElementTypeSet;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.GUIFilterPatternCache;
import ro.amiq.dvt.ui.guifilters.PathSet;
import ro.amiq.dvt.ui.guifilters.PrecompiledFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class DVTGUIFilterMatcher {
    protected ViewSet.ViewName fViewName;
    protected String fParserPath;
    protected IReparseStackProvider fReparsePathsProvider;
    protected List<GUIFilter> fFilters;
    protected IProject fProject;
    protected ITypeProvider fTypeProvider = () -> null;
    protected ITextProvider fTextProvider = () -> null;
    protected boolean isPrecompiled;

    protected GUIFilterResult matches() {
        if (this.fViewName == null) {
            return GUIFilterResult.NOT_FILTERED;
        }
        if (this.fFilters == null || this.fFilters.isEmpty()) {
            return GUIFilterResult.NOT_FILTERED;
        }
        for (GUIFilter filter : this.fFilters) {
            if (!this.matches(filter)) continue;
            return GUIFilterResult.from(filter.getType().toString());
        }
        return GUIFilterResult.NOT_FILTERED;
    }

    public static boolean simpleXVMPathMatch(IRfDefElement declaration, List<GUIFilter> expandedXVMGUIFilters) {
        if (declaration == null || expandedXVMGUIFilters == null) {
            return true;
        }
        String parserPath = null;
        if (declaration.getDefFile() != null && declaration.getParserPath() != null) {
            parserPath = declaration.getParserPath().path;
        }
        return DVTGUIFilterMatcher.simpleXVMPathMatch(parserPath, expandedXVMGUIFilters);
    }

    public static boolean simpleXVMPathMatch(String parserPath, List<GUIFilter> expandedXVMGUIFilters) {
        if (parserPath == null || expandedXVMGUIFilters == null) {
            return true;
        }
        for (GUIFilter guiFilter : expandedXVMGUIFilters) {
            PathSet pathSet = guiFilter.getPathSet();
            if (!DVTGUIFilterMatcher.matches(pathSet, parserPath)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(GUIFilter filter) {
        PrecompiledFilter precompiledFilter;
        Boolean view = null;
        Boolean path = null;
        Boolean elementText = null;
        Boolean elementType = null;
        ViewSet viewSet = filter.getViewSet();
        if (viewSet != null) {
            if (this.fViewName == null) {
                return false;
            }
            view = viewSet.isMatch() ? this.matches(viewSet) : !this.matches(viewSet);
        }
        if (view != null && !view.booleanValue()) {
            return false;
        }
        PathSet pathSet = filter.getPathSet();
        if (pathSet != null) {
            if (this.fParserPath == null) {
                return false;
            }
            path = pathSet.isMatch() ? this.matches(pathSet) : !this.matches(pathSet);
        }
        if (path != null && !path.booleanValue()) {
            return false;
        }
        ElementTextSet elementTextSet = filter.getElementTextSet();
        if (elementTextSet != null) {
            if (this.fTextProvider.getText() == null) {
                return false;
            }
            elementText = elementTextSet.isMatch() ? this.matches(elementTextSet) : !this.matches(elementTextSet);
        }
        if (elementText != null && !elementText.booleanValue()) {
            return false;
        }
        ElementTypeSet elementTypeSet = filter.getElementTypeSet();
        if (elementTypeSet != null) {
            if (this.fTypeProvider.getElementType() == null) {
                return false;
            }
            elementType = elementTypeSet.isMatch() ? this.matches(elementTypeSet) : !this.matches(elementTypeSet);
        }
        if ((precompiledFilter = filter.getPrecompiledFilter()) != null) {
            boolean precompiledFilterMatch;
            boolean bl = precompiledFilter.isMatch() ? this.matches(precompiledFilter) : (precompiledFilterMatch = !this.matches(precompiledFilter));
            if (precompiledFilterMatch) {
                return false;
            }
        }
        if (elementType != null && !elementType.booleanValue()) {
            return false;
        }
        return view != null || path != null || elementText != null || elementType != null;
    }

    private boolean matches(ViewSet viewSet) {
        return viewSet.getViews().contains((Object)this.fViewName);
    }

    private boolean matches(PathSet pathSet) {
        if (DVTGUIFilterMatcher.matches(pathSet, this.fParserPath)) {
            return true;
        }
        if (pathSet.isMatchThroughMacro(this.fViewName) && this.fReparsePathsProvider != null) {
            Set<String> reparseParserPaths = this.fReparsePathsProvider.getReparseParserPaths();
            if (reparseParserPaths == null || reparseParserPaths.isEmpty()) {
                return false;
            }
            for (String parserPath : reparseParserPaths) {
                if (!DVTGUIFilterMatcher.matches(pathSet, parserPath)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matches(PathSet pathSet, String parserPath) {
        Set<String> paths = pathSet.getPaths();
        if (paths != null && !paths.isEmpty() && paths.contains(parserPath)) {
            return true;
        }
        Set<String> pathPatterns = pathSet.getPathPatterns();
        if (pathPatterns != null && !pathPatterns.isEmpty()) {
            if (pathPatterns.contains(parserPath)) {
                return true;
            }
            for (String pattern : pathPatterns) {
                if (!GUIFilterPatternCache.getInstance().getCachedStringMatcher(pattern, true).match(parserPath)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(ElementTextSet elementTextSet) {
        for (String pattern : elementTextSet.getElementTextPatterns()) {
            String text = this.fTextProvider.getText();
            if (text == null) {
                return false;
            }
            if (!GUIFilterPatternCache.getInstance().getCachedStringMatcher(pattern, false).match(text)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(ElementTypeSet elementTypeSet) {
        if (this.fViewName.equals((Object)ViewSet.ViewName.PROBLEMS) || this.fViewName.equals((Object)ViewSet.ViewName.TASKS) || this.fViewName.equals((Object)ViewSet.ViewName.SEARCH)) {
            return true;
        }
        if (this.fTypeProvider.getElementType().equals(new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.PSS))) {
            return false;
        }
        return elementTypeSet.getElementTypes().contains(this.fTypeProvider.getElementType());
    }

    private boolean matches(PrecompiledFilter precompiledFilter) {
        return !this.isPrecompiled;
    }

    public static enum GUIFilterResult {
        NOT_FILTERED,
        PREFERENCE,
        PREDEFINED,
        USER_DEFINED;


        public static GUIFilterResult from(String n) {
            if (n == null) {
                return null;
            }
            GUIFilterResult[] gUIFilterResultArray = GUIFilterResult.values();
            int n2 = gUIFilterResultArray.length;
            int n3 = 0;
            while (n3 < n2) {
                GUIFilterResult result = gUIFilterResultArray[n3];
                if (result.toString().equalsIgnoreCase(n.trim())) {
                    return result;
                }
                ++n3;
            }
            return null;
        }

        public static String valuesList() {
            return DVTStringUtil.join(Arrays.asList(GUIFilterResult.values()), ",");
        }

        public GUIFilterResult mostRelevant(GUIFilterResult other) {
            if (other == null) {
                return this;
            }
            if (other.ordinal() > this.ordinal()) {
                return other;
            }
            return this;
        }
    }

    public static interface IReparseStackProvider {
        public Set<String> getReparseParserPaths();
    }

    public static interface ITextProvider {
        public String getText();
    }

    public static interface ITypeProvider {
        public ElementType getElementType();
    }
}

