/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.ViewsUtils;

public class DVTGUIFiltersPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ro.amiq.dvt.ui.guifilters.DVTGUIFiltersPreferencePage";
    public static final String OVM_LIBRARY = "OVM library";
    public static final String UVM_LIBRARY = "UVM library";
    public static final String VMM_LIBRARY = "VMM library";
    public static final String XILINX_LIBRARIES = "Xilinx libraries";
    public static final String PERSPEC_LIBRARIES = "Perspec libraries";
    public static final String C_SYSTEM_HEADERS = "C/C++ system headers";
    public static final String PSS_C_HEADERS = "PSS C/C++ headers";
    public static final String SYSTEMC_HEADERS = "SystemC headers";
    public static final String PRECOMPILED_DATABASES = "Precompiled databases";
    BooleanFieldEditor fFilterOVMLibrary;
    BooleanFieldEditor fFilterUVMLibrary;
    BooleanFieldEditor fFilterVMMLibrary;
    BooleanFieldEditor fFilterXilinxLibraries;
    BooleanFieldEditor fFilterPerspecLibraries;
    BooleanFieldEditor fFilterCSystemHeaders;
    BooleanFieldEditor fFilterPSSCHeaders;
    BooleanFieldEditor fFilterSystemCHeaders;
    BooleanFieldEditor fFilterPrecompiledDatabases;

    public void init(IWorkbench _workbench) {
    }

    public DVTGUIFiltersPreferencePage() {
        super(1);
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.setDescription("Filter out elements from the following libraries:");
    }

    protected Control createContents(Composite parent) {
        Control superParent = super.createContents(parent);
        Composite noteContainer = new Composite(parent, 0);
        noteContainer.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 4, true, false);
        noteContainer.setLayoutData((Object)layoutData);
        this.createNoteComposite(parent.getFont(), noteContainer, "Note:", "The above Content Filters are applied to the following views:\nCall Hierachy, Checks, Coverage, Diagrams, Field Editor,\nMacros, Outline, Problems, Scope Breadcrumb Navigation Bar,\nSearch, Tasks, Type Hierarchy, Members Panel, Types,\nUVM Browser Classes and Members, Panel,\nUVM Sequence Tree, Verification Hierarchy\n");
        return superParent;
    }

    protected void createFieldEditors() {
        this.fFilterOVMLibrary = new BooleanFieldEditor("guiFiltersHideOVMLibrary", OVM_LIBRARY, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterOVMLibrary);
        this.fFilterUVMLibrary = new BooleanFieldEditor("guiFiltersHideUVMLibrary", UVM_LIBRARY, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterUVMLibrary);
        this.fFilterVMMLibrary = new BooleanFieldEditor("guiFiltersHideVMMLibrary", VMM_LIBRARY, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterVMMLibrary);
        this.fFilterXilinxLibraries = new BooleanFieldEditor("guiFiltersHideXilinxLibraries", XILINX_LIBRARIES, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterXilinxLibraries);
        this.fFilterPerspecLibraries = new BooleanFieldEditor("guiFiltersHidePerspecLibraries", PERSPEC_LIBRARIES, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterPerspecLibraries);
        this.fFilterCSystemHeaders = new BooleanFieldEditor("guiFiltersHideCSystemHeaders", C_SYSTEM_HEADERS, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterCSystemHeaders);
        this.fFilterPSSCHeaders = new BooleanFieldEditor("guiFiltersHidePSSCHeaders", PSS_C_HEADERS, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterPSSCHeaders);
        this.fFilterSystemCHeaders = new BooleanFieldEditor("guiFiltersHideSystemCHeaders", SYSTEMC_HEADERS, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterSystemCHeaders);
        this.fFilterPrecompiledDatabases = new BooleanFieldEditor("guiFiltersHidePrecompiledDatabases", PRECOMPILED_DATABASES, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fFilterPrecompiledDatabases);
    }

    public boolean performOk() {
        boolean modified = this.fFilterOVMLibrary.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHideOVMLibrary") || this.fFilterUVMLibrary.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHideUVMLibrary") || this.fFilterVMMLibrary.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHideVMMLibrary") || this.fFilterXilinxLibraries.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHideXilinxLibraries") || this.fFilterPerspecLibraries.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHidePerspecLibraries") || this.fFilterCSystemHeaders.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHideCSystemHeaders") || this.fFilterPSSCHeaders.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHidePSSCHeaders") || this.fFilterSystemCHeaders.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHideSystemCHeaders") || this.fFilterPrecompiledDatabases.getBooleanValue() != this.getPreferenceStore().getBoolean("guiFiltersHidePrecompiledDatabases");
        boolean result = super.performOk();
        if (result && modified) {
            DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifyViewsWithBuildEvents(BuildEvents.GUI_FILTERS_PROJECT, DVTPlugin.getSelectionManager().getLastSelectedProject(), ViewsUtils.ALL_VIEWS);
        }
        return result;
    }
}

