/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.PathSet;
import ro.amiq.dvt.utils.StringMatcher;

public class DVTGUIFiltersTopFilePatternExpander {
    public static void expand(List<GUIFilter> guiFilters, IProject project) {
        if (project == null || !project.isOpen()) {
            return;
        }
        HashMap<StringMatcher, Set<String>> expanded = new HashMap<StringMatcher, Set<String>>();
        for (GUIFilter guiFilter : guiFilters) {
            if (guiFilter.getPathSet() == null) continue;
            for (String pattern : guiFilter.getPathSet().getPathTopFilePatterns()) {
                expanded.put(new StringMatcher(pattern, false, false, true), new HashSet());
            }
        }
        for (String natureId : Arrays.asList("ro.amiq.edt.enature", "ro.amiq.slndt.slnnature", "ro.amiq.msdldt.msdlnature", "ro.amiq.pssdt.pssnature", "ro.amiq.vlogdt.VlogNature", "ro.amiq.vhdldt.VhdlNature", "ro.amiq.dvt.cdt.cppnature")) {
            IRfSingleLangProject rfSingleLangManager;
            if (!DVTNature.hasNature(project, natureId) || (rfSingleLangManager = RfMixedLangManager.getInstance().getRfSingleLangProject(project, natureId, true)) == null) continue;
            rfSingleLangManager.computeFilesIncludedByMatchingTop(expanded);
        }
        for (GUIFilter guiFilter : guiFilters) {
            PathSet pathSet = guiFilter.getPathSet();
            if (pathSet == null) continue;
            Iterator<String> iterator = pathSet.getPathTopFilePatterns().iterator();
            while (iterator.hasNext()) {
                String pattern = iterator.next();
                if (expanded.get(new StringMatcher(pattern, false, false, true)).isEmpty()) continue;
                iterator.remove();
                for (String expandedPath : expanded.get(new StringMatcher(pattern, false, false, true))) {
                    pathSet.addPath(expandedPath);
                }
            }
        }
    }
}

