/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersXMLParser1;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersXMLParser2;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersXMLParser3;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.utils.XMLErrorHandler;

public abstract class DVTGUIFiltersXMLParser {
    protected static final String TAG_FILTERS = "content-filters";
    private final File fFile;
    private final IProject fProject;
    protected List<String> fMessages = new ArrayList<String>();

    protected DVTGUIFiltersXMLParser(IProject project, File file) {
        this.fFile = file;
        this.fProject = project;
    }

    public abstract void save(List<GUIFilter> var1) throws Exception;

    public abstract List<GUIFilter> load() throws Exception;

    public File getFile() {
        return this.fFile;
    }

    public static DVTGUIFiltersXMLParser newParser(IProject project, File file) throws Exception {
        String version = DVTGUIFiltersXMLParser.detectVersion(file);
        return DVTGUIFiltersXMLParser.newParser(project, file, version);
    }

    private static DVTGUIFiltersXMLParser newParser(IProject project, File file, String version) throws Exception {
        if ("3".equals(version)) {
            return new DVTGUIFiltersXMLParser3(project, file);
        }
        if ("2".equals(version)) {
            return new DVTGUIFiltersXMLParser2(project, file);
        }
        if ("1".equals(version)) {
            return new DVTGUIFiltersXMLParser1(project, file);
        }
        throw new IllegalArgumentException("Unknown content filters file version " + version + ".");
    }

    private static String detectVersion(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList waiversNodes = document.getElementsByTagName(TAG_FILTERS);
        if (waiversNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)waiversNodes.item(0);
        return waiversNode.getAttribute("version");
    }

    public List<String> getMessages() {
        return this.fMessages;
    }

    public IProject getProject() {
        return this.fProject;
    }
}

