/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTMarkerGUIFilterMatcher
extends DVTGUIFilterMatcher {
    private IMarker fMarker;

    private DVTMarkerGUIFilterMatcher(IMarker marker) {
        if (!marker.exists()) {
            return;
        }
        try {
            if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                this.fViewName = ViewSet.ViewName.PROBLEMS;
            } else if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                this.fViewName = ViewSet.ViewName.TASKS;
            }
            this.fMarker = marker;
            this.fProject = this.fMarker.getResource().getProject();
            Map markerAttributes = marker.getAttributes();
            if (markerAttributes == null) {
                return;
            }
            if (markerAttributes.containsKey("ro.amiq.dvt.file_name")) {
                this.fParserPath = (String)markerAttributes.get("ro.amiq.dvt.file_name");
            } else {
                ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(this.fMarker.getResource());
                if (parserPath != null) {
                    this.fParserPath = parserPath.path;
                }
            }
            if (this.fParserPath != null) {
                this.isPrecompiled = PrecompiledDBUtils.isPrecompiledFile(this.fProject, this.fParserPath);
            }
            this.fTextProvider = () -> marker.getAttribute("message", "");
            this.fFilters = DVTViewManager.getGuiFilters(this.fProject, this.fViewName);
        }
        catch (CoreException coreException) {}
    }

    public static DVTGUIFilterMatcher.GUIFilterResult filterElement(IMarker marker) {
        return new DVTMarkerGUIFilterMatcher(marker).matches();
    }
}

