/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;

public class DVTMarkerViewsUpdater {
    private static final String SCHEDULE_UPDATE_METHOD = "scheduleUpdate";
    private static final String BUILDER_FIELD = "builder";
    private static final String[] MARKER_VIEW_IDS = new String[]{"org.eclipse.ui.views.ProblemView", "org.eclipse.ui.views.TaskList", "org.eclipse.ui.views.AllMarkersView"};

    public static void updateMarkerViews() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = Utils.getActiveWorkbenchWindow().getActivePage();
                String[] stringArray = MARKER_VIEW_IDS;
                int n = MARKER_VIEW_IDS.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    IViewPart view = activePage.findView(id);
                    if (view instanceof ExtendedMarkersView) {
                        ExtendedMarkersView markersView = (ExtendedMarkersView)view;
                        try {
                            Field builderField = ExtendedMarkersView.class.getDeclaredField(DVTMarkerViewsUpdater.BUILDER_FIELD);
                            builderField.setAccessible(true);
                            Method scheduleUpdateMethod = CachedMarkerBuilder.class.getDeclaredMethod(DVTMarkerViewsUpdater.SCHEDULE_UPDATE_METHOD, Long.TYPE);
                            scheduleUpdateMethod.setAccessible(true);
                            scheduleUpdateMethod.invoke(builderField.get(markersView), 0L);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
        });
    }
}

