/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.util.Collection;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTViewManager;

public class DVTNamedElementGUIFilterMatcher
extends DVTGUIFilterMatcher {
    private IRfNamedElement fNamedElement;
    private IRfDefElement fDeclaration;
    private ElementPath fInstancePath;

    public DVTNamedElementGUIFilterMatcher(ViewSet.ViewName viewName, IRfNamedElement namedElement, IRfDefElement declaration, ElementPath instancePath, DVTGUIFilterMatcher.ITextProvider textProvider) {
        this.fViewName = viewName;
        this.fNamedElement = namedElement;
        this.fDeclaration = declaration;
        this.fViewName = viewName;
        this.fInstancePath = instancePath;
        if (this.fNamedElement == null) {
            return;
        }
        this.isPrecompiled = namedElement.isPrecompiledDB();
        IRfSingleLangProject rfProject = this.fNamedElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.fProject = rfProject.getProject();
        this.fTextProvider = textProvider;
        this.fFilters = DVTViewManager.getGuiFilters(this.fProject, viewName);
        if (this.fFilters == null || this.fFilters.isEmpty()) {
            return;
        }
        if (this.fDeclaration != null) {
            if (this.fDeclaration.getDefFile() != null && this.fDeclaration.getParserPath() != null) {
                this.fParserPath = this.fDeclaration.getParserPath().path;
            }
            this.fTypeProvider = () -> rfProject.computeElementType(this.fDeclaration, this.fNamedElement, this.fInstancePath);
        } else {
            this.fTypeProvider = () -> rfProject.computeElementType(this.fNamedElement, this.fInstancePath);
        }
        this.fReparsePathsProvider = () -> rfProject.computeFilesInMacroReparseStack(this.fDeclaration);
    }

    public static DVTGUIFilterMatcher.GUIFilterResult filterElement(ViewSet.ViewName viewName, IRfNamedElement namedElement, ElementPath instancePath, DVTGUIFilterMatcher.ITextProvider textProvider) {
        return new DVTNamedElementGUIFilterMatcher(viewName, namedElement, namedElement.getDeclaration(), instancePath, textProvider).matches();
    }

    public static DVTGUIFilterMatcher.GUIFilterResult filterElement(DVTNamedElementGUIFilterMatcher guiFilterMatcher) {
        return guiFilterMatcher.matches();
    }

    public static DVTGUIFilterMatcher.GUIFilterResult filterElement(ViewSet.ViewName viewName, IRfNamedElement namedElement, DVTGUIFilterMatcher.ITextProvider textProvider) {
        Collection<? extends IRfDefElement> declarations = namedElement.getDeclarations();
        if (DVTNamedElementGUIFilterMatcher.hasNoUserDefs(declarations)) {
            return new DVTNamedElementGUIFilterMatcher(viewName, namedElement, null, null, textProvider).matches();
        }
        DVTGUIFilterMatcher.GUIFilterResult result = DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED;
        for (IRfDefElement iRfDefElement : declarations) {
            if (iRfDefElement.getDefFile() == null || iRfDefElement.isPredefinedDef()) continue;
            DVTGUIFilterMatcher.GUIFilterResult defResult = new DVTNamedElementGUIFilterMatcher(viewName, namedElement, iRfDefElement, null, textProvider).matches();
            if (defResult == DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                return DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED;
            }
            result = result.mostRelevant(defResult);
        }
        return result;
    }

    private static boolean hasNoUserDefs(Collection<? extends IRfDefElement> declarations) {
        if (declarations == null) {
            return true;
        }
        if (declarations.isEmpty()) {
            return true;
        }
        for (IRfDefElement iRfDefElement : declarations) {
            if (iRfDefElement.getDefFile() == null || iRfDefElement.isPredefinedDef()) continue;
            return false;
        }
        return true;
    }

    public static DVTGUIFilterMatcher.GUIFilterResult filterElement(ViewSet.ViewName viewName, IRfDefElement defElement, DVTGUIFilterMatcher.ITextProvider textProvider) {
        return new DVTNamedElementGUIFilterMatcher(viewName, defElement.getNamedElement(), defElement, null, textProvider).matches();
    }
}

