/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.ui.guifilters.ElementTextSet;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.guifilters.ElementTypeSet;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.PathSet;
import ro.amiq.dvt.ui.guifilters.PrecompiledFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.GCCUtils;

public class DVTPredefinedGUIFilters {
    private static final String UVM_E_TOP_FILE_PATTERN = "*" + File.separator + "uvm_e_top.e";
    private static final String UVM_SV_TOP_FILE_PATTERN_PKG = "*" + File.separator + "uvm_pkg.sv";
    private static final String ML_UVM_SV_TOP_FILE_PATTERN_PKG = "*" + File.separator + "ml_uvm_pkg.sv";
    private static final String UVM_SV_TOP_FILE_PATTERN = "*" + File.separator + "uvm.svh";
    private static final String QUESTA_UVM_SV_TOP_FILE_PATTERN_PKG = "*" + File.separator + "questa_uvm_pkg.sv";
    private static final String IUS_UVM_SV_TOP_FILE_PATTERN_PKG = "*" + File.separator + "cdns_uvm_pkg.sv";
    private static final String OVM_E_TOP_FILE_PATTERN = "*" + File.separator + "ovm_e_top.e";
    private static final String OVM_SV_TOP_FILE_PATTERN_PKG = "*" + File.separator + "ovm_pkg.sv";
    private static final String OVM_SV_TOP_FILE_PATTERN = "*" + File.separator + "ovm.svh";
    private static final String VMM_TOP_FILE_PATTERN = "*" + File.separator + "vmm.sv";
    private static final String VR_AD_E_TOP_FILE_PATTERN = "*" + File.separator + "vr_ad_top.e";
    private static final String SCBD_E_TOP_FILE_PATTERN = "*" + File.separator + "uvm_scbd_top.e";
    private static final String PSS_C_PATTERN = "*" + File.separator + "include/pss/*";
    private static final String SYSTEMC_PATTERN1 = "*" + File.separator + "src/sysc/*";
    private static final String SYSTEMC_PATTERN2 = "*" + File.separator + "libs/systemc*";
    private static final String TYPES_VIEW_SHOW_OVM_TYPES = "showOVMTypesView";
    private static final String TYPES_VIEW_SHOW_UVM_TYPES = "showUVMTypesView";
    private static final String TYPES_VIEW_SHOW_VMM_TYPES = "showVMMTypesView";
    private static final String TYPES_VIEW_SHOW_C_SYSTEM_TYPES = "showCSystemTypesView";
    private static final String TYPES_VIEW_SHOW_PSS_C_TYPES = "showPSSCTypesView";
    private static final String TYPES_VIEW_SHOW_SYSTEMC_TYPES = "showSystemCTypesView";
    private static final String TYPES_VIEW_SHOW_PRECOMPILED_TYPES = "showPrecompiledTypesView";
    public static final String GUI_FILTERED_INDICATION = "Content Filters matched!";
    public static final String GUI_FILTERS_QUICK_VIEW_INDICATION = "*";
    private static Map<LanguageKind, GUIFilter> fOutlinePredefinedGUIFilters = new EnumMap<LanguageKind, GUIFilter>(LanguageKind.class);

    public static void putOutlinePredefinedGUIFilter(LanguageKind language, IPreferenceStore store) {
        fOutlinePredefinedGUIFilters.put(language, DVTPredefinedGUIFilters.getPredefinedOutlineFilter(language, store));
    }

    public static GUIFilter getPredefinedOutlineFilter(LanguageKind language, IPreferenceStore store) {
        ViewSet viewSet = new ViewSet();
        viewSet.setMatch(true);
        viewSet.addView(ViewSet.ViewName.OUTLINE);
        ElementTypeSet elementTypeSet = new ElementTypeSet();
        elementTypeSet.setMatch(true);
        GUIFilter filter = new GUIFilter();
        filter.setType(GUIFilter.FilterType.PREFERENCE);
        filter.setKind(GUIFilter.FilterKind.HIDE);
        filter.setName("Predefined " + language.DISPLAY_NAME + " Outline Filter");
        filter.setViewSet(viewSet);
        filter.setElementTypeSet(elementTypeSet);
        switch (language) {
            case SLN: {
                if (!store.getBoolean("outline.show_macros")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.MACRO, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_fields")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_methods")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.METHOD, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_methodtypes")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.METHOD_TYPE, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_expects")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EXPECT, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_onevent")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ONEVENT, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_coverdefs")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_events")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_structs")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_types")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_actions")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ACTION, ElementType.ElementTypeLanguage.SLN));
                }
                if (!store.getBoolean("outline.show_components")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COMPONENT, ElementType.ElementTypeLanguage.SLN));
                }
                if (store.getBoolean("outline.show_tokens")) break;
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TOKEN, ElementType.ElementTypeLanguage.SLN));
                break;
            }
            case E: {
                if (!store.getBoolean("outline.show_macros")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.MACRO, ElementType.ElementTypeLanguage.E));
                }
                if (!store.getBoolean("outline.show_fields")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.E));
                }
                if (!store.getBoolean("outline.show_methods")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.METHOD, ElementType.ElementTypeLanguage.E));
                }
                if (!store.getBoolean("outline.show_methodtypes")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.METHOD_TYPE, ElementType.ElementTypeLanguage.E));
                }
                if (!store.getBoolean("outline.show_expects")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EXPECT, ElementType.ElementTypeLanguage.E));
                }
                if (!store.getBoolean("outline.show_onevent")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ONEVENT, ElementType.ElementTypeLanguage.E));
                }
                if (!store.getBoolean("outline.show_coverdefs")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.E));
                }
                if (!store.getBoolean("outline.show_events")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.E));
                }
                if (!store.getBoolean("outline.show_structs")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.E));
                }
                if (store.getBoolean("outline.show_types")) break;
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.E));
                break;
            }
            case VLOG: {
                if (!store.getBoolean("outline.show_asserts")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ASSERT, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_blocks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_checkers")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CHECKER, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_checker_instantiations")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CHECKER_INSTANCE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_classes")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CLASS, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_clocking_blocks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CLOCKING_BLOCK, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_constraints")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CONSTRAINT, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_covergroups")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_fields")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_events")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_expects")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EXPECT, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_functions")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_generate_blocks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.GENERATE_BLOCK, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_interfaces")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.INTERFACE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_interface_instantiations")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.INTERFACE_INSTANCE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_modports")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.MODPORT, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_modules")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.MODULE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_module_instantiations")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.MODULE_INSTANCE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_packages")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_parameters")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PARAMETER, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_ports")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PORT, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_primitives")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PRIMITIVE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_programs")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PROGRAM, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_program_instantiations")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PROGRAM_INSTANCE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_sequences")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PROPERTY_SEQUENCE, ElementType.ElementTypeLanguage.SV));
                }
                if (!store.getBoolean("outline.show_tasks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TASK, ElementType.ElementTypeLanguage.SV));
                }
                if (store.getBoolean("outline.show_types")) break;
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.SV));
                break;
            }
            case VHDL: {
                if (!store.getBoolean("outline.show_architectures")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ARCHITECTURE, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_packages")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_package_bodies")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PACKAGE_BODY, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_blocks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_configurations")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CONFIGURATION, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_entities")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ENTITY, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_components")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COMPONENT, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_ports")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PORT, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_variables")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.VARIABLE, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_signals")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.SIGNAL, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_functions")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_instances")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.INSTANCE, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_processes")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PROCESS, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_sequences")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PROPERTY_SEQUENCE, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_types")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_type_bodies")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TYPE_BODY, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_vunits")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.VUNIT, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_aliases")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ALIAS, ElementType.ElementTypeLanguage.VHDL));
                }
                if (!store.getBoolean("outline.show_package_instances")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PACKAGE_INSTANCE, ElementType.ElementTypeLanguage.VHDL));
                }
                if (store.getBoolean("outline.show_subprogram_instances")) break;
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.SUBPROGRAM_INSTANCE, ElementType.ElementTypeLanguage.VHDL));
                break;
            }
            case PSS: {
                if (!store.getBoolean("outline.show_packages")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_components")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COMPONENT, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_constraints")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CONSTRAINT, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_structs")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_actions")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ACTION, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_covergroups")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_types")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_functions")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_activities")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ACTIVITY, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_exec_blocks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EXEC_BLOCK, ElementType.ElementTypeLanguage.PSS));
                }
                if (!store.getBoolean("outline.show_blocks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.PSS));
                }
                if (store.getBoolean("outline.show_fields")) break;
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.PSS));
                break;
            }
            case MSDL: {
                if (!store.getBoolean("outline.show_packages")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_components")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COMPONENT, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_structs")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_actions")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ACTION, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_covergroups")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_types")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_functions")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_activities")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.ACTIVITY, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_exec_blocks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EXEC_BLOCK, ElementType.ElementTypeLanguage.MSDL));
                }
                if (!store.getBoolean("outline.show_blocks")) {
                    elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.MSDL));
                }
                if (store.getBoolean("outline.show_fields")) break;
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.MSDL));
                break;
            }
        }
        return filter;
    }

    public static GUIFilter getPredefinedOVMMacroFilter() {
        ViewSet viewSet = new ViewSet();
        viewSet.setMatch(true);
        viewSet.addView(ViewSet.ViewName.MACRO);
        PathSet ovmPathSet = new PathSet();
        ovmPathSet.setMatch(true);
        ovmPathSet.setMatchThroughMacro(true);
        ovmPathSet.addPathTopFilePattern(OVM_SV_TOP_FILE_PATTERN);
        ovmPathSet.addPathTopFilePattern(OVM_SV_TOP_FILE_PATTERN_PKG);
        GUIFilter filter = new GUIFilter();
        filter.setType(GUIFilter.FilterType.PREDEFINED);
        filter.setKind(GUIFilter.FilterKind.HIDE);
        filter.setName("OVM Predefined Macros View Filter");
        filter.setViewSet(viewSet);
        filter.setPathSet(ovmPathSet);
        ElementTextSet elementTextSet = new ElementTextSet();
        filter.setElementTextSet(elementTextSet);
        elementTextSet.setMatch(false);
        elementTextSet.addElementTextPattern("ovm_phase_func_decl");
        elementTextSet.addElementTextPattern("ovm_phase_task_decl");
        elementTextSet.addElementTextPattern("ovm_phase_func_topdown_decl");
        elementTextSet.addElementTextPattern("ovm_phase_func_bottomup_decl");
        elementTextSet.addElementTextPattern("ovm_phase_task_topdown_decl");
        elementTextSet.addElementTextPattern("ovm_phase_task_bottomup_decl");
        elementTextSet.addElementTextPattern("ovm_info");
        elementTextSet.addElementTextPattern("ovm_warning");
        elementTextSet.addElementTextPattern("ovm_error");
        elementTextSet.addElementTextPattern("ovm_fatal");
        elementTextSet.addElementTextPattern("ovm_field_utils_begin");
        elementTextSet.addElementTextPattern("ovm_field_utils_end");
        elementTextSet.addElementTextPattern("ovm_object_utils");
        elementTextSet.addElementTextPattern("ovm_object_param_utils");
        elementTextSet.addElementTextPattern("ovm_object_utils_begin");
        elementTextSet.addElementTextPattern("ovm_object_param_utils_begin");
        elementTextSet.addElementTextPattern("ovm_object_utils_end");
        elementTextSet.addElementTextPattern("ovm_component_utils");
        elementTextSet.addElementTextPattern("ovm_component_param_utils");
        elementTextSet.addElementTextPattern("ovm_component_utils_begin");
        elementTextSet.addElementTextPattern("ovm_component_param_utils_begin");
        elementTextSet.addElementTextPattern("ovm_component_utils_end");
        elementTextSet.addElementTextPattern("ovm_field_int");
        elementTextSet.addElementTextPattern("ovm_field_object");
        elementTextSet.addElementTextPattern("ovm_field_string");
        elementTextSet.addElementTextPattern("ovm_field_enum");
        elementTextSet.addElementTextPattern("ovm_field_real");
        elementTextSet.addElementTextPattern("ovm_field_event");
        elementTextSet.addElementTextPattern("ovm_field_sarray_int");
        elementTextSet.addElementTextPattern("ovm_field_sarray_object");
        elementTextSet.addElementTextPattern("ovm_field_sarray_string");
        elementTextSet.addElementTextPattern("ovm_field_sarray_enum");
        elementTextSet.addElementTextPattern("ovm_field_array_int");
        elementTextSet.addElementTextPattern("ovm_field_array_object");
        elementTextSet.addElementTextPattern("ovm_field_array_string");
        elementTextSet.addElementTextPattern("ovm_field_array_enum");
        elementTextSet.addElementTextPattern("ovm_field_queue_int");
        elementTextSet.addElementTextPattern("ovm_field_queue_object");
        elementTextSet.addElementTextPattern("ovm_field_queue_string");
        elementTextSet.addElementTextPattern("ovm_field_queue_enum");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_string");
        elementTextSet.addElementTextPattern("ovm_field_aa_object_string");
        elementTextSet.addElementTextPattern("ovm_field_aa_string_string");
        elementTextSet.addElementTextPattern("ovm_field_aa_object_int");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_int");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_int_unsigned");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_integer");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_integer_unsigned");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_byte");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_byte_unsigned");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_shortint");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_shortint_unsigned");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_longint");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_longint_unsigned");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_key");
        elementTextSet.addElementTextPattern("ovm_field_aa_int_enumkey");
        elementTextSet.addElementTextPattern("ovm_declare_p_sequencer");
        elementTextSet.addElementTextPattern("ovm_sequence_utils_begin");
        elementTextSet.addElementTextPattern("ovm_sequence_utils_end");
        elementTextSet.addElementTextPattern("ovm_sequence_utils");
        elementTextSet.addElementTextPattern("ovm_update_sequence_lib");
        elementTextSet.addElementTextPattern("ovm_update_sequence_lib_and_item");
        elementTextSet.addElementTextPattern("ovm_sequencer_utils");
        elementTextSet.addElementTextPattern("ovm_sequencer_utils_begin");
        elementTextSet.addElementTextPattern("ovm_sequencer_param_utils");
        elementTextSet.addElementTextPattern("ovm_sequencer_param_utils_begin");
        elementTextSet.addElementTextPattern("ovm_sequencer_utils_end");
        elementTextSet.addElementTextPattern("ovm_create");
        elementTextSet.addElementTextPattern("ovm_do");
        elementTextSet.addElementTextPattern("ovm_do_pri");
        elementTextSet.addElementTextPattern("ovm_do_with");
        elementTextSet.addElementTextPattern("ovm_do_pri_with");
        elementTextSet.addElementTextPattern("ovm_send");
        elementTextSet.addElementTextPattern("ovm_send_pri");
        elementTextSet.addElementTextPattern("ovm_rand_send");
        elementTextSet.addElementTextPattern("ovm_rand_send_pri");
        elementTextSet.addElementTextPattern("ovm_rand_send_with");
        elementTextSet.addElementTextPattern("ovm_rand_send_pri_with");
        elementTextSet.addElementTextPattern("ovm_create_on");
        elementTextSet.addElementTextPattern("ovm_do_on");
        elementTextSet.addElementTextPattern("ovm_do_on_pri");
        elementTextSet.addElementTextPattern("ovm_do_on_with");
        elementTextSet.addElementTextPattern("ovm_do_on_pri_with");
        elementTextSet.addElementTextPattern("ovm_blocking_put_imp_decl");
        elementTextSet.addElementTextPattern("ovm_nonblocking_put_imp_decl");
        elementTextSet.addElementTextPattern("ovm_put_imp_decl");
        elementTextSet.addElementTextPattern("ovm_blocking_get_imp_decl");
        elementTextSet.addElementTextPattern("ovm_nonblocking_get_imp_decl");
        elementTextSet.addElementTextPattern("ovm_get_imp_decl");
        elementTextSet.addElementTextPattern("ovm_blocking_peek_imp_decl");
        elementTextSet.addElementTextPattern("ovm_nonblocking_peek_imp_decl");
        elementTextSet.addElementTextPattern("ovm_peek_imp_decl");
        elementTextSet.addElementTextPattern("ovm_blocking_get_peek_imp_decl");
        elementTextSet.addElementTextPattern("ovm_nonblocking_get_peek_imp_decl");
        elementTextSet.addElementTextPattern("ovm_get_peek_imp_decl");
        elementTextSet.addElementTextPattern("ovm_blocking_master_imp_decl");
        elementTextSet.addElementTextPattern("ovm_nonblocking_master_imp_decl");
        elementTextSet.addElementTextPattern("ovm_master_imp_decl");
        elementTextSet.addElementTextPattern("ovm_blocking_slave_imp_decl");
        elementTextSet.addElementTextPattern("ovm_nonblocking_slave_imp_decl");
        elementTextSet.addElementTextPattern("ovm_slave_imp_decl");
        elementTextSet.addElementTextPattern("ovm_blocking_transport_imp_decl");
        elementTextSet.addElementTextPattern("ovm_nonblocking_transport_imp_decl");
        elementTextSet.addElementTextPattern("ovm_transport_imp_decl");
        elementTextSet.addElementTextPattern("ovm_analysis_imp_decl");
        elementTextSet.addElementTextPattern("ovm_do_callbacks");
        elementTextSet.addElementTextPattern("ovm_do_obj_callbacks");
        elementTextSet.addElementTextPattern("ovm_do_callbacks_exit_on");
        elementTextSet.addElementTextPattern("ovm_do_obj_callbacks_exit_on");
        elementTextSet.addElementTextPattern("ovm_do_task_callbacks");
        elementTextSet.addElementTextPattern("ovm_do_ext_task_callbacks");
        return filter;
    }

    public static GUIFilter getPredefinedUVMBrowserMembersModeFilter() {
        ViewSet viewSet = new ViewSet();
        viewSet.setMatch(true);
        viewSet.addView(ViewSet.ViewName.UVM_BROWSER_MEMBERS);
        PathSet uvmPathSet = new PathSet();
        uvmPathSet.setMatch(true);
        uvmPathSet.setMatchThroughMacro(true);
        uvmPathSet.addPathTopFilePattern(UVM_E_TOP_FILE_PATTERN);
        uvmPathSet.addPathTopFilePattern(VR_AD_E_TOP_FILE_PATTERN);
        uvmPathSet.addPathTopFilePattern(SCBD_E_TOP_FILE_PATTERN);
        GUIFilter filter = new GUIFilter();
        filter.setType(GUIFilter.FilterType.PREDEFINED);
        filter.setName("UVM Browser View Members Mode Filter");
        filter.setViewSet(viewSet);
        filter.setPathSet(uvmPathSet);
        return filter;
    }

    public static GUIFilter getPredefinedUVMMacroFilter() {
        ViewSet viewSet = new ViewSet();
        viewSet.setMatch(true);
        viewSet.addView(ViewSet.ViewName.MACRO);
        PathSet uvmPathSet = new PathSet();
        uvmPathSet.setMatch(true);
        uvmPathSet.setMatchThroughMacro(true);
        uvmPathSet.addPathTopFilePattern(UVM_SV_TOP_FILE_PATTERN);
        uvmPathSet.addPathTopFilePattern(UVM_SV_TOP_FILE_PATTERN_PKG);
        uvmPathSet.addPathTopFilePattern(ML_UVM_SV_TOP_FILE_PATTERN_PKG);
        GUIFilter filter = new GUIFilter();
        filter.setType(GUIFilter.FilterType.PREDEFINED);
        filter.setKind(GUIFilter.FilterKind.HIDE);
        filter.setName("UVM Predefined Macros View Filter");
        filter.setViewSet(viewSet);
        filter.setPathSet(uvmPathSet);
        ElementTextSet elementTextSet = new ElementTextSet();
        filter.setElementTextSet(elementTextSet);
        elementTextSet.setMatch(false);
        elementTextSet.addElementTextPattern("uvm_info");
        elementTextSet.addElementTextPattern("uvm_warning");
        elementTextSet.addElementTextPattern("uvm_error");
        elementTextSet.addElementTextPattern("uvm_fatal");
        elementTextSet.addElementTextPattern("uvm_info_context");
        elementTextSet.addElementTextPattern("uvm_warning_context");
        elementTextSet.addElementTextPattern("uvm_error_context");
        elementTextSet.addElementTextPattern("uvm_fatal_context");
        elementTextSet.addElementTextPattern("uvm_field_utils_begin");
        elementTextSet.addElementTextPattern("uvm_field_utils_end");
        elementTextSet.addElementTextPattern("uvm_object_utils");
        elementTextSet.addElementTextPattern("uvm_object_param_utils");
        elementTextSet.addElementTextPattern("uvm_object_utils_begin");
        elementTextSet.addElementTextPattern("uvm_object_param_utils_begin");
        elementTextSet.addElementTextPattern("uvm_object_utils_end");
        elementTextSet.addElementTextPattern("uvm_component_utils");
        elementTextSet.addElementTextPattern("uvm_component_param_utils");
        elementTextSet.addElementTextPattern("uvm_component_utils_begin");
        elementTextSet.addElementTextPattern("uvm_component_param_utils_begin");
        elementTextSet.addElementTextPattern("uvm_component_utils_end");
        elementTextSet.addElementTextPattern("uvm_object_registry");
        elementTextSet.addElementTextPattern("uvm_component_registry");
        elementTextSet.addElementTextPattern("uvm_field_int");
        elementTextSet.addElementTextPattern("uvm_field_object");
        elementTextSet.addElementTextPattern("uvm_field_string");
        elementTextSet.addElementTextPattern("uvm_field_enum");
        elementTextSet.addElementTextPattern("uvm_field_real");
        elementTextSet.addElementTextPattern("uvm_field_event");
        elementTextSet.addElementTextPattern("uvm_field_sarray_int");
        elementTextSet.addElementTextPattern("uvm_field_sarray_object");
        elementTextSet.addElementTextPattern("uvm_field_sarray_string");
        elementTextSet.addElementTextPattern("uvm_field_sarray_enum");
        elementTextSet.addElementTextPattern("uvm_field_array_int");
        elementTextSet.addElementTextPattern("uvm_field_array_object");
        elementTextSet.addElementTextPattern("uvm_field_array_string");
        elementTextSet.addElementTextPattern("uvm_field_array_enum");
        elementTextSet.addElementTextPattern("uvm_field_queue_int");
        elementTextSet.addElementTextPattern("uvm_field_queue_object");
        elementTextSet.addElementTextPattern("uvm_field_queue_string");
        elementTextSet.addElementTextPattern("uvm_field_queue_enum");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_string");
        elementTextSet.addElementTextPattern("uvm_field_aa_object_string");
        elementTextSet.addElementTextPattern("uvm_field_aa_string_string");
        elementTextSet.addElementTextPattern("uvm_field_aa_object_int");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_int");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_int_unsigned");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_integer");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_integer_unsigned");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_byte");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_byte_unsigned");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_shortint");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_shortint_unsigned");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_longint");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_longint_unsigned");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_key");
        elementTextSet.addElementTextPattern("uvm_field_aa_int_enumkey");
        elementTextSet.addElementTextPattern("uvm_record_attribute");
        elementTextSet.addElementTextPattern("uvm_record_field");
        elementTextSet.addElementTextPattern("uvm_pack_intN");
        elementTextSet.addElementTextPattern("uvm_pack_enumN");
        elementTextSet.addElementTextPattern("uvm_pack_sarrayN");
        elementTextSet.addElementTextPattern("uvm_pack_arrayN");
        elementTextSet.addElementTextPattern("uvm_pack_queueN");
        elementTextSet.addElementTextPattern("uvm_pack_int");
        elementTextSet.addElementTextPattern("uvm_pack_enum");
        elementTextSet.addElementTextPattern("uvm_pack_string");
        elementTextSet.addElementTextPattern("uvm_pack_real");
        elementTextSet.addElementTextPattern("uvm_pack_sarray");
        elementTextSet.addElementTextPattern("uvm_pack_array");
        elementTextSet.addElementTextPattern("uvm_pack_queue");
        elementTextSet.addElementTextPattern("uvm_unpack_intN");
        elementTextSet.addElementTextPattern("uvm_unpack_enumN");
        elementTextSet.addElementTextPattern("uvm_unpack_sarrayN");
        elementTextSet.addElementTextPattern("uvm_unpack_arrayN");
        elementTextSet.addElementTextPattern("uvm_unpack_queueN");
        elementTextSet.addElementTextPattern("uvm_unpack_int");
        elementTextSet.addElementTextPattern("uvm_unpack_enum");
        elementTextSet.addElementTextPattern("uvm_unpack_string");
        elementTextSet.addElementTextPattern("uvm_unpack_real");
        elementTextSet.addElementTextPattern("uvm_unpack_sarray");
        elementTextSet.addElementTextPattern("uvm_unpack_array");
        elementTextSet.addElementTextPattern("uvm_unpack_queue");
        elementTextSet.addElementTextPattern("uvm_create");
        elementTextSet.addElementTextPattern("uvm_do");
        elementTextSet.addElementTextPattern("uvm_do_pri");
        elementTextSet.addElementTextPattern("uvm_do_with");
        elementTextSet.addElementTextPattern("uvm_do_pri_with");
        elementTextSet.addElementTextPattern("uvm_create_on");
        elementTextSet.addElementTextPattern("uvm_do_on");
        elementTextSet.addElementTextPattern("uvm_do_on_pri");
        elementTextSet.addElementTextPattern("uvm_do_on_with");
        elementTextSet.addElementTextPattern("uvm_do_on_pri_with");
        elementTextSet.addElementTextPattern("uvm_send");
        elementTextSet.addElementTextPattern("uvm_send_pri");
        elementTextSet.addElementTextPattern("uvm_rand_send");
        elementTextSet.addElementTextPattern("uvm_rand_send_pri");
        elementTextSet.addElementTextPattern("uvm_rand_send_with");
        elementTextSet.addElementTextPattern("uvm_rand_send_pri_with");
        elementTextSet.addElementTextPattern("uvm_declare_p_sequencer");
        elementTextSet.addElementTextPattern("uvm_register_cb");
        elementTextSet.addElementTextPattern("uvm_set_super_type");
        elementTextSet.addElementTextPattern("uvm_do_callbacks");
        elementTextSet.addElementTextPattern("uvm_do_obj_callbacks");
        elementTextSet.addElementTextPattern("uvm_do_callbacks_exit_on");
        elementTextSet.addElementTextPattern("uvm_do_obj_callbacks_exit_on");
        elementTextSet.addElementTextPattern("uvm_blocking_put_imp_decl");
        elementTextSet.addElementTextPattern("uvm_nonblocking_put_imp_decl");
        elementTextSet.addElementTextPattern("uvm_put_imp_decl");
        elementTextSet.addElementTextPattern("uvm_blocking_get_imp_decl");
        elementTextSet.addElementTextPattern("uvm_nonblocking_get_imp_decl");
        elementTextSet.addElementTextPattern("uvm_get_imp_decl");
        elementTextSet.addElementTextPattern("uvm_blocking_peek_imp_decl");
        elementTextSet.addElementTextPattern("uvm_nonblocking_peek_imp_decl");
        elementTextSet.addElementTextPattern("uvm_peek_imp_decl");
        elementTextSet.addElementTextPattern("uvm_blocking_get_peek_imp_decl");
        elementTextSet.addElementTextPattern("uvm_nonblocking_get_peek_imp_decl");
        elementTextSet.addElementTextPattern("uvm_get_peek_imp_decl");
        elementTextSet.addElementTextPattern("uvm_blocking_master_imp_decl");
        elementTextSet.addElementTextPattern("uvm_nonblocking_master_imp_decl");
        elementTextSet.addElementTextPattern("uvm_master_imp_decl");
        elementTextSet.addElementTextPattern("uvm_blocking_slave_imp_decl");
        elementTextSet.addElementTextPattern("uvm_nonblocking_slave_imp_decl");
        elementTextSet.addElementTextPattern("uvm_slave_imp_decl");
        elementTextSet.addElementTextPattern("uvm_blocking_transport_imp_decl");
        elementTextSet.addElementTextPattern("uvm_nonblocking_transport_imp_decl");
        elementTextSet.addElementTextPattern("uvm_transport_imp_decl");
        elementTextSet.addElementTextPattern("uvm_analysis_imp_decl");
        elementTextSet.addElementTextPattern("UVM_REG_ADDR_WIDTH");
        elementTextSet.addElementTextPattern("UVM_REG_DATA_WIDTH");
        elementTextSet.addElementTextPattern("UVM_REG_BYTENABLE_WIDTH");
        elementTextSet.addElementTextPattern("UVM_REG_CVR_WIDTH");
        elementTextSet.addElementTextPattern("UVM_DEFAULT_TIMEOUT");
        elementTextSet.addElementTextPattern("UVM_MAX_STREAMBITS");
        elementTextSet.addElementTextPattern("UVM_PACKER_MAX_BYTES");
        elementTextSet.addElementTextPattern("UVM_TLM_B_MASK");
        elementTextSet.addElementTextPattern("UVM_TLM_B_TRANSPORT_IMP");
        elementTextSet.addElementTextPattern("UVM_TLM_FUNCTION_ERROR");
        elementTextSet.addElementTextPattern("UVM_TLM_NB_BW_MASK");
        elementTextSet.addElementTextPattern("UVM_TLM_NB_FW_MASK");
        elementTextSet.addElementTextPattern("UVM_TLM_NB_TRANSPORT_BW_IMP");
        elementTextSet.addElementTextPattern("UVM_TLM_NB_TRANSPORT_FW_IMP");
        elementTextSet.addElementTextPattern("UVM_TLM_TASK_ERROR");
        return filter;
    }

    public static Set<GUIFilter> getPreferenceFilters() {
        ElementTypeSet elementTypeSet;
        ViewSet viewSet;
        HashSet<GUIFilter> preferenceFilters = new HashSet<GUIFilter>();
        if (!(PrefConst.getTHViewShowFields() && PrefConst.getTHViewShowEvents() && PrefConst.getTHViewShowMethods() && PrefConst.getTHViewShowFunctions() && PrefConst.getTHViewShowTasks())) {
            GUIFilter hierarchyViewFilter = new GUIFilter();
            hierarchyViewFilter.setType(GUIFilter.FilterType.PREFERENCE);
            hierarchyViewFilter.setKind(GUIFilter.FilterKind.HIDE);
            hierarchyViewFilter.setName("Predefined Type Hierarchy View Members Filter");
            viewSet = new ViewSet();
            viewSet.setMatch(true);
            viewSet.addView(ViewSet.ViewName.TYPE_HIERARCHY_MEMBERS);
            elementTypeSet = new ElementTypeSet();
            elementTypeSet.setMatch(true);
            hierarchyViewFilter.setElementTypeSet(elementTypeSet);
            hierarchyViewFilter.setViewSet(viewSet);
            if (!PrefConst.getTHViewShowFields()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.E));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.SLN));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.SV));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.PSS));
            }
            if (!PrefConst.getTHViewShowEvents()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.E));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.SLN));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.SV));
            }
            if (!PrefConst.getTHViewShowMethods()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.METHOD, ElementType.ElementTypeLanguage.E));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.METHOD, ElementType.ElementTypeLanguage.SLN));
            }
            if (!PrefConst.getTHViewShowFunctions()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.SV));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.PSS));
            }
            if (!PrefConst.getTHViewShowTasks()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TASK, ElementType.ElementTypeLanguage.SV));
            }
            preferenceFilters.add(hierarchyViewFilter);
        }
        if (!(PrefConst.getUVMBrowserViewShowUVMMembers() || PrefConst.getUVMBrowserViewShowFields() && PrefConst.getUVMBrowserViewShowEvents() && PrefConst.getUVMBrowserViewShowFunctions() && PrefConst.getUVMBrowserViewShowTasks())) {
            GUIFilter UVMBrowserViewFilter = new GUIFilter();
            UVMBrowserViewFilter.setType(GUIFilter.FilterType.PREFERENCE);
            UVMBrowserViewFilter.setKind(GUIFilter.FilterKind.HIDE);
            UVMBrowserViewFilter.setName("Predefined UVM Browser View Members Filter");
            viewSet = new ViewSet();
            viewSet.setMatch(true);
            viewSet.addView(ViewSet.ViewName.UVM_BROWSER_MEMBERS);
            elementTypeSet = new ElementTypeSet();
            elementTypeSet.setMatch(true);
            UVMBrowserViewFilter.setElementTypeSet(elementTypeSet);
            UVMBrowserViewFilter.setViewSet(viewSet);
            if (!PrefConst.getUVMBrowserViewShowFields()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.SV));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.E));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.SLN));
            }
            if (!PrefConst.getUVMBrowserViewShowEvents()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.SV));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.E));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.SLN));
            }
            if (!PrefConst.getUVMBrowserViewShowFunctions()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.SV));
            }
            if (!PrefConst.getUVMBrowserViewShowTasks()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.TASK, ElementType.ElementTypeLanguage.SV));
            }
            if (!PrefConst.getUVMBrowserViewShowMethods()) {
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.METHOD, ElementType.ElementTypeLanguage.E));
                elementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.METHOD, ElementType.ElementTypeLanguage.SLN));
            }
            preferenceFilters.add(UVMBrowserViewFilter);
        }
        preferenceFilters.addAll(fOutlinePredefinedGUIFilters.values());
        return preferenceFilters;
    }

    public static List<GUIFilter> getXVMFilter() {
        ArrayList<GUIFilter> predefinedFilters = new ArrayList<GUIFilter>();
        GUIFilter ovmFilter = new GUIFilter();
        ovmFilter.setType(GUIFilter.FilterType.PREDEFINED);
        ovmFilter.setKind(GUIFilter.FilterKind.HIDE);
        ovmFilter.setName("guiFiltersHideOVMLibrary");
        PathSet ovmPathSet = new PathSet();
        ovmPathSet.setMatch(true);
        ovmPathSet.setMatchThroughMacro(true);
        ovmPathSet.addPathTopFilePattern(OVM_SV_TOP_FILE_PATTERN);
        ovmPathSet.addPathTopFilePattern(OVM_SV_TOP_FILE_PATTERN_PKG);
        ovmFilter.setPathSet(ovmPathSet);
        predefinedFilters.add(ovmFilter);
        GUIFilter ovmEFilter = new GUIFilter();
        ovmEFilter.setType(GUIFilter.FilterType.PREDEFINED);
        ovmEFilter.setKind(GUIFilter.FilterKind.HIDE);
        ovmEFilter.setName("guiFiltersHideOVMLibrary");
        PathSet ovmEPathSet = new PathSet();
        ovmEPathSet.setMatch(true);
        ovmEPathSet.setMatchThroughMacro(false);
        ovmEPathSet.addPathTopFilePattern(OVM_E_TOP_FILE_PATTERN);
        ovmEFilter.setPathSet(ovmEPathSet);
        predefinedFilters.add(ovmEFilter);
        GUIFilter uvmFilter = new GUIFilter();
        uvmFilter.setType(GUIFilter.FilterType.PREDEFINED);
        uvmFilter.setKind(GUIFilter.FilterKind.HIDE);
        uvmFilter.setName("guiFiltersHideUVMLibrary");
        PathSet uvmPathSet = new PathSet();
        uvmPathSet.setMatch(true);
        uvmPathSet.setMatchThroughMacro(true);
        uvmPathSet.addPathTopFilePattern(UVM_SV_TOP_FILE_PATTERN);
        uvmPathSet.addPathTopFilePattern(UVM_SV_TOP_FILE_PATTERN_PKG);
        uvmPathSet.addPathTopFilePattern(ML_UVM_SV_TOP_FILE_PATTERN_PKG);
        uvmPathSet.addPathTopFilePattern(IUS_UVM_SV_TOP_FILE_PATTERN_PKG);
        uvmPathSet.addPathTopFilePattern(QUESTA_UVM_SV_TOP_FILE_PATTERN_PKG);
        uvmFilter.setPathSet(uvmPathSet);
        predefinedFilters.add(uvmFilter);
        GUIFilter uvmEFilter = new GUIFilter();
        uvmEFilter.setType(GUIFilter.FilterType.PREDEFINED);
        uvmEFilter.setKind(GUIFilter.FilterKind.HIDE);
        uvmEFilter.setName("guiFiltersHideUVMLibrary");
        PathSet uvmEPathSet = new PathSet();
        uvmEPathSet.setMatch(true);
        uvmEPathSet.setMatchThroughMacro(false);
        uvmEPathSet.addPathTopFilePattern(UVM_E_TOP_FILE_PATTERN);
        uvmEFilter.setPathSet(uvmEPathSet);
        predefinedFilters.add(uvmEFilter);
        GUIFilter vmmFilter = new GUIFilter();
        vmmFilter.setType(GUIFilter.FilterType.PREDEFINED);
        vmmFilter.setKind(GUIFilter.FilterKind.HIDE);
        vmmFilter.setName("guiFiltersHideVMMLibrary");
        PathSet vmmPathSet = new PathSet();
        vmmPathSet.setMatch(true);
        vmmPathSet.setMatchThroughMacro(true);
        vmmPathSet.addPathTopFilePattern(VMM_TOP_FILE_PATTERN);
        vmmFilter.setPathSet(vmmPathSet);
        predefinedFilters.add(vmmFilter);
        return predefinedFilters;
    }

    public static Set<GUIFilter> getPredefinedFilters(IProject project) {
        List<Invocation> invocations;
        Object cppViewSet;
        PathSet cppPathSet;
        GUIFilter cppFilter;
        ViewSet diagramEView;
        ElementTypeSet diagramElementTypeSet;
        ViewSet diagramView;
        HashSet<GUIFilter> predefinedFilters = new HashSet<GUIFilter>();
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        if (store.contains(TYPES_VIEW_SHOW_OVM_TYPES)) {
            store.setValue("guiFiltersHideOVMLibrary", !store.getBoolean(TYPES_VIEW_SHOW_OVM_TYPES));
            store.setValue(TYPES_VIEW_SHOW_OVM_TYPES, false);
        }
        if (store.contains(TYPES_VIEW_SHOW_UVM_TYPES)) {
            store.setValue("guiFiltersHideUVMLibrary", !store.getBoolean(TYPES_VIEW_SHOW_UVM_TYPES));
            store.setValue(TYPES_VIEW_SHOW_UVM_TYPES, false);
        }
        if (store.contains(TYPES_VIEW_SHOW_VMM_TYPES)) {
            store.setValue("guiFiltersHideVMMLibrary", !store.getBoolean(TYPES_VIEW_SHOW_VMM_TYPES));
            store.setValue(TYPES_VIEW_SHOW_VMM_TYPES, false);
        }
        if (store.contains(TYPES_VIEW_SHOW_C_SYSTEM_TYPES)) {
            store.setValue("guiFiltersHideCSystemHeaders", !store.getBoolean(TYPES_VIEW_SHOW_C_SYSTEM_TYPES));
            store.setValue(TYPES_VIEW_SHOW_C_SYSTEM_TYPES, false);
        }
        if (store.contains(TYPES_VIEW_SHOW_PSS_C_TYPES)) {
            store.setValue("guiFiltersHidePSSCHeaders", !store.getBoolean(TYPES_VIEW_SHOW_PSS_C_TYPES));
            store.setValue(TYPES_VIEW_SHOW_PSS_C_TYPES, false);
        }
        if (store.contains(TYPES_VIEW_SHOW_SYSTEMC_TYPES)) {
            store.setValue("guiFiltersHideSystemCHeaders", !store.getBoolean(TYPES_VIEW_SHOW_SYSTEMC_TYPES));
            store.setValue(TYPES_VIEW_SHOW_SYSTEMC_TYPES, false);
        }
        if (store.contains(TYPES_VIEW_SHOW_PRECOMPILED_TYPES)) {
            store.setValue("guiFiltersHidePrecompiledDatabases", !store.getBoolean(TYPES_VIEW_SHOW_PRECOMPILED_TYPES));
            store.setValue(TYPES_VIEW_SHOW_PRECOMPILED_TYPES, false);
        }
        ViewSet viewSet = new ViewSet();
        viewSet.setMatch(true);
        viewSet.addView(ViewSet.ViewName.PROBLEMS);
        viewSet.addView(ViewSet.ViewName.TASKS);
        viewSet.addView(ViewSet.ViewName.TYPES);
        viewSet.addView(ViewSet.ViewName.COMPILE_ORDER);
        viewSet.addView(ViewSet.ViewName.TYPES_MEMBERS);
        viewSet.addView(ViewSet.ViewName.OUTLINE);
        viewSet.addView(ViewSet.ViewName.SEARCH);
        viewSet.addView(ViewSet.ViewName.TYPE_HIERARCHY_MEMBERS);
        viewSet.addView(ViewSet.ViewName.CALL_HIERARCHY);
        viewSet.addView(ViewSet.ViewName.UVM_SEQUENCE_TREE);
        viewSet.addView(ViewSet.ViewName.UVM_BROWSER_CLASSES);
        viewSet.addView(ViewSet.ViewName.UVM_BROWSER_MEMBERS);
        viewSet.addView(ViewSet.ViewName.VERIFICATION_HIERARCHY);
        viewSet.addView(ViewSet.ViewName.CHECKS);
        viewSet.addView(ViewSet.ViewName.COVERAGE);
        viewSet.addView(ViewSet.ViewName.SCOPE_BREADCRUMB);
        viewSet.addView(ViewSet.ViewName.FIELD_EDITOR);
        if (store.getBoolean("guiFiltersHideOVMLibrary")) {
            GUIFilter ovmFilter = new GUIFilter();
            ovmFilter.setType(GUIFilter.FilterType.PREDEFINED);
            ovmFilter.setKind(GUIFilter.FilterKind.HIDE);
            ovmFilter.setName("OVM SystemVerilog Predefined Filter");
            PathSet ovmPathSet = new PathSet();
            ovmPathSet.setMatch(true);
            ovmPathSet.setMatchThroughMacro(true);
            ovmPathSet.addPathTopFilePattern(OVM_SV_TOP_FILE_PATTERN);
            ovmPathSet.addPathTopFilePattern(OVM_SV_TOP_FILE_PATTERN_PKG);
            ovmFilter.setPathSet(ovmPathSet);
            ovmFilter.setViewSet(viewSet);
            predefinedFilters.add(ovmFilter);
            GUIFilter ovmDiagramFilter = new GUIFilter();
            ovmDiagramFilter.setType(GUIFilter.FilterType.PREDEFINED);
            ovmDiagramFilter.setKind(GUIFilter.FilterKind.HIDE);
            ovmDiagramFilter.setName("OVM SystemVerilog Predefined Diagram Filter");
            ovmDiagramFilter.setPathSet(ovmPathSet);
            diagramView = new ViewSet();
            diagramView.setMatch(true);
            diagramView.addView(ViewSet.ViewName.DIAGRAM);
            ovmDiagramFilter.setViewSet(diagramView);
            diagramElementTypeSet = new ElementTypeSet();
            diagramElementTypeSet.setMatch(false);
            diagramElementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CLASS, ElementType.ElementTypeLanguage.SV));
            ovmDiagramFilter.setElementTypeSet(diagramElementTypeSet);
            predefinedFilters.add(ovmDiagramFilter);
            GUIFilter ovmEFilter = new GUIFilter();
            ovmEFilter.setType(GUIFilter.FilterType.PREDEFINED);
            ovmEFilter.setKind(GUIFilter.FilterKind.HIDE);
            ovmEFilter.setName("OVM E Language Predefined Filter");
            PathSet ovmEPathSet = new PathSet();
            ovmEPathSet.setMatch(true);
            ovmEPathSet.setMatchThroughMacro(false);
            ovmEPathSet.addPathTopFilePattern(OVM_E_TOP_FILE_PATTERN);
            ovmEFilter.setPathSet(ovmEPathSet);
            ovmEFilter.setViewSet(viewSet);
            predefinedFilters.add(ovmEFilter);
            GUIFilter ovmEDiagramFilter = new GUIFilter();
            ovmEDiagramFilter.setType(GUIFilter.FilterType.PREDEFINED);
            ovmEDiagramFilter.setKind(GUIFilter.FilterKind.HIDE);
            ovmEDiagramFilter.setName("OVM E Language Predefined Diagram Filter");
            ovmEDiagramFilter.setPathSet(ovmEPathSet);
            diagramEView = new ViewSet();
            diagramEView.setMatch(true);
            diagramEView.addView(ViewSet.ViewName.DIAGRAM);
            ovmEDiagramFilter.setViewSet(diagramEView);
            predefinedFilters.add(ovmEDiagramFilter);
            predefinedFilters.add(DVTPredefinedGUIFilters.getPredefinedOVMMacroFilter());
        }
        if (store.getBoolean("guiFiltersHideUVMLibrary")) {
            GUIFilter uvmFilter = new GUIFilter();
            uvmFilter.setType(GUIFilter.FilterType.PREDEFINED);
            uvmFilter.setKind(GUIFilter.FilterKind.HIDE);
            uvmFilter.setName("UVM SystemVerilog Predefined Filter");
            PathSet uvmPathSet = new PathSet();
            uvmPathSet.setMatch(true);
            uvmPathSet.setMatchThroughMacro(true);
            uvmPathSet.addPathTopFilePattern(UVM_SV_TOP_FILE_PATTERN);
            uvmPathSet.addPathTopFilePattern(UVM_SV_TOP_FILE_PATTERN_PKG);
            uvmPathSet.addPathTopFilePattern(ML_UVM_SV_TOP_FILE_PATTERN_PKG);
            uvmPathSet.addPathTopFilePattern(IUS_UVM_SV_TOP_FILE_PATTERN_PKG);
            uvmPathSet.addPathTopFilePattern(QUESTA_UVM_SV_TOP_FILE_PATTERN_PKG);
            uvmFilter.setPathSet(uvmPathSet);
            uvmFilter.setViewSet(viewSet);
            predefinedFilters.add(uvmFilter);
            GUIFilter uvmDiagramFilter = new GUIFilter();
            uvmDiagramFilter.setType(GUIFilter.FilterType.PREDEFINED);
            uvmDiagramFilter.setKind(GUIFilter.FilterKind.HIDE);
            uvmDiagramFilter.setName("UVM SystemVerilog Predefined Diagram Filter");
            uvmDiagramFilter.setPathSet(uvmPathSet);
            diagramView = new ViewSet();
            diagramView.setMatch(true);
            diagramView.addView(ViewSet.ViewName.DIAGRAM);
            uvmDiagramFilter.setViewSet(diagramView);
            diagramElementTypeSet = new ElementTypeSet();
            diagramElementTypeSet.setMatch(false);
            diagramElementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CLASS, ElementType.ElementTypeLanguage.SV));
            uvmDiagramFilter.setElementTypeSet(diagramElementTypeSet);
            predefinedFilters.add(uvmDiagramFilter);
            GUIFilter uvmEFilter = new GUIFilter();
            uvmEFilter.setType(GUIFilter.FilterType.PREDEFINED);
            uvmEFilter.setKind(GUIFilter.FilterKind.HIDE);
            uvmEFilter.setName("UVM E Language Predefined Filter");
            PathSet uvmEPathSet = new PathSet();
            uvmEPathSet.setMatch(true);
            uvmEPathSet.setMatchThroughMacro(false);
            uvmEPathSet.addPathTopFilePattern(UVM_E_TOP_FILE_PATTERN);
            uvmEFilter.setPathSet(uvmEPathSet);
            uvmEFilter.setViewSet(viewSet);
            predefinedFilters.add(uvmEFilter);
            GUIFilter uvmEDiagramFilter = new GUIFilter();
            uvmEDiagramFilter.setType(GUIFilter.FilterType.PREDEFINED);
            uvmEDiagramFilter.setKind(GUIFilter.FilterKind.HIDE);
            uvmEDiagramFilter.setName("UVM E Language Predefined Diagram Filter");
            uvmEDiagramFilter.setPathSet(uvmEPathSet);
            diagramEView = new ViewSet();
            diagramEView.setMatch(true);
            diagramEView.addView(ViewSet.ViewName.DIAGRAM);
            uvmEDiagramFilter.setViewSet(diagramEView);
            predefinedFilters.add(uvmEDiagramFilter);
            predefinedFilters.add(DVTPredefinedGUIFilters.getPredefinedUVMMacroFilter());
        }
        if (store.getBoolean("guiFiltersHideVMMLibrary")) {
            GUIFilter vmmFilter = new GUIFilter();
            vmmFilter.setType(GUIFilter.FilterType.PREDEFINED);
            vmmFilter.setKind(GUIFilter.FilterKind.HIDE);
            vmmFilter.setName("VMM SystemVerilog Predefined Filter");
            PathSet vmmPathSet = new PathSet();
            vmmPathSet.setMatch(true);
            vmmPathSet.setMatchThroughMacro(true);
            vmmPathSet.addPathTopFilePattern(VMM_TOP_FILE_PATTERN);
            vmmFilter.setPathSet(vmmPathSet);
            vmmFilter.setViewSet(viewSet);
            predefinedFilters.add(vmmFilter);
            GUIFilter vmmDiagramFilter = new GUIFilter();
            vmmDiagramFilter.setType(GUIFilter.FilterType.PREDEFINED);
            vmmDiagramFilter.setKind(GUIFilter.FilterKind.HIDE);
            vmmDiagramFilter.setName("VMM SystemVerilog Predefined Diagram Filter");
            vmmDiagramFilter.setPathSet(vmmPathSet);
            diagramView = new ViewSet();
            diagramView.setMatch(true);
            diagramView.addView(ViewSet.ViewName.DIAGRAM);
            vmmDiagramFilter.setViewSet(diagramView);
            diagramElementTypeSet = new ElementTypeSet();
            diagramElementTypeSet.setMatch(false);
            diagramElementTypeSet.addElementType(new ElementType(ElementType.ElementTypeName.CLASS, ElementType.ElementTypeLanguage.SV));
            vmmDiagramFilter.setElementTypeSet(diagramElementTypeSet);
            predefinedFilters.add(vmmDiagramFilter);
        }
        if (store.getBoolean("guiFiltersHideCSystemHeaders")) {
            cppFilter = new GUIFilter();
            cppFilter.setType(GUIFilter.FilterType.PREDEFINED);
            cppFilter.setKind(GUIFilter.FilterKind.HIDE);
            cppFilter.setName("C/C++ System Headers Predefined Filter");
            cppPathSet = new PathSet();
            cppPathSet.setMatch(true);
            List<String> incdirs = GCCUtils.getCSystemHeadersIncdirs(project);
            for (String incdir : incdirs) {
                cppPathSet.addPathPattern(GUI_FILTERS_QUICK_VIEW_INDICATION + incdir + GUI_FILTERS_QUICK_VIEW_INDICATION);
            }
            cppPathSet.addPathPattern("*/svdpi.h");
            cppPathSet.addPathPattern("*/sv_vpi_user.h");
            cppPathSet.addPathPattern("*/vpi_compatibility.h");
            cppPathSet.addPathPattern("*/vpi_user.h");
            cppFilter.setPathSet(cppPathSet);
            ViewSet cppViewSet2 = new ViewSet();
            cppViewSet2.setMatch(true);
            cppViewSet2.addView(ViewSet.ViewName.TYPES);
            cppViewSet2.addView(ViewSet.ViewName.MACRO);
            cppViewSet2.addView(ViewSet.ViewName.PROBLEMS);
            cppFilter.setViewSet(cppViewSet2);
            predefinedFilters.add(cppFilter);
        }
        if (store.getBoolean("guiFiltersHidePSSCHeaders")) {
            cppFilter = new GUIFilter();
            cppFilter.setType(GUIFilter.FilterType.PREDEFINED);
            cppFilter.setKind(GUIFilter.FilterKind.HIDE);
            cppFilter.setName("PSS C/C++ Headers Predefined Filter");
            cppPathSet = new PathSet();
            cppPathSet.setMatch(true);
            cppPathSet.addPathPattern(PSS_C_PATTERN);
            cppFilter.setPathSet(cppPathSet);
            cppViewSet = new ViewSet();
            ((ViewSet)cppViewSet).setMatch(true);
            ((ViewSet)cppViewSet).addView(ViewSet.ViewName.TYPES);
            ((ViewSet)cppViewSet).addView(ViewSet.ViewName.MACRO);
            ((ViewSet)cppViewSet).addView(ViewSet.ViewName.PROBLEMS);
            cppFilter.setViewSet((ViewSet)cppViewSet);
            predefinedFilters.add(cppFilter);
        }
        if (store.getBoolean("guiFiltersHideSystemCHeaders")) {
            cppFilter = new GUIFilter();
            cppFilter.setType(GUIFilter.FilterType.PREDEFINED);
            cppFilter.setKind(GUIFilter.FilterKind.HIDE);
            cppFilter.setName("SystemC Headers Predefined Filter");
            cppPathSet = new PathSet();
            cppPathSet.setMatch(true);
            cppPathSet.addPathPattern(SYSTEMC_PATTERN1);
            cppPathSet.addPathPattern(SYSTEMC_PATTERN2);
            cppFilter.setPathSet(cppPathSet);
            cppViewSet = new ViewSet();
            ((ViewSet)cppViewSet).setMatch(true);
            ((ViewSet)cppViewSet).addView(ViewSet.ViewName.TYPES);
            ((ViewSet)cppViewSet).addView(ViewSet.ViewName.MACRO);
            ((ViewSet)cppViewSet).addView(ViewSet.ViewName.PROBLEMS);
            cppFilter.setViewSet((ViewSet)cppViewSet);
            predefinedFilters.add(cppFilter);
        }
        if (store.getBoolean("guiFiltersHideXilinxLibraries") && (invocations = BuildConfigManager.getInvocations(project)) != null) {
            for (Invocation inv : invocations) {
                String xilinxHome = BuildConfigManager.getenv(inv, "DVT_XILINX_HOME");
                if (xilinxHome == null || xilinxHome.isEmpty()) continue;
                predefinedFilters.addAll(DVTPredefinedGUIFilters.getPredefinedXilinxFilters(xilinxHome));
                break;
            }
        }
        if (store.getBoolean("guiFiltersHidePerspecLibraries") && (invocations = BuildConfigManager.getInvocations(project)) != null) {
            for (Invocation inv : invocations) {
                String perspecHome;
                if (inv.getToolCompat() != IBuildConfigParserConstants.ToolCompat.SVR || (perspecHome = BuildConfigManager.getenv(inv, "PERSPEC_HOME")) == null || perspecHome.isEmpty()) continue;
                predefinedFilters.addAll(DVTPredefinedGUIFilters.getPredefinedPerspecFilters(perspecHome));
                break;
            }
        }
        if (store.getBoolean("guiFiltersHidePrecompiledDatabases")) {
            GUIFilter precompiledGUIFilter = new GUIFilter();
            precompiledGUIFilter.setKind(GUIFilter.FilterKind.HIDE);
            precompiledGUIFilter.setType(GUIFilter.FilterType.PREDEFINED);
            precompiledGUIFilter.setName("Precompiled Databases Predefined Filter");
            PathSet pathSet = new PathSet();
            pathSet.addPath(GUI_FILTERS_QUICK_VIEW_INDICATION);
            pathSet.setMatchThroughMacro(true);
            PrecompiledFilter precompiledFilter = new PrecompiledFilter();
            precompiledFilter.setMatch(true);
            precompiledGUIFilter.setPathSet(pathSet);
            precompiledGUIFilter.setViewSet(viewSet);
            precompiledGUIFilter.setPrecompiledFilter(precompiledFilter);
            predefinedFilters.add(precompiledGUIFilter);
        }
        return predefinedFilters;
    }

    private static List<GUIFilter> getPredefinedXilinxFilters(String xilinxHome) {
        ArrayList<GUIFilter> result = new ArrayList<GUIFilter>();
        ViewSet viewSet = new ViewSet();
        viewSet.setMatch(true);
        viewSet.addView(ViewSet.ViewName.UVM_SEQUENCE_TREE);
        viewSet.addView(ViewSet.ViewName.MACRO);
        viewSet.addView(ViewSet.ViewName.DIAGRAM);
        viewSet.addView(ViewSet.ViewName.PROBLEMS);
        viewSet.addView(ViewSet.ViewName.TASKS);
        viewSet.addView(ViewSet.ViewName.TYPES);
        viewSet.addView(ViewSet.ViewName.TYPES_MEMBERS);
        viewSet.addView(ViewSet.ViewName.OUTLINE);
        viewSet.addView(ViewSet.ViewName.SEARCH);
        viewSet.addView(ViewSet.ViewName.TYPE_HIERARCHY_MEMBERS);
        viewSet.addView(ViewSet.ViewName.CALL_HIERARCHY);
        viewSet.addView(ViewSet.ViewName.UVM_BROWSER_CLASSES);
        viewSet.addView(ViewSet.ViewName.UVM_BROWSER_MEMBERS);
        viewSet.addView(ViewSet.ViewName.CHECKS);
        viewSet.addView(ViewSet.ViewName.COVERAGE);
        viewSet.addView(ViewSet.ViewName.SCOPE_BREADCRUMB);
        viewSet.addView(ViewSet.ViewName.FIELD_EDITOR);
        viewSet.addView(ViewSet.ViewName.DESIGN_HIERARCHY_TOP_SELECTOR);
        GUIFilter filter = new GUIFilter();
        filter.setKind(GUIFilter.FilterKind.HIDE);
        filter.setType(GUIFilter.FilterType.PREDEFINED);
        filter.setName("Xilinx Predefined Filter");
        PathSet pathSet = new PathSet();
        pathSet.setMatch(true);
        pathSet.setMatchThroughMacro(true);
        pathSet.addPathPattern(String.valueOf(xilinxHome) + GUI_FILTERS_QUICK_VIEW_INDICATION);
        filter.setPathSet(pathSet);
        filter.setViewSet(viewSet);
        result.add(filter);
        GUIFilter libraryFilter = new GUIFilter();
        libraryFilter.setKind(GUIFilter.FilterKind.HIDE);
        libraryFilter.setType(GUIFilter.FilterType.PREDEFINED);
        libraryFilter.setName("Xilinx Library Name Filter");
        libraryFilter.setViewSet(viewSet);
        ElementTextSet textSet = new ElementTextSet();
        textSet.setMatch(true);
        IBuildConfigParserConstants.XilinxLibName[] xilinxLibNameArray = IBuildConfigParserConstants.XilinxLibName.values();
        int n = xilinxLibNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfigParserConstants.XilinxLibName xl = xilinxLibNameArray[n2];
            textSet.addElementTextPattern(xl.name().toLowerCase());
            ++n2;
        }
        ElementTypeSet typeSet = new ElementTypeSet();
        typeSet.setMatch(true);
        typeSet.addAllLanguagesElementType(ElementType.ElementTypeName.LIBRARY);
        libraryFilter.setElementTextSet(textSet);
        libraryFilter.setElementTypeSet(typeSet);
        result.add(libraryFilter);
        return result;
    }

    private static List<GUIFilter> getPredefinedPerspecFilters(String perspecHome) {
        ArrayList<GUIFilter> result = new ArrayList<GUIFilter>();
        ViewSet viewSet = new ViewSet();
        viewSet.setMatch(true);
        viewSet.addView(ViewSet.ViewName.PROBLEMS);
        viewSet.addView(ViewSet.ViewName.TASKS);
        viewSet.addView(ViewSet.ViewName.TYPES);
        viewSet.addView(ViewSet.ViewName.MACRO);
        viewSet.addView(ViewSet.ViewName.OUTLINE);
        viewSet.addView(ViewSet.ViewName.DIAGRAM);
        viewSet.addView(ViewSet.ViewName.TYPE_HIERARCHY_MEMBERS);
        viewSet.addView(ViewSet.ViewName.TYPES_MEMBERS);
        viewSet.addView(ViewSet.ViewName.SEARCH);
        viewSet.addView(ViewSet.ViewName.CHECKS);
        viewSet.addView(ViewSet.ViewName.COVERAGE);
        viewSet.addView(ViewSet.ViewName.SCOPE_BREADCRUMB);
        GUIFilter filter = new GUIFilter();
        filter.setKind(GUIFilter.FilterKind.HIDE);
        filter.setType(GUIFilter.FilterType.PREDEFINED);
        filter.setName("Perspec Predefined Filter");
        PathSet pathSet = new PathSet();
        pathSet.setMatch(true);
        pathSet.setMatchThroughMacro(true);
        pathSet.addPathPattern(String.valueOf(perspecHome) + "/cdn_pslib/*");
        pathSet.addPathPattern(String.valueOf(perspecHome) + "/packages/*");
        filter.setPathSet(pathSet);
        filter.setViewSet(viewSet);
        result.add(filter);
        return result;
    }
}

