/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.util.Arrays;
import ro.amiq.dvt.utils.DVTStringUtil;

public class ElementType {
    private ElementTypeName fElementTypeName;
    private ElementTypeLanguage fLanguage;

    public ElementType(ElementTypeName elementTypeName, ElementTypeLanguage elementTypeLanguage) {
        this.fElementTypeName = elementTypeName;
        this.fLanguage = elementTypeLanguage;
    }

    public ElementTypeName getElementTypeName() {
        return this.fElementTypeName;
    }

    public void setElementTypeName(ElementTypeName elementTypeName) {
        this.fElementTypeName = elementTypeName;
    }

    public ElementTypeLanguage getLanguage() {
        return this.fLanguage;
    }

    public void setLanguage(ElementTypeLanguage language) {
        this.fLanguage = language;
    }

    public int hashCode() {
        return (String.valueOf(this.fLanguage.toString()) + this.fElementTypeName.toString()).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ElementType)) {
            return false;
        }
        ElementType elementType = (ElementType)o;
        if (this.fLanguage != elementType.getLanguage()) {
            return false;
        }
        return this.fElementTypeName == elementType.getElementTypeName();
    }

    public String toString() {
        return (Object)((Object)this.fLanguage) + " " + (Object)((Object)this.fElementTypeName);
    }

    public static enum ElementTypeLanguage {
        E,
        SV,
        VHDL,
        SLN,
        MSDL,
        PSS,
        CPP;


        public static ElementTypeLanguage from(String n) {
            if (n == null) {
                return null;
            }
            ElementTypeLanguage[] elementTypeLanguageArray = ElementTypeLanguage.values();
            int n2 = elementTypeLanguageArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ElementTypeLanguage type = elementTypeLanguageArray[n3];
                if (type.toString().equalsIgnoreCase(n.trim())) {
                    return type;
                }
                ++n3;
            }
            return null;
        }

        public static String valuesList() {
            return DVTStringUtil.join(Arrays.asList(ElementTypeLanguage.values()), ",");
        }
    }

    public static enum ElementTypeName {
        ASSERT,
        CHECK,
        EVENT,
        EXPECT,
        MACRO,
        METHOD,
        METHOD_TYPE,
        ONEVENT,
        STRUCT,
        CHECKER,
        CHECKER_INSTANCE,
        CLASS,
        CLOCKING_BLOCK,
        CONSTRAINT,
        COVER_GROUP,
        COVER_POINT,
        COVER_CROSS,
        COVER_TRANSITION,
        FIELD,
        FUNCTION,
        GENERATE_BLOCK,
        INTERFACE,
        INTERFACE_INSTANCE,
        MODPORT,
        MODULE,
        MODULE_INSTANCE,
        PACKAGE,
        LIBRARY,
        PRIMITIVE,
        PROGRAM,
        PROGRAM_INSTANCE,
        PROPERTY_SEQUENCE,
        TASK,
        PARAMETER,
        TYPE_PARAMETER,
        ARCHITECTURE,
        BLOCK,
        COMPONENT,
        CONFIGURATION,
        ENTITY,
        INSTANCE,
        PACKAGE_BODY,
        PORT,
        PROCESS,
        SIGNAL,
        TYPE,
        TYPE_BODY,
        VARIABLE,
        VUNIT,
        ALIAS,
        PACKAGE_INSTANCE,
        SUBPROGRAM_INSTANCE,
        TOKEN,
        ACTION,
        ACTIVITY,
        EXEC_BLOCK,
        MSDL_ACTOR,
        MSDL_SCENARIO,
        MSDL_MODIFIER,
        UNION,
        NAMESPACE,
        LINKAGE,
        TYPEDEF;


        public static ElementTypeName from(String n) {
            if (n == null) {
                return null;
            }
            ElementTypeName[] elementTypeNameArray = ElementTypeName.values();
            int n2 = elementTypeNameArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ElementTypeName type = elementTypeNameArray[n3];
                if (type.toString().equalsIgnoreCase(n.trim())) {
                    return type;
                }
                ++n3;
            }
            return null;
        }

        public static String valuesList() {
            return DVTStringUtil.join(Arrays.asList(ElementTypeName.values()), ",");
        }
    }
}

