/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.util.Arrays;
import ro.amiq.dvt.ui.guifilters.ElementTextSet;
import ro.amiq.dvt.ui.guifilters.ElementTypeSet;
import ro.amiq.dvt.ui.guifilters.PathSet;
import ro.amiq.dvt.ui.guifilters.PrecompiledFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.utils.DVTStringUtil;

public class GUIFilter {
    private FilterType fType;
    private FilterKind fKind;
    private String fDescription;
    private String fName;
    private ViewSet fViewSet = ViewSet.ALL;
    private PathSet fPathSet;
    private ElementTypeSet fElementTypeSet;
    private ElementTextSet fElementTextSet;
    private PrecompiledFilter fPrecompiledFilter;

    public FilterType getType() {
        return this.fType;
    }

    public void setType(FilterType type) {
        this.fType = type;
    }

    public FilterKind getKind() {
        return this.fKind;
    }

    public void setKind(FilterKind kind) {
        this.fKind = kind;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public ViewSet getViewSet() {
        return this.fViewSet;
    }

    public void setViewSet(ViewSet viewSet) {
        this.fViewSet = viewSet;
    }

    public PathSet getPathSet() {
        return this.fPathSet;
    }

    public void setPathSet(PathSet pathSet) {
        this.fPathSet = pathSet;
    }

    public ElementTypeSet getElementTypeSet() {
        return this.fElementTypeSet;
    }

    public void setElementTypeSet(ElementTypeSet elementTypeSet) {
        this.fElementTypeSet = elementTypeSet;
    }

    public ElementTextSet getElementTextSet() {
        return this.fElementTextSet;
    }

    public void setElementTextSet(ElementTextSet elementTextSet) {
        this.fElementTextSet = elementTextSet;
    }

    public void setPrecompiledFilter(PrecompiledFilter newPrecompiledFilter) {
        this.fPrecompiledFilter = newPrecompiledFilter;
    }

    public PrecompiledFilter getPrecompiledFilter() {
        return this.fPrecompiledFilter;
    }

    public String toString() {
        return "GUIFilter [fName=" + this.fName + "]";
    }

    public static enum FilterKind {
        HIDE;


        public static FilterKind from(String n) {
            if (n == null) {
                return null;
            }
            FilterKind[] filterKindArray = FilterKind.values();
            int n2 = filterKindArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FilterKind type = filterKindArray[n3];
                if (type.toString().equalsIgnoreCase(n.trim())) {
                    return type;
                }
                ++n3;
            }
            return null;
        }

        public static String valuesList() {
            return DVTStringUtil.join(Arrays.asList(FilterKind.values()), ",");
        }
    }

    public static enum FilterType {
        PREFERENCE,
        PREDEFINED,
        USER_DEFINED;


        public static FilterType from(String n) {
            if (n == null) {
                return null;
            }
            FilterType[] filterTypeArray = FilterType.values();
            int n2 = filterTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FilterType type = filterTypeArray[n3];
                if (type.toString().equalsIgnoreCase(n.trim())) {
                    return type;
                }
                ++n3;
            }
            return null;
        }

        public static String valuesList() {
            return DVTStringUtil.join(Arrays.asList(FilterType.values()), ",");
        }
    }
}

