/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.guifilters;

import java.util.Collections;
import java.util.Map;
import ro.amiq.dvt.utils.LRUCache;
import ro.amiq.dvt.utils.StringMatcher;

public class GUIFilterPatternCache {
    private static final int CACHE_SIZE = 300;
    private static volatile GUIFilterPatternCache fInstance;
    private static final Object fSyncInstance;
    private Map<String, StringMatcher> fStringMatcherCache = Collections.synchronizedMap(new LRUCache(300));

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GUIFilterPatternCache getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new GUIFilterPatternCache();
            }
        }
        return fInstance;
    }

    public StringMatcher getCachedStringMatcher(String pattern, boolean ignoreEscaping) {
        StringMatcher temp = this.fStringMatcherCache.get(pattern);
        if (temp == null) {
            temp = new StringMatcher(pattern, false, false, ignoreEscaping);
            this.fStringMatcherCache.put(pattern, temp);
        }
        return temp;
    }
}

