/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.icons;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class IconColorUtils {
    private static final float SAT_SHIFT = 0.7f;
    private static final float BRI_SHIFT = 0.9f;
    private static final Map<PrimaryColor, Float> COLOR_TO_HUE = new EnumMap<PrimaryColor, Float>(PrimaryColor.class);
    private static final Map<PrimaryColor, Float> COLOR_TO_INDEX;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$ui$icons$IconColorUtils$TransformType;

    static {
        COLOR_TO_HUE.put(PrimaryColor.RED, Float.valueOf(0.0f));
        COLOR_TO_HUE.put(PrimaryColor.YELLOW, Float.valueOf(60.0f));
        COLOR_TO_HUE.put(PrimaryColor.GREEN, Float.valueOf(120.0f));
        COLOR_TO_HUE.put(PrimaryColor.CYAN, Float.valueOf(180.0f));
        COLOR_TO_HUE.put(PrimaryColor.BLUE, Float.valueOf(240.0f));
        COLOR_TO_HUE.put(PrimaryColor.MAGENTA, Float.valueOf(300.0f));
        COLOR_TO_INDEX = new EnumMap<PrimaryColor, Float>(PrimaryColor.class);
        COLOR_TO_INDEX.put(PrimaryColor.RED, Float.valueOf(0.0f));
        COLOR_TO_INDEX.put(PrimaryColor.YELLOW, Float.valueOf(1.0f));
        COLOR_TO_INDEX.put(PrimaryColor.GREEN, Float.valueOf(2.0f));
        COLOR_TO_INDEX.put(PrimaryColor.CYAN, Float.valueOf(3.0f));
        COLOR_TO_INDEX.put(PrimaryColor.BLUE, Float.valueOf(4.0f));
        COLOR_TO_INDEX.put(PrimaryColor.MAGENTA, Float.valueOf(5.0f));
    }

    /*
     * Unable to fully structure code
     */
    public static ImageData applyPixelTransform(ImageData image, HSBInput inputPrefs) {
        block34: {
            block33: {
                transparencyType = image.getTransparencyType();
                alpha = new byte[image.width];
                transparentPixel = image.transparentPixel;
                savedRGB = IconColorUtils.extractRGB(image);
                data = new int[image.width];
                p = new short[3];
                palette = image.palette;
                shiftInput = null;
                if (!palette.isDirect) break block33;
                i = 0;
                while (i < image.height) {
                    image.getPixels(0, i, image.width, data, 0);
                    image.getAlphas(0, i, image.width, alpha, 0);
                    j = 0;
                    while (j < image.width) {
                        value = data[j];
                        p[0] = palette.redShift >= 0 ? (short)((value & palette.redMask) << palette.redShift) : (short)((value & palette.redMask) >>> -palette.redShift);
                        p[1] = palette.greenShift >= 0 ? (short)((value & palette.greenMask) << palette.greenShift) : (short)((value & palette.greenMask) >>> -palette.greenShift);
                        p[2] = palette.blueShift >= 0 ? (short)((value & palette.blueMask) << palette.blueShift) : (short)((value & palette.blueMask) >>> -palette.blueShift);
                        switch (transparencyType) {
                            case 2: {
                                ** GOTO lbl32
                            }
                            case 1: {
                                if (alpha[j] == 0) {
                                    image.setPixel(j, i, palette.getPixel(new RGB((int)p[0], (int)p[1], (int)p[2])));
                                    break;
                                }
                                ** GOTO lbl32
                            }
                            case 4: {
                                if (value == transparentPixel) {
                                    image.setPixel(j, i, palette.getPixel(new RGB((int)p[0], (int)p[1], (int)p[2])));
                                    break;
                                }
                            }
lbl32:
                            // 5 sources

                            default: {
                                if (p[0] == 255 && p[1] == 255 && p[2] == 255) {
                                    image.setPixel(j, i, palette.getPixel(new RGB(255, 255, 255)));
                                    break;
                                }
                                switch (IconColorUtils.$SWITCH_TABLE$ro$amiq$dvt$ui$icons$IconColorUtils$TransformType()[inputPrefs.transformType.ordinal()]) {
                                    case 2: {
                                        if (shiftInput == null) {
                                            shiftInput = IconColorUtils.computeShift(savedRGB, (Object)inputPrefs.shiftColor);
                                        }
                                        newRGB = IconColorUtils.applyShiftOnPixel(p[0], p[1], p[2], shiftInput);
                                        break;
                                    }
                                    case 1: {
                                        newRGB = IconColorUtils.applyHSBOnPixel(p[0], p[1], p[2], inputPrefs);
                                        break;
                                    }
                                    default: {
                                        newRGB = new RGB((int)p[0], (int)p[1], (int)p[2]);
                                    }
                                }
                                newPixel = palette.getPixel(newRGB);
                                image.setPixel(j, i, newPixel);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                break block34;
            }
            table = palette.getRGBs();
            newPalette = new ArrayList<RGB>(table.length);
            i = 0;
            while (i < table.length) {
                newPalette.add(table[i]);
                ++i;
            }
            i = 0;
            while (i < image.height) {
                image.getPixels(0, i, image.width, data, 0);
                j = 0;
                while (j < image.width) {
                    value = table[data[j]];
                    p[0] = (short)value.red;
                    p[1] = (short)value.green;
                    p[2] = (short)value.blue;
                    switch (transparencyType) {
                        case 2: {
                            ** GOTO lbl84
                        }
                        case 1: {
                            if (alpha[j] == 0) {
                                image.setPixel(j, i, palette.getPixel(new RGB((int)p[0], (int)p[1], (int)p[2])));
                                break;
                            }
                            ** GOTO lbl84
                        }
                        case 4: {
                            if (data[j] == transparentPixel) {
                                image.setPixel(j, i, transparentPixel);
                                break;
                            }
                        }
lbl84:
                        // 5 sources

                        default: {
                            if (p[0] == 255 && p[1] == 255 && p[2] == 255) {
                                image.setPixel(j, i, palette.getPixel(new RGB(255, 255, 255)));
                                break;
                            }
                            switch (IconColorUtils.$SWITCH_TABLE$ro$amiq$dvt$ui$icons$IconColorUtils$TransformType()[inputPrefs.transformType.ordinal()]) {
                                case 2: {
                                    if (shiftInput == null) {
                                        shiftInput = IconColorUtils.computeShift(savedRGB, (Object)inputPrefs.shiftColor);
                                    }
                                    newRGB = IconColorUtils.applyShiftOnPixel(p[0], p[1], p[2], shiftInput);
                                    break;
                                }
                                case 1: {
                                    newRGB = IconColorUtils.applyHSBOnPixel(p[0], p[1], p[2], inputPrefs);
                                    break;
                                }
                                default: {
                                    newRGB = new RGB((int)p[0], (int)p[1], (int)p[2]);
                                }
                            }
                            try {
                                newPixel = palette.getPixel(newRGB);
                            }
                            catch (IllegalArgumentException v0) {
                                newPalette.add(newRGB);
                                newPixel = newPalette.indexOf(newRGB);
                            }
                            image.setPixel(j, i, newPixel);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            image.palette = new PaletteData(newPalette.toArray(new RGB[1]));
        }
        return image;
    }

    private static RGB applyHSBOnPixel(short r, short g, short b, Object parameter) {
        if (!(parameter instanceof HSBInput)) {
            return new RGB((int)r, (int)g, (int)b);
        }
        HSBInput input = (HSBInput)parameter;
        float[] hsb = new RGB((int)r, (int)g, (int)b).getHSB();
        float hue = hsb[0];
        float overlap = input.overlap.floatValue();
        float hueShift = input.hue.floatValue();
        float satShift = input.sat.floatValue();
        float briShift = input.bri.floatValue();
        PrimaryColor[] primaryColorArray = PrimaryColor.values();
        int n = primaryColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrimaryColor color = primaryColorArray[n2];
            if (input.getValue(color)) {
                float hueCenter = COLOR_TO_HUE.get((Object)color).floatValue();
                float min = IconColorUtils.truncateCircular(hueCenter - overlap);
                float max = IconColorUtils.truncateCircular(hueCenter + overlap);
                if (min <= hue && hue < max || hue <= max && max < min || max < min && min <= hue) {
                    hsb[0] = IconColorUtils.truncateCircular(hsb[0] + hueShift);
                    hsb[1] = hsb[1] + satShift;
                    hsb[1] = hsb[1] < 0.0f ? 0.0f : (hsb[1] > 1.0f ? 1.0f : hsb[1]);
                    hsb[2] = hsb[2] + briShift;
                    hsb[2] = hsb[2] < 0.0f ? 0.0f : (hsb[2] > 1.0f ? 1.0f : hsb[2]);
                    break;
                }
            }
            ++n2;
        }
        return new RGB(hsb[0], hsb[1], hsb[2]);
    }

    private static float[] computeShift(RGB[][] rgb, Object parameter) {
        if (!(parameter instanceof PrimaryColor)) {
            return new float[]{0.0f, 0.0f};
        }
        PrimaryColor wantedColor = (PrimaryColor)((Object)parameter);
        int height = rgb.length;
        int width = rgb[0].length;
        EnumMap<PrimaryColor, Integer> colorHistogram = new EnumMap<PrimaryColor, Integer>(PrimaryColor.class);
        int x = 0;
        while (x < height) {
            int y = 0;
            while (y < width) {
                PrimaryColor color;
                float[] hsb = rgb[x][y].getHSB();
                float hue = hsb[0];
                if (hsb[1] != 0.0f && hsb[2] != 0.0f && hsb[2] != 1.0f && (color = IconColorUtils.getColorFromHue(hue)) != null) {
                    if (colorHistogram.get((Object)color) == null) {
                        colorHistogram.put(color, 1);
                    } else {
                        colorHistogram.put(color, (Integer)colorHistogram.get((Object)color) + 1);
                    }
                }
                ++y;
            }
            ++x;
        }
        PrimaryColor predominant = wantedColor;
        int max = -1;
        PrimaryColor[] primaryColorArray = PrimaryColor.values();
        int color = primaryColorArray.length;
        int hue = 0;
        while (hue < color) {
            int frequence;
            PrimaryColor color2 = primaryColorArray[hue];
            if (colorHistogram.containsKey((Object)color2) && (frequence = ((Integer)colorHistogram.get((Object)color2)).intValue()) > max) {
                max = frequence;
                predominant = color2;
            }
            ++hue;
        }
        Float shift = Float.valueOf(IconColorUtils.computeColorDifference(wantedColor, predominant));
        float count = 0.0f;
        float sumSat = 0.0f;
        float sumBri = 0.0f;
        int x2 = 0;
        while (x2 < height) {
            int y = 0;
            while (y < width) {
                PrimaryColor color3;
                float[] hsb = rgb[x2][y].getHSB();
                float hue2 = hsb[0];
                float sat = hsb[1];
                float bri = hsb[2];
                if (hsb[1] != 0.0f && hsb[2] != 0.0f && hsb[2] != 1.0f && (color3 = IconColorUtils.getColorFromHue(hue2)) != null) {
                    sumBri += bri;
                    sumSat += sat;
                    count += 1.0f;
                }
                ++y;
            }
            ++x2;
        }
        float meanSat = count == 0.0f ? sumSat : sumSat / count;
        float meanBri = count == 0.0f ? sumBri : sumBri / count;
        Float satShift = Float.valueOf(0.7f - meanSat);
        Float briShift = Float.valueOf(0.9f - meanBri);
        return new float[]{shift.floatValue(), satShift.floatValue(), briShift.floatValue()};
    }

    private static float computeColorDifference(PrimaryColor wanted, PrimaryColor predominant) {
        return COLOR_TO_INDEX.get((Object)wanted).floatValue() - COLOR_TO_INDEX.get((Object)predominant).floatValue();
    }

    private static PrimaryColor computeColorIndexShift(PrimaryColor color, float shift) {
        float colorIndex = COLOR_TO_INDEX.get((Object)color).floatValue();
        colorIndex = (colorIndex += shift) < 0.0f ? 6.0f + colorIndex : (colorIndex > 5.0f ? colorIndex - 6.0f : colorIndex);
        switch ((int)colorIndex) {
            case 0: {
                return PrimaryColor.RED;
            }
            case 1: {
                return PrimaryColor.YELLOW;
            }
            case 2: {
                return PrimaryColor.GREEN;
            }
            case 3: {
                return PrimaryColor.CYAN;
            }
            case 4: {
                return PrimaryColor.BLUE;
            }
            case 5: {
                return PrimaryColor.MAGENTA;
            }
        }
        return PrimaryColor.BLUE;
    }

    private static RGB applyShiftOnPixel(short r, short g, short b, float[] shiftInput) {
        float[] hsb = new RGB((int)r, (int)g, (int)b).getHSB();
        float hue = hsb[0];
        float sat = hsb[1];
        float bri = hsb[2];
        PrimaryColor currentColor = IconColorUtils.getColorFromHue(hue);
        if (currentColor == null) {
            return new RGB(hue, sat, bri);
        }
        float[] currentColorInterval = IconColorUtils.getColorInterval(currentColor);
        PrimaryColor wantedColor = IconColorUtils.computeColorIndexShift(currentColor, shiftInput[0]);
        float[] wantedColorInterval = IconColorUtils.getColorInterval(wantedColor);
        float currentColorPercentage = currentColor == PrimaryColor.RED ? (hue + (360.0f - currentColorInterval[0])) / (360.0f - currentColorInterval[0] + currentColorInterval[1]) : (hue - currentColorInterval[0]) / (currentColorInterval[1] - currentColorInterval[0]);
        hue = wantedColor == PrimaryColor.RED ? wantedColorInterval[0] + currentColorPercentage * (360.0f - wantedColorInterval[0] + wantedColorInterval[1]) : wantedColorInterval[0] + currentColorPercentage * (wantedColorInterval[1] - wantedColorInterval[0]);
        sat = (sat += shiftInput[1]) < 0.0f ? 0.0f : (sat > 1.0f ? 1.0f : sat);
        bri = bri < 0.0f ? 0.0f : (bri > 1.0f ? 1.0f : (bri += shiftInput[2]));
        return new RGB(IconColorUtils.truncateCircular(hue), sat, bri);
    }

    private static RGB[][] extractRGB(ImageData image) {
        RGB[][] pixels = new RGB[image.height][image.width];
        PaletteData palette = image.palette;
        int[] data = new int[image.width];
        short[] p = new short[3];
        if (palette.isDirect) {
            int i = 0;
            while (i < image.height) {
                image.getPixels(0, i, image.width, data, 0);
                int j = 0;
                while (j < image.width) {
                    int value = data[j];
                    p[0] = palette.redShift >= 0 ? (short)((value & palette.redMask) << palette.redShift) : (short)((value & palette.redMask) >>> -palette.redShift);
                    p[1] = palette.greenShift >= 0 ? (short)((value & palette.greenMask) << palette.greenShift) : (short)((value & palette.greenMask) >>> -palette.greenShift);
                    p[2] = palette.blueShift >= 0 ? (short)((value & palette.blueMask) << palette.blueShift) : (short)((value & palette.blueMask) >>> -palette.blueShift);
                    pixels[i][j] = new RGB((int)p[0], (int)p[1], (int)p[2]);
                    ++j;
                }
                ++i;
            }
        } else {
            RGB[] table = palette.getRGBs();
            int i = 0;
            while (i < image.height) {
                image.getPixels(0, i, image.width, data, 0);
                int j = 0;
                while (j < image.width) {
                    RGB value = table[data[j]];
                    p[0] = (short)value.red;
                    p[1] = (short)value.green;
                    p[2] = (short)value.blue;
                    pixels[i][j] = new RGB((int)p[0], (int)p[1], (int)p[2]);
                    ++j;
                }
                ++i;
            }
        }
        return pixels;
    }

    private static float[] getColorInterval(PrimaryColor wantedColor) {
        switch (wantedColor) {
            case RED: {
                return new float[]{340.0f, 40.0f};
            }
            case YELLOW: {
                return new float[]{40.0f, 80.0f};
            }
            case GREEN: {
                return new float[]{80.0f, 160.0f};
            }
            case CYAN: {
                return new float[]{160.0f, 200.0f};
            }
            case BLUE: {
                return new float[]{200.0f, 280.0f};
            }
            case MAGENTA: {
                return new float[]{280.0f, 320.0f};
            }
        }
        return new float[]{200.0f, 280.0f};
    }

    private static PrimaryColor getColorFromHue(float hue) {
        if (hue >= 340.0f || hue <= 40.0f) {
            return PrimaryColor.RED;
        }
        if (hue > 40.0f && hue < 80.0f) {
            return PrimaryColor.YELLOW;
        }
        if (hue >= 80.0f && hue <= 160.0f) {
            return PrimaryColor.GREEN;
        }
        if (hue > 160.0f && hue < 200.0f) {
            return PrimaryColor.CYAN;
        }
        if (hue >= 200.0f && hue <= 280.0f) {
            return PrimaryColor.BLUE;
        }
        if (hue > 280.0f && hue < 320.0f) {
            return PrimaryColor.MAGENTA;
        }
        return null;
    }

    private static float truncateCircular(float hsbValue) {
        return hsbValue < 0.0f ? 360.0f + hsbValue : (hsbValue > 360.0f ? hsbValue - 360.0f : hsbValue);
    }

    public static float max(float ... args) {
        float max = -0.1f;
        float[] fArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            float no = fArray[n2];
            if (no > max) {
                max = no;
            }
            ++n2;
        }
        return max;
    }

    public static short max(short ... args) {
        short max = 0;
        short[] sArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            short no = sArray[n2];
            if (no > max) {
                max = no;
            }
            ++n2;
        }
        return max;
    }

    public static float min(float ... args) {
        float min = 1.01f;
        float[] fArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            float no = fArray[n2];
            if (no < min) {
                min = no;
            }
            ++n2;
        }
        return min;
    }

    public static PrimaryColor stringToColor(String str) {
        switch (str) {
            case "Red": {
                return PrimaryColor.RED;
            }
            case "Yellow": {
                return PrimaryColor.YELLOW;
            }
            case "Green": {
                return PrimaryColor.GREEN;
            }
            case "Cyan": {
                return PrimaryColor.CYAN;
            }
            case "Blue": {
                return PrimaryColor.BLUE;
            }
            case "Magenta": {
                return PrimaryColor.MAGENTA;
            }
        }
        return PrimaryColor.RED;
    }

    public static PrimaryColor toColor(Color color) {
        RGB rgb = color.getRGB();
        if (rgb.equals((Object)new RGB(255, 0, 0))) {
            return PrimaryColor.RED;
        }
        if (rgb.equals((Object)new RGB(255, 255, 0))) {
            return PrimaryColor.YELLOW;
        }
        if (rgb.equals((Object)new RGB(0, 255, 0))) {
            return PrimaryColor.GREEN;
        }
        if (rgb.equals((Object)new RGB(0, 255, 255))) {
            return PrimaryColor.CYAN;
        }
        if (rgb.equals((Object)new RGB(0, 0, 255))) {
            return PrimaryColor.BLUE;
        }
        return PrimaryColor.MAGENTA;
    }

    public static Color toColor(PrimaryColor color) {
        switch (color) {
            case RED: {
                return DVTColorUtil.INSTANCE.getColor(255, 0, 0);
            }
            case YELLOW: {
                return DVTColorUtil.INSTANCE.getColor(255, 255, 0);
            }
            case GREEN: {
                return DVTColorUtil.INSTANCE.getColor(0, 255, 0);
            }
            case CYAN: {
                return DVTColorUtil.INSTANCE.getColor(0, 255, 255);
            }
            case BLUE: {
                return DVTColorUtil.INSTANCE.getColor(0, 0, 255);
            }
            case MAGENTA: {
                return DVTColorUtil.INSTANCE.getColor(255, 0, 255);
            }
        }
        return DVTColorUtil.INSTANCE.getColor(0, 0, 255);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$ui$icons$IconColorUtils$TransformType() {
        if ($SWITCH_TABLE$ro$amiq$dvt$ui$icons$IconColorUtils$TransformType != null) {
            return $SWITCH_TABLE$ro$amiq$dvt$ui$icons$IconColorUtils$TransformType;
        }
        int[] nArray = new int[TransformType.values().length];
        try {
            nArray[TransformType.HSB.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TransformType.SHIFTCOLOR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ro$amiq$dvt$ui$icons$IconColorUtils$TransformType = nArray;
        return nArray;
    }

    public static class HSBInput {
        public String name;
        public String newName;
        public TransformType transformType;
        public PrimaryColor shiftColor;
        public Float hue;
        public Float sat;
        public Float bri;
        public Float overlap;
        public boolean red;
        public boolean yellow;
        public boolean green;
        public boolean cyan;
        public boolean blue;
        public boolean magenta;

        public HSBInput(String name) {
            this.name = name;
            this.transformType = TransformType.HSB;
            this.hue = Float.valueOf(0.0f);
            this.sat = Float.valueOf(0.0f);
            this.bri = Float.valueOf(0.0f);
            this.overlap = Float.valueOf(60.0f);
            this.red = true;
            this.yellow = true;
            this.green = true;
            this.cyan = true;
            this.blue = true;
            this.magenta = true;
        }

        public HSBInput(TransformType type, String name, Float hue, Float sat, Float bri, Float o, boolean r, boolean y, boolean g, boolean c, boolean b, boolean m) {
            this.name = name;
            this.transformType = type;
            this.hue = hue;
            this.sat = sat;
            this.bri = bri;
            this.red = r;
            this.yellow = y;
            this.green = g;
            this.cyan = c;
            this.blue = b;
            this.magenta = m;
            this.overlap = o;
            if (this.overlap.floatValue() == -180.0f) {
                this.overlap = Float.valueOf(-179.99f);
            } else if (this.overlap.floatValue() == 180.0f) {
                this.overlap = Float.valueOf(179.99f);
            }
        }

        public HSBInput(PrimaryColor shiftColor) {
            this.transformType = TransformType.SHIFTCOLOR;
            this.shiftColor = shiftColor;
            this.name = shiftColor.toString().toLowerCase();
            this.name = this.name.substring(0, 1).toUpperCase().concat(this.name.substring(1));
        }

        public boolean getValue(PrimaryColor color) {
            switch (color) {
                case RED: {
                    return this.red;
                }
                case YELLOW: {
                    return this.yellow;
                }
                case GREEN: {
                    return this.green;
                }
                case CYAN: {
                    return this.cyan;
                }
                case BLUE: {
                    return this.blue;
                }
                case MAGENTA: {
                    return this.magenta;
                }
            }
            return false;
        }

        public String serialize() {
            StringBuilder serial = new StringBuilder();
            serial.append((Object)this.transformType);
            serial.append(',');
            serial.append(this.name);
            serial.append(',');
            if (this.transformType == TransformType.HSB) {
                serial.append(this.hue);
                serial.append(",");
                serial.append(this.sat);
                serial.append(",");
                serial.append(this.bri);
                serial.append(",");
                serial.append(this.overlap);
                serial.append(",");
                serial.append(this.red ? 1 : 0);
                serial.append(",");
                serial.append(this.yellow ? 1 : 0);
                serial.append(",");
                serial.append(this.green ? 1 : 0);
                serial.append(",");
                serial.append(this.cyan ? 1 : 0);
                serial.append(",");
                serial.append(this.blue ? 1 : 0);
                serial.append(",");
                serial.append(this.magenta ? 1 : 0);
            }
            return serial.toString();
        }
    }

    public static enum PrimaryColor {
        RED,
        YELLOW,
        GREEN,
        CYAN,
        BLUE,
        MAGENTA;

    }

    public static enum TransformType {
        HSB,
        SHIFTCOLOR;

    }
}

