/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.icons;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.ui.icons.IconColorUtils;
import ro.amiq.dvt.ui.icons.IconsPreferencePage;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class IconImageDescriptor
extends ImageDescriptor {
    private static LinkedHashMap<String, IconColorUtils.HSBInput> iconColorPreferences = new LinkedHashMap();
    private static Set<ImageDescriptor> allAffectedDescriptors = null;
    private URL fURL;
    private ImageData fOriginalImageData;
    private ImageData fProcessedImageData;

    public IconImageDescriptor(URL url) {
        this.fURL = url;
        this.fOriginalImageData = null;
        this.fProcessedImageData = null;
    }

    public ImageData getImageData() {
        if (iconColorPreferences.isEmpty()) {
            IconImageDescriptor.loadIconPreferences(this);
        }
        if (this.fProcessedImageData == null) {
            this.fOriginalImageData = IconImageDescriptor.createFromURL((URL)this.fURL).getImageData();
            this.fProcessedImageData = IconImageDescriptor.createFromURL((URL)this.fURL).getImageData();
            IconColorUtils.HSBInput input = iconColorPreferences.get(this.toString());
            if (input != null) {
                Image tmp = new Image((Device)Display.getDefault(), this.fOriginalImageData);
                this.fProcessedImageData = IconColorUtils.applyPixelTransform(tmp.getImageData(), input);
                tmp.dispose();
            }
        }
        return this.fProcessedImageData;
    }

    public IconColorUtils.HSBInput getFilterInput() {
        if (iconColorPreferences.isEmpty()) {
            IconImageDescriptor.loadIconPreferences(this);
        }
        return iconColorPreferences.get(this.toString());
    }

    public Image createImage() {
        if (this.fProcessedImageData == null) {
            this.getImageData();
        }
        return new Image((Device)Display.getDefault(), this.fProcessedImageData);
    }

    public Image createOriginalImage() {
        if (this.fOriginalImageData == null) {
            this.getImageData();
        }
        return new Image((Device)Display.getDefault(), this.fOriginalImageData);
    }

    public static String getFilterNameForIcon(ImageDescriptor desc) {
        if (iconColorPreferences == null) {
            return "";
        }
        IconColorUtils.HSBInput input = iconColorPreferences.get(desc.toString());
        return input == null ? "" : input.name;
    }

    private static void flushIconPreferences() {
        StringBuilder serial = new StringBuilder();
        for (Map.Entry<String, IconColorUtils.HSBInput> entry : iconColorPreferences.entrySet()) {
            serial.append(entry.getKey());
            serial.append('=');
            serial.append(entry.getValue().serialize());
            serial.append("\n");
        }
        PrefConst.setIconColorAppliedFilters(serial.toString());
    }

    public static void addColorPreferences(Map<String, IconColorUtils.HSBInput> imageDescNamesToInputs) {
        for (Map.Entry<String, IconColorUtils.HSBInput> entry : imageDescNamesToInputs.entrySet()) {
            String imageDescriptorName = entry.getKey();
            IconColorUtils.HSBInput input = entry.getValue();
            if (iconColorPreferences.containsKey(imageDescriptorName)) {
                if (input == null) {
                    iconColorPreferences.remove(imageDescriptorName);
                    continue;
                }
                iconColorPreferences.put(imageDescriptorName, input);
                continue;
            }
            if (input == null) continue;
            iconColorPreferences.put(imageDescriptorName, input);
        }
        IconImageDescriptor.flushIconPreferences();
    }

    private static void loadIconPreferences(IconImageDescriptor source) {
        if (allAffectedDescriptors == null) {
            allAffectedDescriptors = IconsPreferencePage.getAllAffectedDescriptors();
        }
        if (!allAffectedDescriptors.contains((Object)source)) {
            return;
        }
        String prefs = PrefConst.getIconColorAppliedFilters();
        if (prefs == null || prefs.isEmpty()) {
            return;
        }
        String[] lines = prefs.split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            String[] split = line.split("=");
            String imageDescriptorName = split[0];
            String[] colorPrefs = split[1].split(",");
            if (colorPrefs[0].equals("SHIFTCOLOR")) {
                input = new IconColorUtils.HSBInput(IconColorUtils.stringToColor(colorPrefs[1]));
                iconColorPreferences.put(imageDescriptorName, input);
            } else if (colorPrefs.length == 12 && colorPrefs[0].equals("HSB")) {
                input = new IconColorUtils.HSBInput(IconColorUtils.TransformType.HSB, colorPrefs[1], Float.valueOf(Float.parseFloat(colorPrefs[2])), Float.valueOf(Float.parseFloat(colorPrefs[3])), Float.valueOf(Float.parseFloat(colorPrefs[4])), Float.valueOf(Float.parseFloat(colorPrefs[5])), colorPrefs[6].equals("1"), colorPrefs[7].equals("1"), colorPrefs[8].equals("1"), colorPrefs[9].equals("1"), colorPrefs[10].equals("1"), colorPrefs[11].equals("1"));
                iconColorPreferences.put(imageDescriptorName, input);
            }
            ++i;
        }
    }

    public int hashCode() {
        return this.fURL == null ? 0 : this.fURL.toExternalForm().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        URL objUrl = ((IconImageDescriptor)((Object)obj)).fURL;
        URL thisUrl = this.fURL;
        if (objUrl == null && thisUrl == null) {
            return true;
        }
        if (objUrl == null || thisUrl == null) {
            return false;
        }
        return objUrl.toExternalForm().equals(thisUrl.toExternalForm());
    }

    public String toString() {
        if (this.fURL == null) {
            return "null";
        }
        String toReturn = this.fURL.toString();
        toReturn = toReturn.substring(toReturn.indexOf("obj16/") + 6);
        return toReturn;
    }

    public URL getURL() {
        return this.fURL;
    }
}

