/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.icons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.RestartRequiredDialog;
import ro.amiq.dvt.ui.icons.IconColorUtils;
import ro.amiq.dvt.ui.icons.IconImageDescriptor;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class IconsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final List<ImageDescriptor> PREVIEW_IMAGES = Arrays.asList(DVTImages.OUTLINE_FIELD, DVTImages.OUTLINE_PACKAGE, DVTImages.OUTLINE_METHOD, DVTImages.OUTLINE_COVERGROUP, DVTImages.OUTLINE_SEQUENCE, DVTImages.ASSUME, DVTImages.OUTLINE_MODULE_INSTANCE, DVTImages.OUTLINE_CONDITION, DVTImages.OUTLINE_UNIT_EXTEND, DVTImages.OUTLINE_LIBRARY, DVTImages.TRACE_WHY_PORT_CONNECTION);
    private static final String[] PRESET_FILTERS = new String[]{"Red", "Yellow", "Green", "Cyan", "Blue", "Magenta"};
    private static final Set<String> PRESET_FILTERS_SET = new HashSet<String>(Arrays.asList(PRESET_FILTERS));
    private static final String DEFAULT_NO_FILTER_NAME = "Default";
    private static final String FILTER_DEFAULT_NAME = "Custom Color Filter";
    private static final String SUBTITLE_LABEL = "Color Filter";
    private static final String EDIT_BUTTON_TEXT = "Edit...";
    private static Set<ImageDescriptor> allAffectedDescriptors = null;
    private static final Map<String, ImageDescriptor> SVNameToIcon = new LinkedHashMap<String, ImageDescriptor>();
    private static final Map<String, ImageDescriptor> ENameToIcon;
    private static final Map<String, ImageDescriptor> VHDLNameToIcon;
    private boolean fIsApplied;
    private static List<String> allFilterNames;
    private static Map<String, IconColorUtils.HSBInput> allFilterNameToInput;
    private List<TreeItem> allItems;
    private Tree fIconTree;
    private Label fSubtitleLabel;
    private Combo fAllFiltersCombo;
    private Button fEditButton;
    private Display fDisplay = DVTUiUtils.getActiveWorkbenchShell().getDisplay();
    private Map<String, Image> fOriginalImages = new HashMap<String, Image>();

    static {
        SVNameToIcon.put("Always", DVTImages.OUTLINE_ALWAYS);
        SVNameToIcon.put("Argument", DVTImages.OUTLINE_ARGUMENT);
        SVNameToIcon.put("Assert Concurrent", DVTImages.OUTLINE_ASSERT_CONCURRENT);
        SVNameToIcon.put("Assert Immediate Deferred", DVTImages.OUTLINE_ASSERT_IMMEDIATE_DEFERRED);
        SVNameToIcon.put("Assign", DVTImages.OUTLINE_ASSIGN);
        SVNameToIcon.put("Assume Immediate Deferred", DVTImages.OUTLINE_ASSUME_IMMEDIATE_DEFERRED);
        SVNameToIcon.put("Checker", DVTImages.OUTLINE_CHECKER);
        SVNameToIcon.put("Checker Instance", DVTImages.OUTLINE_CHECKER_INSTANCE);
        SVNameToIcon.put("Class", DVTImages.OUTLINE_CLASS);
        SVNameToIcon.put("Class Instance", DVTImages.CLASS_INSTANCE);
        SVNameToIcon.put("Class Interface", DVTImages.OUTLINE_INTERFACE_CLASS);
        SVNameToIcon.put("Clocking Block", DVTImages.OUTLINE_CLOCKING);
        SVNameToIcon.put("Configuration", DVTImages.OUTLINE_CONFIGURATION);
        SVNameToIcon.put("Constant", DVTImages.OUTLINE_CONSTANT);
        SVNameToIcon.put("Constraint", DVTImages.OUTLINE_CONSTRAINT);
        SVNameToIcon.put("Constructor", DVTImages.OUTLINE_CONSTRUCTOR);
        SVNameToIcon.put("Cover Concurrent", DVTImages.OUTLINE_COVER_CONCURRENT);
        SVNameToIcon.put("Cover Cross", DVTImages.COVER_CROSS);
        SVNameToIcon.put("Cover Group", DVTImages.OUTLINE_COVERGROUP);
        SVNameToIcon.put("Cover Item", DVTImages.COVER_ITEM);
        SVNameToIcon.put("Cover Immediate", DVTImages.OUTLINE_COVER_IMMEDIATE);
        SVNameToIcon.put("Cover Immediate Deferred", DVTImages.OUTLINE_COVER_IMMEDIATE_DEFERRED);
        SVNameToIcon.put("Cover Transition", DVTImages.COVER_TRANSITION);
        SVNameToIcon.put("Enumeration name", DVTImages.OUTLINE_ENUM_ITEM);
        SVNameToIcon.put("Event", DVTImages.OUTLINE_EVENT);
        SVNameToIcon.put("Field", DVTImages.OUTLINE_FIELD);
        SVNameToIcon.put("Function", DVTImages.OUTLINE_METHOD);
        SVNameToIcon.put("Generate", DVTImages.OUTLINE_CONDITION);
        SVNameToIcon.put("Interface", DVTImages.OUTLINE_INTERFACE);
        SVNameToIcon.put("Interface instance", DVTImages.OUTLINE_INTERFACE_INSTANCE);
        SVNameToIcon.put("Library", DVTImages.OUTLINE_LIBRARY);
        SVNameToIcon.put("Local Parameter", DVTImages.OUTLINE_LOCAL_PARAM);
        SVNameToIcon.put("Modport", DVTImages.OUTLINE_MODPORT);
        SVNameToIcon.put("Module", DVTImages.OUTLINE_MODULE);
        SVNameToIcon.put("Module instance", DVTImages.OUTLINE_MODULE_INSTANCE);
        SVNameToIcon.put("Parameter", DVTImages.OUTLINE_PARAM);
        SVNameToIcon.put("Package", DVTImages.OUTLINE_PACKAGE);
        SVNameToIcon.put("Preproc - Define Match", DVTImages.DEFINE_INSTANCE);
        SVNameToIcon.put("Preproc - Define", DVTImages.PREPROC_DEFINE);
        SVNameToIcon.put("Preproc - Ifdef / Ifndef", DVTImages.PREPROC_IFDEF);
        SVNameToIcon.put("Preproc - Undefine", DVTImages.PREPROC_UNDEF);
        SVNameToIcon.put("Primitive", DVTImages.OUTLINE_PRIMITIVE);
        SVNameToIcon.put("Primitive Instance", DVTImages.OUTLINE_PRIMITIVE_INSTANCE);
        SVNameToIcon.put("Program", DVTImages.OUTLINE_PROGRAM);
        SVNameToIcon.put("Program Instance", DVTImages.OUTLINE_PROGRAM_INSTANCE);
        SVNameToIcon.put("Port - Input", DVTImages.OUTLINE_INPUT_PORT);
        SVNameToIcon.put("Port - Inout", DVTImages.OUTLINE_INOUT_PORT);
        SVNameToIcon.put("Port - Interface", DVTImages.OUTLINE_INTERFACE_PORT);
        SVNameToIcon.put("Port - Output", DVTImages.OUTLINE_OUTPUT_PORT);
        SVNameToIcon.put("Port - Reference", DVTImages.OUTLINE_REF);
        SVNameToIcon.put("Property", DVTImages.OUTLINE_PROPERTY);
        SVNameToIcon.put("Sequence", DVTImages.OUTLINE_SEQUENCE);
        SVNameToIcon.put("Sequence item", DVTImages.OUTLINE_SEQUENCE_ITEM);
        SVNameToIcon.put("Task", DVTImages.OUTLINE_TASK);
        SVNameToIcon.put("Type Parameter", DVTImages.OUTLINE_TYPE_PARAM);
        SVNameToIcon.put("Typedef", DVTImages.OUTLINE_TYPE);
        SVNameToIcon.put("Variable", DVTImages.OUTLINE_VARIABLE);
        SVNameToIcon.put("Virtual Interface", DVTImages.XVM_VIRTUAL_INTERFACE);
        SVNameToIcon.put("Wire", DVTImages.OUTLINE_WIRE);
        SVNameToIcon.put("XVM Component", DVTImages.XVM_CLASS_COMPONENT);
        SVNameToIcon.put("XVM Component Instance", DVTImages.XVM_COMPONENT_INSTANCE);
        SVNameToIcon.put("XVM Factory Registered Field", DVTImages.XVM_FIELD_REGISTERED);
        SVNameToIcon.put("XVM Root", DVTImages.XVM_ROOT);
        SVNameToIcon.put("XVM Test", DVTImages.XVM_TEST);
        ENameToIcon = new LinkedHashMap<String, ImageDescriptor>();
        ENameToIcon.put("Argument", DVTImages.OUTLINE_ARGUMENT);
        ENameToIcon.put("Assert", DVTImages.ASSERT);
        ENameToIcon.put("Assume", DVTImages.ASSUME);
        ENameToIcon.put("Constraint", DVTImages.OUTLINE_CONSTRAINT);
        ENameToIcon.put("Constant", DVTImages.OUTLINE_CONSTANT);
        ENameToIcon.put("Check That", DVTImages.CHECK);
        ENameToIcon.put("Cover Cross", DVTImages.COVER_CROSS);
        ENameToIcon.put("Cover Group", DVTImages.OUTLINE_COVERGROUP);
        ENameToIcon.put("Cover Item", DVTImages.COVER_ITEM);
        ENameToIcon.put("Cover Transition", DVTImages.COVER_TRANSITION);
        ENameToIcon.put("Enumeration item", DVTImages.OUTLINE_ENUM_ITEM);
        ENameToIcon.put("Event", DVTImages.OUTLINE_EVENT);
        ENameToIcon.put("Expect", DVTImages.EXPECT);
        ENameToIcon.put("Field", DVTImages.OUTLINE_FIELD);
        ENameToIcon.put("Library", DVTImages.OUTLINE_LIBRARY);
        ENameToIcon.put("Method", DVTImages.OUTLINE_METHOD);
        ENameToIcon.put("Method Type", DVTImages.METHOD_TYPE);
        ENameToIcon.put("On Event", DVTImages.OUTLINE_ON_EVENT);
        ENameToIcon.put("Package", DVTImages.OUTLINE_PACKAGE);
        ENameToIcon.put("Port - Input Buffer", DVTImages.PORT_BUFFER_IN);
        ENameToIcon.put("Port - Input Event", DVTImages.PORT_EVENT_IN);
        ENameToIcon.put("Port - Input Interface", DVTImages.PORT_INTERFACE_IN);
        ENameToIcon.put("Port - Input Method", DVTImages.PORT_METHOD_IN);
        ENameToIcon.put("Port - Input Simple", DVTImages.PORT_SIMPLE_IN);
        ENameToIcon.put("Port - Inout Event", DVTImages.PORT_EVENT_INOUT);
        ENameToIcon.put("Port - Inout Simple", DVTImages.PORT_SIMPLE_INOUT);
        ENameToIcon.put("Port - Output Buffer", DVTImages.PORT_BUFFER_OUT);
        ENameToIcon.put("Port - Output Event", DVTImages.PORT_EVENT_OUT);
        ENameToIcon.put("Port - Output Interface", DVTImages.PORT_INTERFACE_OUT);
        ENameToIcon.put("Port - Output Method", DVTImages.PORT_METHOD_OUT);
        ENameToIcon.put("Port - Output Simple", DVTImages.PORT_SIMPLE_OUT);
        ENameToIcon.put("Preproc - Define", DVTImages.PREPROC_DEFINE);
        ENameToIcon.put("Preproc - Define As", DVTImages.DEFINE_AS);
        ENameToIcon.put("Preproc - Define As Computed", DVTImages.DEFINE_AS_COMPUTED);
        ENameToIcon.put("Preproc - Define As Computed Match", DVTImages.DEFINE_INSTANCE_AS_COMPUTED);
        ENameToIcon.put("Preproc - Define As Match", DVTImages.DEFINE_AS_INSTANCE);
        ENameToIcon.put("Preproc - Ifdef / Ifndef", DVTImages.PREPROC_IFDEF);
        ENameToIcon.put("Preproc - Undefine", DVTImages.PREPROC_UNDEF);
        ENameToIcon.put("Sequence", DVTImages.OUTLINE_SEQUENCE);
        ENameToIcon.put("Sequence item", DVTImages.OUTLINE_SEQUENCE_ITEM);
        ENameToIcon.put("Struct", DVTImages.OUTLINE_STRUCT);
        ENameToIcon.put("Struct Extend Layer", DVTImages.OUTLINE_STRUCT_EXTEND);
        ENameToIcon.put("Struct When", DVTImages.OUTLINE_STRUCT_WHEN);
        ENameToIcon.put("Type", DVTImages.OUTLINE_TYPE);
        ENameToIcon.put("Type Extend Layer", DVTImages.OUTLINE_TYPE_EXTEND);
        ENameToIcon.put("Unit", DVTImages.OUTLINE_UNIT);
        ENameToIcon.put("Unit Extend Layer", DVTImages.OUTLINE_UNIT_EXTEND);
        ENameToIcon.put("Unit Instance", DVTImages.OUTLINE_UNIT_INSTANCE);
        ENameToIcon.put("Unit When Subtype", DVTImages.OUTLINE_UNIT_WHEN);
        ENameToIcon.put("Variable", DVTImages.OUTLINE_VARIABLE);
        VHDLNameToIcon = new LinkedHashMap<String, ImageDescriptor>();
        VHDLNameToIcon.put("Architecture", DVTImages.OUTLINE_ARCHITECTURE);
        VHDLNameToIcon.put("Argument", DVTImages.OUTLINE_ARGUMENT);
        VHDLNameToIcon.put("Attribute", DVTImages.OUTLINE_ATTRIBUTE);
        VHDLNameToIcon.put("Block", DVTImages.OUTLINE_BLOCK);
        VHDLNameToIcon.put("Component", DVTImages.OUTLINE_COMPONENT);
        VHDLNameToIcon.put("Component Instance", DVTImages.OUTLINE_COMPONENT_INSTANCE);
        VHDLNameToIcon.put("Constant", DVTImages.OUTLINE_CONSTANT);
        VHDLNameToIcon.put("Configuration", DVTImages.OUTLINE_CONFIGURATION);
        VHDLNameToIcon.put("Configuration Instance", DVTImages.OUTLINE_CONFIGURATION_INSTANCE);
        VHDLNameToIcon.put("Entity", DVTImages.OUTLINE_ENTITY);
        VHDLNameToIcon.put("Entity Instance", DVTImages.OUTLINE_ENTITY_INSTANCE);
        VHDLNameToIcon.put("Enumeration Literal", DVTImages.OUTLINE_ENUM_ITEM);
        VHDLNameToIcon.put("Function", DVTImages.OUTLINE_METHOD);
        VHDLNameToIcon.put("Field", DVTImages.OUTLINE_FIELD);
        VHDLNameToIcon.put("Generate", DVTImages.OUTLINE_CONDITION);
        VHDLNameToIcon.put("Generic", DVTImages.OUTLINE_GENERIC);
        VHDLNameToIcon.put("Library", DVTImages.OUTLINE_LIBRARY);
        VHDLNameToIcon.put("Package", DVTImages.OUTLINE_PACKAGE);
        VHDLNameToIcon.put("Procedure", DVTImages.OUTLINE_PROCEDURE);
        VHDLNameToIcon.put("Property", DVTImages.OUTLINE_PROPERTY);
        VHDLNameToIcon.put("Port - Buffer", DVTImages.OUTLINE_BUFFER_PORT);
        VHDLNameToIcon.put("Port - Input", DVTImages.OUTLINE_INPUT_PORT);
        VHDLNameToIcon.put("Port - Inout", DVTImages.OUTLINE_INOUT_PORT);
        VHDLNameToIcon.put("Port - Output", DVTImages.OUTLINE_OUTPUT_PORT);
        VHDLNameToIcon.put("Port - Linkage", DVTImages.OUTLINE_LINKAGE_PORT);
        VHDLNameToIcon.put("Sequence", DVTImages.OUTLINE_SEQUENCE);
        VHDLNameToIcon.put("Signal", DVTImages.OUTLINE_SIGNAL);
        VHDLNameToIcon.put("Type", DVTImages.OUTLINE_TYPE);
        VHDLNameToIcon.put("Variable", DVTImages.OUTLINE_VARIABLE);
        allFilterNames = null;
        allFilterNameToInput = null;
    }

    public static Set<ImageDescriptor> getAllAffectedDescriptors() {
        if (allAffectedDescriptors == null) {
            allAffectedDescriptors = new LinkedHashSet<ImageDescriptor>();
            allAffectedDescriptors.addAll(SVNameToIcon.values());
            allAffectedDescriptors.addAll(VHDLNameToIcon.values());
            allAffectedDescriptors.addAll(ENameToIcon.values());
        }
        return allAffectedDescriptors;
    }

    public IconsPreferencePage() {
        this.loadColorFilters();
        this.fIsApplied = true;
    }

    private void loadColorFilters() {
        allFilterNames = new ArrayList<String>(Arrays.asList(PRESET_FILTERS));
        allFilterNameToInput = new HashMap<String, IconColorUtils.HSBInput>();
        for (String filter : allFilterNames) {
            allFilterNameToInput.put(filter, new IconColorUtils.HSBInput(IconColorUtils.stringToColor(filter)));
        }
        allFilterNames.add(0, DEFAULT_NO_FILTER_NAME);
        String separator = System.getProperty("line.separator");
        String prefs = PrefConst.getIconColorCustomFilters();
        if (prefs.isEmpty()) {
            return;
        }
        String[] lines = prefs.split(separator);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            String[] split = line.split("=");
            String filterName = split[0];
            String[] hsbInputPrefs = split[1].split(",");
            if (hsbInputPrefs.length == 12 && hsbInputPrefs[0].equals("HSB")) {
                IconColorUtils.HSBInput input = new IconColorUtils.HSBInput(IconColorUtils.TransformType.HSB, hsbInputPrefs[1], Float.valueOf(Float.parseFloat(hsbInputPrefs[2])), Float.valueOf(Float.parseFloat(hsbInputPrefs[3])), Float.valueOf(Float.parseFloat(hsbInputPrefs[4])), Float.valueOf(Float.parseFloat(hsbInputPrefs[5])), hsbInputPrefs[6].equals("1"), hsbInputPrefs[7].equals("1"), hsbInputPrefs[8].equals("1"), hsbInputPrefs[9].equals("1"), hsbInputPrefs[10].equals("1"), hsbInputPrefs[11].equals("1"));
                allFilterNames.add(filterName);
                allFilterNameToInput.put(filterName, input);
            }
            ++i;
        }
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        parent.setLayout((Layout)new GridLayout(1, true));
        this.initializeUpperPart(parent);
        this.initializeLowerPart(parent);
        return parent;
    }

    private void initializeUpperPart(final Composite parent) {
        Composite upperPart = new Composite(parent, 0);
        upperPart.setLayoutData((Object)new GridData(0, 0, false, false));
        upperPart.setLayout((Layout)new GridLayout(4, false));
        this.fSubtitleLabel = new Label(upperPart, 0);
        this.fSubtitleLabel.setText(SUBTITLE_LABEL);
        this.fAllFiltersCombo = new Combo(upperPart, 8);
        this.fAllFiltersCombo.setItems(allFilterNames.toArray(new String[0]));
        this.fAllFiltersCombo.setText(allFilterNames.get(0));
        this.fAllFiltersCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        int selectionIndex = IconsPreferencePage.this.fAllFiltersCombo.getSelectionIndex();
                        if (selectionIndex < 0 || selectionIndex >= allFilterNames.size()) {
                            IconsPreferencePage.this.updatePreviewImages(IconsPreferencePage.this.fIconTree.getSelection(), null);
                            break;
                        }
                        IconColorUtils.HSBInput input = allFilterNameToInput.get(allFilterNames.get(selectionIndex));
                        if (input != null) {
                            IconsPreferencePage.this.updatePreviewImages(IconsPreferencePage.this.fIconTree.getSelection(), input);
                            break;
                        }
                        IconsPreferencePage.this.updatePreviewImages(IconsPreferencePage.this.fIconTree.getSelection(), null);
                    }
                }
            }
        });
        this.fEditButton = new Button(upperPart, 8);
        this.fEditButton.setText(EDIT_BUTTON_TEXT);
        this.fEditButton.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                ImageDescriptor selectedDescriptor;
                block13: {
                    TreeItem[] selection = IconsPreferencePage.this.fIconTree.getSelection();
                    selectedDescriptor = null;
                    if (selection == null || selection.length <= 0 || selection[0].getImage(1) == null) break block13;
                    TreeItem item = selection[0];
                    selectedDescriptor = (switch (item.getParentItem().getText()) {
                        case "SystemVerilog" -> SVNameToIcon;
                        case "VHDL" -> VHDLNameToIcon;
                        case "e Language" -> ENameToIcon;
                        default -> SVNameToIcon;
                    }).get(item.getText());
                }
                new CustomFiltersDialog(parent.getShell(), selectedDescriptor).open();
                IconsPreferencePage.this.refreshAllIconPreviews();
                IconsPreferencePage.this.fIsApplied = false;
            }
        });
    }

    private void initializeLowerPart(Composite parent) {
        Composite lowerPart = new Composite(parent, 0);
        lowerPart.setLayoutData((Object)new GridData(4, 4, true, true));
        lowerPart.setLayout((Layout)new FillLayout());
        this.fIconTree = this.createIconTree(lowerPart);
    }

    private void refreshAllIconPreviews() {
        if (this.allItems == null || this.allItems.isEmpty()) {
            return;
        }
        for (TreeItem item : this.allItems) {
            ImageData previewImageData;
            Image image = this.fOriginalImages.get(item.getText());
            if (image == null) continue;
            IconColorUtils.HSBInput input = this.getInputFromTreeItem(item);
            if (input == null) {
                previewImageData = image.getImageData();
                item.setText(3, "");
            } else {
                previewImageData = IconColorUtils.applyPixelTransform(image.getImageData(), input);
                item.setText(3, input.name);
            }
            Image toDispose = item.getImage(2);
            item.setImage(2, new Image((Device)this.fDisplay, previewImageData));
            toDispose.dispose();
        }
    }

    private IconColorUtils.HSBInput getInputFromTreeItem(TreeItem item) {
        String filterName = item.getText(3);
        IconColorUtils.HSBInput input = filterName.isEmpty() ? null : allFilterNameToInput.get(filterName);
        return input;
    }

    private ImageDescriptor getImageDescriptorFromItem(TreeItem item) {
        if (item == null || item.getParentItem() == null || item.getParentItem().getText() == null) {
            return null;
        }
        return (switch (item.getParentItem().getText()) {
            case "SystemVerilog" -> SVNameToIcon;
            case "VHDL" -> VHDLNameToIcon;
            case "e Language" -> ENameToIcon;
            default -> SVNameToIcon;
        }).get(item.getText());
    }

    private void updatePreviewImages(TreeItem[] items, IconColorUtils.HSBInput input) {
        ArrayList<TreeItem> itemsToUpdate = new ArrayList<TreeItem>(Arrays.asList(items));
        boolean regularIconFound = false;
        for (TreeItem item : Arrays.asList(items)) {
            if (item.getImage(1) == null) continue;
            regularIconFound = true;
            break;
        }
        if (regularIconFound) {
            for (TreeItem item : Arrays.asList(items)) {
                if (item.getImage(1) != null) continue;
                itemsToUpdate.remove(item);
            }
        }
        for (TreeItem item : itemsToUpdate) {
            this.updatePreviewImages(item.getItems(), input);
            this.fIsApplied = false;
            ImageDescriptor imageDescriptor = this.getImageDescriptorFromItem(item);
            if (imageDescriptor == null) continue;
            for (TreeItem otherItem : this.allItems) {
                ImageData previewImageData;
                Image image;
                if (!imageDescriptor.equals(this.getImageDescriptorFromItem(otherItem)) || (image = this.fOriginalImages.get(otherItem.getText())) == null) continue;
                if (input == null) {
                    previewImageData = image.getImageData();
                    otherItem.setText(3, "");
                } else {
                    previewImageData = IconColorUtils.applyPixelTransform(image.getImageData(), input);
                    otherItem.setText(3, input.name);
                }
                Image toDispose = otherItem.getImage(2);
                otherItem.setImage(2, new Image((Device)this.fDisplay, previewImageData));
                toDispose.dispose();
            }
        }
    }

    private Tree createIconTree(Composite parent) {
        this.allItems = new ArrayList<TreeItem>();
        Tree iconTree = new Tree(parent, 2818);
        iconTree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(iconTree, 16384);
        nameColumn.setText("Icon Name");
        nameColumn.setWidth(300);
        TreeColumn originalColumn = new TreeColumn(iconTree, 0x1000000);
        originalColumn.setText("Original");
        originalColumn.setWidth(100);
        TreeColumn previewColumn = new TreeColumn(iconTree, 0x1000000);
        previewColumn.setText("Preview");
        previewColumn.setWidth(100);
        TreeColumn filterNameColumn = new TreeColumn(iconTree, 16384);
        filterNameColumn.setText("Filter");
        filterNameColumn.setWidth(100);
        TreeItem EGroup = new TreeItem(iconTree, 0);
        EGroup.setText("e Language");
        for (Map.Entry<String, ImageDescriptor> entry : ENameToIcon.entrySet()) {
            TreeItem child = new TreeItem(EGroup, 0x1000000);
            String iconName = entry.getKey();
            child.setText(iconName);
            Image originalImage = ((IconImageDescriptor)entry.getValue()).createOriginalImage();
            IconColorUtils.HSBInput filterInput = ((IconImageDescriptor)entry.getValue()).getFilterInput();
            ImageData previewImageData = filterInput == null ? originalImage.getImageData() : IconColorUtils.applyPixelTransform(originalImage.getImageData(), filterInput);
            Image previewImage = new Image((Device)this.fDisplay, previewImageData);
            child.setImage(1, originalImage);
            child.setImage(2, previewImage);
            child.setText(3, IconImageDescriptor.getFilterNameForIcon(entry.getValue()));
            this.fOriginalImages.put(iconName, originalImage);
            this.allItems.add(child);
        }
        TreeItem SVGroup = new TreeItem(iconTree, 0);
        SVGroup.setText("SystemVerilog");
        for (Map.Entry entry : SVNameToIcon.entrySet()) {
            TreeItem child = new TreeItem(SVGroup, 0x1000000);
            String iconName = (String)entry.getKey();
            child.setText(iconName);
            Image originalImage = ((IconImageDescriptor)((Object)entry.getValue())).createOriginalImage();
            IconColorUtils.HSBInput filterInput = ((IconImageDescriptor)((Object)entry.getValue())).getFilterInput();
            ImageData previewImageData = filterInput == null ? originalImage.getImageData() : IconColorUtils.applyPixelTransform(originalImage.getImageData(), filterInput);
            Image previewImage = new Image((Device)this.fDisplay, previewImageData);
            child.setImage(1, originalImage);
            child.setImage(2, previewImage);
            child.setText(3, IconImageDescriptor.getFilterNameForIcon((ImageDescriptor)entry.getValue()));
            this.fOriginalImages.put(iconName, originalImage);
            this.allItems.add(child);
        }
        TreeItem treeItem = new TreeItem(iconTree, 0);
        treeItem.setText("VHDL");
        for (Map.Entry<String, ImageDescriptor> entry : VHDLNameToIcon.entrySet()) {
            TreeItem child = new TreeItem(treeItem, 0x1000000);
            String iconName = entry.getKey();
            child.setText(iconName);
            Image originalImage = ((IconImageDescriptor)entry.getValue()).createOriginalImage();
            IconColorUtils.HSBInput filterInput = ((IconImageDescriptor)entry.getValue()).getFilterInput();
            ImageData previewImageData = filterInput == null ? originalImage.getImageData() : IconColorUtils.applyPixelTransform(originalImage.getImageData(), filterInput);
            Image previewImage = new Image((Device)this.fDisplay, previewImageData);
            child.setImage(1, originalImage);
            child.setImage(2, previewImage);
            child.setText(3, IconImageDescriptor.getFilterNameForIcon(entry.getValue()));
            this.fOriginalImages.put(iconName, originalImage);
            this.allItems.add(child);
        }
        iconTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                String filterName = item.getText(3).isEmpty() ? IconsPreferencePage.DEFAULT_NO_FILTER_NAME : item.getText(3);
                IconsPreferencePage.this.fAllFiltersCombo.select(IconsPreferencePage.this.fAllFiltersCombo.indexOf(filterName));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return iconTree;
    }

    private void updateIconsFilterRenamed(String filterName, IconColorUtils.HSBInput newInput) {
        if (this.allItems == null || this.allItems.isEmpty()) {
            return;
        }
        for (TreeItem item : this.allItems) {
            Image image;
            if (item.getImage(1) == null || !item.getText(3).equals(filterName) || (image = this.fOriginalImages.get(item.getText())) == null) continue;
            Image toDispose = item.getImage(2);
            ImageData previewImageData = IconColorUtils.applyPixelTransform(image.getImageData(), newInput);
            item.setImage(2, new Image((Device)this.fDisplay, previewImageData));
            toDispose.dispose();
            item.setText(3, newInput.newName);
        }
    }

    private void performApplyLogic() {
        if (this.allItems == null || this.allItems.isEmpty()) {
            return;
        }
        HashMap<String, IconColorUtils.HSBInput> imageDescriptorNamesToInputs = new HashMap<String, IconColorUtils.HSBInput>();
        for (TreeItem item : this.allItems) {
            IconColorUtils.HSBInput input;
            if (item.getImage(1) == null) continue;
            String imageDescriptorName = (switch (item.getParentItem().getText()) {
                case "SystemVerilog" -> SVNameToIcon;
                case "VHDL" -> VHDLNameToIcon;
                case "e Language" -> ENameToIcon;
                default -> SVNameToIcon;
            }).get(item.getText()).toString();
            String filterName = item.getText(3);
            IconColorUtils.HSBInput hSBInput = input = filterName.isEmpty() ? null : allFilterNameToInput.get(filterName);
            if (input == null && imageDescriptorNamesToInputs.containsKey(imageDescriptorName)) continue;
            imageDescriptorNamesToInputs.put(imageDescriptorName, input);
            if (!imageDescriptorName.contains("method_obj.png")) continue;
            imageDescriptorNamesToInputs.put(DVTImages.OUTLINE_FUNCTION.toString(), input);
        }
        IconImageDescriptor.addColorPreferences(imageDescriptorNamesToInputs);
    }

    protected void performApply() {
        if (!this.fIsApplied) {
            this.fIsApplied = true;
            this.performApplyLogic();
            new RestartRequiredDialog("Restart Required", "You have to restart DVT in to update icons.\n\nDo you want to restart now?", false).open();
        }
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        PrefConst.setIconColorAppliedFilters("");
        this.updatePreviewImages(this.fIconTree.getItems(), null);
        this.fAllFiltersCombo.select(this.fAllFiltersCombo.indexOf(DEFAULT_NO_FILTER_NAME));
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    private Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f2 = JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont");
        gc.setFont(f2);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }

    public void dispose() {
        for (TreeItem item : this.allItems) {
            item.getImage(1).dispose();
            item.getImage(2).dispose();
        }
        super.dispose();
    }

    private class CustomFiltersDialog
    extends Dialog {
        private int fCounter;
        private List<String> customFilterNames;
        private Map<String, IconColorUtils.HSBInput> customFilterNameToInput;
        private Button fAddButton;
        private Button fRemoveButton;
        private Button fDuplicateButton;
        private org.eclipse.swt.widgets.List fCustomFilterList;
        private Text fFilterName;
        private Map<Button, IconColorUtils.PrimaryColor> fColorButtons;
        private Scale fHueScale;
        private Scale fSatScale;
        private Scale fBriScale;
        private Scale fOverlapScale;
        private Label fSatLabel;
        private Label fHueLabel;
        private Label fBriLabel;
        private Label fOverlapLabel;
        private String fCurrentSelection;
        private ImageDescriptor fPreviewDescriptor;
        private List<Image> fOriginalImages;
        private List<Label> fOriginalLabels;
        private List<Label> fPreviewLabels;

        public CustomFiltersDialog(Shell parentShell, ImageDescriptor previewImageData) {
            super(parentShell);
            this.fCounter = 1;
            this.fCurrentSelection = null;
            this.initializeCustomFilters();
            this.fPreviewDescriptor = previewImageData;
        }

        private void initializeCustomFilters() {
            this.customFilterNames = new ArrayList<String>();
            this.customFilterNameToInput = new HashMap<String, IconColorUtils.HSBInput>();
            HashSet<String> predefinedFilterNames = new HashSet<String>(Arrays.asList(PRESET_FILTERS));
            predefinedFilterNames.add(IconsPreferencePage.DEFAULT_NO_FILTER_NAME);
            for (String filter : allFilterNames) {
                if (predefinedFilterNames.contains(filter)) continue;
                this.customFilterNames.add(filter);
                this.customFilterNameToInput.put(filter, allFilterNameToInput.get(filter));
            }
        }

        protected Control createDialogArea(Composite ancestor) {
            Composite parent = (Composite)super.createDialogArea(ancestor);
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
            parent.setLayout((Layout)new GridLayout(2, true));
            Composite filterListGroup = new Composite(parent, 0);
            filterListGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            filterListGroup.setLayout((Layout)new GridLayout(1, true));
            this.createFiltersGroup(filterListGroup);
            Composite optionsGroup = new Composite(parent, 0);
            optionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            optionsGroup.setLayout((Layout)new GridLayout(1, true));
            this.createOptionsGroup(optionsGroup);
            if (this.fCustomFilterList.getItemCount() > 0) {
                this.fCustomFilterList.select(0);
                this.fCustomFilterList.notifyListeners(13, null);
            } else {
                this.disableOptionsGroup();
            }
            return parent;
        }

        private void disableOptionsGroup() {
            this.fFilterName.setEnabled(false);
            for (Button button : this.fColorButtons.keySet()) {
                button.setEnabled(false);
            }
            this.fHueLabel.setEnabled(false);
            this.fHueScale.setEnabled(false);
            this.fSatLabel.setEnabled(false);
            this.fSatScale.setEnabled(false);
            this.fBriLabel.setEnabled(false);
            this.fBriScale.setEnabled(false);
            this.fOverlapLabel.setEnabled(false);
            this.fOverlapScale.setEnabled(false);
            int i = 0;
            while (i < this.fOriginalLabels.size()) {
                this.fOriginalLabels.get(i).setEnabled(false);
                this.fPreviewLabels.get(i).setEnabled(false);
                ++i;
            }
        }

        private void enableOptionsGroup() {
            this.fFilterName.setEnabled(true);
            for (Button button : this.fColorButtons.keySet()) {
                button.setEnabled(true);
            }
            this.fHueLabel.setEnabled(true);
            this.fHueScale.setEnabled(true);
            this.fSatLabel.setEnabled(true);
            this.fSatScale.setEnabled(true);
            this.fBriLabel.setEnabled(true);
            this.fBriScale.setEnabled(true);
            this.fOverlapLabel.setEnabled(true);
            this.fOverlapScale.setEnabled(true);
            int i = 0;
            while (i < this.fOriginalLabels.size()) {
                this.fOriginalLabels.get(i).setEnabled(true);
                this.fPreviewLabels.get(i).setEnabled(true);
                ++i;
            }
        }

        private void createOptionsGroup(Composite parent) {
            Image image;
            Group groupName = new Group(parent, 0);
            groupName.setText("Filter Name");
            groupName.setLayoutData((Object)new GridData(4, 4, true, true));
            groupName.setLayout((Layout)new GridLayout(1, false));
            this.fFilterName = new Text((Composite)groupName, 0);
            this.fFilterName.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fFilterName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    int filterIndex = CustomFiltersDialog.this.fCustomFilterList.getSelectionIndex();
                    if (filterIndex < 0) {
                        return;
                    }
                    String filterName = CustomFiltersDialog.this.fFilterName.getText();
                    boolean otherFilter = false;
                    int i = 0;
                    while (i < CustomFiltersDialog.this.fCustomFilterList.getItemCount()) {
                        if (i != filterIndex && CustomFiltersDialog.this.fCustomFilterList.getItem(i).equals(filterName)) {
                            otherFilter = true;
                            break;
                        }
                        ++i;
                    }
                    if (PRESET_FILTERS_SET.contains(filterName) || otherFilter) {
                        filterName = filterName.concat(" (" + CustomFiltersDialog.this.fCounter++ + ")");
                        CustomFiltersDialog.this.fFilterName.setText(filterName);
                    }
                    CustomFiltersDialog.this.fCustomFilterList.setItem(filterIndex, filterName);
                }
            });
            Group colorPickGroup = new Group(parent, 0);
            colorPickGroup.setText("Select Primary Colors to Adjust");
            colorPickGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            colorPickGroup.setLayout((Layout)new GridLayout(3, true));
            this.fColorButtons = new HashMap<Button, IconColorUtils.PrimaryColor>();
            IconColorUtils.PrimaryColor[] primaryColorArray = IconColorUtils.PrimaryColor.values();
            int n = primaryColorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconColorUtils.PrimaryColor color = primaryColorArray[n2];
                Button button = new Button((Composite)colorPickGroup, 2);
                button.setLayoutData((Object)new GridData(4, 4, true, true));
                Point extent = IconsPreferencePage.this.computeImageSize((Control)parent);
                image = new Image((Device)parent.getDisplay(), extent.x, extent.y);
                GC gc = new GC((Drawable)image);
                gc.setForeground(IconsPreferencePage.this.fDisplay.getSystemColor(2));
                gc.drawRectangle(0, 2, extent.x - 1, extent.y - 4);
                Color buttonColor = IconColorUtils.toColor(color);
                gc.setBackground(buttonColor);
                gc.fillRectangle(1, 3, extent.x - 2, extent.y - 5);
                gc.dispose();
                button.setImage(image);
                button.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        image.dispose();
                    }
                });
                button.setSelection(true);
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        IconColorUtils.HSBInput input = CustomFiltersDialog.this.readInputFromOptionsPanel();
                        CustomFiltersDialog.this.updatePreviewImages(input);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.fColorButtons.put(button, color);
                ++n2;
            }
            Group hsbPick = new Group(parent, 0);
            hsbPick.setText("Adjust Selected Colors");
            hsbPick.setLayoutData((Object)new GridData(4, 4, true, true));
            hsbPick.setLayout((Layout)new GridLayout(2, false));
            this.fHueLabel = new Label((Composite)hsbPick, 0);
            this.fHueLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fHueScale = new Scale((Composite)hsbPick, 256);
            this.fHueScale.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fHueScale.setBounds(0, 0, 200, 40);
            this.fHueScale.setMaximum(360);
            this.fHueScale.setMinimum(0);
            this.fHueScale.setSelection(180);
            this.fHueScale.setIncrement(10);
            this.fHueLabel.setText("Hue: 0");
            this.fHueScale.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int hueValue = CustomFiltersDialog.this.fHueScale.getSelection() - CustomFiltersDialog.this.fHueScale.getMaximum() / 2;
                    CustomFiltersDialog.this.fHueLabel.setText("Hue: " + hueValue);
                    IconColorUtils.HSBInput input = CustomFiltersDialog.this.readInputFromOptionsPanel();
                    CustomFiltersDialog.this.updatePreviewImages(input);
                }
            });
            this.fSatLabel = new Label((Composite)hsbPick, 0);
            this.fSatLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fSatScale = new Scale((Composite)hsbPick, 256);
            this.fSatScale.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fSatScale.setBounds(0, 0, 200, 40);
            this.fSatScale.setMaximum(200);
            this.fSatScale.setMinimum(0);
            this.fSatScale.setSelection(100);
            this.fSatScale.setIncrement(10);
            this.fSatLabel.setText("Saturation: 0");
            this.fSatScale.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    float satValue = ((float)CustomFiltersDialog.this.fSatScale.getSelection() - (float)CustomFiltersDialog.this.fSatScale.getMaximum() / 2.0f) / 100.0f;
                    CustomFiltersDialog.this.fSatLabel.setText("Saturation: " + satValue);
                    IconColorUtils.HSBInput input = CustomFiltersDialog.this.readInputFromOptionsPanel();
                    CustomFiltersDialog.this.updatePreviewImages(input);
                }
            });
            this.fBriLabel = new Label((Composite)hsbPick, 0);
            this.fBriLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fBriScale = new Scale((Composite)hsbPick, 256);
            this.fBriScale.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fBriScale.setBounds(0, 0, 200, 40);
            this.fBriScale.setMaximum(200);
            this.fBriScale.setMinimum(0);
            this.fBriScale.setSelection(100);
            this.fBriScale.setIncrement(10);
            this.fBriLabel.setText("Brightness: 0");
            this.fBriScale.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    float briValue = ((float)CustomFiltersDialog.this.fBriScale.getSelection() - (float)CustomFiltersDialog.this.fBriScale.getMaximum() / 2.0f) / 100.0f;
                    CustomFiltersDialog.this.fBriLabel.setText("Brightness: " + briValue);
                    IconColorUtils.HSBInput input = CustomFiltersDialog.this.readInputFromOptionsPanel();
                    CustomFiltersDialog.this.updatePreviewImages(input);
                }
            });
            this.fOverlapLabel = new Label((Composite)hsbPick, 0);
            this.fOverlapLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fOverlapScale = new Scale((Composite)hsbPick, 256);
            this.fOverlapScale.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fOverlapScale.setBounds(0, 0, 200, 40);
            this.fOverlapScale.setMaximum(180);
            this.fOverlapScale.setMinimum(0);
            this.fOverlapScale.setSelection(60);
            this.fOverlapScale.setIncrement(10);
            this.fOverlapLabel.setText("Overlap: 60");
            this.fOverlapScale.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    float overlapValue = CustomFiltersDialog.this.fOverlapScale.getSelection();
                    CustomFiltersDialog.this.fOverlapLabel.setText("Overlap: " + overlapValue);
                    IconColorUtils.HSBInput input = CustomFiltersDialog.this.readInputFromOptionsPanel();
                    CustomFiltersDialog.this.updatePreviewImages(input);
                }
            });
            Group previewGroup = new Group(parent, 0);
            previewGroup.setText("Preview");
            previewGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            previewGroup.setLayout((Layout)new GridLayout(PREVIEW_IMAGES.size(), true));
            this.fOriginalImages = new ArrayList<Image>();
            ArrayList<ImageDescriptor> previewDescriptors = new ArrayList<ImageDescriptor>(PREVIEW_IMAGES);
            if (this.fPreviewDescriptor != null) {
                previewDescriptors.set(0, this.fPreviewDescriptor);
            }
            this.fOriginalLabels = new ArrayList<Label>();
            for (ImageDescriptor desc : previewDescriptors) {
                Label label = new Label((Composite)previewGroup, 0);
                image = ((IconImageDescriptor)desc).createOriginalImage();
                label.setImage(image);
                this.fOriginalImages.add(image);
                this.fOriginalLabels.add(label);
            }
            this.fPreviewLabels = new ArrayList<Label>();
            int i = 0;
            while (i < PREVIEW_IMAGES.size()) {
                Label label = new Label((Composite)previewGroup, 0);
                Image image2 = new Image((Device)IconsPreferencePage.this.fDisplay, this.fOriginalImages.get(i).getImageData());
                label.setImage(image2);
                this.fPreviewLabels.add(label);
                ++i;
            }
        }

        private void createFiltersGroup(Composite filterListGroup) {
            Composite buttonsGroup = new Composite(filterListGroup, 0);
            buttonsGroup.setLayoutData((Object)new GridData(4, 0, false, false));
            buttonsGroup.setLayout((Layout)new FillLayout());
            this.fAddButton = new Button(buttonsGroup, 0);
            this.fAddButton.setText("Add");
            this.fAddButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (CustomFiltersDialog.this.fCustomFilterList.getItemCount() <= 0) {
                        CustomFiltersDialog.this.enableOptionsGroup();
                    }
                    String filterName = "Custom Color Filter (" + CustomFiltersDialog.this.fCounter++ + ")";
                    IconColorUtils.HSBInput input = new IconColorUtils.HSBInput(filterName);
                    CustomFiltersDialog.this.customFilterNames.add(filterName);
                    CustomFiltersDialog.this.customFilterNameToInput.put(filterName, input);
                    CustomFiltersDialog.this.fCustomFilterList.add(filterName, 0);
                    CustomFiltersDialog.this.fCustomFilterList.select(0);
                    CustomFiltersDialog.this.fCustomFilterList.notifyListeners(13, null);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fRemoveButton = new Button(buttonsGroup, 0);
            this.fRemoveButton.setText("Remove");
            this.fRemoveButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int[] indexes;
                    int[] nArray = indexes = CustomFiltersDialog.this.fCustomFilterList.getSelectionIndices();
                    int n = indexes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Integer index = nArray[n2];
                        String fName = CustomFiltersDialog.this.fCustomFilterList.getItem(index.intValue());
                        CustomFiltersDialog.this.customFilterNames.remove(fName);
                        CustomFiltersDialog.this.customFilterNameToInput.remove(fName);
                        CustomFiltersDialog.this.fCustomFilterList.remove(fName);
                        CustomFiltersDialog.this.fCurrentSelection = null;
                        if (index < CustomFiltersDialog.this.fCustomFilterList.getItemCount()) {
                            CustomFiltersDialog.this.fCustomFilterList.select(index.intValue());
                            CustomFiltersDialog.this.fCustomFilterList.notifyListeners(13, null);
                        } else if (CustomFiltersDialog.this.fCustomFilterList.getItemCount() > 0) {
                            CustomFiltersDialog.this.fCustomFilterList.select(0);
                            CustomFiltersDialog.this.fCustomFilterList.notifyListeners(13, null);
                        }
                        if (CustomFiltersDialog.this.fCustomFilterList.getItemCount() <= 0) {
                            CustomFiltersDialog.this.disableOptionsGroup();
                        }
                        ++n2;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fDuplicateButton = new Button(buttonsGroup, 0);
            this.fDuplicateButton.setText("Duplicate");
            this.fDuplicateButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int[] indexes;
                    int[] nArray = indexes = CustomFiltersDialog.this.fCustomFilterList.getSelectionIndices();
                    int n = indexes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Integer index = nArray[n2];
                        String selectedFilterName = CustomFiltersDialog.this.fCustomFilterList.getItem(index.intValue());
                        String newName = selectedFilterName.indexOf(40) > 0 ? selectedFilterName.substring(0, selectedFilterName.indexOf(40)).concat("(" + CustomFiltersDialog.this.fCounter++ + ")") : selectedFilterName.concat("(" + CustomFiltersDialog.this.fCounter++ + ")");
                        CustomFiltersDialog.this.fCustomFilterList.add(newName, index + 1);
                        CustomFiltersDialog.this.customFilterNames.add(newName);
                        CustomFiltersDialog.this.customFilterNameToInput.put(newName, CustomFiltersDialog.this.customFilterNameToInput.get(selectedFilterName));
                        CustomFiltersDialog.this.fCustomFilterList.select(index + 1);
                        CustomFiltersDialog.this.fCustomFilterList.notifyListeners(13, null);
                        ++n2;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fCustomFilterList = new org.eclipse.swt.widgets.List(filterListGroup, 2048);
            this.fCustomFilterList.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fCustomFilterList.setItems(this.customFilterNames.toArray(new String[0]));
            this.fCustomFilterList.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String currentFilter;
                    if (CustomFiltersDialog.this.fCurrentSelection != null) {
                        CustomFiltersDialog.this.updateSelectedFilter(CustomFiltersDialog.this.fCurrentSelection);
                    }
                    if (CustomFiltersDialog.this.fCustomFilterList.getSelectionCount() <= 0) {
                        return;
                    }
                    CustomFiltersDialog.this.fCurrentSelection = currentFilter = CustomFiltersDialog.this.fCustomFilterList.getSelection()[0];
                    IconColorUtils.HSBInput currentInput = CustomFiltersDialog.this.customFilterNameToInput.get(currentFilter);
                    CustomFiltersDialog.this.updateOptionsFromInput(currentInput, currentFilter);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        private IconColorUtils.HSBInput readInputFromOptionsPanel() {
            IconColorUtils.TransformType type = IconColorUtils.TransformType.HSB;
            float hue = (float)this.fHueScale.getSelection() - (float)this.fHueScale.getMaximum() / 2.0f;
            float sat = ((float)this.fSatScale.getSelection() - (float)this.fSatScale.getMaximum() / 2.0f) / 100.0f;
            float bri = ((float)this.fBriScale.getSelection() - (float)this.fBriScale.getMaximum() / 2.0f) / 100.0f;
            float overlap = this.fOverlapScale.getSelection();
            boolean r = false;
            boolean y = false;
            boolean g = false;
            boolean c = false;
            boolean b = false;
            boolean m = false;
            for (Map.Entry<Button, IconColorUtils.PrimaryColor> entry : this.fColorButtons.entrySet()) {
                Button button = entry.getKey();
                switch (entry.getValue()) {
                    case RED: {
                        r = button.getSelection();
                        break;
                    }
                    case YELLOW: {
                        y = button.getSelection();
                        break;
                    }
                    case GREEN: {
                        g = button.getSelection();
                        break;
                    }
                    case CYAN: {
                        c = button.getSelection();
                        break;
                    }
                    case BLUE: {
                        b = button.getSelection();
                        break;
                    }
                    case MAGENTA: {
                        m = button.getSelection();
                    }
                }
            }
            IconColorUtils.HSBInput input = new IconColorUtils.HSBInput(type, this.fFilterName.getText(), Float.valueOf(hue), Float.valueOf(sat), Float.valueOf(bri), Float.valueOf(overlap), r, y, g, c, b, m);
            return input;
        }

        private void updateOptionsFromInput(IconColorUtils.HSBInput currentInput, String name) {
            this.fFilterName.setText(name);
            if (currentInput == null) {
                return;
            }
            for (Map.Entry<Button, IconColorUtils.PrimaryColor> entry : this.fColorButtons.entrySet()) {
                Button button = entry.getKey();
                if (button == null) continue;
                switch (entry.getValue()) {
                    case RED: {
                        button.setSelection(currentInput.red);
                        break;
                    }
                    case YELLOW: {
                        button.setSelection(currentInput.yellow);
                        break;
                    }
                    case GREEN: {
                        button.setSelection(currentInput.green);
                        break;
                    }
                    case CYAN: {
                        button.setSelection(currentInput.cyan);
                        break;
                    }
                    case BLUE: {
                        button.setSelection(currentInput.blue);
                        break;
                    }
                    case MAGENTA: {
                        button.setSelection(currentInput.magenta);
                    }
                }
            }
            int value = (int)(currentInput.hue.floatValue() + (float)this.fHueScale.getMaximum() / 2.0f);
            this.fHueScale.setSelection(value);
            this.fHueLabel.setText("Hue: " + currentInput.hue);
            value = (int)(currentInput.sat.floatValue() * 100.0f + (float)this.fSatScale.getMaximum() / 2.0f);
            this.fSatScale.setSelection(value);
            this.fSatLabel.setText("Saturation: " + currentInput.sat);
            value = (int)(currentInput.bri.floatValue() * 100.0f + (float)this.fBriScale.getMaximum() / 2.0f);
            this.fBriScale.setSelection(value);
            this.fBriLabel.setText("Brightness: " + currentInput.bri);
            value = (int)Math.floor(currentInput.overlap.floatValue());
            this.fOverlapScale.setSelection(value);
            this.fOverlapLabel.setText("Overlap: " + currentInput.overlap);
            this.updatePreviewImages(currentInput);
        }

        private void updatePreviewImages(IconColorUtils.HSBInput currentInput) {
            int i = 0;
            while (i < PREVIEW_IMAGES.size()) {
                ImageData original = this.fOriginalImages.get(i).getImageData();
                original = IconColorUtils.applyPixelTransform(original, currentInput);
                Image toDispose = this.fPreviewLabels.get(i).getImage();
                this.fPreviewLabels.get(i).setImage(new Image((Device)IconsPreferencePage.this.fDisplay, original));
                toDispose.dispose();
                ++i;
            }
        }

        private void updateSelectedFilter(String fCurrentSelection) {
            String newName = this.fFilterName.getText();
            if (newName == null || newName.isEmpty() || this.customFilterNames.contains(newName)) {
                newName = fCurrentSelection;
            }
            float hue = (float)this.fHueScale.getSelection() - (float)this.fHueScale.getMaximum() / 2.0f;
            float sat = ((float)this.fSatScale.getSelection() - (float)this.fSatScale.getMaximum() / 2.0f) / 100.0f;
            float bri = ((float)this.fBriScale.getSelection() - (float)this.fBriScale.getMaximum() / 2.0f) / 100.0f;
            float overlap = this.fOverlapScale.getSelection();
            boolean r = false;
            boolean y = false;
            boolean g = false;
            boolean c = false;
            boolean b = false;
            boolean m = false;
            for (Map.Entry<Button, IconColorUtils.PrimaryColor> entry : this.fColorButtons.entrySet()) {
                Button button = entry.getKey();
                switch (entry.getValue()) {
                    case RED: {
                        r = button.getSelection();
                        break;
                    }
                    case YELLOW: {
                        y = button.getSelection();
                        break;
                    }
                    case GREEN: {
                        g = button.getSelection();
                        break;
                    }
                    case CYAN: {
                        c = button.getSelection();
                        break;
                    }
                    case BLUE: {
                        b = button.getSelection();
                        break;
                    }
                    case MAGENTA: {
                        m = button.getSelection();
                    }
                }
            }
            IconColorUtils.HSBInput input = this.customFilterNameToInput.get(fCurrentSelection);
            if (input == null) {
                return;
            }
            input.hue = Float.valueOf(hue);
            input.sat = Float.valueOf(sat);
            input.bri = Float.valueOf(bri);
            input.overlap = Float.valueOf(overlap);
            input.red = r;
            input.yellow = y;
            input.green = g;
            input.cyan = c;
            input.blue = b;
            input.magenta = m;
            if (!fCurrentSelection.equals(newName)) {
                input.newName = newName;
            }
            if (this.customFilterNames.contains(fCurrentSelection)) {
                this.customFilterNames.remove(fCurrentSelection);
            }
            this.customFilterNames.add(newName);
            if (this.customFilterNameToInput.containsKey(fCurrentSelection)) {
                this.customFilterNameToInput.remove(fCurrentSelection);
            }
            this.customFilterNameToInput.put(newName, input);
        }

        protected void cancelPressed() {
            super.cancelPressed();
        }

        protected void okPressed() {
            if (this.fCurrentSelection != null) {
                this.updateSelectedFilter(this.fCurrentSelection);
            }
            ArrayList<String> filtersToSerialize = new ArrayList<String>(this.customFilterNames);
            HashSet<String> predef = new HashSet<String>(Arrays.asList(PRESET_FILTERS));
            for (String filterName : new ArrayList<String>(allFilterNames)) {
                if (predef.contains(filterName) || IconsPreferencePage.DEFAULT_NO_FILTER_NAME.equals(filterName)) continue;
                IconColorUtils.HSBInput newInput = null;
                for (IconColorUtils.HSBInput input : this.customFilterNameToInput.values()) {
                    if (input == null || input.name == null || !input.name.equals(filterName)) continue;
                    newInput = input;
                    break;
                }
                if (newInput == null) {
                    if (allFilterNames.contains(filterName)) {
                        allFilterNames.remove(filterName);
                    }
                    if (allFilterNameToInput.containsKey(filterName)) {
                        allFilterNameToInput.remove(filterName);
                    }
                    if (IconsPreferencePage.this.fAllFiltersCombo.indexOf(filterName) < 0) continue;
                    IconsPreferencePage.this.fAllFiltersCombo.remove(filterName);
                    continue;
                }
                if (newInput.newName != null && !newInput.newName.isEmpty() && !newInput.newName.equals(filterName)) {
                    newInput.name = newInput.newName;
                    allFilterNames.set(allFilterNames.indexOf(filterName), newInput.newName);
                    allFilterNameToInput.remove(filterName);
                    allFilterNameToInput.put(newInput.newName, newInput);
                    IconsPreferencePage.this.fAllFiltersCombo.remove(filterName);
                    IconsPreferencePage.this.fAllFiltersCombo.add(newInput.newName);
                    IconsPreferencePage.this.updateIconsFilterRenamed(filterName, newInput);
                    this.customFilterNames.remove(newInput.newName);
                    continue;
                }
                allFilterNameToInput.put(filterName, newInput);
                this.customFilterNames.remove(filterName);
            }
            for (String filterName : this.customFilterNames) {
                allFilterNames.add(filterName);
                IconColorUtils.HSBInput input = this.customFilterNameToInput.get(filterName);
                if (input == null) continue;
                allFilterNameToInput.put(filterName, input);
                IconsPreferencePage.this.fAllFiltersCombo.add(filterName);
            }
            this.serializeFilters(filtersToSerialize);
            super.okPressed();
        }

        private void serializeFilters(List<String> filtersToSerialize) {
            StringBuilder serial = new StringBuilder();
            for (String filter : filtersToSerialize) {
                if (this.customFilterNameToInput.get(filter) == null) continue;
                serial.append(filter);
                serial.append("=");
                serial.append(this.customFilterNameToInput.get(filter).serialize());
                serial.append(System.getProperty("line.separator"));
            }
            PrefConst.setIconColorCustomFilters(serial.toString());
        }

        public boolean close() {
            for (Image image : this.fOriginalImages) {
                image.dispose();
            }
            return super.close();
        }
    }
}

