/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.namechecker;

import java.io.File;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Convention {
    private String fKind;
    private String fName;
    private String fDescription;
    private String fMatch;
    private Pattern fPattern;
    private boolean fEnabled;
    private boolean fDeleted;
    private boolean fModified;
    private boolean fOverriden;
    private boolean fIsGlobal;
    private String fLanguage;
    private File fFile;
    private String fLine;

    public Convention(Convention convention) {
        this.fLanguage = convention.getLanguage();
        this.fKind = convention.getKind();
        this.fName = convention.getName();
        this.fDescription = convention.getDescription();
        this.fMatch = convention.getMatch();
        this.fPattern = Pattern.compile(convention.getPatternString());
        this.fEnabled = convention.getEnabled();
        this.fDeleted = false;
        this.fFile = convention.getFile();
        this.fLine = convention.getLine();
    }

    public Convention(String language, String kind, String name, String description, String match, String pattern, boolean enabled) {
        this.fLanguage = language;
        this.fKind = kind;
        this.fName = name;
        this.fMatch = match;
        this.fPattern = Pattern.compile(pattern);
        this.fEnabled = enabled;
        this.fDescription = description;
        this.fDeleted = false;
    }

    public void init() {
        this.fOverriden = false;
    }

    public String getLanguage() {
        return this.fLanguage;
    }

    public String getKind() {
        return this.fKind;
    }

    public String getName() {
        return this.fName;
    }

    public String getMatch() {
        return this.fMatch;
    }

    public String getPatternString() {
        return this.fPattern.pattern();
    }

    public String getDescription() {
        return this.fDescription;
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public boolean getDeleted() {
        return this.fDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.fDeleted = deleted;
    }

    public boolean isModified() {
        return this.fModified;
    }

    public void setKind(String kind) {
        this.fModified = true;
        this.fKind = kind;
    }

    public void setName(String name) {
        this.fModified = true;
        this.fName = name;
    }

    public void setMatch(String match) {
        this.fModified = true;
        this.fMatch = match;
    }

    public void setPatternString(String pattern) {
        this.fModified = true;
        this.fPattern = Pattern.compile(pattern);
    }

    public void setDescription(String description) {
        this.fModified = true;
        this.fDescription = description;
    }

    public void setEnabled(boolean enabled) {
        this.fModified = true;
        this.fEnabled = enabled;
    }

    public Pattern getPattern() {
        return this.fPattern;
    }

    public void setOverriden() {
        this.fOverriden = true;
    }

    public boolean isOverriden() {
        return this.fOverriden;
    }

    public void setIsGlobal() {
        this.fIsGlobal = true;
    }

    public boolean isGlobal() {
        return this.fIsGlobal;
    }

    public String getLocation(boolean absolute) {
        if (this.fFile == null) {
            return "DEFAULT";
        }
        if (absolute) {
            return String.valueOf(this.fFile.getAbsolutePath()) + " at line " + this.fLine;
        }
        String absolutePath = this.fFile.getAbsolutePath();
        IPath path = Path.fromOSString((String)absolutePath);
        int segmentCount = path.segmentCount();
        if (segmentCount <= 3) {
            return String.valueOf(absolutePath) + " at line " + this.fLine;
        }
        StringBuilder result = new StringBuilder("...");
        String[] segments = path.segments();
        int i = segmentCount - 3;
        while (i < segmentCount) {
            result.append("/").append(segments[i]);
            ++i;
        }
        return result.append(" at line ").append(this.fLine).toString();
    }

    public void setLocation(File file, String line) {
        this.fFile = file;
        this.fLine = line;
    }

    public File getFile() {
        return this.fFile;
    }

    public String getLine() {
        return this.fLine;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Language: ").append(this.fLanguage).append("\n");
        result.append("Name: ").append(this.fName).append("\n").append("Description: ").append(this.fDescription).append("\n");
        result.append("Pattern: ").append(this.fPattern).append("\n").append("Enabled: ").append(this.fEnabled ? "YES" : "NO").append("\n");
        result.append("Applies for: ").append(this.fKind).append("\n").append("Match: ").append(this.fMatch).append("\n");
        result.append("Location: ").append(this.getLocation(true)).append("\n").append("Overridden: ").append(this.fOverriden ? "YES" : "NO");
        result.append("\n").append("Editable: ").append(this.fIsGlobal ? "NO" : "YES");
        return result.toString();
    }
}

