/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.namechecker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.namechecker.Convention;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;

public class ConventionReaderWriter {
    private static final String CONVENTIONS_ROOT = "conventions";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String CONVENTION_ELEMENT = "convention";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String KIND_ATTRIBUTE = "kind";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String MATCH_ATTRIBUTE = "match";
    private static final String LANGUAGE_ATTRIBUTE = "language";
    private static final String E_LANGUAGE_VALUE = "e Language";
    private static final String SLN_LANGUAGE_VALUE = "SLN";
    private static final String SDL_LANGUAGE_VALUE = "SDL";
    private static final String MSDL_LANGUAGE_VALUE = "MSDL";
    private static final String PSS_LANGUAGE_VALUE = "PSS";
    private static final String VERSION_ONE = "1";
    private static final String LINE_NUMBER_ATTRIBUTE = "lineNumber";

    public Convention[] read(File file) throws IOException {
        BufferedInputStream input = null;
        Convention[] result = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            result = this.read(input, null, file);
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(input);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(input);
        return result;
    }

    public Convention[] read(String string) throws IOException {
        StringInputStream input = null;
        Convention[] result = null;
        try {
            input = new StringInputStream(string);
            result = this.read((InputStream)input, null, null);
        }
        finally {
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)input);
        }
        return result;
    }

    private Convention[] read(InputStream is, ResourceBundle bundle, File file) throws IOException {
        try {
            ArrayList<Convention> conventions = new ArrayList<Convention>();
            Document document = PositionalXMLReader.readXML(is);
            NodeList conventionsNodes = document.getElementsByTagName(CONVENTIONS_ROOT);
            if (conventionsNodes.getLength() < 1) {
                return conventions.toArray(new Convention[conventions.size()]);
            }
            NodeList elements = document.getElementsByTagName(CONVENTION_ELEMENT);
            Element conventionsNode = (Element)conventionsNodes.item(0);
            String version = conventionsNode.getAttribute(VERSION_ATTRIBUTE);
            if (version.isEmpty()) {
                this.read0(elements, conventions, file);
            } else if (version.equals(VERSION_ONE)) {
                this.read1(elements, conventions, file);
            }
            return conventions.toArray(new Convention[conventions.size()]);
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }

    private void read0(NodeList elements, Collection<Convention> conventions, File file) throws IOException {
        try {
            HashSet<String> ids = new HashSet<String>();
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    String name = this.getStringValue(attributes, NAME_ATTRIBUTE, null);
                    if (name != null && ids.contains(name)) {
                        DVTLogger.INSTANCE.logError("ConventionReaderWriter.error.duplicate_id in file " + (file == null ? "DEFAULT" : file.getAbsolutePath()));
                    } else {
                        ids.add(name);
                        String description = this.getStringValue(attributes, DESCRIPTION_ATTRIBUTE, "");
                        String kind = this.getStringValue(attributes, KIND_ATTRIBUTE, null);
                        String match = this.getStringValue(attributes, MATCH_ATTRIBUTE, null);
                        if (name == null || kind == null || match == null) {
                            DVTLogger.INSTANCE.logError("ConventionReaderWriter.error.duplicate_id in file " + (file == null ? "DEFAULT" : file.getAbsolutePath()));
                        } else {
                            boolean enabled = this.getBooleanValue(attributes, ENABLED_ATTRIBUTE, true);
                            StringBuilder buffer = new StringBuilder();
                            NodeList children = node.getChildNodes();
                            int j = 0;
                            while (j != children.getLength()) {
                                String value = children.item(j).getNodeValue();
                                if (value != null) {
                                    buffer.append(value);
                                }
                                ++j;
                            }
                            String pattern = buffer.toString();
                            Convention convention = new Convention(E_LANGUAGE_VALUE, kind, name, description, match, pattern, enabled);
                            conventions.add(convention);
                        }
                    }
                }
                ++i;
            }
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }

    private void read1(NodeList elements, Collection<Convention> conventions, File file) throws IOException {
        try {
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                String line = (String)node.getUserData(LINE_NUMBER_ATTRIBUTE);
                if (attributes != null) {
                    String name = this.getStringValue(attributes, NAME_ATTRIBUTE, null);
                    String language = this.getStringValue(attributes, LANGUAGE_ATTRIBUTE, null);
                    if (name == null || language == null) {
                        DVTLogger.INSTANCE.logError("ConventionReaderWriter.error.missing_attribute in file " + (file == null ? "DEFAULT" : String.valueOf(file.getAbsolutePath()) + " at line " + line));
                    } else {
                        if (language.equals("E")) {
                            language = E_LANGUAGE_VALUE;
                        }
                        if (language.equals(SLN_LANGUAGE_VALUE)) {
                            language = SLN_LANGUAGE_VALUE;
                        }
                        if (language.equals(SDL_LANGUAGE_VALUE)) {
                            language = SDL_LANGUAGE_VALUE;
                        }
                        if (language.equals(MSDL_LANGUAGE_VALUE)) {
                            language = MSDL_LANGUAGE_VALUE;
                        }
                        if (language.equals(PSS_LANGUAGE_VALUE)) {
                            language = PSS_LANGUAGE_VALUE;
                        }
                        String description = this.getStringValue(attributes, DESCRIPTION_ATTRIBUTE, "");
                        String kind = this.getStringValue(attributes, KIND_ATTRIBUTE, null);
                        String match = this.getStringValue(attributes, MATCH_ATTRIBUTE, null);
                        if (kind == null || match == null) {
                            DVTLogger.INSTANCE.logError("ConventionReaderWriter.error.missing_attribute in file " + (file == null ? "DEFAULT" : String.valueOf(file.getAbsolutePath()) + " at line " + line));
                        } else {
                            boolean enabled = this.getBooleanValue(attributes, ENABLED_ATTRIBUTE, true);
                            StringBuilder buffer = new StringBuilder();
                            NodeList children = node.getChildNodes();
                            int j = 0;
                            while (j != children.getLength()) {
                                String value = children.item(j).getNodeValue();
                                if (value != null) {
                                    buffer.append(value);
                                }
                                ++j;
                            }
                            String pattern = buffer.toString();
                            Convention convention = new Convention(language, kind, name, description, match, pattern, enabled);
                            convention.setLocation(file, (String)node.getUserData(LINE_NUMBER_ATTRIBUTE));
                            conventions.add(convention);
                        }
                    }
                }
                ++i;
            }
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }

    public void save(Convention[] conventions, File file) throws IOException {
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file));
            this.save(conventions, new StreamResult(output), file);
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(output);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(output);
    }

    private void save(Convention[] conventions, StreamResult result, File file) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(CONVENTIONS_ROOT);
            NamedNodeMap attributes = root.getAttributes();
            Attr version = document.createAttribute(VERSION_ATTRIBUTE);
            version.setValue(VERSION_ONE);
            attributes.setNamedItem(version);
            document.appendChild(root);
            int i = 0;
            while (i < conventions.length) {
                Convention convention = conventions[i];
                Element node = document.createElement(CONVENTION_ELEMENT);
                root.appendChild(node);
                attributes = node.getAttributes();
                if (convention != null) {
                    Attr name = document.createAttribute(NAME_ATTRIBUTE);
                    name.setValue(convention.getName());
                    attributes.setNamedItem(name);
                }
                if (convention != null) {
                    Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                    description.setValue(convention.getDescription());
                    attributes.setNamedItem(description);
                }
                if (convention != null) {
                    Attr context = document.createAttribute(KIND_ATTRIBUTE);
                    context.setValue(convention.getKind());
                    attributes.setNamedItem(context);
                }
                if (convention != null) {
                    Attr language = document.createAttribute(LANGUAGE_ATTRIBUTE);
                    String conventionLanguage = convention.getLanguage();
                    if (conventionLanguage.equals(E_LANGUAGE_VALUE)) {
                        conventionLanguage = "E";
                    }
                    if (conventionLanguage.equals(SLN_LANGUAGE_VALUE)) {
                        conventionLanguage = SLN_LANGUAGE_VALUE;
                    }
                    if (conventionLanguage.equals(SDL_LANGUAGE_VALUE)) {
                        conventionLanguage = SDL_LANGUAGE_VALUE;
                    }
                    if (conventionLanguage.equals(MSDL_LANGUAGE_VALUE)) {
                        conventionLanguage = MSDL_LANGUAGE_VALUE;
                    }
                    if (conventionLanguage.equals(PSS_LANGUAGE_VALUE)) {
                        conventionLanguage = PSS_LANGUAGE_VALUE;
                    }
                    language.setValue(conventionLanguage);
                    attributes.setNamedItem(language);
                }
                if (convention != null) {
                    Attr enabled = document.createAttribute(ENABLED_ATTRIBUTE);
                    enabled.setValue(convention.getEnabled() ? Boolean.toString(true) : Boolean.toString(false));
                    attributes.setNamedItem(enabled);
                }
                if (convention != null) {
                    Attr match = document.createAttribute(MATCH_ATTRIBUTE);
                    match.setValue(convention.getMatch());
                    attributes.setNamedItem(match);
                }
                if (convention != null) {
                    Text pattern = document.createTextNode(convention.getPatternString());
                    node.appendChild(pattern);
                }
                if (convention != null) {
                    convention.setLocation(file, "-1");
                }
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "-//DVT//naming_conventions");
            transformer.setOutputProperty("doctype-system", "naming_conventions.dtd");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            Assert.isTrue((boolean)false);
        }
    }

    private boolean getBooleanValue(NamedNodeMap attributes, String attribute, boolean defaultValue) throws SAXException {
        Node enabledNode = attributes.getNamedItem(attribute);
        if (enabledNode == null) {
            return defaultValue;
        }
        if (enabledNode.getNodeValue().equals(Boolean.toString(true))) {
            return true;
        }
        if (enabledNode.getNodeValue().equals(Boolean.toString(false))) {
            return false;
        }
        throw new SAXException("ConventionReaderWriter.error.illegal_boolean_attribute");
    }

    private String getStringValue(NamedNodeMap attributes, String name, String defaultValue) {
        Node node = attributes.getNamedItem(name);
        return node == null ? defaultValue : node.getNodeValue();
    }
}

