/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.namechecker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.namechecker.Convention;
import ro.amiq.dvt.ui.namechecker.ConventionReaderWriter;

public class ConventionStoreUtil {
    public static final String NAME_CHECK_FILE_NAME = "naming_conventions.xml";
    public static final String EDT_PLUGIN_ID = "ro.amiq.edt";
    public static final String OLD_GLOBAL_CONVENTIONS_ID = "namecheck.conventions";
    public static final String OLD_PROJECT_CONVENTIONS_ID = "prj_namecheck.conventions";
    public static final String E_LANGUAGE_TAG = "e Language";
    public static final String SLN_LANGUAGE_TAG = "SLN";
    public static final String SDL_LANGUAGE_TAG = "SDL";
    public static final String MSDL_LANGUAGE_TAG = "MSDL";
    public static final String PSS_LANGUAGE_TAG = "PSS";
    public static final String VHDL_LANGUAGE_TAG = "VHDL";

    public ConventionStoreUtil(List<Convention> conventionList) {
        try {
            ConventionStoreUtil.load(conventionList, null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void save(List<Convention> conventionList, IProject project) throws IOException {
        ArrayList<Convention> custom = new ArrayList<Convention>();
        for (Convention data : conventionList) {
            if (data.getDeleted()) continue;
            custom.add(data);
        }
        File file = ConventionStoreUtil.getPropertyFile(project);
        if (file == null) {
            return;
        }
        ConventionReaderWriter writer = new ConventionReaderWriter();
        writer.save(custom.toArray(new Convention[custom.size()]), file);
    }

    public static File getPropertyFile(IProject project) {
        if (project == null) {
            return null;
        }
        String path = ConventionStoreUtil.getPathToPropertyFile(project, NAME_CHECK_FILE_NAME, false);
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            String deprecatedPath = ConventionStoreUtil.getPathToPropertyFile(project, NAME_CHECK_FILE_NAME, true);
            if (deprecatedPath == null) {
                return null;
            }
            File deprecatedFile = new File(deprecatedPath);
            if (deprecatedFile.exists()) {
                return deprecatedFile;
            }
        }
        return file;
    }

    public static String getPathToPropertyFile(IProject project, String fileName, boolean withPrefix) {
        try {
            return String.valueOf(project.getLocation().toOSString()) + '/' + ".dvt" + '/' + (withPrefix ? ".dvt_" : "") + fileName;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static void add(List<Convention> conventionList, Convention convention) {
        if (convention == null) {
            return;
        }
        if (convention.getName() == null) {
            return;
        }
        convention.init();
        int i = 0;
        while (i < conventionList.size()) {
            Convention existing = conventionList.get(i);
            if (existing.getName().equals(convention.getName()) && existing.getLanguage().equals(convention.getLanguage()) && !convention.getLocation(true).equals("DEFAULT")) {
                existing.setOverriden();
            }
            ++i;
        }
        String match = convention.getMatch();
        String kind = convention.getKind();
        if (match != null && !match.isEmpty() && kind != null && !kind.isEmpty()) {
            conventionList.add(convention);
        }
    }

    public static void addAll(List<Convention> conventionList, List<Convention> toAddConventionList) {
        for (Convention convention : toAddConventionList) {
            ConventionStoreUtil.add(conventionList, convention);
        }
    }

    public static void delete(Convention data) {
        data.setDeleted(true);
    }

    public static void addDefaults(List<Convention> conventionList, IProject project) throws IOException, CoreException {
        Convention data;
        int i;
        ConventionReaderWriter reader = new ConventionReaderWriter();
        Convention[] datas = null;
        if (project.hasNature("ro.amiq.edt.enature")) {
            datas = reader.read("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE conventions PUBLIC \"-//DVT//name_convention\" \"name_convention.dtd\"><conventions version=\"1\"><convention description=\"Matches any identifier starting with an underscore followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"e Language\"  match=\"NEGATIVE\" name=\"NO_UNDERSCORE_PREFIX\">^_.*$</convention><convention description=\"Matches any identifier starting with &quot;sn_&quot; followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"e Language\"  match=\"NEGATIVE\" name=\"NO_SN_PREFIX\">^sn_.*$</convention><convention description=\"Matches any identifier starting with &quot;vr_&quot; followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"e Language\"  match=\"NEGATIVE\" name=\"NO_VR_PREFIX\">^vr_.*$</convention><convention description=\"Matches any identifier ending in &quot;_t&quot;.\" enabled=\"false\" kind=\"TYPE\" language=\"e Language\"  match=\"POSITIVE\" name=\"TYPE_POSTFIX\">^.*_t$</convention><convention description=\"Matches any identifier ending in &quot;_u&quot;.\" enabled=\"false\" kind=\"UNIT\" language=\"e Language\" match=\"POSITIVE\" name=\"UNIT_POSTFIX\">^.*_u$</convention></conventions>");
            i = 0;
            while (i < datas.length) {
                data = datas[i];
                ConventionStoreUtil.add(conventionList, data);
                ++i;
            }
        }
        if (project.hasNature("ro.amiq.slndt.slnnature")) {
            datas = reader.read("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE conventions PUBLIC \"-//DVT//name_convention\" \"name_convention.dtd\"><conventions version=\"1\"><convention description=\"Matches any identifier starting with an underscore followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"SLN\"  match=\"NEGATIVE\" name=\"NO_UNDERSCORE_PREFIX\">^_.*$</convention><convention description=\"Matches any identifier starting with &quot;sn_&quot; followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"SLN\"  match=\"NEGATIVE\" name=\"NO_SN_PREFIX\">^sn_.*$</convention><convention description=\"Matches any identifier starting with &quot;vr_&quot; followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"SLN\"  match=\"NEGATIVE\" name=\"NO_VR_PREFIX\">^vr_.*$</convention><convention description=\"Matches any identifier ending in &quot;_t&quot;.\" enabled=\"false\" kind=\"TYPE\" language=\"SLN\"  match=\"POSITIVE\" name=\"TYPE_POSTFIX\">^.*_t$</convention><convention description=\"Matches any identifier ending in &quot;_u&quot;.\" enabled=\"false\" kind=\"UNIT\" language=\"SLN\" match=\"POSITIVE\" name=\"UNIT_POSTFIX\">^.*_u$</convention></conventions>");
            i = 0;
            while (i < datas.length) {
                data = datas[i];
                ConventionStoreUtil.add(conventionList, data);
                ++i;
            }
        }
        if (project.hasNature("ro.amiq.msdldt.msdlnature")) {
            datas = reader.read("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE conventions PUBLIC \"-//DVT//name_convention\" \"name_convention.dtd\"><conventions version=\"1\"><convention description=\"Matches any identifier starting with an underscore followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"MSDL\"  match=\"NEGATIVE\" name=\"NO_UNDERSCORE_PREFIX\">^_.*$</convention><convention description=\"Matches any identifier starting with &quot;sn_&quot; followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"MSDL\"  match=\"NEGATIVE\" name=\"NO_SN_PREFIX\">^sn_.*$</convention><convention description=\"Matches any identifier starting with &quot;vr_&quot; followed by any character.\" enabled=\"false\" kind=\"ANY\" language=\"MSDL\"  match=\"NEGATIVE\" name=\"NO_VR_PREFIX\">^vr_.*$</convention><convention description=\"Matches any identifier ending in &quot;_t&quot;.\" enabled=\"false\" kind=\"TYPE\" language=\"MSDL\"  match=\"POSITIVE\" name=\"TYPE_POSTFIX\">^.*_t$</convention><convention description=\"Matches any identifier ending in &quot;_u&quot;.\" enabled=\"false\" kind=\"UNIT\" language=\"MSDL\" match=\"POSITIVE\" name=\"UNIT_POSTFIX\">^.*_u$</convention></conventions>");
            i = 0;
            while (i < datas.length) {
                data = datas[i];
                ConventionStoreUtil.add(conventionList, data);
                ++i;
            }
        }
        if (project.hasNature("ro.amiq.pssdt.pssnature")) {
            datas = reader.read("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE conventions PUBLIC \"-//DVT//name_convention\" \"name_convention.dtd\"><conventions version=\"1\"><convention description=\"Matches any identifier ending in &quot;_a&quot;.\" enabled=\"false\" kind=\"ACTION\" language=\"PSS\"  match=\"POSITIVE\" name=\"ACTION_SUFFIX\">.*_a$</convention><convention description=\"Matches any identifier ending in &quot;_i&quot;.\" enabled=\"false\" kind=\"ACTION_INPUT\" language=\"PSS\" match=\"POSITIVE\" name=\"ACTION_INPUT_SUFFIX\">.*_i$</convention><convention description=\"Matches any identifier ending in &quot;_o&quot;.\" enabled=\"false\" kind=\"ACTION_OUTPUT\" language=\"PSS\" match=\"POSITIVE\" name=\"ACTION_OUTPUT_SUFFIX\">.*_o$</convention><convention description=\"Matches any identifier ending in &quot;_buff&quot;.\" enabled=\"false\" kind=\"BUFFER\" language=\"PSS\" match=\"POSITIVE\" name=\"BUFFER_SUFFIX\">.*_buff$</convention><convention description=\"Matches any identifier ending in &quot;_c&quot;.\" enabled=\"false\" kind=\"COMPONENT\" language=\"PSS\" match=\"POSITIVE\" name=\"COMPONENT_SUFFIX\">.*_c$</convention><convention description=\"Matches any identifier ending in &quot;_ct&quot;.\" enabled=\"false\" kind=\"CONSTRAINT\" language=\"PSS\" match=\"POSITIVE\" name=\"CONSTRAINT_SUFFIX\">.*_ct$</convention><convention description=\"Matches any identifier ending in &quot;_e&quot;.\" enabled=\"false\" kind=\"ENUM_TYPE\" language=\"PSS\" match=\"POSITIVE\" name=\"ENUM_TYPE_SUFFIX\">.*_e$</convention><convention description=\"Matches any identifier ending in &quot;_lk&quot;.\" enabled=\"false\" kind=\"LOCK\" language=\"PSS\" match=\"POSITIVE\" name=\"LOCK_SUFFIX\">.*_lk$</convention><convention description=\"Matches any identifier ending in &quot;_sh&quot;.\" enabled=\"false\" kind=\"SHARE\" language=\"PSS\" match=\"POSITIVE\" name=\"SHARE_SUFFIX\">.*_sh$</convention><convention description=\"Matches any identifier ending in &quot;_st&quot;.\" enabled=\"false\" kind=\"STATE\" language=\"PSS\" match=\"POSITIVE\" name=\"STATE_SUFFIX\">.*_st$</convention><convention description=\"Matches any identifier ending in &quot;_str&quot;.\" enabled=\"false\" kind=\"STREAM\" language=\"PSS\" match=\"POSITIVE\" name=\"STREAM_SUFFIX\">.*_str$</convention><convention description=\"Matches any identifier ending in &quot;_pool&quot;.\" enabled=\"false\" kind=\"POOL_OF_FLOW\" language=\"PSS\" match=\"POSITIVE\" name=\"POOL_OF_FLOW_SUFFIX\">.*_pool$</convention><convention description=\"Matches any identifier ending in &quot;_pool&quot;.\" enabled=\"false\" kind=\"POOL_OF_RESOURCE\" language=\"PSS\" match=\"POSITIVE\" name=\"POOL_OF_RESOURCE_SUFFIX\">.*_pool$</convention><convention description=\"Matches any identifier ending in &quot;_sym&quot;.\" enabled=\"false\" kind=\"SYMBOL\" language=\"PSS\" match=\"POSITIVE\" name=\"SYMBOL_SUFFIX\">.*_sym$</convention><convention description=\"Matches any identifier ending in &quot;_r&quot;.\" enabled=\"false\" kind=\"RESOURCE\" language=\"PSS\" match=\"POSITIVE\" name=\"RESOURCE_SUFFIX\">.*_r$</convention><convention description=\"Matches any identifier ending in &quot;_s&quot;.\" enabled=\"false\" kind=\"STRUCT\" language=\"PSS\" match=\"POSITIVE\" name=\"STRUCT_SUFFIX\">.*_s$</convention><convention description=\"Matches any identifier ending in &quot;_t&quot;.\" enabled=\"false\" kind=\"TYPEDEF\" language=\"PSS\" match=\"POSITIVE\" name=\"TYPEDEF_SUFFIX\">.*_t$</convention><convention description=\"Matches any identifier that contains only uppercase characters.\" enabled=\"false\" kind=\"ENUM_ITEM\" language=\"PSS\" match=\"POSITIVE\" name=\"ENUM_ITEM_UPPERCASE\">[A-Z][A-Z0-9_]*</convention><convention description=\"Matches any identifier that contains only uppercase characters.\" enabled=\"false\" kind=\"CONSTANT\" language=\"PSS\" match=\"POSITIVE\" name=\"CONSTANT_UPPERCASE\">[A-Z][A-Z0-9_]*</convention></conventions>");
            i = 0;
            while (i < datas.length) {
                data = datas[i];
                ConventionStoreUtil.add(conventionList, data);
                ++i;
            }
        }
        if (project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
            datas = reader.read("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE conventions PUBLIC \"-//DVT//name_convention\" \"name_convention.dtd\"><conventions version=\"1\"><convention description=\"Matches any identifier starting with an uppercase letter followed by any character.\" enabled=\"false\" kind=\"SIGNAL\" language=\"VHDL\" match=\"POSITIVE\" name=\"SIGNAL_UPPERCASE_START\">^[A-Z].*</convention><convention description=\"Matches any identifier starting with a lowercase letter followed by any character.\" enabled=\"false\" kind=\"VARIABLE\" language=\"VHDL\" match=\"POSITIVE\" name=\"VARIABLE_LOWERCASE_START\">^[a-z].*</convention><convention description=\"Matches any identifier starting with a lowercase letter followed by any character.\" enabled=\"false\" kind=\"TYPE\" language=\"VHDL\" match=\"POSITIVE\" name=\"TYPE_LOWERCASE_START\">^[a-z].*</convention><convention description=\"Matches any identifier containing from 1 to 24 characters.\" enabled=\"false\" kind=\"ANY\" language=\"VHDL\" match=\"POSITIVE\" name=\"IDENTIFIER_LENGTH\">.{1,24}</convention><convention description=\"Matches any identifier starting with an uppercase letter followed by any character.\" enabled=\"false\" kind=\"ARCHITECTURE\" language=\"VHDL\" match=\"POSITIVE\" name=\"ARCHITECTURE_UPPERCASE_START\">^[A-Z].*</convention><convention description=\"Matches any identifier starting with an uppercase letter followed by any character.\" enabled=\"false\" kind=\"ENTITY\" language=\"VHDL\" match=\"POSITIVE\" name=\"ENTITY_UPPERCASE_START\">^[A-Z].*</convention><convention description=\"Matches any identifier starting with an uppercase letter followed by any character.\" enabled=\"false\" kind=\"COMPONENT\" language=\"VHDL\" match=\"POSITIVE\" name=\"COMPONENT_UPPERCASE_START\">^[A-Z].*</convention><convention description=\"Matches any identifier starting with an uppercase letter followed by uppercase letters, digits or '_'.\" enabled=\"false\" kind=\"CONSTANT\" language=\"VHDL\" match=\"POSITIVE\" name=\"CONSTANT_ALL_UPPERCASE\">[A-Z][A-Z0-9_]*</convention><convention description=\"Matches any identifier ending in &quot;_pi&quot;.\" enabled=\"false\" kind=\"PORT_INPUT\" language=\"VHDL\" match=\"POSITIVE\" name=\"INPUT_PORT_PI_SUFFIX\">(?i).*_pi$</convention><convention description=\"Matches any identifier ending in &quot;_pio&quot;.\" enabled=\"false\" kind=\"PORT_INOUT\" language=\"VHDL\" match=\"POSITIVE\" name=\"INOUT_PORT_PIO_SUFFIX\">(?i).*_pio$</convention><convention description=\"Matches any identifier ending in &quot;_po&quot;.\" enabled=\"false\" kind=\"PORT_OUTPUT\" language=\"VHDL\" match=\"POSITIVE\" name=\"OUTPUT_PORT_PO_SUFFIX\">(?i).*_po$</convention><convention description=\"Matches any identifier containing any character, except for &quot;_&quot;.\" enabled=\"false\" kind=\"GENERIC\" language=\"VHDL\" match=\"POSITIVE\" name=\"NO_UNDERLINE_IN_GENERIC\">[^_]*</convention></conventions>");
            i = 0;
            while (i < datas.length) {
                data = datas[i];
                ConventionStoreUtil.add(conventionList, data);
                ++i;
            }
        }
    }

    public static Convention findConvention(List<Convention> conventionList, String name, String language) {
        return ConventionStoreUtil.findConvention(conventionList, name, language, null);
    }

    public static Convention findConvention(List<Convention> conventionList, String name, String language, String kind) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)language);
        for (Convention convention : conventionList) {
            if (!convention.getEnabled() || convention.getDeleted() || kind != null && !kind.equals(convention.getKind()) || !name.equals(convention.getName()) || !language.equals(convention.getLanguage())) continue;
            return convention;
        }
        return null;
    }

    public static List<Convention> getConventionData(List<Convention> conventionList, boolean includeDeleted) {
        if (!includeDeleted) {
            ArrayList<Convention> conventions = new ArrayList<Convention>();
            int i = 0;
            while (i < conventionList.size()) {
                if (!conventionList.get(i).getDeleted()) {
                    conventions.add(conventionList.get(i));
                }
                ++i;
            }
            return conventions;
        }
        return conventionList;
    }

    public static void load(List<Convention> conventionList, IProject project) throws IOException, CoreException {
        conventionList.clear();
        ConventionStoreUtil.loadGlobal(conventionList, project);
        ConventionStoreUtil.loadLocal(conventionList, project);
    }

    public static void loadGlobal(List<Convention> conventionList, IProject project) throws IOException, CoreException {
        ConventionReaderWriter reader = new ConventionReaderWriter();
        Convention[] datas = null;
        List files = DVTSFiles.NAME_CHECK.getAllFiles(true);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.exists()) continue;
            datas = reader.read(file);
            int i = 0;
            while (i < datas.length) {
                Convention data = datas[i];
                if (project.hasNature("ro.amiq.edt.enature") && data.getLanguage().equals(E_LANGUAGE_TAG)) {
                    data.setIsGlobal();
                    ConventionStoreUtil.add(conventionList, data);
                }
                if (project.hasNature("ro.amiq.slndt.slnnature") && data.getLanguage().equals(SLN_LANGUAGE_TAG)) {
                    data.setIsGlobal();
                    ConventionStoreUtil.add(conventionList, data);
                }
                if (project.hasNature("ro.amiq.msdldt.msdlnature") && data.getLanguage().equals(MSDL_LANGUAGE_TAG)) {
                    data.setIsGlobal();
                    ConventionStoreUtil.add(conventionList, data);
                }
                if (project.hasNature("ro.amiq.pssdt.pssnature") && data.getLanguage().equals(PSS_LANGUAGE_TAG)) {
                    data.setIsGlobal();
                    ConventionStoreUtil.add(conventionList, data);
                }
                if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && data.getLanguage().equals(VHDL_LANGUAGE_TAG)) {
                    data.setIsGlobal();
                    ConventionStoreUtil.add(conventionList, data);
                }
                ++i;
            }
        }
    }

    public static void loadLocal(List<Convention> conventionList, IProject project) throws IOException, CoreException {
        ConventionReaderWriter reader = new ConventionReaderWriter();
        Convention[] datas = null;
        File xmlFile = ConventionStoreUtil.getPropertyFile(project);
        if (xmlFile != null) {
            if (!xmlFile.exists()) {
                IEclipsePreferences EDTPreferenceStore;
                boolean containsOldConventions = false;
                if (project.hasNature("ro.amiq.edt.enature") && (EDTPreferenceStore = DVTPlugin.getDefault().getPreferences(EDT_PLUGIN_ID)) != null) {
                    Convention data;
                    int i;
                    String pref = EDTPreferenceStore.get("ro.amiq.edtnamecheck.conventions", null);
                    if (pref != null && pref.trim().length() > 0) {
                        datas = reader.read(pref);
                        i = 0;
                        while (i < datas.length) {
                            containsOldConventions = true;
                            data = datas[i];
                            ConventionStoreUtil.add(conventionList, data);
                            ++i;
                        }
                    }
                    if ((pref = EDTPreferenceStore.get("ro.amiq.edtprj_namecheck.conventions", null)) != null && pref.trim().length() > 0) {
                        datas = reader.read(pref);
                        i = 0;
                        while (i < datas.length) {
                            containsOldConventions = true;
                            data = datas[i];
                            ConventionStoreUtil.add(conventionList, data);
                            ++i;
                        }
                    }
                }
                if (!containsOldConventions) {
                    ConventionStoreUtil.addDefaults(conventionList, project);
                }
            } else {
                datas = reader.read(xmlFile);
                int i = 0;
                while (i < datas.length) {
                    Convention data = datas[i];
                    if (project.hasNature("ro.amiq.edt.enature") && data.getLanguage().equals(E_LANGUAGE_TAG)) {
                        ConventionStoreUtil.add(conventionList, data);
                    }
                    if (project.hasNature("ro.amiq.slndt.slnnature") && data.getLanguage().equals(SLN_LANGUAGE_TAG)) {
                        ConventionStoreUtil.add(conventionList, data);
                    }
                    if (project.hasNature("ro.amiq.msdldt.msdlnature") && data.getLanguage().equals(MSDL_LANGUAGE_TAG)) {
                        ConventionStoreUtil.add(conventionList, data);
                    }
                    if (project.hasNature("ro.amiq.pssdt.pssnature") && data.getLanguage().equals(PSS_LANGUAGE_TAG)) {
                        ConventionStoreUtil.add(conventionList, data);
                    }
                    if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && data.getLanguage().equals(VHDL_LANGUAGE_TAG)) {
                        ConventionStoreUtil.add(conventionList, data);
                    }
                    ++i;
                }
            }
        }
    }
}

