/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.persistenttask;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.DVTUpdatePersistentJob;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.preferences.PrefConst;

public abstract class DVTPersistentTaskManager {
    protected String[] fAllTaskNames;
    private final ConcurrentLinkedQueue<Runnable> fUpdateQueue = new ConcurrentLinkedQueue();
    private final Job fUpdateJob;

    protected DVTPersistentTaskManager() {
        this.fUpdateJob = new DVTUpdatePersistentJob("Update Persistent Tasks for: " + this.getLanguageKind().DISPLAY_NAME, this.fUpdateQueue);
        this.fUpdateJob.schedule();
    }

    public abstract LanguageKind getLanguageKind();

    public Set<String> getAllTaskNames() {
        HashSet<String> result = new HashSet<String>();
        String[] taskTags = PrefConst.getTaskTagsNames();
        int i = 0;
        while (i < taskTags.length) {
            result.add(taskTags[i]);
            ++i;
        }
        result.add("@DVT_EXPAND_MACRO_INLINE_START");
        return result;
    }

    public boolean getHideTaskTags() {
        return PrefConst.getHideTaskTags();
    }

    public boolean getCaseSensitiveTaskTags() {
        return PrefConst.getTaskTagsCaseSensitive();
    }

    public void runAsync(Runnable r) {
        this.fUpdateQueue.add(r);
    }
}

