/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.persistenttask;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class DVTTaskInfoWrapper {
    protected String fTaskType;
    protected int fLineNumber;
    protected int fCharStart;
    protected int fCharEnd;
    protected String fMessage;

    public DVTTaskInfoWrapper(String taskType, int lineNumber, int charStart, int charEnd, String message) {
        this.fTaskType = DVTStringUtil.intern(taskType);
        this.fLineNumber = lineNumber;
        this.fCharStart = charStart;
        this.fCharEnd = charEnd;
        this.fMessage = message;
    }

    public String getTaskType() {
        return this.fTaskType;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getCharStart() {
        return this.fCharStart;
    }

    public int getCharEnd() {
        return this.fCharEnd;
    }

    public String getMessage() {
        if (this.fTaskType.equals("@DVT_EXPAND_MACRO_INLINE_START")) {
            return "Macro expansion. [Right click to collapse]";
        }
        return this.fMessage;
    }

    public int getPriority() {
        if (this.fTaskType.equals("@DVT_EXPAND_MACRO_INLINE_START")) {
            return 2;
        }
        String priorityString = PrefConst.getTaskTagPriority(this.getTaskType());
        return PrefConst.getTaskTagPriorityIndex(priorityString);
    }

    public abstract String getMarkerId();

    public IMarker makeMarker(IFile file) throws CoreException {
        if (file == null || !file.isAccessible()) {
            return null;
        }
        IMarker marker = file.createMarker(this.getMarkerId());
        marker.setAttribute("lineNumber", this.getLineNumber());
        marker.setAttribute("charStart", this.getCharStart());
        marker.setAttribute("charEnd", this.getCharEnd());
        marker.setAttribute("message", (Object)this.getMessage());
        marker.setAttribute("priority", this.getPriority());
        marker.setAttribute("userEditable", false);
        return marker;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fCharEnd;
        result = 31 * result + this.fCharStart;
        result = 31 * result + this.fLineNumber;
        result = 31 * result + (this.fMessage == null ? 0 : this.fMessage.hashCode());
        result = 31 * result + (this.fTaskType == null ? 0 : this.fTaskType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DVTTaskInfoWrapper other = (DVTTaskInfoWrapper)obj;
        if (this.fCharEnd != other.fCharEnd) {
            return false;
        }
        if (this.fCharStart != other.fCharStart) {
            return false;
        }
        if (this.fLineNumber != other.fLineNumber) {
            return false;
        }
        if (this.fMessage == null ? other.fMessage != null : !this.fMessage.equals(other.fMessage)) {
            return false;
        }
        return !(this.fTaskType == null ? other.fTaskType != null : !this.fTaskType.equals(other.fTaskType));
    }
}

