/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.persistenttask;

import java.util.regex.Pattern;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.preferences.PrefConst;

public abstract class PersistentTaskWalker
implements IPropertyChangeListener {
    private static final Pattern TRIMMED_TASK_PATTERN = Pattern.compile("^\\s*:*\\s*(.*?)\\s*$");
    public static final int NONE = -1;
    protected static final Object fSyncInstance = new Object();
    protected boolean fCaseSensitive;
    protected boolean fHideTaskTags;
    protected String[] fTaskTags = PrefConst.getTaskTagsNames();
    protected String[] fRevTaskNames;

    public PersistentTaskWalker() {
        this.fCaseSensitive = PrefConst.getTaskTagsCaseSensitive();
        this.fHideTaskTags = PrefConst.getHideTaskTags();
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected int taskDetector(char[] buffer) {
        String bufferAsString = new String(buffer);
        if (!this.fCaseSensitive) {
            bufferAsString = bufferAsString.toLowerCase();
        }
        int i = 0;
        while (i < this.fRevTaskNames.length) {
            if (!Character.isJavaIdentifierPart(buffer[this.fRevTaskNames[i].length()]) || buffer[this.fRevTaskNames[i].length()] == '\u0000') {
                if (bufferAsString.startsWith(this.fRevTaskNames[i])) {
                    return i;
                }
                if (!this.fCaseSensitive && bufferAsString.startsWith(this.fRevTaskNames[i].toLowerCase())) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    protected char[] createBuffer(String[] taskNames) {
        int longest = 0;
        String[] stringArray = taskNames;
        int n = taskNames.length;
        int n2 = 0;
        while (n2 < n) {
            String taskName = stringArray[n2];
            if (taskName.length() > longest) {
                longest = taskName.length();
            }
            ++n2;
        }
        return new char[longest + 1];
    }

    protected String typeToString(int type, String[] taskNames) {
        if (type >= 0 && type < taskNames.length) {
            return taskNames[type];
        }
        return "";
    }

    protected char[] bufferShift(char[] buffer, int c) {
        int i = buffer.length - 1;
        while (i > 0) {
            buffer[i] = buffer[i - 1];
            --i;
        }
        buffer[0] = (char)c;
        return buffer;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("taskTags")) {
            this.fTaskTags = PrefConst.getTaskTagsNames();
        }
        if (event.getProperty().equals("taskTagsCase")) {
            this.fCaseSensitive = PrefConst.getTaskTagsCaseSensitive();
        }
        if (event.getProperty().equals("taskTagsHide")) {
            this.fHideTaskTags = PrefConst.getHideTaskTags();
        }
    }

    protected String prepareTaskMessage(String taskTag, String msg) {
        if (!this.fHideTaskTags) {
            return String.valueOf(taskTag) + msg;
        }
        return TRIMMED_TASK_PATTERN.matcher(msg).replaceFirst("$1");
    }
}

