/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.perspectives;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTSlimPerspective
implements IPerspectiveFactory {
    public static final String ID = "ro.amiq.dvt.ui.perspectives.DVTSlimPerspective";

    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        activeWorkbenchWindow.addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (DVTSlimPerspective.ID.equals(perspective.getId())) {
                    this.hideViews(page);
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                if (DVTSlimPerspective.ID.equals(perspective.getId()) && changeId.equals("resetComplete")) {
                    this.hideViews(page);
                }
            }

            private void hideViews(IWorkbenchPage page) {
                IViewReference[] views;
                page.getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
                IViewReference[] iViewReferenceArray = views = page.getViewReferences();
                int n = views.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference view = iViewReferenceArray[n2];
                    if (view != null && !"org.eclipse.ui.navigator.ProjectExplorer".equals(view.getId())) {
                        try {
                            if (page.getPartState((IWorkbenchPartReference)view) != 0) {
                                page.setPartState((IWorkbenchPartReference)view, 0);
                            }
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    private void defineActions(IPageLayout layout) {
        layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        this.addBlockSelectionActionSet(layout);
        layout.addActionSet("ro.amiq.dvt.ui.03.menu.DVTLintActionSet");
        layout.addActionSet("ro.amiq.dvt.ui.06.menu.DVTDiagramsActionSet");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        this.addClearcaseActionSet(layout);
        layout.addNewWizardShortcut("ro.amiq.dvt.wizards.NewProjectWizard");
        layout.addNewWizardShortcut("ro.amiq.dvt.wizards.newfile.NewFileWizardLaunch");
        layout.addNewWizardShortcut("ro.amiq.dvt.ui.wizards.createlinkedresources");
        layout.addNewWizardShortcut("ro.amiq.dvt.wizards.NewProjectFromTemplateWizard");
        layout.addNewWizardShortcut("ro.amiq.dvt.wizards.AddFromProjectTemplateWizard");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        layout.addNewWizardShortcut("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");
        layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.TypeHierarchyView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.templates.CodeTemplatesView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addShowViewShortcut("org.eclipse.ui.views.BookmarkView");
        layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
        layout.addShowViewShortcut("org.eclipse.search.ui.views.SearchView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.TypesView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.CompileOrderView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.RefactoringConnectView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.CoverageView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.ChecksView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.LayersView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.TraceConnectionsView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.VerificationHierarchyView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.MacrosView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.UVMSequenceTreeView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.CallHierarchyView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.UVMComponentsHierarchyView");
    }

    private void addClearcaseActionSet(IPageLayout layout) {
        try {
            String property = System.getProperty("ro.amiq.dvt.showClearcaseActionSet");
            if (property != null && property.equalsIgnoreCase("true")) {
                layout.addActionSet("com.rational.clearcase.ActionSet");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addBlockSelectionActionSet(IPageLayout layout) {
        try {
            layout.addActionSet("org.eclipse.ui.edit.text.actionSet.presentation");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout navFolder = layout.createFolder("nav", 1, 0.23f, editorArea);
        navFolder.addView("org.eclipse.ui.navigator.ProjectExplorer");
        IFolderLayout bottomFolder = layout.createFolder("bottom", 4, 0.7f, editorArea);
        bottomFolder.addView("org.eclipse.ui.views.ProblemView");
        bottomFolder.addView("org.eclipse.ui.views.TaskList");
        bottomFolder.addView("ro.amiq.dvt.ui.views.MacrosView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.CoverageView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.ChecksView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.RefactoringConnectView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.LayersView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.UVMSequenceTreeView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.CallHierarchyView");
        bottomFolder.addView("org.eclipse.ui.console.ConsoleView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.InspectView");
        bottomFolder.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        IFolderLayout outlineFolder = layout.createFolder("outline", 2, 0.7f, editorArea);
        outlineFolder.addView("org.eclipse.ui.views.ContentOutline");
        outlineFolder.addView("ro.amiq.dvt.ui.views.TypesView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.TypeHierarchyView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.VerificationHierarchyView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.UVMComponentsHierarchyView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.CompileOrderView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.TraceConnectionsView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.templates.CodeTemplatesView");
        outlineFolder.addPlaceholder("org.eclipse.ui.views.BookmarkView");
    }
}

