/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.preferences.BooleanFieldEditor2;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.utils.IntegerFieldEditor;

public class DVTPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFERENCE_PAGE_ID = "ro.amiq.dvt.ui.preferences.DVTPreferencePage";
    private static final String[][] TIME_INTERVALS = new String[][]{{"30 sec", "30"}, {"1 min", "60"}, {"2 min", "120"}, {"5 min", "300"}, {"10 min", "600"}, {"15 min", "900"}, {"20 min", "1200"}, {"30 min", "1800"}, {"1 hour", "3600"}, {"2 hours", "7200"}};
    private static final String[][] DIFFERENT_COLORS_OPTIONS = new String[][]{{"background", "background"}, {"text", "text"}};
    private BooleanFieldEditor2 fShowReadOnlyDecorator;
    private StringFieldEditor fReadOnlyDefinedDecorator;
    private BooleanFieldEditor2 fCheckFreeSpace;
    private ComboFieldEditor fCheckFreeSpaceInterval;
    private Composite fCheckFreeSpaceIntervalContainer;
    private ComboFieldEditor fAutoSaveInterval;
    private Composite fAutoSaveIntervalContainer;
    private BooleanFieldEditor2 fAutoSave;
    private BooleanFieldEditor fShowQuickViewNotifications;
    private BooleanFieldEditor fShowInspectViewNotifications;
    private BooleanFieldEditor fShowBreadcrumbNotifications;
    private BooleanFieldEditor fAutomaticBuildNotifications;
    private BooleanFieldEditor fContentAssistNotifications;
    private BooleanFieldEditor fSemanticShowAliasName;
    private IntegerFieldEditor fInspectViewMaxContextLines;
    private IntegerFieldEditor fQuickQueryMaxElementsPerCategory;
    private ComboFieldEditor fDifferentColorsProjectOptions;
    private Composite fDifferentColorsProjectContainer;
    private BooleanFieldEditor2 fDifferentColorsProject;
    private BooleanFieldEditor2 fCheckFreeSpaceOnSave;
    private ComboFieldEditor fParamRadix;

    public DVTPreferencePage() {
        super(1);
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.setDescription("General Settings for Design and Verification Tools");
    }

    public void createFieldEditors() {
        BooleanFieldEditor commonSettingsInvalidPathsPopup = new BooleanFieldEditor("common.settings.paths.check", "Report invalid common settings paths at startup.", 0, this.getFieldEditorParent());
        this.addField((FieldEditor)commonSettingsInvalidPathsPopup);
        BooleanFieldEditor editorPerspectiveSwitch = new BooleanFieldEditor("ro.amiq.dvt.DISABLE_SWITCH_PERSPECTIVE", "Disable automatic switch of the perspective when switching between editors.", 0, this.getFieldEditorParent());
        this.addField((FieldEditor)editorPerspectiveSwitch);
        StringFieldEditor emacsCommand = new StringFieldEditor("emacs.command", "Emacs command:", this.getFieldEditorParent());
        this.addField((FieldEditor)emacsCommand);
        BooleanFieldEditor2 autoSaveBeforeRebuild = new BooleanFieldEditor2("autoSaveBeforeRebuild", "Save automatically before build", 0, this.getFieldEditorParent());
        this.addField((FieldEditor)autoSaveBeforeRebuild);
        BooleanFieldEditor2 bufferedSave = new BooleanFieldEditor2("bufferSaveWhenOverlappingOperationInProgress", "Hide \"User Operation is waiting\" dialog (when saving a file during build/restore)", 0, this.getFieldEditorParent());
        this.addField((FieldEditor)bufferedSave);
        Composite autosaveContainer = new Composite(this.getFieldEditorParent(), 0);
        GridLayout autosaveContainerLayout = new GridLayout(2, false);
        autosaveContainerLayout.marginHeight = 0;
        autosaveContainerLayout.marginWidth = 0;
        autosaveContainer.setLayout((Layout)autosaveContainerLayout);
        GridData autosaveContainerLayoutData = new GridData(4, 4, true, false);
        autosaveContainerLayoutData.horizontalSpan = 2;
        autosaveContainer.setLayoutData((Object)autosaveContainerLayoutData);
        Composite checkboxContainer = new Composite(autosaveContainer, 0);
        this.fAutoSave = new BooleanFieldEditor2("saveDirtyEditors", "Enable auto-save", 0, checkboxContainer);
        final Button changeControl = this.fAutoSave.getChangeControl(checkboxContainer);
        this.addField((FieldEditor)this.fAutoSave);
        this.fAutoSaveIntervalContainer = new Composite(autosaveContainer, 0);
        this.fAutoSaveInterval = new ComboFieldEditor("saveDirtyEditorsInterval", "every", TIME_INTERVALS, this.fAutoSaveIntervalContainer);
        this.fAutoSaveInterval.setEnabled(this.getPreferenceStore().getBoolean("saveDirtyEditors"), this.fAutoSaveIntervalContainer);
        this.addField((FieldEditor)this.fAutoSaveInterval);
        changeControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTPreferencePage.this.fAutoSaveInterval.setEnabled(changeControl.getSelection(), DVTPreferencePage.this.fAutoSaveIntervalContainer);
            }
        });
        BooleanFieldEditor button = new BooleanFieldEditor("clear_selection_focus_lost", "Single selection (a single DVT editor can have selected text at any given time)", this.getFieldEditorParent());
        this.addField((FieldEditor)button);
        Composite readOnlyContainer = new Composite(this.getFieldEditorParent(), 4);
        GridLayout readOnlyContainerLayout = new GridLayout(2, false);
        readOnlyContainerLayout.marginHeight = 0;
        readOnlyContainerLayout.marginWidth = 0;
        readOnlyContainer.setLayout((Layout)readOnlyContainerLayout);
        GridData readOnlyContainerLayoutData = new GridData(4, 4, true, false, 2, 1);
        readOnlyContainer.setLayoutData((Object)readOnlyContainerLayoutData);
        Composite readOnlyCheckboxContainer = new Composite(readOnlyContainer, 0);
        this.fShowReadOnlyDecorator = new BooleanFieldEditor2("showReadOnlyDecorators", "Show read-only decorators:", 0, readOnlyCheckboxContainer);
        final Button changeControlOnDefinedReadOnlyDecorator = this.fShowReadOnlyDecorator.getChangeControl(readOnlyCheckboxContainer);
        this.addField((FieldEditor)this.fShowReadOnlyDecorator);
        final Composite readOnlyContainer2 = new Composite(readOnlyContainer, 4);
        readOnlyContainer2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fReadOnlyDefinedDecorator = new StringFieldEditor("readOnlyDecorator", "", readOnlyContainer2);
        this.fReadOnlyDefinedDecorator.setEnabled(this.getPreferenceStore().getBoolean("showReadOnlyDecorators"), readOnlyContainer2);
        this.addField((FieldEditor)this.fReadOnlyDefinedDecorator);
        changeControlOnDefinedReadOnlyDecorator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTPreferencePage.this.fReadOnlyDefinedDecorator.setEnabled(changeControlOnDefinedReadOnlyDecorator.getSelection(), readOnlyContainer2);
            }
        });
        Composite checkFreeSpaceContainer = new Composite(this.getFieldEditorParent(), 4);
        GridLayout checkFreeSpaceContainerLayout = new GridLayout(2, false);
        checkFreeSpaceContainerLayout.marginHeight = 0;
        checkFreeSpaceContainerLayout.marginWidth = 0;
        checkFreeSpaceContainer.setLayout((Layout)checkFreeSpaceContainerLayout);
        GridData checkFreeSpaceContainerLayoutData = new GridData(4, 4, true, false, 2, 1);
        checkFreeSpaceContainer.setLayoutData((Object)checkFreeSpaceContainerLayoutData);
        Composite checkFreeSpaceCheckboxContainer = new Composite(checkFreeSpaceContainer, 0);
        this.fCheckFreeSpace = new BooleanFieldEditor2("checkWorkspaceFreeSpace", "Check free space", 0, checkFreeSpaceCheckboxContainer);
        final Button changeControlCheckFreeSpaceInterval = this.fCheckFreeSpace.getChangeControl(checkFreeSpaceCheckboxContainer);
        this.addField((FieldEditor)this.fCheckFreeSpace);
        this.fCheckFreeSpaceIntervalContainer = new Composite(checkFreeSpaceContainer, 4);
        this.fCheckFreeSpaceIntervalContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fCheckFreeSpaceInterval = new ComboFieldEditor("checkWorkspaceFreeSpaceInterval", "every", TIME_INTERVALS, this.fCheckFreeSpaceIntervalContainer);
        this.fCheckFreeSpaceInterval.setEnabled(this.getPreferenceStore().getBoolean("checkWorkspaceFreeSpace"), this.fCheckFreeSpaceIntervalContainer);
        this.addField((FieldEditor)this.fCheckFreeSpaceInterval);
        changeControlCheckFreeSpaceInterval.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTPreferencePage.this.fCheckFreeSpaceInterval.setEnabled(changeControlCheckFreeSpaceInterval.getSelection(), DVTPreferencePage.this.fCheckFreeSpaceIntervalContainer);
            }
        });
        Composite checkFreeSpaceOnSaveContainer = new Composite(this.getFieldEditorParent(), 4);
        GridLayout checkFreeSpaceOnSaveContainerLayout = new GridLayout(2, false);
        checkFreeSpaceOnSaveContainerLayout.marginHeight = 0;
        checkFreeSpaceOnSaveContainerLayout.marginWidth = 0;
        checkFreeSpaceOnSaveContainer.setLayout((Layout)checkFreeSpaceContainerLayout);
        GridData checkFreeSpaceOnSaveContainerLayoutData = new GridData(4, 4, true, false, 2, 1);
        checkFreeSpaceOnSaveContainer.setLayoutData((Object)checkFreeSpaceOnSaveContainerLayoutData);
        Composite checkFreeSpaceOnSaveCheckboxContainer = new Composite(checkFreeSpaceOnSaveContainer, 0);
        this.fCheckFreeSpaceOnSave = new BooleanFieldEditor2("checkWorkspaceFreeSpaceOnSave", "Check free space on save", 0, checkFreeSpaceOnSaveCheckboxContainer);
        this.addField((FieldEditor)this.fCheckFreeSpaceOnSave);
        if (EclipseUtils.isEclipse4x()) {
            Composite differentColorsContainer = new Composite(this.getFieldEditorParent(), 0);
            GridDataFactory.fillDefaults().span(2, 0).align(4, 128).grab(true, false).applyTo((Control)differentColorsContainer);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(differentColorsContainer);
            Composite checkboxDCContainer = new Composite(differentColorsContainer, 0);
            this.fDifferentColorsProject = new BooleanFieldEditor2("perProjectColors", "Color editor icons and view labels per project", 0, checkboxDCContainer);
            final Button changeControl2 = this.fDifferentColorsProject.getChangeControl(checkboxDCContainer);
            this.addField((FieldEditor)this.fDifferentColorsProject);
            this.fDifferentColorsProjectContainer = new Composite(differentColorsContainer, 0);
            this.fDifferentColorsProjectOptions = new ComboFieldEditor("perProjectColorsFgBg", "", DIFFERENT_COLORS_OPTIONS, this.fDifferentColorsProjectContainer);
            this.fDifferentColorsProjectOptions.setEnabled(this.getPreferenceStore().getBoolean("perProjectColors"), this.fDifferentColorsProjectContainer);
            this.addField((FieldEditor)this.fDifferentColorsProjectOptions);
            changeControl2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DVTPreferencePage.this.fDifferentColorsProjectOptions.setEnabled(changeControl2.getSelection(), DVTPreferencePage.this.fDifferentColorsProjectContainer);
                }
            });
        }
        this.fShowQuickViewNotifications = new BooleanFieldEditor("show.notifications", "Show Quick View notifications", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fShowQuickViewNotifications);
        this.fShowInspectViewNotifications = new BooleanFieldEditor("show.inspect.notifications", "Show Inspect View notifications", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fShowInspectViewNotifications);
        this.fShowBreadcrumbNotifications = new BooleanFieldEditor("show.breadcrumb.notifications", "Show Breadcrumb notifications", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fShowBreadcrumbNotifications);
        this.fAutomaticBuildNotifications = new BooleanFieldEditor("show.automatic.build.notifications", "Show Build notifications", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fAutomaticBuildNotifications);
        this.fContentAssistNotifications = new BooleanFieldEditor("show.content.assist.notifications", "Show Content Assist notifications", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fContentAssistNotifications);
        this.fParamRadix = new ComboFieldEditor("Choose radix for parameter actual value", "Choose radix for parameter actual value", this.getRadixOptions(), this.getFieldEditorParent());
        this.addField((FieldEditor)this.fParamRadix);
        this.fSemanticShowAliasName = new BooleanFieldEditor("semantic.show.alias.name", "Also show type alias name in semantic errors/warnings", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fSemanticShowAliasName);
        this.fInspectViewMaxContextLines = new IntegerFieldEditor("inspect.context.lines", "Number of context lines in Inspect View:", this.getFieldEditorParent());
        this.fInspectViewMaxContextLines.setValidRange(0, 1000);
        this.addField((FieldEditor)this.fInspectViewMaxContextLines);
        this.fQuickQueryMaxElementsPerCategory = new IntegerFieldEditor("quickQuery.maxElementsPerCategory", "Maximum number of elements per category in Quick Query View:", this.getFieldEditorParent());
        this.fQuickQueryMaxElementsPerCategory.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.fQuickQueryMaxElementsPerCategory);
        StringFieldEditor copyHierarchyPathSegmentSeparator = new StringFieldEditor("copyHierarchyPathSegmentSeparator", "Copy Hierarchy Path segment separator:", this.getFieldEditorParent());
        copyHierarchyPathSegmentSeparator.setEmptyStringAllowed(false);
        this.addField((FieldEditor)copyHierarchyPathSegmentSeparator);
    }

    private String[][] getRadixOptions() {
        int len = PrefConst.PARAM_RADIX_VALUE.length;
        String[][] result = new String[len][2];
        int i = 0;
        while (i < len) {
            result[i][0] = PrefConst.PARAM_RADIX_VALUE[i];
            result[i][1] = PrefConst.PARAM_RADIX_VALUE[i];
            ++i;
        }
        return result;
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        if (EclipseUtils.isEclipse4x()) {
            ProjectColorUtils.colorFiles();
            ProjectColorUtils.updateViews();
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fCheckFreeSpaceInterval.setEnabled(this.fCheckFreeSpace.getBooleanValue(), this.fCheckFreeSpaceIntervalContainer);
        this.fAutoSaveInterval.setEnabled(this.fAutoSave.getBooleanValue(), this.fAutoSaveIntervalContainer);
        if (EclipseUtils.isEclipse4x()) {
            this.fDifferentColorsProjectOptions.setEnabled(this.fDifferentColorsProject.getBooleanValue(), this.fDifferentColorsProjectContainer);
        }
    }

    public void dispose() {
        super.dispose();
        this.fQuickQueryMaxElementsPerCategory = null;
    }
}

