/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.osgi.service.prefs.BackingStoreException;
import ro.amiq.dvt.DVTPlugin;

public class EclipsePreferencesUtils {
    private static final String EMPTY_STRING = "";
    private static final Comparator<String> STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean isAutobuildOn() {
        IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
        if (preferences == null) {
            return false;
        }
        return preferences.getBoolean("description.autobuilding", true);
    }

    public static Map<String, String> getPreferences(String scope) {
        return EclipsePreferencesUtils.convertToMap((IEclipsePreferences)Platform.getPreferencesService().getRootNode().node(scope));
    }

    private static Map<String, String> convertToMap(IEclipsePreferences preferences) {
        if (preferences == null) {
            return Collections.emptyMap();
        }
        final TreeMap<String, String> map = new TreeMap<String, String>(STRING_COMPARATOR);
        final int baseLength = preferences.absolutePath().length();
        try {
            preferences.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                    String[] keys;
                    String absolutePath = node.absolutePath();
                    if (absolutePath.length() <= baseLength + 1) {
                        return true;
                    }
                    String path = absolutePath.substring(baseLength + 1);
                    String[] stringArray = keys = node.keys();
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        String value = node.get(key, null);
                        if (value != null) {
                            map.put(EclipsePreferencesUtils.escape(String.valueOf(path) + '/' + (key.indexOf(47) == -1 ? EclipsePreferencesUtils.EMPTY_STRING : String.valueOf('/')) + key, true, true), EclipsePreferencesUtils.escape(value, false, true));
                        }
                        ++n2;
                    }
                    return true;
                }
            });
        }
        catch (BackingStoreException backingStoreException) {
            return Collections.emptyMap();
        }
        return map;
    }

    private static String escape(String string, boolean escapeSpace, boolean escapeUnicode) {
        int len = string.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder sb = new StringBuilder(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = string.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    sb.append('\\');
                    sb.append('\\');
                } else {
                    sb.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            sb.append('\\');
                        }
                        sb.append(' ');
                        break;
                    }
                    case '\t': {
                        sb.append('\\');
                        sb.append('t');
                        break;
                    }
                    case '\n': {
                        sb.append('\\');
                        sb.append('n');
                        break;
                    }
                    case '\r': {
                        sb.append('\\');
                        sb.append('r');
                        break;
                    }
                    case '\f': {
                        sb.append('\\');
                        sb.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        sb.append('\\');
                        sb.append(aChar);
                        break;
                    }
                    default: {
                        if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                            sb.append('\\');
                            sb.append('u');
                            sb.append(EclipsePreferencesUtils.toHex(aChar >> 12 & 0xF));
                            sb.append(EclipsePreferencesUtils.toHex(aChar >> 8 & 0xF));
                            sb.append(EclipsePreferencesUtils.toHex(aChar >> 4 & 0xF));
                            sb.append(EclipsePreferencesUtils.toHex(aChar & 0xF));
                            break;
                        }
                        sb.append(aChar);
                    }
                }
            }
            ++x;
        }
        return sb.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

