/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.diagrams.uml.preferences.UMLPreferenceInitializer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationMode;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.preferences.DiagramPrefConst;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        try {
            IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
            store.setDefault("disable.new.hyperlink.tooltip.engine", false);
            store.setDefault("search.view.vlogdt.hide_references_to_overriden", false);
            store.setDefault("search.view.vlogdt.hide_references_to_getter_setter", false);
            store.setDefault("search.view.dvt.hide_post_config", false);
            store.setDefault("search.view.vlogdt.hide_non_type_matching_specializations", true);
            store.setDefault("search.view.vlogdt.hide_references_ouside_instance_path", true);
            store.setDefault("search.view.vlogdt.hide_only_reads", false);
            store.setDefault("search.view.vlogdt.hide_only_writes", false);
            store.setDefault("search.view.vlogdt.hide_only_read_writes", false);
            store.setDefault("rename.rename_in_sub_instances", true);
            store.setDefault("rename.rename_in_parent_instances", true);
            store.setDefault("wavedrom.waveform.size", 5000);
            store.setDefault("tooltip.size", 30000);
            store.setDefault("semantic.show.alias.name", false);
            this.initializeSpellingPreferences(store);
            this.initializeMarkOccurences(store);
            this.initializeViewPreferences(store);
            this.initializeExternalProgramsPreferences(store);
            this.initializeOtherPreferences(store);
            this.initializeMiscPreferences(store);
            this.initializeSyntaxPreferences(store);
            this.initializeEditorPreferences(store);
            this.initializeInspectPreferences(store);
            this.initializeBitfieldDiagramsPreferences(store);
            this.initializeThemePreferences(store);
            this.initializePredefinedFilters(store);
            this.initializeTraceConnectionsPreferences(store);
            this.initializeDesignDiagramsPreferences(store);
            this.initializePerProjectColors(store);
            this.initializeUMLDiagramsPreferences(store);
            this.initializeUMLDiagramConfigPreferences(store);
            this.initializeBreadcrumbPreferences(store);
            this.initializeCopyHierarchyPathSegmentSeparatorPreferences(store);
            this.initializeGeneralEditorsPreferences(store);
            this.initializeQuickQueryPreferences(store);
            this.initializeAIAssistantPreferences(store);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void initializeBitfieldDiagramsPreferences(IPreferenceStore store) {
        store.setDefault("bitfield.view_mode", PrefConst.DEFAULT_BITFIELD_VIEW_MODE_VAL);
    }

    private void initializeGeneralEditorsPreferences(IPreferenceStore store) {
        store.setDefault("editor.maxiumSizeOfFile", 25.0f);
        store.setDefault("disable.codeformatting", 10000);
        store.setDefault("format.indent.auto_detect", true);
    }

    private void initializeBreadcrumbPreferences(IPreferenceStore store) {
        store.setDefault("breadcrumb_type", "DESIGN,VERIFICATION,SCOPE,FILESYSTEM");
    }

    private void initializePredefinedFilters(IPreferenceStore store) {
        store.setDefault("guiFiltersHideOVMLibrary", true);
        store.setDefault("guiFiltersHideUVMLibrary", true);
        store.setDefault("guiFiltersHideVMMLibrary", true);
        store.setDefault("guiFiltersHideXilinxLibraries", true);
        store.setDefault("guiFiltersHidePerspecLibraries", true);
        store.setDefault("guiFiltersHideCSystemHeaders", true);
        store.setDefault("guiFiltersHidePSSCHeaders", true);
        store.setDefault("guiFiltersHideSystemCHeaders", true);
        store.setDefault("guiFiltersHidePrecompiledDatabases", false);
    }

    private void initializeOtherPreferences(IPreferenceStore store) {
        store.setDefault("saveDirtyEditors", false);
        store.setDefault("saveDirtyEditorsInterval", 300);
        store.setDefault("autoSaveBeforeRebuild", false);
        store.setDefault("bufferSaveWhenOverlappingOperationInProgress", false);
        store.setDefault("checkWorkspaceFreeSpaceInterval", 300);
        store.setDefault("checkWorkspaceFreeSpace", false);
        store.setDefault("checkWorkspaceFreeSpaceOnSave", "checkWorkspaceFreeSpaceOnSave");
        store.setDefault("editor.disable_auto_complete", false);
        store.setDefault("ca.insert_named_arguments", false);
        store.setDefault("ca.delay_trigger", 200);
        store.setDefault("diagramfilters.all_design_diagrams_filters", "Clock (predefined)\nreduceGates\nhide ports, signals matching .*\nshow ports, signals matching (?i).*clk.*\ncolor ports, signals matching (?i).*clk.* using green\nshow ports, signals matching (?i).*clock.*\ncolor ports, signals matching (?i).*clock.* using greenNEW_SETReset (predefined)\nreduceGates\nhide ports, signals matching .*\nshow ports, signals matching (?i).*rst.*\ncolor ports, signals matching (?i).*rst.* using blue\nshow ports, signals matching (?i).*reset.*\ncolor ports, signals matching (?i).*reset.* using blueNEW_SETClock & Reset (predefined)\nreduceGates\nhide ports, signals matching .*\nshow ports, signals matching (?i).*clk.*\ncolor ports, signals matching (?i).*clk.* using green\nshow ports, signals matching (?i).*clock.*\ncolor ports, signals matching (?i).*clock.* using green\nshow ports, signals matching (?i).*rst.*\ncolor ports, signals matching (?i).*rst.* using blue\nshow ports, signals matching (?i).*reset.*\ncolor ports, signals matching (?i).*reset.* using blue");
        store.setDefault("diagramfilters.all_ch_diagram_filters", "Driver & Monitor (predefined)\nreducePorts\ncolor instances, types matching .*(driver|drv).* using lightgreen\ncolor instances, types matching .*(monitor|mon).* using lightskyblue");
        store.setDefault("diagram.search_jump_to_first_match", false);
        store.setDefault("diagram.diagram_generation_timeout", PrefConst.DIAGRAM_GENERATION_TIMEOUT_VAL);
        store.setDefault("diagram.diagram_layout_retries", PrefConst.DIAGRAM_LAYOUT_RETRIES_VAL);
        store.setDefault("diagram.reverse_arrows", false);
        store.setDefault("ro.amiq.dvt.PERFORM_AUTOBUILD_DISABLED_CHECK", true);
        store.setDefault("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE", 5);
        store.setDefault("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE", true);
        store.setDefault("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE", true);
        store.setDefault("ro.amiq.dvt.DATABASE_UPDATE_ENABLE", true);
        store.setDefault("ro.amiq.dvt.DATABASE_UPDATE", 60);
        store.setDefault("ro.amiq.dvt.DISABLE_SWITCH_PERSPECTIVE", true);
        store.setDefault("ro.amiq.dvt.RESOURCE_MONITOR_ENABLE", true);
        store.setDefault("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT_ENABLE", true);
        store.setDefault("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT", 6);
        store.setDefault("ro.amiq.dvt.RESOURCE_MONITOR_THRESHOLD", 500);
        store.setDefault("ro.amiq.dvt.REPORT_AN_ISSUE_NOTIFICATION_ENABLED", true);
        store.setDefault("ro.amiq.dvt.EXTERNAL_PLUGIN_NOTIFICATION_ENABLED", true);
        store.setDefault("ro.amiq.dvt.MEMORY_MONITOR_DISPLAY_WARNING_POPUP", true);
        store.setDefault("common.settings.paths.check", true);
        store.setDefault("mdiagram.highlightNodesWithSubinstances", StringConverter.asString((boolean)true));
        store.setDefault("mdiagram.highlightNodesWithSubinstancesThickness", "2.5");
        store.setDefault("mdiagram.propagateportcolor", StringConverter.asString((boolean)true));
        store.setDefault("mdiagram.bgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_BG_COLOR_DEFAULT));
        store.setDefault("mdiagram.graphlabelcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_GRAPH_LABEL_COLOR_DEFAULT));
        store.setDefault("mdiagram.inportbgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_IN_PORT_BG_COLOR_DEFAULT));
        store.setDefault("mdiagram.inportfgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_IN_PORT_FG_COLOR_DEFAULT));
        store.setDefault("mdiagram.outportbgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_OUT_PORT_BG_COLOR_DEFAULT));
        store.setDefault("mdiagram.outportfgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_OUT_PORT_FG_COLOR_DEFAULT));
        store.setDefault("mdiagram.inoutportbgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INOUT_PORT_BG_COLOR_DEFAULT));
        store.setDefault("mdiagram.inoutportfgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INOUT_PORT_FG_COLOR_DEFAULT));
        store.setDefault("mdiagram.interfaceportbgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INTERFACE_PORT_BG_COLOR_DEFAULT));
        store.setDefault("mdiagram.interfaceportfgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INTERFACE_PORT_FG_COLOR_DEFAULT));
        store.setDefault("mdiagram.otherportbgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_OTHER_PORT_BG_COLOR_DEFAULT));
        store.setDefault("mdiagram.otherportfgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_OTHER_PORT_FG_COLOR_DEFAULT));
        store.setDefault("mdiagram.instbgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INST_BG_COLOR_DEFAULT));
        store.setDefault("mdiagram.instfgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INST_FG_COLOR_DEFAULT));
        store.setDefault("mdiagram.interfaceinstancebgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INTERFACE_INSTANCE_BG_COLOR_DEFAULT));
        store.setDefault("mdiagram.interfaceinstancefgcolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INTERFACE_INSTANCE_FG_COLOR_DEFAULT));
        store.setDefault("mdiagram.unidiredgecolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_UNIDIR_EDGE_COLOR_DEFAULT));
        store.setDefault("mdiagram.bidiredgecolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_BIDIR_EDGE_COLOR_DEFAULT));
        store.setDefault("mdiagram.interfaceedgecolor", StringConverter.asString((RGB)DiagramPrefConst.MDIAGRAM_INTERFACE_EDGE_COLOR_DEFAULT));
        store.setDefault("graphviz.umlAutoUpdateDiagram", true);
        store.setDefault("chdiagrams.decreasing_font", false);
        store.setDefault("chdiagrams.font_size", 18);
        store.setDefault("chdiagrams.exclude_names_vlog", "");
        store.setDefault("chdiagrams.exclude_types_vlog", "");
        store.setDefault("chdiagrams.exclude_names_edt", "");
        store.setDefault("chdiagrams.exclude_types_edt", "");
        store.setDefault("chdiagrams.exclude_names_slndt", "");
        store.setDefault("chdiagrams.exclude_types_slndt", "");
        store.setDefault("designhierarchyview.showPorts", true);
        store.setDefault("designhierarchyview.showPortsBelow", false);
        store.setDefault("designhierarchyview.sortalphabetically", false);
        store.setDefault("designhierarchyview.prependLibrary", false);
        store.setDefault("designhierarchyview.hideGenerates", true);
        store.setDefault("designhierarchyview.showUPF", true);
        store.setDefault("designhierarchyview.showPDColor", true);
        store.setDefault("designhierarchyview.UPFColorBackground", false);
        store.setDefault("designhierarchyview.UPFColorText", true);
        store.setDefault("macrosViewVlogdtHideIfndefGuardsLazy", true);
        store.setDefault("macrosViewVlogdtHideConfigUnDefinedLazy", true);
        store.setDefault("traceconnectionsview.showPorts", true);
        store.setDefault("traceconnectionsview.showPortsBelow", false);
        store.setDefault("traceconnectionsview.showContentAsList", false);
        store.setDefault("verificationhierarchyview.showPorts", true);
        store.setDefault("verificationhierarchyview.showPortsBelow", false);
        store.setDefault("verificationhierarchyview.showComponentsOnly", true);
        store.setDefault("verificationhierarchyview.prependPackage", false);
        store.setDefault("verificationhierarchyview.sortAlphabetically", false);
        store.setDefault("layersview.vlog.showSuperTypeLayers", false);
        store.setDefault("layersview.vlog.showSubTypeLayers", false);
        store.setDefault("layersview.vlog.showTypeLayers", true);
        store.setDefault("layersview.e.showSuperTypeLayers", false);
        store.setDefault("layersview.e.showSubTypeLayers", false);
        store.setDefault("layersview.e.showSubAndSuperTypeLayers", false);
        store.setDefault("layersview.e.showTypeLayers", true);
        store.setDefault("uvmcomponentsview.show_uvm_members", true);
        store.setDefault("uvmcomponentsview.group_by_package", false);
        store.setDefault("uvmcomponentsview.prepend_package", true);
        store.setDefault("uvmcomponentsview.sort_by_category", false);
        store.setDefault("uvmcomponentsview.show_only_public", false);
        store.setDefault("uvmcomponentsview.show_all_inherited", false);
        store.setDefault("uvmcomponentsview.show_predefined", false);
        store.setDefault("uvmcomponentsview.show_fields", true);
        store.setDefault("uvmcomponentsview.show_functions", true);
        store.setDefault("uvmcomponentsview.show_tasks", true);
        store.setDefault("uvmcomponentsview.show_methods", true);
        store.setDefault("uvmcomponentsview.show_event", true);
        store.setDefault("uvmcomponentsview.show_definition_layer", true);
        store.setDefault("typehierarchyview.show_subtype_hierarchy", false);
        store.setDefault("typehierarchyview.show_supertype_hierarchy", false);
        store.setDefault("typehierarchyview.show_type_hierarchy", true);
        store.setDefault("typehierarchyview.show_only_public", true);
        store.setDefault("typehierarchyview.show_all_inherited", false);
        store.setDefault("typehierarchyview.show_predefined", false);
        store.setDefault("typehierarchyview.show_fields", true);
        store.setDefault("typehierarchyview.show_methods", true);
        store.setDefault("typehierarchyview.show_functions", true);
        store.setDefault("typehierarchyview.show_tasks", true);
        store.setDefault("typehierarchyview.show_tcms", true);
        store.setDefault("typehierarchyview.show_event", true);
        store.setDefault("typehierarchyview.show_onevent", false);
        store.setDefault("typehierarchyview.show_constraints", false);
        store.setDefault("typehierarchyview.show_cover_definitions", false);
        store.setDefault("typehierarchyview.show_definition_layer", true);
        store.setDefault("typehierarchyview.prepend_package", false);
        store.setDefault("callHierarchyView.strategy", PrefConst.CALL_HIERARCHY_BASE_STRATEGY_VAL.toString());
        store.setDefault("callhierarchyview.prependPackage", false);
        store.setDefault("callHierarchyView.hideOverrides", true);
        store.setDefault("callHierarchyView.hideConditionals", false);
        store.setDefault("callHierarchyView.hideForks", false);
        store.setDefault("callHierarchyView.hideNamedBeginEnds", true);
        store.setDefault("callHierarchyView.linkWithEditor", false);
        store.setDefault("callHierarchyView.showInspectPanel", true);
        store.setDefault("callHierarchyView.showAllSimilarLayers", false);
        store.setDefault("icon.color.applied.filters", "");
        store.setDefault("icon.color.custom.filters", "");
        store.setDefault("favorite.searches", PrefConst.ALL_FAVORITE_SEARCHES_VAL);
    }

    private void initializeExternalProgramsPreferences(IPreferenceStore store) {
        store.setDefault("emacs.command", "emacs");
    }

    private void initializeViewPreferences(IPreferenceStore store) {
        store.setDefault("typesViewSortByType", true);
        store.setDefault("checksViewSortByType", true);
        store.setDefault("coverageViewSortByType", true);
        store.setDefault("uvmcomponentsview.prefs_changed", false);
        store.setDefault("searchViewVlogdtHideConstraintModes", false);
        store.setDefault("searchViewVlogdtHideRandModes", false);
        store.setDefault("searchViewEdtHideNewWith", false);
        store.setDefault("searchViewEdtHideNew", false);
        store.setDefault("searchViewEdtHideGen", false);
        store.setDefault("searchViewEdtHideDo", false);
    }

    private void initializeSpellingPreferences(IPreferenceStore store) {
        store.setDefault("spelling_locale", SpellCheckEngine.getDefaultLocale().toString());
        store.setDefault("spelling_ignore_digits", true);
        store.setDefault("spelling_ignore_mixed", true);
        store.setDefault("spelling_ignore_sentence", true);
        store.setDefault("spelling_ignore_upper", true);
        store.setDefault("spelling_proposal_threshold", 10);
        store.setDefault("spelling_user_dictionary", "");
        store.setDefault("spelling_max_reported_errors", 100);
    }

    private void initializeMarkOccurences(IPreferenceStore store) {
        store.setDefault("markOccurrences", true);
        store.setDefault("editor.markOccurencesNumberOfLines", 10000);
        store.setDefault("editor.markOccurencesNumberOfMatches", 1500);
        store.setDefault("editor.markOccurencesNumberOfMatchesPerLine", 100);
        store.setDefault("editor.markOccurencesMatchPartialWords", false);
    }

    private void initializeMiscPreferences(IPreferenceStore store) {
        store.setDefault("last.new.file.template", "default");
        store.setDefault("clear_selection_focus_lost", false);
        store.setDefault("showReadOnlyDecorators", false);
        store.setDefault("readOnlyDecorator", "[RO]");
        store.setDefault("editor_emulation_mode", EditorEmulationMode.ECLIPSE.getName());
        store.setDefault("show.notifications", true);
        store.setDefault("show.inspect.notifications", true);
        store.setDefault("show.breadcrumb.notifications", true);
        store.setDefault("show.automatic.build.notifications", true);
        store.setDefault("show.content.assist.notifications", true);
    }

    private void initializeSyntaxPreferences(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.default.color", (RGB)PrefConst.DEFAULT_COLOR);
        store.setDefault("highlight.default.bold", false);
        store.setDefault("highlight.default.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment.color", (RGB)PrefConst.COMMENT_COLOR);
        store.setDefault("highlight.comment.bold", false);
        store.setDefault("highlight.comment.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.keyword.color", (RGB)PrefConst.KEYWORD_COLOR);
        store.setDefault("highlight.keyword.bold", true);
        store.setDefault("highlight.keyword.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.init.color", (RGB)PrefConst.INIT_COLOR);
        store.setDefault("highlight.init.bold", true);
        store.setDefault("highlight.init.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.irun_collection_keywords.color", (RGB)PrefConst.IRUN_COLLECTION_COLOR);
        store.setDefault("highlight.irun_collection_keywords.bold", true);
        store.setDefault("highlight.irun_collection_keywords.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.non_dvt.color", (RGB)PrefConst.NON_DVT_COLOR);
        store.setDefault("highlight.non_dvt.bold", true);
        store.setDefault("highlight.non_dvt.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.number.color", (RGB)PrefConst.NUMBER_COLOR);
        store.setDefault("highlight.number.bold", false);
        store.setDefault("highlight.number.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.string.color", (RGB)PrefConst.STRING_COLOR);
        store.setDefault("highlight.string.bold", false);
        store.setDefault("highlight.string.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_hyperlink.color", (RGB)PrefConst.COMMENT_HYPERLINK_COLOR);
        store.setDefault("highlight.comment_hyperlink.bold", false);
        store.setDefault("highlight.comment_hyperlink.italic", true);
    }

    private void initializeEditorPreferences(IPreferenceStore store) {
        PrefConst.setDefaultTaskTags();
        PrefConst.migrateTaskTags();
        store.setDefault("tooltipMarkupLanguage", DVTComment.CommentFormat.AUTO.getPreferenceName());
        store.setDefault("Display parameter default value alongside actual value", false);
        store.setDefault("Choose radix for parameter actual value", "Base 16");
        store.setDefault("ro.amiq.dvt.PRESERVE_CLIPBOARD_CONTENT", false);
    }

    private void initializeInspectPreferences(IPreferenceStore store) {
        String lineBackgroundPrefKey = "currentLineColor";
        String lineBackgroundPrefString = EditorsUI.getPreferenceStore().getDefaultString(lineBackgroundPrefKey);
        store.setDefault("inspect.file_info_color", lineBackgroundPrefString);
        store.setDefault("inspect.file_info_enable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inspect.context_color", (RGB)PrefConst.INSPECT_INTEREST_HIGHLIGHT_COLOR_VALUE);
        store.setDefault("inspect.context_enable", true);
        store.setDefault("inspect.diagram_editor_layout", PrefConst.INSPECT_DIAGRAM_EDITOR_LAYOUT_VALUE);
        store.setDefault("inspect.max.file.size", 0x6400000);
    }

    private void initializeThemePreferences(IPreferenceStore store) {
        store.setDefault("syncEditorAndUI", true);
    }

    private void initializeTraceConnectionsPreferences(IPreferenceStore store) {
        store.setDefault("traceconnections.ignoreAlwaysBlocks", false);
        store.setDefault("traceconnections.ignoreNonBlockingAssignments", true);
        store.setDefault("traceconnections.ignoreConcurrentAssignments", false);
        store.setDefault("traceconnections.ignoreProcesses", false);
        store.setDefault("traceconnections.linkWithTraceDiagram", false);
    }

    private void initializeCopyHierarchyPathSegmentSeparatorPreferences(IPreferenceStore store) {
        store.setDefault("copyHierarchyPathSegmentSeparator", ".");
    }

    private void initializeDesignDiagramsPreferences(IPreferenceStore store) {
        store.setDefault("designdiagrams.schematic_show_details_in_always_blocks", false);
        store.setDefault("designdiagrams.fsm_highlight_prev_and_next_states", true);
        store.setDefault("designdiagrams.fsm_direction", PrefConst.FSM_DIAGRAM_DIRECTION_DEFAULT);
        store.setDefault("designdiagrams.fsm_node_placement_strategy", PrefConst.FSM_NODE_PLACEMENT_STRATEGY_DEFAULT);
        store.setDefault("designdiagrams.fsm_enforce_transition_ports", PrefConst.FSM_ENFORCE_TRANSITION_PORTS_DEFAULT);
        store.setDefault("designdiagrams.fsm_enforce_initial_state_layer", PrefConst.FSM_ENFORCE_INITIAL_STATE_LAYER_DEFAULT);
        store.setDefault("designdiagrams.fsm_show_default_state", true);
        store.setDefault("designdiagrams.fsm_loopback_transitions", false);
        store.setDefault("designdiagrams.fms_filter_common_expressions_in_conditions", false);
        store.setDefault("designdiagrams.fsm_show_edge_transition_labels", PrefConst.FSM_SHOW_TRANSITION_LABELS_DEFAULT);
        store.setDefault("designdiagrams.fsm_hide_names_in_conditions", "reset");
        store.setDefault("designdiagrams.fsm_transition_table_disabled", false);
        store.setDefault("designdiagrams.fsm_export_table_format", PrefConst.FSM_EXPORT_TABLE_FORMAT_DEFAULT);
        store.setDefault("designdiagrams.show_power_domain_info", false);
        store.setDefault("designdiagrams.schematic_show_waveform_info", false);
        store.setDefault("designdiagrams.schematic_hide_logic_gates", false);
        store.setDefault("designdiagrams.schematic_show_constants", true);
        store.setDefault("designdiagrams.diagram_port_label_infos", true);
        store.setDefault("designdiagrams.diagram_show_fully_qualified_type", false);
        store.setDefault("designdiagrams.starting_type", PrefConst.DEFAULT_DESIGN_DIAGRAM_VAL);
        store.setDefault("designdiagrams.flow_show_boundary_connections", true);
        store.setDefault("designdiagrams.fsm_show_notifications", true);
    }

    private void initializePerProjectColors(IPreferenceStore store) {
        store.setDefault("perProjectColors", false);
        store.setDefault("perProjectColorsFgBg", "background");
        store.setDefault("custom.colors.for.projects", "");
    }

    private void initializeUMLDiagramsPreferences(IPreferenceStore store) {
        new UMLPreferenceInitializer().init(store);
    }

    private void initializeUMLDiagramConfigPreferences(IPreferenceStore store) {
        store.setDefault("umldiagrams.uml_parents", 1);
        store.setDefault("umldiagrams.uml_children", 1);
        store.setDefault("umldiagrams.uml_associations", 1);
        store.setDefault("umldiagrams.uml_direction", "up");
        store.setDefault("umldiagrams.uml_members", "none");
        store.setDefault("umldiagrams.uml_show_fields", true);
        store.setDefault("umldiagrams.uml_show_events", true);
        store.setDefault("umldiagrams.uml_show_methods", true);
        store.setDefault("umldiagrams.uml_package_information", false);
        store.setDefault("umldiagrams.uml_full_signature", false);
        store.setDefault("umldiagrams.uml_association_labels", true);
        store.setDefault("umldiagrams.uml_group_by_package", false);
        store.setDefault("umldiagrams.uml_orthogonal_routing", false);
        store.setDefault("umldiagrams.architecture_includes", PrefConst.UML_ARCH_INCLUDES_VAL);
        store.setDefault("umldiagrams.architecture_excludes", PrefConst.UML_ARCH_EXCLUDES_VAL);
        store.setDefault("umldiagrams.sequences_includes", PrefConst.UML_SEQ_INCLUDES_VAL);
        store.setDefault("umldiagrams.sequences_excludes", PrefConst.UML_SEQ_EXCLUDES_VAL);
    }

    private void initializeQuickQueryPreferences(IPreferenceStore store) {
        store.setDefault("quickQuery.maxElementsPerCategory", PrefConst.QUICK_QUERY_MAX_ELEMENTS_PER_CATEGORY_VAL.intValue());
    }

    private void initializeAIAssistantPreferences(IPreferenceStore store) {
        store.setDefault("ai.editorInsertUnmodifiedReplyEnable", false);
        store.setDefault("ai.addGeneratedCodeWatermarkEnable", false);
        store.setDefault("ai.insertShowCodeCompletionsInDefaultListEnable", true);
        store.setDefault("ai.clipboardSnippetEnable", true);
        store.setDefault("ai.sendKeyPreference", PrefConst.AIA_SEND_KEY_PREFERENCE_VAL);
    }
}

