/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ai.SendKeyPrefChangeListener;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.floatingwidgets.preferences.ExternalPluginPreferenceCallback;
import ro.amiq.dvt.ui.editor.floatingwidgets.preferences.ReportIssuePreferenceCallback;
import ro.amiq.dvt.ui.preferences.IPreferenceUtilsCommon;
import ro.amiq.dvt.ui.preferences.PreferenceListenerCallback;

public enum PreferenceUtils implements IPreferenceUtilsCommon
{
    INSTANCE;

    private IPreferenceStore preferenceStore;
    private Map<String, String> cachedPreferenceMap;
    private ChangedPreferenceListener changedPreferenceListener;
    private static final Map<String, PreferenceListenerCallback> trackedPreferences;

    static {
        trackedPreferences = new HashMap<String, PreferenceListenerCallback>(2);
        trackedPreferences.put("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE", null);
        trackedPreferences.put("ro.amiq.dvt.REPORT_AN_ISSUE_NOTIFICATION_ENABLED", ReportIssuePreferenceCallback.INSTANCE);
        trackedPreferences.put("ro.amiq.dvt.EXTERNAL_PLUGIN_NOTIFICATION_ENABLED", ExternalPluginPreferenceCallback.INSTANCE);
        trackedPreferences.put("ai.sendKeyPreference", SendKeyPrefChangeListener.INSTANCE);
    }

    public synchronized void init() {
        if (this.preferenceStore == null) {
            this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        }
        if (this.preferenceStore == null) {
            return;
        }
        if (this.cachedPreferenceMap == null) {
            this.cachedPreferenceMap = new HashMap<String, String>(trackedPreferences.keySet().size());
        }
        for (String preference : trackedPreferences.keySet()) {
            if (!this.preferenceStore.contains(preference) || this.cachedPreferenceMap.containsKey(preference)) continue;
            this.cachedPreferenceMap.put(preference, this.preferenceStore.getString(preference));
        }
        if (this.changedPreferenceListener != null) {
            return;
        }
        this.changedPreferenceListener = new ChangedPreferenceListener();
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.changedPreferenceListener);
    }

    private void preferenceCallback(String preference, String oldValue, String newValue) {
        PreferenceListenerCallback preferenceCallback = trackedPreferences.get(preference);
        if (preferenceCallback == null) {
            return;
        }
        preferenceCallback.preferenceChanged(oldValue, newValue);
    }

    @Override
    public String getString(String preferenceName) {
        String value;
        if (preferenceName == null) {
            return "";
        }
        if (this.preferenceStore == null) {
            this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        }
        if (this.preferenceStore == null) {
            return "";
        }
        if (this.cachedPreferenceMap == null) {
            this.init();
            if (this.cachedPreferenceMap == null) {
                return this.preferenceStore.getString(preferenceName);
            }
        }
        if ((value = this.cachedPreferenceMap.get(preferenceName)) == null) {
            this.init();
            value = this.cachedPreferenceMap.get(preferenceName);
            if (value == null) {
                return this.preferenceStore.getString(preferenceName);
            }
        }
        return value;
    }

    @Override
    public boolean getBoolean(String preferenceName) {
        String value;
        if (preferenceName == null) {
            return false;
        }
        if (this.preferenceStore == null) {
            this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        }
        if (this.preferenceStore == null) {
            return false;
        }
        if (this.cachedPreferenceMap == null) {
            this.init();
            if (this.cachedPreferenceMap == null) {
                return this.preferenceStore.getBoolean(preferenceName);
            }
        }
        if ((value = this.cachedPreferenceMap.get(preferenceName)) == null) {
            this.init();
            value = this.cachedPreferenceMap.get(preferenceName);
            if (value == null) {
                return this.preferenceStore.getBoolean(preferenceName);
            }
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public double getDouble(String preferenceName) {
        String value;
        if (preferenceName == null) {
            return 0.0;
        }
        if (this.preferenceStore == null) {
            this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        }
        if (this.preferenceStore == null) {
            return 0.0;
        }
        if (this.cachedPreferenceMap == null) {
            this.init();
            if (this.cachedPreferenceMap == null) {
                return this.preferenceStore.getDouble(preferenceName);
            }
        }
        if ((value = this.cachedPreferenceMap.get(preferenceName)) == null) {
            this.init();
            value = this.cachedPreferenceMap.get(preferenceName);
            if (value == null) {
                return this.preferenceStore.getDouble(preferenceName);
            }
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.logCacheError(preferenceName);
            return this.preferenceStore.getDouble(preferenceName);
        }
    }

    @Override
    public float getFloat(String preferenceName) {
        String value;
        if (preferenceName == null) {
            return 0.0f;
        }
        if (this.preferenceStore == null) {
            this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        }
        if (this.preferenceStore == null) {
            return 0.0f;
        }
        if (this.cachedPreferenceMap == null) {
            this.init();
            if (this.cachedPreferenceMap == null) {
                return this.preferenceStore.getFloat(preferenceName);
            }
        }
        if ((value = this.cachedPreferenceMap.get(preferenceName)) == null) {
            this.init();
            value = this.cachedPreferenceMap.get(preferenceName);
            if (value == null) {
                return this.preferenceStore.getFloat(preferenceName);
            }
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.logCacheError(preferenceName);
            return this.preferenceStore.getFloat(preferenceName);
        }
    }

    @Override
    public int getInt(String preferenceName) {
        String value;
        if (preferenceName == null) {
            return 0;
        }
        if (this.preferenceStore == null) {
            this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        }
        if (this.preferenceStore == null) {
            return 0;
        }
        if (this.cachedPreferenceMap == null) {
            this.init();
            if (this.cachedPreferenceMap == null) {
                return this.preferenceStore.getInt(preferenceName);
            }
        }
        if ((value = this.cachedPreferenceMap.get(preferenceName)) == null) {
            this.init();
            if (value == null) {
                return this.preferenceStore.getInt(preferenceName);
            }
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.logCacheError(preferenceName);
            return this.preferenceStore.getInt(preferenceName);
        }
    }

    @Override
    public long getLong(String preferenceName) {
        String value;
        if (preferenceName == null) {
            return 0L;
        }
        if (this.preferenceStore == null) {
            this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        }
        if (this.preferenceStore == null) {
            return 0L;
        }
        if (this.cachedPreferenceMap == null) {
            this.init();
            if (this.cachedPreferenceMap == null) {
                return this.preferenceStore.getLong(preferenceName);
            }
        }
        if ((value = this.cachedPreferenceMap.get(preferenceName)) == null) {
            this.init();
            value = this.cachedPreferenceMap.get(preferenceName);
            if (value == null) {
                return this.preferenceStore.getLong(preferenceName);
            }
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.logCacheError(preferenceName);
            return this.preferenceStore.getLong(preferenceName);
        }
    }

    private void logCacheError(String preferenceName) {
        DVTLogger.INSTANCE.logError(String.valueOf(preferenceName) + " preference not cached properly! ", (Throwable)new Exception());
    }

    public void dispose() {
        if (this.preferenceStore == null) {
            this.internalDispose();
            return;
        }
        if (this.changedPreferenceListener == null) {
            this.internalDispose();
            return;
        }
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.changedPreferenceListener);
        this.internalDispose();
    }

    private void internalDispose() {
        this.preferenceStore = null;
        this.cachedPreferenceMap = null;
        this.changedPreferenceListener = null;
    }

    class ChangedPreferenceListener
    implements IPropertyChangeListener {
        ChangedPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event == null) {
                return;
            }
            String changedPreference = event.getProperty();
            if (changedPreference == null) {
                return;
            }
            if (PreferenceUtils.this.cachedPreferenceMap == null) {
                PreferenceUtils.this.init();
                if (PreferenceUtils.this.cachedPreferenceMap == null) {
                    return;
                }
            }
            if (!PreferenceUtils.this.cachedPreferenceMap.containsKey(changedPreference)) {
                PreferenceUtils.this.init();
                if (!PreferenceUtils.this.cachedPreferenceMap.containsKey(changedPreference)) {
                    return;
                }
            }
            if (PreferenceUtils.this.preferenceStore == null) {
                PreferenceUtils.this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
            }
            if (PreferenceUtils.this.preferenceStore == null) {
                return;
            }
            String oldValue = PreferenceUtils.this.cachedPreferenceMap.get(changedPreference);
            Object newPrefValue = event.getNewValue();
            if (newPrefValue == null) {
                String defaultValue = PreferenceUtils.this.preferenceStore.getDefaultString(changedPreference);
                PreferenceUtils.this.cachedPreferenceMap.put(changedPreference, defaultValue);
                PreferenceUtils.this.preferenceCallback(changedPreference, oldValue, defaultValue);
                return;
            }
            String newPrefValueString = newPrefValue.toString();
            if (newPrefValueString == null) {
                newPrefValueString = PreferenceUtils.this.preferenceStore.getDefaultString(changedPreference);
            }
            PreferenceUtils.this.cachedPreferenceMap.put(changedPreference, newPrefValueString);
            PreferenceUtils.this.preferenceCallback(changedPreference, oldValue, newPrefValueString);
        }
    }
}

