/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.preferences.language.TablePreferencePage;
import ro.amiq.dvt.ui.preferences.language.TableSymbol;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class TaskTagsPreferencePage
extends TablePreferencePage {
    private boolean fChanged;
    private Text fTaskTagTextControl;
    private Label fTaskTagTextLabel;
    private Combo fTaskTagPriorityControl;
    private Label fTaskTagPriorityLabel;
    private BooleanFieldEditor fCaseFieldEditor;
    private BooleanFieldEditor fHideTagNamesFieldEditor;

    public TaskTagsPreferencePage() {
        this.fColumnNames = new String[2];
        this.fColumnNames[0] = "Tag";
        this.fColumnNames[1] = "Priority";
        this.fColumnWidths = new Integer[2];
        this.fColumnWidths[0] = 200;
        this.fColumnWidths[1] = 80;
        this.fChanged = false;
    }

    @Override
    public void init(IWorkbench workbench) {
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
    }

    @Override
    protected void initGUI() {
        this.updateFromStore();
        this.fTableViewer.setInput((Object)this.fTableSymbols);
    }

    protected void performDefaults() {
        this.updateFromStoreDefaults();
        this.fTableViewer.setInput((Object)this.fTableSymbols);
        this.fCaseFieldEditor.loadDefault();
        this.fHideTagNamesFieldEditor.loadDefault();
    }

    public boolean performOk() {
        this.updateChanged();
        this.updateStore();
        if (this.fCaseFieldEditor.getBooleanValue() != PrefConst.getTaskTagsCaseSensitive()) {
            this.fChanged = true;
        }
        if (this.fHideTagNamesFieldEditor.getBooleanValue() != PrefConst.getHideTaskTags()) {
            this.fChanged = true;
        }
        this.fCaseFieldEditor.store();
        this.fHideTagNamesFieldEditor.store();
        if (this.fChanged) {
            this.askForRebuild();
        }
        return true;
    }

    private void askForRebuild() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] projects = workspace.getRoot().getProjects();
                ArrayList<IProject> candidateProjects = new ArrayList<IProject>();
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject i = iProjectArray[n2];
                    if (i.isAccessible() && DVTNature.hasAnyDVTNatureEnabled(i)) {
                        candidateProjects.add(i);
                    }
                    ++n2;
                }
                if (candidateProjects.isEmpty()) {
                    return;
                }
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Task Tags Changed", null, "You changed the task tags. It is recommended to rebuild projects in order to collect new tasks.", 4, new String[]{"Rebuild Now", "Later"}, 0);
                if (dialog.open() != 0) {
                    return;
                }
                ElementListSelectionDialog selDialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new WorkbenchLabelProvider());
                selDialog.setElements((Object[])candidateProjects.toArray(new IProject[candidateProjects.size()]));
                selDialog.setTitle("Projects to rebuild");
                selDialog.setMessage("Select the projects you want to rebuild.");
                selDialog.setMultipleSelection(true);
                if (selDialog.open() != 0) {
                    return;
                }
                Object[] toRebuild = selDialog.getResult();
                if (toRebuild == null || toRebuild.length == 0) {
                    return;
                }
                Object[] objectArray = toRebuild;
                int n3 = toRebuild.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object project = objectArray[n4];
                    TaskTagsPreferencePage.this.doRebuild((IProject)project);
                    ++n4;
                }
            }
        });
    }

    protected void performApply() {
        this.updateChanged();
    }

    private void updateFromStore() {
        if (this.fTableSymbols == null) {
            this.fTableSymbols = new ArrayList();
        } else {
            this.fTableSymbols.clear();
        }
        String[] taskTags = PrefConst.getTaskTagsNames();
        String[] taskTagsPriorities = PrefConst.getTaskTagsPriorities();
        if (taskTags.length != taskTagsPriorities.length) {
            return;
        }
        int i = 0;
        while (i < taskTags.length) {
            this.fTableSymbols.add(new TableSymbol(taskTags[i], taskTagsPriorities[i]));
            ++i;
        }
    }

    private void updateFromStoreDefaults() {
        if (this.fTableSymbols == null) {
            this.fTableSymbols = new ArrayList();
        } else {
            this.fTableSymbols.clear();
        }
        String[] taskTags = PrefConst.getDefaultTaskTags();
        String[] taskTagsPriorities = PrefConst.getDefaultTaskTagsPriorities();
        if (taskTags.length != taskTagsPriorities.length) {
            return;
        }
        int i = 0;
        while (i < taskTags.length) {
            this.fTableSymbols.add(new TableSymbol(taskTags[i], taskTagsPriorities[i]));
            ++i;
        }
    }

    private void updateStore() {
        if (this.fTableSymbols == null) {
            this.fTableSymbols = new ArrayList();
        }
        String taskTagsString = "";
        String taskTagsPrioritiesString = "";
        for (TableSymbol taskTag : this.fTableSymbols) {
            taskTagsString = String.valueOf(taskTagsString) + ";" + taskTag.getColumnText(0);
            taskTagsPrioritiesString = String.valueOf(taskTagsPrioritiesString) + ";" + taskTag.getColumnText(1);
        }
        taskTagsString = taskTagsString.replaceFirst(";", "");
        taskTagsPrioritiesString = taskTagsPrioritiesString.replaceFirst(";", "");
        this.getPreferenceStore().setValue("taskTags", taskTagsString);
        this.getPreferenceStore().setValue("taskTagsPriorities", taskTagsPrioritiesString);
    }

    private void updateChanged() {
        if (this.fTableSymbols == null) {
            this.fTableSymbols = new ArrayList();
        }
        this.fChanged = false;
        String[] taskTags = PrefConst.getTaskTagsNames();
        String[] taskTagsPriorities = PrefConst.getTaskTagsPriorities();
        if (taskTags.length != this.fTableSymbols.size()) {
            this.fChanged = true;
        } else {
            int i = 0;
            while (i < taskTags.length) {
                if (!taskTags[i].equals(((TableSymbol)this.fTableSymbols.get(i)).getColumnText(0)) || !taskTagsPriorities[i].equals(((TableSymbol)this.fTableSymbols.get(i)).getColumnText(1))) {
                    this.fChanged = true;
                }
                ++i;
            }
        }
    }

    @Override
    protected void createControls(Composite parent, final TablePreferencePage.SymbolDialog symbolDialog) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.numColumns = 2;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fTaskTagTextLabel = new Label(composite, 0);
        this.fTaskTagTextLabel.setText("Tag: ");
        this.fTaskTagTextLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fTaskTagTextControl = new Text(composite, 2048);
        this.fTaskTagTextControl.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fTaskTagTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!(e.widget instanceof Text)) {
                    return;
                }
                String text = ((Text)e.widget).getText().trim();
                boolean isValidText = TaskTagsPreferencePage.this.isValidText(text);
                if (!isValidText) {
                    this.setErrorMessageForInvalidText(text);
                } else {
                    symbolDialog.setMessage("");
                }
                if (symbolDialog.getOkButton() == null) {
                    return;
                }
                symbolDialog.getOkButton().setEnabled(isValidText);
            }

            private void setErrorMessageForInvalidText(String text) {
                if (text.isEmpty()) {
                    symbolDialog.setMessage("Task tag cannot be an empty field.", 3);
                    return;
                }
                if (!TaskTagsPreferencePage.this.isAlphanum(text)) {
                    symbolDialog.setMessage("Task tag should be an alphanumeric string.", 3);
                    return;
                }
                if (TaskTagsPreferencePage.this.isDuplicate(text)) {
                    symbolDialog.setMessage("Task tag already in use.", 3);
                    return;
                }
            }
        });
        this.fTaskTagPriorityLabel = new Label(composite, 64);
        this.fTaskTagPriorityLabel.setText("Priority: ");
        this.fTaskTagPriorityLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        this.fTaskTagPriorityControl = new Combo(composite, 2056);
        this.fTaskTagPriorityControl.setItems(PrefConst.TASK_PRIORITIES);
        this.fTaskTagPriorityControl.select(0);
        this.fTaskTagPriorityControl.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.applyDialogFont(composite);
    }

    private boolean isValidText(String text) {
        return this.isAlphanum(text) && !this.isDuplicate(text);
    }

    private boolean isAlphanum(String text) {
        return text.matches("\\w+");
    }

    @Override
    protected void buttonsCreated(TablePreferencePage.SymbolDialog symbolDialog) {
        symbolDialog.getOkButton().setEnabled(this.isValidText(this.fTaskTagTextControl.getText()));
    }

    @Override
    protected void initializeControls(TableSymbol symbol) {
        this.fTaskTagTextControl.setText(symbol.getColumnText(0));
        this.fTaskTagPriorityControl.select(PrefConst.getTaskTagPriorityIndex(symbol.getColumnText(1)));
    }

    @Override
    protected TableSymbol getSymbol() {
        String text = this.fTaskTagTextControl.getText().trim();
        int selectedPriorityIndex = this.fTaskTagPriorityControl.getSelectionIndex();
        if (text.equals("")) {
            return null;
        }
        if (selectedPriorityIndex < 0 || selectedPriorityIndex > PrefConst.TASK_PRIORITIES.length - 1) {
            return null;
        }
        if (this.isDuplicate(text)) {
            return null;
        }
        return new TableSymbol(text, PrefConst.TASK_PRIORITIES[selectedPriorityIndex]);
    }

    private boolean isDuplicate(String text) {
        if (text.isEmpty()) {
            return false;
        }
        for (TableSymbol symbol : this.fTableSymbols) {
            if (!text.equals(symbol.getColumnText(0))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void createCustomContents(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fCaseFieldEditor = new BooleanFieldEditor("taskTagsCase", "Case sensitive", composite);
        this.fCaseFieldEditor.setPreferenceStore(this.getPreferenceStore());
        this.fCaseFieldEditor.load();
        this.fHideTagNamesFieldEditor = new BooleanFieldEditor("taskTagsHide", "Hide tag name in tasks view", composite);
        this.fHideTagNamesFieldEditor.setPreferenceStore(this.getPreferenceStore());
        this.fHideTagNamesFieldEditor.load();
    }

    @Override
    protected String getSymbolDialogTitle() {
        return "Task Tag";
    }

    private void doRebuild(IProject project) {
        DVTBuildUtils.runInternalBuilder(project);
    }
}

