/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences.language;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.ui.preferences.language.TableSymbol;

public abstract class TablePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected TableViewer fTableViewer;
    protected ArrayList<TableSymbol> fTableSymbols;
    protected String[] fColumnNames;
    protected Integer[] fColumnWidths;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.fTableViewer = this.createTableViewer(composite);
        this.fTableViewer.setSorter(new ViewerSorter());
        this.fTableViewer.getControl().setFont(JFaceResources.getDialogFont());
        GridData gd = new GridData(1808);
        this.fTableViewer.getControl().setLayoutData((Object)gd);
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setText("Add...");
        addButton.setFont(parent.getFont());
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                new SymbolDialog(TablePreferencePage.this.getShell()).open();
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setEnabled(false);
        removeButton.setText("Remove");
        removeButton.setFont(parent.getFont());
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TablePreferencePage.this.fTableViewer.getSelection();
                if (selection.size() < 1) {
                    return;
                }
                for (TableSymbol symbol : selection) {
                    ArrayList input = (ArrayList)TablePreferencePage.this.fTableViewer.getInput();
                    input.remove(symbol);
                    TablePreferencePage.this.refreshViewer();
                }
            }
        });
        final Button editButton = new Button(buttonComposite, 8);
        editButton.setEnabled(false);
        editButton.setText("Edit...");
        editButton.setFont(parent.getFont());
        editButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TablePreferencePage.this.fTableViewer.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                TableSymbol symbol = (TableSymbol)selection.getFirstElement();
                new SymbolDialog(TablePreferencePage.this.getShell(), symbol).open();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TablePreferencePage.this.fTableViewer.getSelection();
                if (selection.size() < 1) {
                    removeButton.setEnabled(false);
                    editButton.setEnabled(false);
                } else {
                    removeButton.setEnabled(true);
                    editButton.setEnabled(true);
                }
            }
        });
        Composite customComposite = new Composite(composite, 0);
        this.createCustomContents(customComposite);
        this.initGUI();
        return composite;
    }

    protected TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 2052);
        viewer.setLabelProvider((IBaseLabelProvider)new TableViewerLabelProvider());
        viewer.setContentProvider((IContentProvider)new TableViewerContentProvider());
        viewer.getTable().setHeaderVisible(true);
        int i = 0;
        while (i < this.fColumnNames.length) {
            TableColumn col = new TableColumn(viewer.getTable(), 16384, i);
            col.setText(this.fColumnNames[i]);
            if (this.fColumnWidths != null) {
                col.setWidth(this.fColumnWidths[i].intValue());
            } else {
                col.setWidth(100);
            }
            ++i;
        }
        return viewer;
    }

    private void refreshViewer() {
        if (this.fTableSymbols != null) {
            Collections.sort(this.fTableSymbols);
        }
        this.fTableViewer.refresh();
    }

    public void init(IWorkbench workbench) {
    }

    protected abstract void initGUI();

    protected abstract void createControls(Composite var1, SymbolDialog var2);

    protected abstract void initializeControls(TableSymbol var1);

    protected abstract TableSymbol getSymbol();

    protected abstract void createCustomContents(Composite var1);

    protected abstract String getSymbolDialogTitle();

    protected abstract void buttonsCreated(SymbolDialog var1);

    public class SymbolDialog
    extends TitleAreaDialog {
        private boolean fEditing;
        private TableSymbol fSymbol;
        private String fTitlePrepend;

        public SymbolDialog(Shell parent, TableSymbol symbol) {
            super(parent);
            this.fSymbol = symbol;
            this.fEditing = true;
            this.fTitlePrepend = "Edit ";
            this.setHelpAvailable(false);
        }

        public SymbolDialog(Shell parent) {
            super(parent);
            this.fTitlePrepend = "New ";
            this.setHelpAvailable(false);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(String.valueOf(this.fTitlePrepend) + TablePreferencePage.this.getSymbolDialogTitle());
        }

        public void create() {
            super.create();
            if (!this.fEditing) {
                this.setMessage("Task tag cannot be an empty field.", 3);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            TablePreferencePage.this.createControls(composite, this);
            if (this.fEditing) {
                TablePreferencePage.this.initializeControls(this.fSymbol);
                TablePreferencePage.this.fTableSymbols.remove(this.fSymbol);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            TablePreferencePage.this.buttonsCreated(this);
        }

        protected void okPressed() {
            TableSymbol newSymbol = TablePreferencePage.this.getSymbol();
            if (newSymbol != null) {
                TablePreferencePage.this.fTableSymbols.add(newSymbol);
                TablePreferencePage.this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newSymbol), true);
            }
            TablePreferencePage.this.refreshViewer();
            super.okPressed();
        }

        protected void cancelPressed() {
            if (this.fEditing) {
                TablePreferencePage.this.fTableSymbols.add(this.fSymbol);
            }
            super.cancelPressed();
        }

        public Control getOkButton() {
            return this.getButton(0);
        }
    }

    public class TableViewerContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
            if (TablePreferencePage.this.fTableSymbols != null) {
                TablePreferencePage.this.fTableSymbols = null;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            TablePreferencePage.this.fTableSymbols = (ArrayList)newInput;
            TablePreferencePage.this.refreshViewer();
        }

        public Object[] getElements(Object inputElement) {
            if (TablePreferencePage.this.fTableSymbols == null) {
                return new TableSymbol[0];
            }
            return TablePreferencePage.this.fTableSymbols.toArray();
        }
    }

    static class TableViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableViewerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((TableSymbol)element).getColumnText(columnIndex);
        }
    }
}

