/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences.language;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.ui.preferences.language.TreeSymbol;

public abstract class TreePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Text fNewEntryText;
    protected TreeViewer fTreeViewer;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 1;
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        parentLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)parentLayout);
        Label label = new Label(composite, 0);
        label.setFont(parent.getFont());
        this.createTreeAreaContents(composite);
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 2;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData(770);
        buttonComposite.setLayoutData((Object)data);
        final Button addButton = new Button(buttonComposite, 0x1000008);
        addButton.setEnabled(false);
        addButton.setText("Add to List");
        addButton.setFont(parent.getFont());
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TreePreferencePage.this.fTreeViewer.getSelection();
                if (selection.size() < 1) {
                    return;
                }
                for (TreeSymbol parent : selection) {
                    while (parent != null && !parent.getParent().getText().equals("root")) {
                        parent = parent.getParent();
                    }
                    if (parent == null) {
                        return;
                    }
                    String text = TreePreferencePage.this.fNewEntryText.getText().trim();
                    if (text.length() == 0) {
                        return;
                    }
                    TreeSymbol child = new TreeSymbol(text);
                    if (!parent.add(child)) continue;
                    TreePreferencePage.this.fTreeViewer.refresh();
                    TreePreferencePage.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)child), true);
                    TreePreferencePage.this.fTreeViewer.refresh();
                    TreePreferencePage.this.fNewEntryText.setText("");
                }
            }
        });
        this.fNewEntryText = new Text(buttonComposite, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.fNewEntryText.setLayoutData((Object)data);
        this.fNewEntryText.setFont(parent.getFont());
        final Button removeButton = new Button(buttonComposite, 0x1000008);
        removeButton.setEnabled(false);
        removeButton.setText("Remove Selection");
        removeButton.setFont(parent.getFont());
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TreePreferencePage.this.fTreeViewer.getSelection();
                if (selection.size() < 1) {
                    return;
                }
                for (TreeSymbol symbol : selection) {
                    if (symbol.hasChildren()) {
                        return;
                    }
                    TreeSymbol parent = symbol.getParent();
                    parent.remove(symbol);
                    TreePreferencePage.this.fTreeViewer.refresh();
                    TreePreferencePage.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)parent), true);
                    TreePreferencePage.this.fTreeViewer.refresh();
                }
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                addButton.setEnabled(false);
                removeButton.setEnabled(false);
                IStructuredSelection selection = (IStructuredSelection)TreePreferencePage.this.fTreeViewer.getSelection();
                if (selection.size() < 1) {
                    return;
                }
                for (TreeSymbol symbol : selection) {
                    TreeSymbol parent = symbol.getParent();
                    if (parent == null) continue;
                    if (parent.getText().equals("root")) {
                        addButton.setEnabled(true);
                        continue;
                    }
                    if (parent.getParent() == null || !parent.getParent().getText().equals("root")) continue;
                    addButton.setEnabled(true);
                    removeButton.setEnabled(true);
                }
            }
        });
        data = new GridData();
        data.horizontalSpan = 2;
        removeButton.setLayoutData((Object)data);
        this.initGUI();
        return composite;
    }

    protected Control createTreeAreaContents(Composite parent) {
        this.fTreeViewer = this.createTreeViewer(parent);
        this.fTreeViewer.setSorter(new ViewerSorter());
        this.updateTreeFont(JFaceResources.getDialogFont());
        this.layoutTreeAreaControl(this.fTreeViewer.getControl());
        return this.fTreeViewer.getControl();
    }

    protected void layoutTreeAreaControl(Control control) {
        GridData gd = new GridData(1808);
        gd.verticalSpan = 1;
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void updateTreeFont(Font dialogFont) {
        this.fTreeViewer.getControl().setFont(dialogFont);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2052);
        viewer.setLabelProvider((IBaseLabelProvider)new TreeViewerLabelProvider());
        viewer.setContentProvider((IContentProvider)new TreeViewerContentProvider());
        return viewer;
    }

    public void init(IWorkbench workbench) {
    }

    protected abstract void initGUI();

    protected abstract void performDefaults();

    public abstract boolean performOk();

    public static class TreeViewerContentProvider
    implements ITreeContentProvider {
        private TreeSymbol fNode;

        public Object[] getChildren(Object parentElement) {
            TreeSymbol os = (TreeSymbol)parentElement;
            return os.getChildren();
        }

        public Object getParent(Object element) {
            TreeSymbol os = (TreeSymbol)element;
            return os.getParent();
        }

        public boolean hasChildren(Object element) {
            TreeSymbol os = (TreeSymbol)element;
            return os.hasChildren();
        }

        public TreeSymbol[] getElements(Object inputElement) {
            if (inputElement == null) {
                return null;
            }
            TreeSymbol adapter = (TreeSymbol)inputElement;
            return adapter.getChildren();
        }

        public void dispose() {
            if (this.fNode != null) {
                this.fNode = null;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fNode = (TreeSymbol)newInput;
        }

        public TreeSymbol getRoot() {
            return this.fNode;
        }
    }

    static class TreeViewerLabelProvider
    extends LabelProvider {
        TreeViewerLabelProvider() {
        }

        public String getText(Object element) {
            TreeSymbol os = (TreeSymbol)element;
            return os.fText;
        }
    }
}

