/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences.theme;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeSection;

public class DVTTheme {
    public static final String THEME_EXTENSION = ".dvttheme";
    private static final String DEFAULT_THEME_NAME = "default";
    private static final String THEME_DIRECTORY = "themes";
    private static final Pattern SECTION_PATTERN = Pattern.compile("\\[\\s*(.*)\\s*\\|\\s*(.*)\\s*\\]");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("(.*)\\s*=\\s*(.*)");
    private final String fName;
    private final LinkedList<DVTThemeSection> fSections;

    private DVTTheme(String name) {
        this.fName = name;
        this.fSections = new LinkedList();
    }

    private DVTTheme(URL url) throws IOException {
        this(DVTTheme.nameFromURL(url));
        this.readFromURL(url);
    }

    private void readFromURL(URL url) throws IOException {
        DVTThemeSection currentSection = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                String value;
                String key;
                Matcher matcher;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                if (line.charAt(0) == '[') {
                    String prefix;
                    matcher = SECTION_PATTERN.matcher(line);
                    if (!matcher.matches() || (prefix = matcher.group(2)) == null || prefix.trim().isEmpty()) continue;
                    String name = matcher.group(1);
                    if (name == null || name.trim().isEmpty()) {
                        name = "Unnamed Settings";
                    }
                    currentSection = DVTThemeSection.createSection(name.trim(), prefix.trim(), this.fName.equals(DEFAULT_THEME_NAME));
                    this.fSections.add(currentSection);
                    continue;
                }
                if (currentSection == null || !(matcher = PROPERTY_PATTERN.matcher(line)).matches() || (key = matcher.group(1)) == null || key.trim().isEmpty() || (value = matcher.group(2)) == null) continue;
                currentSection.put(key, value);
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    br = null;
                }
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                br = null;
            }
        }
    }

    public String getName() {
        return this.fName;
    }

    public List<DVTThemeSection> getSections() {
        return Collections.unmodifiableList(this.fSections);
    }

    public void apply(List<DVTThemeSection> sections) {
        for (DVTThemeSection section : sections) {
            if (section == null || !this.fSections.contains(section)) continue;
            section.apply();
        }
    }

    private static String nameFromURL(URL url) {
        return new File(url.getPath()).getName().replace(THEME_EXTENSION, "");
    }

    public static Map<String, DVTTheme> createBundleThemes() {
        Enumeration themesEnum = DVTPlugin.getDefault().getBundle().findEntries(THEME_DIRECTORY, "*.dvttheme", true);
        LinkedHashMap<String, DVTTheme> themes = new LinkedHashMap<String, DVTTheme>();
        while (themesEnum.hasMoreElements()) {
            Object element = themesEnum.nextElement();
            if (element == null || !(element instanceof URL)) continue;
            DVTTheme theme = null;
            try {
                if (DEFAULT_THEME_NAME.equals(DVTTheme.nameFromURL((URL)element))) continue;
                theme = new DVTTheme((URL)element);
                themes.put(theme.getName(), theme);
            }
            catch (IOException iOException) {}
        }
        return themes;
    }

    public static DVTTheme createTheme(URL url) throws IOException {
        return new DVTTheme(url);
    }

    public static DVTTheme createDefaultTheme() {
        URL themeURL = DVTPlugin.getDefault().getBundle().getEntry("themes/default.dvttheme");
        DVTTheme theme = null;
        if (themeURL != null) {
            try {
                theme = new DVTTheme(themeURL);
            }
            catch (IOException iOException) {}
        }
        if (theme == null) {
            theme = DVTTheme.createInternalDefaultTheme();
        }
        return theme;
    }

    public static DVTTheme createInternalDefaultTheme() {
        DVTTheme theme = new DVTTheme(DEFAULT_THEME_NAME);
        return theme;
    }
}

