/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences.theme;

import com.github.eclipsecolortheme.Activator;
import com.github.eclipsecolortheme.Color;
import com.github.eclipsecolortheme.ColorTheme;
import com.github.eclipsecolortheme.ColorThemeManager;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.RestartRequiredDialog;
import ro.amiq.dvt.ui.actions.editor.fonts.FontUtils;
import ro.amiq.dvt.ui.preferences.OverlayPreferenceStore;
import ro.amiq.dvt.ui.preferences.theme.DVTTheme;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.ui.preferences.theme.IThemePreviewContributor;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTThemePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final boolean IS_LINUX = "linux".equals(Platform.getOS());
    private static final int GTK_VERSION = DVTThemeUtils.getGTKVersion();
    private static final String DEFAULT_THEMENAME = "Default";
    private static final String ORG_ECLIPSE_UI_EDITORS_ID = "org.eclipse.ui.editors";
    private static final String ORG_ECLIPSE_TM_TERMINAL_CONTROL_ID = "org.eclipse.tm.terminal.control";
    private static final String ORG_ECLIPSE_UI_WORKBECNH_ID = "org.eclipse.ui.workbench";
    private static final String TERMINAL_INVERT_COLORS_PREF_KEY = "TerminalPrefInvertColors";
    private static final String DVT_THEME_PREVIEW_CONTRIBUTOR_EXTENSION_POINT_ID = "ro.amiq.dvt.themePreviewContributor";
    private static final String DVT_THEME_PREVIEW_CONTRIBUTOR_ELEMENT = "themePreviewContributor";
    private static final String LIGHT_UI = "Light";
    private static final String DARK_UI = "Dark";
    private static final String GTK2_LIGHT_THEME = "";
    private static final String GTK2_DARK_THEME = "base[ACTIVE]=\"#4d4d4d\" base[INSENSITIVE]=\"#4d4d4d\" base[NORMAL]=\"#293134\" base[PRELIGHT]=\"#e0e2e4\" base[SELECTED]=\"#bfbfbf\" bg[ACTIVE]=\"#7f7f7f\" bg[INSENSITIVE]=\"#3d3d3d\" bg[NORMAL]=\"#4d4d4d\" bg[PRELIGHT]=\"#7f7f7f\" bg[SELECTED]=\"#7f7f7f\" fg[ACTIVE]=\"#e0e2e4\" fg[INSENSITIVE]=\"#e0e2e4\" fg[NORMAL]=\"#e0e2e4\" fg[PRELIGHT]=\"#e5e5e5\" fg[SELECTED]=\"#4d4d4d\" text[ACTIVE]=\"#bfbfbf\" text[INSENSITIVE]=\"#bfbfbf\" text[NORMAL]=\"#e0e2e4\" text[PRELIGHT]=\"#4d4d4d\" text[SELECTED]=\"#293134\"  ";
    private Composite container;
    private Button uiThemeSyncCheckbox;
    private List themeSelectionList;
    private Combo uiThemeCombo;
    private ColorThemeManager colorThemeManager = new ColorThemeManager();
    private String selectedThemeName;
    private Map<String, String> initialEclipseValues = new HashMap<String, String>();
    private ArrayList<IThemePreviewContributor> contributors;
    private FontSelector uiFontSelector = new FontSelector();
    private FontSelector editorFontSelector = new FontSelector();
    private ThemeModel originalTheme;

    public DVTThemePreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.container);
        GridDataFactory.fillDefaults().applyTo((Control)this.container);
        this.createUIThemeGroup();
        this.createEditorThemeGroup();
        this.createFontGroup();
        this.copyInitialEclipseSettings();
        this.updatePreviewers();
        this.originalTheme = this.getThemeModel();
        return this.container;
    }

    private void createUIThemeGroup() {
        Group uiThemeGroup = new Group(this.container, 0);
        uiThemeGroup.setText("UI Theme");
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)uiThemeGroup);
        GridDataFactory.fillDefaults().applyTo((Control)uiThemeGroup);
        Composite uiThemeComposite = new Composite((Composite)uiThemeGroup, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(uiThemeComposite);
        GridDataFactory.fillDefaults().applyTo((Control)uiThemeComposite);
        Label uiThemeLabel = new Label(uiThemeComposite, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)uiThemeLabel);
        uiThemeLabel.setText("Theme");
        this.uiThemeCombo = new Combo(uiThemeComposite, 12);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.uiThemeCombo);
        this.uiThemeCombo.add(LIGHT_UI);
        this.uiThemeCombo.add(DARK_UI);
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("syncEditorAndUI")) {
            this.uiThemeCombo.setEnabled(false);
        }
        this.uiThemeSyncCheckbox = new Button((Composite)uiThemeGroup, 32);
        GridDataFactory.fillDefaults().applyTo((Control)this.uiThemeSyncCheckbox);
        this.uiThemeSyncCheckbox.setText("Synchronize UI theme color with editor background");
        this.uiThemeSyncCheckbox.setSelection(DVTPlugin.getDefault().getPreferenceStore().getBoolean("syncEditorAndUI"));
        this.uiThemeSyncCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DVTThemePreferencePage.this.uiThemeSyncCheckbox.getSelection()) {
                    DVTThemePreferencePage.this.uiThemeCombo.setEnabled(false);
                    DVTThemePreferencePage.this.updateUIThemeCombo(DVTThemePreferencePage.this.isDarkEditor());
                } else {
                    DVTThemePreferencePage.this.uiThemeCombo.setEnabled(true);
                    DVTThemePreferencePage.this.updateUIThemeCombo(DVTThemePreferencePage.this.isDarkUI());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private boolean isDarkUI() {
        return DVTThemeUtils.isDarkUI();
    }

    private boolean isDarkEditor() {
        Color backgroundColor = this.colorThemeManager.getThemeBackground(this.selectedThemeName);
        return backgroundColor == null ? false : backgroundColor.isDarkColor();
    }

    private void createEditorThemeGroup() {
        Group editorThemeGroup = new Group(this.container, 0);
        editorThemeGroup.setText("Editor Theme");
        GridDataFactory.fillDefaults().applyTo((Control)editorThemeGroup);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)editorThemeGroup);
        this.createThemeSelectionList((Composite)editorThemeGroup);
        this.createThemePreviewer((Composite)editorThemeGroup);
    }

    private void createThemeSelectionList(Composite parent) {
        this.themeSelectionList = new List(parent, 2560);
        GridDataFactory.fillDefaults().hint(300, 600).applyTo((Control)this.themeSelectionList);
        this.fillThemeSelectionList();
        this.themeSelectionList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DVTThemePreferencePage.this.selectedThemeName = DVTThemePreferencePage.this.themeSelectionList.getSelection()[0];
                if (DVTThemePreferencePage.this.uiThemeSyncCheckbox.getSelection()) {
                    DVTThemePreferencePage.this.updateUIThemeCombo(DVTThemePreferencePage.this.isDarkEditor());
                }
                DVTThemePreferencePage.this.updatePreviewers();
            }
        });
        String activeThemeName = this.getPreferenceStore().getString("colorTheme");
        if (this.colorThemeManager.getTheme(activeThemeName) == null) {
            activeThemeName = DEFAULT_THEMENAME;
        }
        this.themeSelectionList.setSelection(new String[]{activeThemeName});
        this.selectedThemeName = activeThemeName;
        if (this.uiThemeSyncCheckbox.getSelection()) {
            this.updateUIThemeCombo(this.isDarkEditor());
        } else {
            this.updateUIThemeCombo(this.isDarkUI());
        }
    }

    private void fillThemeSelectionList() {
        Set themes = this.colorThemeManager.getThemes();
        LinkedList<String> themeNames = new LinkedList<String>();
        for (ColorTheme theme : themes) {
            themeNames.add(theme.getName());
        }
        Collections.sort(themeNames, String.CASE_INSENSITIVE_ORDER);
        themeNames.add(0, DEFAULT_THEMENAME);
        this.themeSelectionList.setItems(themeNames.toArray(new String[themeNames.size()]));
    }

    private void createThemePreviewer(Composite parent) {
        CTabFolder previewComposite = new CTabFolder(parent, 128);
        GridDataFactory.fillDefaults().hint(-1, 600).applyTo((Control)previewComposite);
        ArrayList<IThemePreviewContributor> previewContributors = this.getThemePreviewContributors();
        for (IThemePreviewContributor contributor : previewContributors) {
            Control languagePreviewer = contributor.createLanguagePreviewer((Composite)previewComposite);
            CTabItem tabItem = new CTabItem(previewComposite, 0);
            tabItem.setControl(languagePreviewer);
            tabItem.setText(contributor.getLanguage());
        }
        previewComposite.setSelection(0);
        previewComposite.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTThemePreferencePage.this.updatePreviewers();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createFontGroup() {
        String editorInitialText;
        FontData editorInitialFont;
        Group fontGroup = new Group(this.container, 0);
        fontGroup.setText("Fonts");
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)fontGroup);
        GridDataFactory.fillDefaults().applyTo((Control)fontGroup);
        FontData uiInitialFont = DVTThemeUtils.getGTKFont();
        String uiInitalText = "DEFAULT";
        if (uiInitialFont != null) {
            this.uiFontSelector.font = new Font((Device)Display.getDefault(), uiInitialFont);
            FontData uiInitialFontData = this.uiFontSelector.font.getFontData()[0];
            uiInitalText = String.valueOf(uiInitialFontData.getName()) + " " + uiInitialFontData.getHeight();
        }
        if ((editorInitialFont = FontUtils.getFont()) == null) {
            editorInitialText = "CUSTOM";
        } else if (editorInitialFont.getName().isEmpty()) {
            editorInitialText = "DEFAULT";
        } else {
            this.editorFontSelector.font = new Font((Device)Display.getDefault(), editorInitialFont);
            FontData editorInitialFontData = this.editorFontSelector.font.getFontData()[0];
            editorInitialText = String.valueOf(editorInitialFontData.getName()) + " " + editorInitialFontData.getHeight();
        }
        if (IS_LINUX && EclipseUtils.isAtMostEclipse47()) {
            this.createFontSelector(fontGroup, this.uiFontSelector, "UI font: ", uiInitalText);
        }
        this.createFontSelector(fontGroup, this.editorFontSelector, "Editor font: ", editorInitialText);
    }

    private void createFontSelector(Group fontGroup, FontSelector fontSelector, String label, String initialText) {
        fontSelector.label = new Label((Composite)fontGroup, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)fontSelector.label);
        fontSelector.label.setText(label);
        fontSelector.text = new Text((Composite)fontGroup, 2048);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(400, -1).applyTo((Control)fontSelector.text);
        fontSelector.text.setEditable(false);
        fontSelector.text.setText(initialText);
        final Button editFontButton = new Button((Composite)fontGroup, 8);
        editFontButton.setText("Select...");
        editFontButton.addSelectionListener(new SelectionListener(){
            private FontSelector fontSelector;

            public void widgetSelected(SelectionEvent e) {
                FontData fontData;
                FontDialog fontDialog = new FontDialog(editFontButton.getShell());
                if (this.fontSelector.font != null) {
                    fontDialog.setFontList(this.fontSelector.font.getFontData());
                }
                if ((fontData = fontDialog.open()) != null) {
                    fontData.setStyle(0);
                    this.fontSelector.text.setText(String.valueOf(fontData.getName()) + " " + fontData.getHeight());
                    if (this.fontSelector.font != null && !this.fontSelector.font.isDisposed()) {
                        this.fontSelector.font.dispose();
                    }
                    if (this.fontSelector.exampleDisplayFont != null && !this.fontSelector.exampleDisplayFont.isDisposed()) {
                        this.fontSelector.exampleDisplayFont.dispose();
                    }
                    this.fontSelector.font = new Font((Device)Display.getDefault(), fontData);
                    fontData.setHeight(10);
                    this.fontSelector.exampleDisplayFont = new Font((Device)Display.getDefault(), fontData);
                    this.fontSelector.text.setFont(this.fontSelector.exampleDisplayFont);
                    DVTThemePreferencePage.this.container.layout(true, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            private SelectionListener init(FontSelector fontSelector) {
                this.fontSelector = fontSelector;
                return this;
            }
        }.init(fontSelector));
    }

    public boolean performOk() {
        DVTPlugin.getDefault().getPreferenceStore().setValue("syncEditorAndUI", this.uiThemeSyncCheckbox.getSelection());
        ThemeModel currentTheme = this.getThemeModel();
        if (this.originalTheme.equals(currentTheme)) {
            return true;
        }
        if (!currentTheme.uiTheme.equals(this.originalTheme.uiTheme)) {
            this.customizePreferences(currentTheme.uiTheme.equals(DARK_UI));
        }
        if (IS_LINUX) {
            String uiFont = GTK2_LIGHT_THEME;
            if (currentTheme.uiFont != null) {
                uiFont = String.valueOf(uiFont) + "font_name = \"" + currentTheme.uiFont.getName() + " " + currentTheme.uiFont.getHeight() + "\"  ";
            }
            String gtk2ThemeContent = GTK2_LIGHT_THEME;
            if (EclipseUtils.isAtMostEclipse47() && GTK_VERSION == 3) {
                this.setEclipseTheme(currentTheme.uiTheme.equals(DARK_UI));
            } else {
                gtk2ThemeContent = currentTheme.uiTheme.equals(DARK_UI) ? GTK2_DARK_THEME : GTK2_LIGHT_THEME;
                this.setEclipseTheme(false);
            }
            gtk2ThemeContent = String.valueOf(gtk2ThemeContent) + uiFont;
            if (currentTheme.uiFont != null && !currentTheme.uiFont.equals((Object)this.originalTheme.uiFont) || !currentTheme.uiTheme.equals(this.originalTheme.uiTheme)) {
                try {
                    DVTThemeUtils.writeThemeGTKRCFile(gtk2ThemeContent);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        } else {
            this.setEclipseTheme(currentTheme.uiTheme.equals(DARK_UI));
        }
        if (currentTheme.editorFont != null && !currentTheme.editorFont.equals((Object)this.originalTheme.editorFont)) {
            FontUtils.setFont(this.editorFontSelector.font.getFontData()[0]);
        }
        if (!currentTheme.editorTheme.equals(this.originalTheme.editorTheme)) {
            this.getPreferenceStore().setValue("colorTheme", this.selectedThemeName);
            this.colorThemeManager.applyTheme(this.selectedThemeName);
        }
        this.popRestartDialog();
        return true;
    }

    protected void performDefaults() {
        this.getPreferenceStore().setToDefault("colorTheme");
        DVTPlugin.getDefault().getPreferenceStore().setToDefault("syncEditorAndUI");
        if (IS_LINUX) {
            try {
                DVTThemeUtils.writeThemeGTKRCFile(GTK2_LIGHT_THEME);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        this.customizePreferences(false);
        this.setEclipseTheme(false);
        FontUtils.setFont(null);
        this.colorThemeManager.clearImportedThemes();
        this.reloadThemeSelectionList();
        this.colorThemeManager.applyTheme(DEFAULT_THEMENAME);
        this.popRestartDialog();
    }

    private void customizePreferences(boolean isDarkUI) {
        ScopedPreferenceStore terminalPreference = new ScopedPreferenceStore(InstanceScope.INSTANCE, ORG_ECLIPSE_TM_TERMINAL_CONTROL_ID);
        ScopedPreferenceStore workbenchPreference = new ScopedPreferenceStore(InstanceScope.INSTANCE, ORG_ECLIPSE_UI_WORKBECNH_ID);
        ScopedPreferenceStore vlogPreference = new ScopedPreferenceStore(InstanceScope.INSTANCE, "ro.amiq.vlogdt");
        ScopedPreferenceStore edtPreference = new ScopedPreferenceStore(InstanceScope.INSTANCE, "ro.amiq.edt");
        if (isDarkUI) {
            DVTPlugin.getDefault().getPreferenceStore().setValue("diagram.invert_colors", true);
            terminalPreference.setValue(TERMINAL_INVERT_COLORS_PREF_KEY, "true");
            workbenchPreference.setValue("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END", "77,77,77");
            workbenchPreference.setValue("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START", "127,127,127");
            workbenchPreference.setValue("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR", "255,255,255");
            workbenchPreference.setValue("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR", "127,127,127");
            workbenchPreference.setValue("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor", "77,77,77");
            workbenchPreference.setValue("ro.amiq.dvt.ui.filter.foregroundColor", "224,226,228");
            workbenchPreference.setValue("ro.amiq.dvt.ui.filter.backgroundColor", "58, 29, 29");
            workbenchPreference.setValue("ro.amiq.dvt.ui.filter.emptyBackgroundColor", "41,49,52");
            workbenchPreference.setValue("ro.amiq.dvt.ui.notification.foregroundColor", "224,226,228");
            workbenchPreference.setValue("ro.amiq.dvt.ui.notification.backgroundColor", "58, 29, 29");
            workbenchPreference.setValue("ro.amiq.dvt.ui.prefpages.settingsManagementCustomPragmasForegroundColor", "128,128,128");
            workbenchPreference.setValue("ro.amiq.dvt.ui.tooltip.foregroundColor", "224,226,228");
            workbenchPreference.setValue("ro.amiq.dvt.ui.tooltip.backgroundColor", "77,77,77");
            workbenchPreference.setValue("org.eclipse.search.ui.match.highlight", "128,128,128");
            vlogPreference.setValue("verissimo.background_color", "77,77,77");
            edtPreference.setValue("verissimo.background_color", "77,77,77");
            vlogPreference.setValue("verissimo.button_background_color", "214,209,205");
            edtPreference.setValue("verissimo.button_background_color", "214,209,205");
        } else {
            DVTPlugin.getDefault().getPreferenceStore().setValue("diagram.invert_colors", false);
            terminalPreference.setToDefault(TERMINAL_INVERT_COLORS_PREF_KEY);
            workbenchPreference.setToDefault("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
            workbenchPreference.setToDefault("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            workbenchPreference.setToDefault("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR");
            workbenchPreference.setToDefault("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR");
            workbenchPreference.setToDefault("org.eclipse.search.ui.match.highlight");
            workbenchPreference.setValue("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor", "237,236,235");
            workbenchPreference.setValue("ro.amiq.dvt.ui.filter.foregroundColor", "0,0,0");
            workbenchPreference.setValue("ro.amiq.dvt.ui.filter.backgroundColor", "245,245,181");
            workbenchPreference.setValue("ro.amiq.dvt.ui.filter.emptyBackgroundColor", "255,255,255");
            workbenchPreference.setValue("ro.amiq.dvt.ui.notification.foregroundColor", "0,0,0");
            workbenchPreference.setValue("ro.amiq.dvt.ui.notification.backgroundColor", "212,239,216");
            workbenchPreference.setValue("ro.amiq.dvt.ui.prefpages.settingsManagementCustomPragmasForegroundColor", "173,169,165");
            workbenchPreference.setValue("ro.amiq.dvt.ui.tooltip.foregroundColor", "0,0,0");
            workbenchPreference.setValue("ro.amiq.dvt.ui.tooltip.backgroundColor", "255,255,255");
            vlogPreference.setValue("verissimo.background_color", "255,255,255");
            edtPreference.setValue("verissimo.background_color", "255,255,255");
            vlogPreference.setValue("verissimo.button_background_color", "214,209,205");
            edtPreference.setValue("verissimo.button_background_color", "214,209,205");
        }
    }

    public boolean performCancel() {
        ArrayList<IThemePreviewContributor> previewContributors = this.getThemePreviewContributors();
        for (IThemePreviewContributor contributor : previewContributors) {
            contributor.cancelPreview();
        }
        GenericMapper eclipseEditorMapper = (GenericMapper)this.colorThemeManager.getEditorMapper(ORG_ECLIPSE_UI_EDITORS_ID);
        eclipseEditorMapper.restoreDefaultValues(EditorsUI.getPreferenceStore(), this.initialEclipseValues);
        return super.performCancel();
    }

    protected void contributeButtons(Composite parent) {
        ((GridLayout)parent.getLayout()).numColumns += 2;
        Button button = new Button(parent, 0);
        button.setText("&Import a theme...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(DVTThemePreferencePage.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.xml"});
                dialog.setText("Select an Eclipse Color Theme");
                String file = dialog.open();
                if (file != null) {
                    BufferedInputStream bufferedFileStream = null;
                    try {
                        try {
                            bufferedFileStream = new BufferedInputStream(new FileInputStream(file));
                            DVTThemePreferencePage.this.colorThemeManager.saveTheme((InputStream)bufferedFileStream);
                        }
                        catch (CharConversionException charConversionException) {
                            DVTThemePreferencePage.this.showErrorMessage("Invalid file encoding.");
                            try {
                                if (bufferedFileStream != null) {
                                    bufferedFileStream.close();
                                }
                            }
                            catch (IOException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                            return;
                        }
                        catch (Exception exception) {
                            DVTThemePreferencePage.this.showErrorMessage("This is not a valid theme file.");
                            try {
                                if (bufferedFileStream != null) {
                                    bufferedFileStream.close();
                                }
                            }
                            catch (IOException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                            return;
                        }
                    }
                    finally {
                        try {
                            if (bufferedFileStream != null) {
                                bufferedFileStream.close();
                            }
                        }
                        catch (IOException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    DVTThemePreferencePage.this.reloadThemeSelectionList();
                }
            }
        });
        Button dvtImportButton = new Button(parent, 0);
        dvtImportButton.setText("&Import an old DVT theme...");
        dvtImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(DVTThemePreferencePage.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.dvttheme"});
                dialog.setText("Select an Old DVT Theme");
                String file = dialog.open();
                if (file != null) {
                    DVTFileUtils.getInstance().setLastDirectory(file);
                    File themeFile = new File(file);
                    try {
                        DVTTheme theme = DVTTheme.createTheme(themeFile.toURI().toURL());
                        theme.apply(theme.getSections());
                        DVTThemePreferencePage.this.popRestartDialog();
                        DVTThemePreferencePage.super.performOk();
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        });
    }

    private void showErrorMessage(String message) {
        MessageBox box = new MessageBox(this.getShell(), 32);
        box.setText("Theme not imported");
        box.setMessage(message);
        box.open();
    }

    private void reloadThemeSelectionList() {
        this.themeSelectionList.removeAll();
        this.fillThemeSelectionList();
        this.themeSelectionList.setSelection(new String[]{DEFAULT_THEMENAME});
        this.updatePreviewers();
        this.container.pack();
    }

    private void updatePreviewers() {
        ColorTheme theme = this.colorThemeManager.getTheme(this.selectedThemeName);
        ArrayList<IThemePreviewContributor> previewContributors = this.getThemePreviewContributors();
        for (IThemePreviewContributor contributor : previewContributors) {
            GenericMapper pluginEditorMapper;
            if (contributor.getPreviewControl() != null && !contributor.getPreviewControl().isVisible()) continue;
            OverlayPreferenceStore overlayPreferenceStore = contributor.getOverlayPreferenceStore();
            String pluginID = contributor.getPluginId();
            if (theme == null) {
                pluginEditorMapper = (GenericMapper)this.colorThemeManager.getEditorMapper(pluginID);
                if (pluginEditorMapper == null) continue;
                pluginEditorMapper.defaultPreviewMap((IPreferenceStore)overlayPreferenceStore, contributor.getPluginPreferenceStore());
                contributor.updateBackground(DVTColorUtil.INSTANCE.getColor(255, 255, 255));
                continue;
            }
            pluginEditorMapper = (GenericMapper)this.colorThemeManager.getEditorMapper(pluginID);
            if (pluginEditorMapper == null) continue;
            pluginEditorMapper.previewMap(theme.getEntries(), theme.getMappings() == null ? null : (Map)theme.getMappings().get(pluginID), (IPreferenceStore)overlayPreferenceStore);
            Color ectColor = this.colorThemeManager.getThemeBackground(this.selectedThemeName);
            contributor.updateBackground(DVTColorUtil.INSTANCE.getColor(ectColor.getR().intValue(), ectColor.getG().intValue(), ectColor.getB().intValue()));
        }
    }

    private void updateUIThemeCombo(boolean isDarkUI) {
        this.uiThemeCombo.select(isDarkUI ? 1 : 0);
    }

    private void copyInitialEclipseSettings() {
        GenericMapper eclipseEditorMapper = (GenericMapper)this.colorThemeManager.getEditorMapper(ORG_ECLIPSE_UI_EDITORS_ID);
        if (eclipseEditorMapper != null) {
            eclipseEditorMapper.copyMapping(EditorsUI.getPreferenceStore(), this.initialEclipseValues);
        }
    }

    private ArrayList<IThemePreviewContributor> getThemePreviewContributors() {
        if (this.contributors != null) {
            return this.contributors;
        }
        this.contributors = new ArrayList();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DVT_THEME_PREVIEW_CONTRIBUTOR_EXTENSION_POINT_ID);
            if (extensionPoint == null) {
                return this.contributors;
            }
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!DVT_THEME_PREVIEW_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + DVT_THEME_PREVIEW_CONTRIBUTOR_EXTENSION_POINT_ID));
                    }
                    IThemePreviewContributor themePreviewContributor = (IThemePreviewContributor)configurationElement.createExecutableExtension("class");
                    this.contributors.add(themePreviewContributor);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.contributors.sort(new Comparator<IThemePreviewContributor>(){

            @Override
            public int compare(IThemePreviewContributor o1, IThemePreviewContributor o2) {
                return o1.getPreviewOrderId().compareTo(o2.getPreviewOrderId());
            }
        });
        return this.contributors;
    }

    private void popRestartDialog() {
        new RestartRequiredDialog("Restart Required", "You have to exit and re-launch DVT in order to apply the theme.\n\nDo you want to exit now?", true).open();
    }

    private void setEclipseTheme(boolean isDarkTheme) {
        Object engine = Display.getDefault().getData("org.eclipse.e4.ui.css.swt.theme");
        if (!(engine instanceof IThemeEngine)) {
            return;
        }
        ((IThemeEngine)engine).setTheme(isDarkTheme ? "org.eclipse.e4.ui.css.theme.e4_dark" : "org.eclipse.e4.ui.css.theme.e4_classic", true);
    }

    private ThemeModel getThemeModel() {
        String uiTheme = this.uiThemeCombo.getText();
        String editorTheme = this.selectedThemeName;
        FontData uiFont = this.uiFontSelector.font == null ? null : this.uiFontSelector.font.getFontData()[0];
        FontData editorFont = this.editorFontSelector.font == null ? null : this.editorFontSelector.font.getFontData()[0];
        return new ThemeModel(uiTheme, editorTheme, uiFont, editorFont);
    }

    private static class FontSelector {
        Label label;
        Text text;
        Font font;
        Font exampleDisplayFont;

        private FontSelector() {
        }
    }

    private class ThemeModel {
        String uiTheme;
        String editorTheme;
        FontData uiFont;
        FontData editorFont;

        public ThemeModel(String uiTheme, String editorTheme, FontData uiFont, FontData editorFont) {
            this.uiTheme = uiTheme;
            this.editorTheme = editorTheme;
            this.uiFont = uiFont;
            this.editorFont = editorFont;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getEnclosingInstance())).hashCode();
            result = 31 * result + (this.editorFont == null ? 0 : this.editorFont.hashCode());
            result = 31 * result + (this.editorTheme == null ? 0 : this.editorTheme.hashCode());
            result = 31 * result + (this.uiFont == null ? 0 : this.uiFont.hashCode());
            result = 31 * result + (this.uiTheme == null ? 0 : this.uiTheme.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ThemeModel other = (ThemeModel)obj;
            if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)other.getEnclosingInstance())) {
                return false;
            }
            if (this.editorFont == null ? other.editorFont != null : !this.editorFont.equals((Object)other.editorFont)) {
                return false;
            }
            if (this.editorTheme == null ? other.editorTheme != null : !this.editorTheme.equals(other.editorTheme)) {
                return false;
            }
            if (this.uiFont == null ? other.uiFont != null : !this.uiFont.equals((Object)other.uiFont)) {
                return false;
            }
            return !(this.uiTheme == null ? other.uiTheme != null : !this.uiTheme.equals(other.uiTheme));
        }

        private DVTThemePreferencePage getEnclosingInstance() {
            return DVTThemePreferencePage.this;
        }
    }
}

