/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences.theme;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;

public abstract class DVTThemeSection {
    private final String fName;
    private final String fPrefix;
    private final LinkedHashMap<String, String> fMap;

    private DVTThemeSection(String name, String prefix) {
        this.fName = name;
        this.fPrefix = prefix;
        this.fMap = new LinkedHashMap();
    }

    public void put(String key, String value) {
        this.fMap.put(key, value);
    }

    public String getName() {
        return this.fName;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public Map<String, String> getMap() {
        return Collections.unmodifiableMap(this.fMap);
    }

    public abstract void apply();

    public static DVTThemeSection createSection(String name, String prefix, boolean isRemover) {
        if (prefix.equals("GTK")) {
            if (isRemover) {
                return new GTKRemoverSection(name, prefix);
            }
            return new GTKSection(name, prefix);
        }
        if (isRemover) {
            return new RemoverSection(name, prefix);
        }
        return new NormalSection(name, prefix);
    }

    private static class GTKRemoverSection
    extends DVTThemeSection {
        private GTKRemoverSection(String name, String prefix) {
            super(name, prefix);
        }

        @Override
        public void apply() {
            try {
                DVTThemeUtils.writeThemeGTKRCFile("");
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private static class GTKSection
    extends DVTThemeSection {
        private GTKSection(String name, String prefix) {
            super(name, prefix);
        }

        @Override
        public void apply() {
            StringBuilder gtkTheme = new StringBuilder();
            Map<String, String> map = this.getMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                gtkTheme.append(entry.getKey()).append('=').append(entry.getValue()).append(' ');
            }
            try {
                DVTThemeUtils.writeThemeGTKRCFile(gtkTheme.toString());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private static class NormalSection
    extends DVTThemeSection {
        private NormalSection(String name, String prefix) {
            super(name, prefix);
        }

        @Override
        public void apply() {
            IEclipsePreferences preferences = new InstanceScope().getNode(this.getPrefix());
            Map<String, String> map = this.getMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                preferences.put(entry.getKey(), entry.getValue());
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private static class RemoverSection
    extends DVTThemeSection {
        private RemoverSection(String name, String prefix) {
            super(name, prefix);
        }

        @Override
        public void apply() {
            IEclipsePreferences preferences = new InstanceScope().getNode(this.getPrefix());
            Map<String, String> map = this.getMap();
            for (String key : map.keySet()) {
                preferences.remove(key);
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }
}

