/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.preferences.theme;

import com.github.eclipsecolortheme.Activator;
import com.github.eclipsecolortheme.ColorTheme;
import com.github.eclipsecolortheme.ColorThemeManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.utils.OSInformation;

public class DVTThemeUtils {
    private static final Pattern THEME_PATTERN = Pattern.compile("(?s)style\\s*\\\"dvt\\\"\\s*\\{(.*)\\}\\s*class\\s*\\\"GtkWidget\\\"\\s*style\\s*\\\"dvt\\\"");
    private static final Pattern fPattern = Pattern.compile(String.valueOf(Pattern.quote("font_name")) + "\\s*=\\s*\"(.*?)\"");
    private static final String GTKRC_END = "} class \"GtkWidget\" style \"dvt\"";
    private static final String GTKRC_START = "style \"dvt\" { ";
    private static final float DARKNESS_THRESHOLD = 0.5f;

    public static void writeThemeGTKRCFile(String content) throws Exception {
        if (!content.isEmpty()) {
            content = GTKRC_START + content + GTKRC_END;
        }
        File file = DVTSFiles.GTKRC.getUserFile(false);
        DVTThemeUtils.createFile(file);
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(file));
                bw.write(content);
                bw.flush();
            }
            catch (IOException e) {
                throw new Exception(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {
                bw = null;
            }
            throw throwable;
        }
        try {
            if (bw != null) {
                bw.close();
            }
        }
        catch (IOException iOException) {
            bw = null;
        }
    }

    public static FontData getGTKFont() {
        String value;
        Matcher matcher2;
        Matcher matcher = THEME_PATTERN.matcher(DVTThemeUtils.themeFromFile(null));
        String themeString = "";
        FontData result = null;
        if (matcher.matches()) {
            themeString = matcher.group(1);
        }
        if ((matcher2 = fPattern.matcher(themeString)).find() && (value = matcher2.group(1)) != null && !value.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int i = value.length() - 1;
            while (i >= 0) {
                char ch = value.charAt(i);
                if (ch == ' ') break;
                sb.append(ch);
                --i;
            }
            sb.reverse();
            result = new FontData(value.substring(0, i), Integer.parseInt(sb.toString()), 0);
        }
        return result;
    }

    public static boolean isGTK2DarkTheme(String themeFilePath) {
        return DVTThemeUtils.themeFromFile(themeFilePath).contains("base[NORMAL]");
    }

    private static void createFile(File file) throws Exception {
        if (file == null) {
            throw new Exception("Can't find a writable location for settings file!");
        }
        if (file.exists()) {
            if (!file.isFile()) {
                throw new Exception("Settings file " + file.getAbsolutePath() + " exists but is not a file!");
            }
            if (!file.canRead()) {
                throw new Exception("Settings file " + file.getAbsolutePath() + " exists but is not readable!");
            }
            if (!file.canWrite()) {
                throw new Exception("Settings file " + file.getAbsolutePath() + " exists but is not writable!");
            }
        } else {
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new Exception("Can't create settings file parent directory" + parent.getAbsolutePath() + "!");
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new Exception("Can't create settings file in directory" + parent.getAbsolutePath() + "!");
            }
            if (!file.canWrite()) {
                throw new Exception("Settings file " + file.getAbsolutePath() + " exists but is not writable!");
            }
        }
    }

    private static String themeFromFile(String themeFilePath) {
        File file = themeFilePath != null ? new File(themeFilePath) : DVTThemeUtils.getFileForRead();
        String content = "";
        if (file != null && file.exists()) {
            StringBuilder sb;
            block16: {
                BufferedReader br = null;
                String line = null;
                sb = new StringBuilder();
                try {
                    try {
                        br = new BufferedReader(new FileReader(file));
                        while ((line = br.readLine()) != null) {
                            sb.append(line);
                        }
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        try {
                            if (br != null) {
                                br.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException) {
                            br = null;
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException iOException) {
                        br = null;
                    }
                    throw throwable;
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {
                    br = null;
                }
            }
            content = sb.toString();
        }
        return content;
    }

    private static File getFileForRead() {
        List settingFiles = DVTSFiles.GTKRC.getAllFiles(true);
        if (settingFiles != null && !settingFiles.isEmpty()) {
            return (File)settingFiles.get(settingFiles.size() - 1);
        }
        return null;
    }

    public static boolean isDarkUI() {
        AtomicBoolean result = new AtomicBoolean(false);
        Display.getDefault().syncExec(() -> result.set(DVTColorUtil.INSTANCE.isEclipseDarkTheme() || DVTThemeUtils.isGTK2DarkTheme() || DVTThemeUtils.isGTK3DarkTheme() || DVTThemeUtils.isSystemDarkTheme()));
        return result.get();
    }

    private static boolean isGTK2DarkTheme() {
        String gtk2RCFilePath = System.getenv("GTK2_RC_FILES");
        if (gtk2RCFilePath == null) {
            return false;
        }
        return DVTThemeUtils.isGTK2DarkTheme(gtk2RCFilePath);
    }

    private static boolean isGTK3DarkTheme() {
        String gtk3Theme = System.getenv("GTK_THEME");
        if (gtk3Theme == null) {
            return false;
        }
        return gtk3Theme.endsWith(":dark");
    }

    private static boolean isSystemDarkTheme() {
        try {
            Color widgetBackgroundColor = Display.getDefault().getSystemColor(22);
            float[] hsb = widgetBackgroundColor.getRGB().getHSB();
            return hsb[2] < 0.5f;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public static int getGTKVersion() {
        String gtkVersion = System.getProperty("org.eclipse.swt.internal.gtk.version");
        if (gtkVersion == null) {
            gtkVersion = OSInformation.getOSGTKVersion();
        }
        if (gtkVersion == null) {
            gtkVersion = OSInformation.getGTKGTKVersion();
        }
        if (gtkVersion == null) {
            return 2;
        }
        String[] versionParts = gtkVersion.split("\\.");
        if (versionParts.length == 0) {
            return 2;
        }
        return Integer.parseInt(versionParts[0]);
    }

    public static void setFontRecursive(Control control, Font font) {
        control.setFont(font);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                DVTThemeUtils.setFontRecursive(children[i], font);
                ++i;
            }
        }
    }

    public static ColorTheme getActiveTheme() {
        ColorThemeManager colorThemeManager = new ColorThemeManager();
        String activeThemeName = Activator.getDefault().getPreferenceStore().getString("colorTheme");
        return colorThemeManager.getTheme(activeThemeName);
    }
}

