/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversTreeNode;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversUtil;
import ro.amiq.dvt.ui.Utils;

public class CreateWaiverFromProblemDialog
extends TitleAreaDialog {
    private static final String CREATED_FILE_MESSAGE = "The selected file doesn't exist and will be created";
    private static final String DEFAULT_INFO_MESSAGE = "The waiver will be written to the selected file";
    private static final String READ_ONLY_FILE_MESSAGE = "No permissions to write in the selected file";
    private IMarker fMarker;
    private Text fTextName;
    private Button fBtnError;
    private Button fBtnWarning;
    private Button fBtnDisabled;
    private Button fBtnUsePath;
    private Text fTextPath;
    private Button fBtnUseMessage;
    private Text fTextMessage;
    private Combo fComboView;
    private Text fTextDescription;
    private Map<String, Object> fDialogData;

    public CreateWaiverFromProblemDialog(IMarker marker) {
        this(Utils.getActiveShell());
        this.fMarker = marker;
    }

    public CreateWaiverFromProblemDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Create waiver from problem");
        super.configureShell(newShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Create waiver from problem");
        this.setMessage(DEFAULT_INFO_MESSAGE, 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        String markerMessage = "";
        String markerPath = "";
        try {
            markerMessage = (String)this.fMarker.getAttribute("message");
            markerPath = this.fMarker.getResource().getLocation().toOSString();
        }
        catch (CoreException coreException) {}
        Composite comp1 = (Composite)super.createDialogArea(parent);
        comp1.setLayout((Layout)new GridLayout(1, true));
        GridData comp1LD = new GridData(4, 4, true, true);
        comp1LD.widthHint = 500;
        comp1.setLayoutData((Object)comp1LD);
        Group groupNameSeverity = new Group(comp1, 16);
        groupNameSeverity.setLayout((Layout)new GridLayout(2, false));
        groupNameSeverity.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label((Composite)groupNameSeverity, 0);
        label.setText("Name: ");
        this.fTextName = new Text((Composite)groupNameSeverity, 2048);
        this.fTextName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fTextName.setText(markerMessage.indexOf(":") > 0 ? markerMessage.substring(0, markerMessage.indexOf(":")) : "");
        label = new Label((Composite)groupNameSeverity, 0);
        label.setText("New severity: ");
        Composite compSeverity = new Composite((Composite)groupNameSeverity, 0);
        compSeverity.setLayout((Layout)new GridLayout(3, false));
        compSeverity.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fBtnDisabled = new Button(compSeverity, 16);
        this.fBtnDisabled.setText("DISABLED");
        this.fBtnDisabled.setSelection(true);
        this.fBtnError = new Button(compSeverity, 16);
        this.fBtnError.setText("ERROR");
        this.fBtnWarning = new Button(compSeverity, 16);
        this.fBtnWarning.setText("WARNING");
        Group groupTargetFile = new Group(comp1, 16);
        groupTargetFile.setText("Waiver File");
        groupTargetFile.setLayout((Layout)new GridLayout(1, false));
        groupTargetFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fComboView = new Combo((Composite)groupTargetFile, 8);
        this.fComboView.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.compileWaiversFilesList(CompileWaiversUtil.getInstance().getCompileWaiversTreeRoot());
        String lastSelectedFile = CompileWaiversUtil.getInstance().getLastSelectedFile();
        int index = -1;
        String[] stringArray = this.fComboView.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            ++index;
            if (this.fComboView.getData(filePath).equals(lastSelectedFile)) break;
            ++n2;
        }
        this.fComboView.select(index);
        this.fComboView.setToolTipText((String)this.fComboView.getData(this.fComboView.getItem(index)));
        this.fComboView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.widget;
                String text = combo.getText();
                Button okButton = CreateWaiverFromProblemDialog.this.getButton(0);
                CreateWaiverFromProblemDialog.this.fComboView.setToolTipText((String)CreateWaiverFromProblemDialog.this.fComboView.getData(CreateWaiverFromProblemDialog.this.fComboView.getItem(CreateWaiverFromProblemDialog.this.fComboView.getSelectionIndex())));
                CreateWaiverFromProblemDialog.this.checkOptionTags(text, okButton);
            }
        });
        Group groupMatch = new Group(comp1, 16);
        groupMatch.setText("Match");
        groupMatch.setLayout((Layout)new GridLayout(2, false));
        groupMatch.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fBtnUsePath = new Button((Composite)groupMatch, 32);
        this.fBtnUsePath.setText("Path");
        this.fBtnUsePath.setSelection(true);
        this.fTextPath = new Text((Composite)groupMatch, 2048);
        this.fTextPath.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fTextPath.setText(markerPath);
        this.fBtnUseMessage = new Button((Composite)groupMatch, 32);
        this.fBtnUseMessage.setText("Message");
        this.fBtnUseMessage.setSelection(true);
        this.fTextMessage = new Text((Composite)groupMatch, 2048);
        this.fTextMessage.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fTextMessage.setText(markerMessage);
        this.fBtnUsePath.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateWaiverFromProblemDialog.this.fTextPath.setEnabled(CreateWaiverFromProblemDialog.this.fBtnUsePath.getSelection());
                CreateWaiverFromProblemDialog.this.handleMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fBtnUseMessage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateWaiverFromProblemDialog.this.fTextMessage.setEnabled(CreateWaiverFromProblemDialog.this.fBtnUseMessage.getSelection());
                CreateWaiverFromProblemDialog.this.handleMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group groupDescription = new Group(comp1, 16);
        groupDescription.setText("Description");
        groupDescription.setLayout((Layout)new GridLayout(1, false));
        groupDescription.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTextDescription = new Text((Composite)groupDescription, 2626);
        this.fTextDescription.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTextDescription.setText("\n\n\n");
        return comp1;
    }

    private void checkOptionTags(String text, Button okButton) {
        if (text.contains(" [readonly]")) {
            this.setMessage(READ_ONLY_FILE_MESSAGE, 3);
            okButton.setEnabled(false);
            return;
        }
        okButton.setEnabled(true);
        if (text.contains(" [file will be created]")) {
            this.setMessage(CREATED_FILE_MESSAGE, 2);
        } else {
            this.setMessage(DEFAULT_INFO_MESSAGE, 1);
        }
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void okPressed() {
        try {
            this.setDialogData();
            String fileAbsolutePath = (String)this.fComboView.getData(this.fComboView.getItem(this.fComboView.getSelectionIndex()));
            CompileWaiversUtil.getInstance().setLastSelectedFile(fileAbsolutePath);
        }
        catch (CoreException coreException) {}
        super.okPressed();
    }

    private void handleMessage() {
        if (!this.fBtnUsePath.getSelection() && !this.fBtnUseMessage.getSelection()) {
            this.setMessage("The current data will match all problems", 2);
        } else {
            this.setMessage("The waiver will be written to the .dvt/waivers.xml", 1);
        }
    }

    private void setDialogData() throws CoreException {
        String originalMessage = (String)this.fMarker.getAttribute("message");
        String goodMessage = this.fTextMessage.getText();
        if (originalMessage.contains("\n") && !originalMessage.contains("\r\n")) {
            goodMessage = goodMessage.replaceAll("\r\n", "\n");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.fTextName.getText());
        map.put("usePath", this.fBtnUsePath.getSelection());
        map.put("path", this.fTextPath.getText());
        map.put("useMessage", this.fBtnUseMessage.getSelection());
        map.put("message", goodMessage);
        map.put("severity", this.fBtnError.getSelection() ? "ERROR" : (this.fBtnWarning.getSelection() ? "WARNING" : "DISABLED"));
        map.put("description", this.fTextDescription.getText());
        map.put("location", this.fComboView.getData(this.fComboView.getItem(this.fComboView.getSelectionIndex())));
        this.fDialogData = map;
    }

    public Map<String, Object> getDialogData() {
        return this.fDialogData;
    }

    private void compileWaiversFilesList(CompileWaiversTreeNode node) {
        String fileName = node.getUiEntryName();
        if (fileName != null && !"".equals(fileName)) {
            this.fComboView.add(fileName);
            this.fComboView.setData(fileName, (Object)node.getFileAbsolutePath());
        }
        for (CompileWaiversTreeNode child : node.getChildren()) {
            this.compileWaiversFilesList(child);
        }
    }
}

