/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.views.markers.MarkerItem;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversConstants;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversUtil;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.problems.CreateWaiverFromProblemDialog;
import ro.amiq.dvt.ui.problems.CreateWaiverFromProblemHandlerCommon;
import ro.amiq.dvt.ui.problems.ReapplyWaiversHandler;
import ro.amiq.dvt.utils.DVTFileUtils;

public class CreateWaiverFromProblemHandler
extends CreateWaiverFromProblemHandlerCommon {
    private IProject fProject;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMarker marker = this.computeMarker(event);
        if (marker == null) {
            return null;
        }
        this.fProject = marker.getResource().getProject();
        if (this.fProject == null) {
            return null;
        }
        CompileWaiversUtil.getInstance().updateCompileWaiversTree(this.fProject);
        Map<String, Object> dialogData = this.computeData(marker);
        this.addNewWaiverFromDialogData(dialogData, marker);
        return null;
    }

    private Map<String, Object> computeData(IMarker marker) {
        CreateWaiverFromProblemDialog waiverDialog = this.createDialog(marker);
        if (waiverDialog == null) {
            return null;
        }
        return waiverDialog.getDialogData();
    }

    private CreateWaiverFromProblemDialog createDialog(IMarker marker) {
        if (TestHelper.isTestMode() && !TestHelper.isSWTBotSuite()) {
            return null;
        }
        CreateWaiverFromProblemDialog createWaiverDialog = new CreateWaiverFromProblemDialog(marker);
        if (createWaiverDialog.open() == 1) {
            return null;
        }
        return createWaiverDialog;
    }

    @Override
    protected IFile computeWaiversFile(Map<String, Object> dialogData) {
        String location = this.extractFileLocation(dialogData);
        if (location == null) {
            return null;
        }
        IFile waiversFile = this.computeSettingsManagedWaiversFile(location);
        if (waiversFile != null) {
            return waiversFile;
        }
        return this.computeProjectWaiversFile(location);
    }

    private String extractFileLocation(Map<String, Object> dialogData) {
        Object data = this.extractFileData(dialogData);
        if (data instanceof String) {
            return (String)data;
        }
        return null;
    }

    private Object extractFileData(Map<String, Object> dialogData) {
        if (TestHelper.isTestMode()) {
            return this.testGetData();
        }
        if (dialogData == null) {
            return null;
        }
        return dialogData.get("location");
    }

    private Object testGetData() {
        return CompileWaiversUtil.getInstance().getLastSelectedFile();
    }

    private IFile computeSettingsManagedWaiversFile(String location) {
        File userSettingsFile = DVTSFiles.WAIVERS.getUserFile(false);
        if (userSettingsFile != null && location.equals(userSettingsFile.getAbsolutePath())) {
            return this.getSettingsManagementFile("user");
        }
        List commonSettingsFiles = DVTSFiles.WAIVERS.getCommonFiles(false);
        if (commonSettingsFiles == null) {
            return null;
        }
        for (File file : commonSettingsFiles) {
            if (file == null || !location.equals(file.getAbsolutePath())) continue;
            return this.getSettingsManagementFile("common");
        }
        return null;
    }

    private IFile computeProjectWaiversFile(String location) {
        IFile waiversFile = null;
        waiversFile = location.equals(String.valueOf(this.fProject.getLocation().toOSString()) + System.getProperty("file.separator") + CompileWaiversConstants.XML_PROJECT_RELATIVE_PATH) ? this.fProject.getFile(CompileWaiversConstants.XML_PROJECT_RELATIVE_PATH) : DVTFileUtils.getInstance().getProjectFile(this.fProject, location);
        return waiversFile;
    }

    private IFile getSettingsManagementFile(String folderPrefix) {
        IProject dvtSettingsProject = ResourcesPlugin.getWorkspace().getRoot().getProject("DVT-Settings");
        return dvtSettingsProject.getFile(String.valueOf(folderPrefix) + System.getProperty("file.separator") + "waivers.xml");
    }

    @Override
    protected boolean saveWaiversFileIfDirty(IFile waiversFile) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(waiversFile.getFullPath(), LocationKind.IFILE);
        if (textFileBuffer == null) {
            return true;
        }
        if (!textFileBuffer.isDirty()) {
            return true;
        }
        boolean save = MessageDialog.open((int)5, (Shell)DVTUiUtils.getActiveWorkbenchShell(), (String)"Waivers File has Been Modified", (String)("The compile waivers file was modified and not saved: \n" + waiversFile.getLocation().toOSString() + "\nDo you want to save the file and apply the waiver?"), (int)0);
        if (!save) {
            return false;
        }
        try {
            textFileBuffer.commit(null, true);
        }
        catch (CoreException e) {
            MessageDialog.open((int)1, (Shell)DVTUiUtils.getActiveWorkbenchShell(), (String)"Internal Error", (String)("An internal error has occurred when trying to save '" + waiversFile.getLocation().toOSString() + "'"), (int)0);
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected void createDefaultWaiversFile(IFile waiversFile, boolean overwrite) {
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)activeWorkbenchWindow.getService(ICommandService.class);
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put("filePath", waiversFile.getFullPath().toOSString());
        parameters.put("overwrite", String.valueOf(overwrite));
        ParameterizedCommand editWaiversCommand = ParameterizedCommand.generateCommand((Command)commandService.getCommand("org.eclipse.ui.views.problems.editDVTProblemWaivers"), parameters);
        try {
            handlerService.executeCommand(editWaiversCommand, null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private IMarker computeMarker(ExecutionEvent event) {
        if (event.getTrigger() instanceof Event && ((Event)event.getTrigger()).data instanceof IMarker) {
            return (IMarker)((Event)event.getTrigger()).data;
        }
        Object defaultVar = ((IEvaluationContext)event.getApplicationContext()).getDefaultVariable();
        if (!(defaultVar instanceof List)) {
            return null;
        }
        if (((List)defaultVar).isEmpty()) {
            return null;
        }
        Object markerItem = ((AbstractList)defaultVar).get(0);
        if (!(markerItem instanceof MarkerItem)) {
            return null;
        }
        return ((MarkerItem)markerItem).getMarker();
    }

    @Override
    protected void reapplyWaivers() {
        ReapplyWaiversHandler.reapplyWaivers(this.fProject);
    }

    @Override
    protected void showFileCreationError() {
        MessageDialog.open((int)1, (Shell)DVTUiUtils.getActiveWorkbenchShell(), (String)"Internal Error", (String)("An internal error has occurred when trying to create '" + CompileWaiversConstants.XML_PROJECT_RELATIVE_PATH + "'"), (int)0);
    }

    @Override
    protected String getMessageFromMarker(IMarker marker) throws Exception {
        return (String)marker.getAttribute("message");
    }

    @Override
    protected void writeAndRefreshWaiversFile(IFile waiversFile, String content) throws Exception {
        waiversFile.setContents((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), 3, null);
        waiversFile.refreshLocal(2, null);
    }

    @Override
    protected boolean openCorruptedWaiversFileDialog(IFile waiversFile) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Overwrite Waivers File", null, "The compile waivers file is missing the end </waivers> tag:\n" + waiversFile.getLocation().toOSString() + "\nDo you want to overwrite the file?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        return dialog.open() == 0;
    }

    @Override
    protected boolean isTestMode() {
        return TestHelper.isTestMode();
    }
}

