/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class CreateWaiverFromProblemHandlerCommon
extends AbstractHandler {
    private static final Pattern FIRST_WORD = Pattern.compile("\\s*(\\w+)");
    private static final String WAIVERS_CLOSING_TAG = "</waivers>";

    public void addNewWaiverFromDialogData(Map<String, Object> dialogData, IMarker marker) {
        String currentContent;
        IFile waiversFile = this.computeWaiversFile(dialogData);
        if (waiversFile == null) {
            return;
        }
        if (!this.saveWaiversFileIfDirty(waiversFile)) {
            return;
        }
        try {
            waiversFile.refreshLocal(0, null);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (!waiversFile.exists()) {
            this.createDefaultWaiversFile(waiversFile, false);
            if (!waiversFile.exists()) {
                this.showFileCreationError();
                return;
            }
        }
        if ((currentContent = DVTFileUtils.getInstance().readFileContent(waiversFile.getLocation().toFile())).trim().isEmpty()) {
            this.createDefaultWaiversFile(waiversFile, true);
            currentContent = DVTFileUtils.getInstance().readFileContent(waiversFile.getLocation().toFile());
        }
        if (!this.isTestMode() && dialogData != null) {
            this.addWaiver(waiversFile, (String)dialogData.get("name"), (String)dialogData.get("severity"), (Boolean)dialogData.get("usePath"), (String)dialogData.get("path"), (Boolean)dialogData.get("useMessage"), (String)dialogData.get("message"), (String)dialogData.get("description"), currentContent);
        } else {
            try {
                String UNKNOWN_PROBLEM = "UNKNOWN_PROBLEM";
                String message = this.getMessageFromMarker(marker);
                Matcher matcher = FIRST_WORD.matcher(message);
                String testName = !matcher.find() ? UNKNOWN_PROBLEM : matcher.group(1);
                String testSeverity = "DISABLED";
                boolean testUsePath = true;
                String testPath = marker.getResource().getLocation().toOSString();
                boolean testUseMessage = true;
                String testMessage = this.getMessageFromMarker(marker);
                String testDescription = "";
                this.addWaiver(waiversFile, testName, testSeverity, testUsePath, testPath, testUseMessage, testMessage, testDescription, currentContent);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        this.reapplyWaivers();
    }

    private void addWaiver(IFile waiversFile, String name, String severity, boolean usePath, String path, boolean useMessage, String message, String description, String currentContent) {
        StringBuilder sb = new StringBuilder(currentContent);
        int idxInsert = sb.indexOf(WAIVERS_CLOSING_TAG);
        if (idxInsert < 0) {
            if (!this.openCorruptedWaiversFileDialog(waiversFile)) {
                return;
            }
            this.createDefaultWaiversFile(waiversFile, true);
            sb = new StringBuilder(DVTFileUtils.getInstance().readFileContent(waiversFile.getLocation().toFile()));
            idxInsert = sb.indexOf(WAIVERS_CLOSING_TAG);
        }
        name = name == null ? null : DVTStringUtil.escapeXMLString(name, true);
        path = path == null ? "" : DVTStringUtil.escapeXMLString(path, true);
        message = message == null ? "" : DVTStringUtil.escapeXMLString(message, true);
        String string = description = description == null ? "" : DVTStringUtil.escapeXMLString(description, false).trim();
        if (path.trim().isEmpty()) {
            usePath = false;
        }
        if (message.trim().isEmpty()) {
            useMessage = false;
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = "\t<waiver name=\"%1$s\" severity=\"%2$s\">";
        Object object = objectArray[1] = description.isEmpty() ? "" : "\n\t\t<description>%3$s\n\t\t</description>";
        objectArray[2] = usePath || useMessage ? "\n\t\t<match" + (usePath ? " path=\"%4$s\"" : "") + (useMessage ? " message=\"%5$s\"" : "") + "/>" : "";
        objectArray[3] = "\n\t</waiver>\n";
        String waiverStructure = String.format("%s%s%s%s", objectArray);
        String waiverContents = String.format(waiverStructure, name, severity, description, path, message);
        sb.insert(idxInsert, waiverContents);
        try {
            this.writeAndRefreshWaiversFile(waiversFile, sb.toString());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected abstract boolean openCorruptedWaiversFileDialog(IFile var1);

    protected abstract void showFileCreationError();

    protected abstract void reapplyWaivers();

    protected abstract void createDefaultWaiversFile(IFile var1, boolean var2);

    protected abstract IFile computeWaiversFile(Map<String, Object> var1);

    protected abstract boolean saveWaiversFileIfDirty(IFile var1);

    protected abstract String getMessageFromMarker(IMarker var1) throws Exception;

    protected abstract void writeAndRefreshWaiversFile(IFile var1, String var2) throws Exception;

    protected abstract boolean isTestMode();
}

