/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemKind;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTMarkerFactory {
    private static final int SEVERITY_DISABLED = -1;
    public static final String DVT_PROBLEM_MESSAGE_PARAMETER = "DVT_PROBLEM_MESSAGE_PARAMETER";
    public static final String DVT_PROBLEM_KIND = "DVT_PROBLEM_KIND";
    public static final String DVT_PROBLEM_PROJECT_NAME = "DVT_PROBLEM_PROJECT_NAME";

    public static IMarker createMarker(DVTProblem problem, IResource resource) {
        IMarker marker = null;
        if (resource == null) {
            return null;
        }
        if (problem.getSeverity() == Severity.DISABLED) {
            return marker;
        }
        try {
            String markerId = problem.isObsolete() ? problem.getCategory().getObsoleteMarkerId() : problem.getCategory().getMarkerId();
            marker = resource.createMarker(markerId);
            int lineNumber = problem.getLine();
            if (lineNumber <= 0) {
                lineNumber = 1;
            }
            String message = problem.getMessage();
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", DVTMarkerFactory.toMarkerSeverity(problem.getSeverity()));
            marker.setAttribute("lineNumber", lineNumber);
            if (problem.getAttribute("priority") == null) {
                marker.setAttribute("priority", 2);
            }
            int i = 0;
            while (i < problem.getMessageParameters().length) {
                String messageParameter = problem.getMessageParameters()[i];
                marker.setAttribute(DVT_PROBLEM_MESSAGE_PARAMETER + i, (Object)messageParameter);
                ++i;
            }
            marker.setAttribute(DVT_PROBLEM_PROJECT_NAME, (Object)problem.getProject().getName());
            marker.setAttribute(DVT_PROBLEM_KIND, (Object)problem.getKind().getId());
            for (String attribute : problem.getAttributes().keySet()) {
                marker.setAttribute(attribute, DVTMarkerFactory.safeGet(problem.getAttribute(attribute)));
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return marker;
    }

    /*
     * WARNING - void declaration
     */
    private static Object safeGet(Object attributeValue) {
        void attributeString;
        void var2_1;
        String string;
        Object object = attributeValue;
        return object instanceof String && (string = (String)object) == (String)var2_1 ? DVTStringUtil.capBytesLength((String)attributeString) : attributeValue;
    }

    public static IMarker createMarker(DVTProblem problem) {
        IProject project = problem.getProject();
        Object resource = null;
        resource = problem.getPath() == null ? project : DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, problem.getPath());
        return DVTMarkerFactory.createMarker(problem, (IResource)resource);
    }

    public static Severity toProblemSeverity(Integer severity) {
        switch (severity) {
            case 2: {
                return Severity.ERROR;
            }
            case 1: {
                return Severity.WARNING;
            }
            case 0: {
                return Severity.INFO;
            }
            case -1: {
                return Severity.DISABLED;
            }
        }
        return null;
    }

    public static int toMarkerSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
            case DISABLED: {
                return -1;
            }
        }
        return -1;
    }

    public static DVTProblem fromMarker(IMarker marker, DVTProblemCategory category) {
        Map attributes = null;
        try {
            attributes = marker.getAttributes();
        }
        catch (CoreException coreException) {}
        if (attributes == null) {
            return null;
        }
        DVTProblem result = null;
        try {
            result = new DVTProblem(DVTMarkerFactory.extractProject(attributes), DVTMarkerFactory.extractProblemKind(attributes, category), DVTMarkerFactory.getPath(marker), false, DVTMarkerFactory.extractLine(attributes), DVTMarkerFactory.extractMessageParameters(attributes));
            result.setSeverity(DVTMarkerFactory.extractSeverity(attributes));
            attributes.remove("priority");
            attributes.remove("message");
            DVTMarkerFactory.putAttributes(result, attributes);
        }
        catch (ProblemUnpackException problemUnpackException) {
            return null;
        }
        return result;
    }

    private static Severity extractSeverity(Map<String, Object> attributes) throws ProblemUnpackException {
        Object severityVal = attributes.get("severity");
        if (!(severityVal instanceof Integer)) {
            throw new ProblemUnpackException();
        }
        Severity severity = DVTMarkerFactory.toProblemSeverity((Integer)severityVal);
        if (severity == null) {
            throw new ProblemUnpackException();
        }
        attributes.remove("severity");
        return severity;
    }

    private static void putAttributes(DVTProblem problem, Map<String, Object> attributes) throws ProblemUnpackException {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            problem.setAttribute(entry.getKey(), entry.getValue().toString());
        }
    }

    private static String[] extractMessageParameters(Map<String, Object> attributes) throws ProblemUnpackException {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < attributes.size()) {
            Object parameter = attributes.get(DVT_PROBLEM_MESSAGE_PARAMETER + i);
            if (parameter == null) break;
            result.add(parameter.toString());
            attributes.remove(DVT_PROBLEM_MESSAGE_PARAMETER + i);
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static int extractLine(Map<String, Object> attributes) throws ProblemUnpackException {
        Object line = attributes.get("lineNumber");
        attributes.remove("lineNumber");
        if (!(line instanceof Integer)) {
            throw new ProblemUnpackException();
        }
        return (Integer)line;
    }

    private static String getPath(IMarker marker) throws ProblemUnpackException {
        try {
            return marker.getResource().getLocation().toOSString();
        }
        catch (Exception exception) {
            throw new ProblemUnpackException();
        }
    }

    private static DVTProblemKind extractProblemKind(Map<String, Object> attributes, DVTProblemCategory category) throws ProblemUnpackException {
        Object problemKindName = attributes.get(DVT_PROBLEM_KIND);
        if (!(problemKindName instanceof String)) {
            throw new ProblemUnpackException();
        }
        if (category == null) {
            for (DVTProblemCategory candidate : DVTProblemManager.getInstance().getAllCategories()) {
                if (candidate.getProblemKinds().get(problemKindName) == null) continue;
                category = candidate;
            }
        }
        if (category == null) {
            throw new ProblemUnpackException();
        }
        DVTProblemKind result = category.getProblemKinds().get(problemKindName);
        if (result == null) {
            throw new ProblemUnpackException();
        }
        attributes.remove(DVT_PROBLEM_KIND);
        return result;
    }

    private static IProject extractProject(Map<String, Object> attributes) throws ProblemUnpackException {
        Object projectName = attributes.get(DVT_PROBLEM_PROJECT_NAME);
        if (projectName == null || !(projectName instanceof String)) {
            throw new ProblemUnpackException();
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.toString());
        if (!(project != null && project.exists() && project.isAccessible() && project.isOpen())) {
            throw new ProblemUnpackException();
        }
        attributes.remove(DVT_PROBLEM_PROJECT_NAME);
        return project;
    }

    public static List<DVTProblem> fromMarkers(IProject project, DVTProblemCategory category) {
        ArrayList<DVTProblem> result = new ArrayList<DVTProblem>();
        if (project == null || category.getMarkerId() == null) {
            return result;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = project.findMarkers(category.getMarkerId(), true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                DVTProblem fromMarker = DVTMarkerFactory.fromMarker(marker, category);
                if (fromMarker != null) {
                    result.add(fromMarker);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    static class ProblemUnpackException
    extends Exception {
        private static final long serialVersionUID = 835997417268932724L;

        ProblemUnpackException() {
        }
    }
}

