/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;

public class DVTProblemDecorator
extends DVTAbstractDecorator {
    public static final String ID = "ro.amiq.dvt.DVTProblemDecorator";

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = (IResource)Platform.getAdapterManager().getAdapter(element, IResource.class);
        if (resource != null && (resource.getType() != 4 || ((IProject)resource).isOpen())) {
            ImageDescriptor overlay = null;
            switch (DVTProblemDecorator.getHighestProblemSeverity(resource)) {
                case 2: {
                    FieldDecoration errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                    if (errorDecoration == null) break;
                    overlay = ImageDescriptor.createFromImage((Image)errorDecoration.getImage());
                    break;
                }
                case 1: {
                    overlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
                }
            }
            if (overlay != null) {
                decoration.addOverlay(overlay, 2);
            }
        }
    }

    public static int getHighestProblemSeverity(IResource resource) {
        int problemSeverity = -1;
        try {
            IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                problemSeverity = Math.max(problemSeverity, marker.getAttribute("severity", -1));
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return problemSeverity;
    }
}

