/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.DVTUpdatePersistentJob;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.problems.DVTMarkerFactory;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTProblemsUiUpdater {
    public static final int MAX_MARKERS_PER_PROBLEM_CATEGORY = new Boolean(System.getenv("DVT_DISABLE_MAX_MARKERS_PER_PROBLEM_CATEGORY")) != false ? Integer.MAX_VALUE : 999;
    private final DVTProblemCategory fCategory;
    private final ConcurrentLinkedQueue<Runnable> fUpdateQueue = new ConcurrentLinkedQueue();
    private final Job fUpdateJob;
    private Map<String, Map<Severity, Integer>> fNofMarkers = new HashMap<String, Map<Severity, Integer>>();
    private final String GLUE = "__#__";

    public DVTProblemCategory getCategory() {
        return this.fCategory;
    }

    public DVTProblemsUiUpdater(DVTProblemCategory category) {
        this.fCategory = category;
        this.fUpdateJob = new DVTUpdatePersistentJob("Update " + this.fCategory.getDescription(), this.fUpdateQueue);
        this.fUpdateJob.schedule();
    }

    public void update(final IProject project) {
        try {
            final Map<String, Collection<DVTProblem>> problemsByFile = DVTProblemManager.getInstance().getProblemsWithCategoryByFile(project, this.fCategory);
            new Update(this, "Update", (IResource)project){
                Set<Severity> outsideProjectSeverities;
                {
                    super($anonymous0, $anonymous1);
                    this.outsideProjectSeverities = EnumSet.noneOf(Severity.class);
                }

                @Override
                public void update() throws Exception {
                    if (!project.isOpen() || !project.isAccessible()) {
                        return;
                    }
                    List<IFile> currentlyEditedFiles = Utils.getCurrentlyEditedFiles();
                    for (Map.Entry entry : problemsByFile.entrySet()) {
                        String file = (String)entry.getKey();
                        if (!project.isOpen()) {
                            return;
                        }
                        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, file);
                        if (iFile == null) {
                            this.reportOutsideProject(project, (Collection)entry.getValue());
                            continue;
                        }
                        HashMap<String, IMarker> existing = new HashMap<String, IMarker>();
                        IMarker[] iMarkerArray = iFile.findMarkers(fCategory.getMarkerId(), true, 0);
                        int n = iMarkerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker marker = iMarkerArray[n2];
                            existing.put(this.myHash(marker), marker);
                            ++n2;
                        }
                        for (DVTProblem problem : (Collection)entry.getValue()) {
                            if (this.getNofMarkers(project, problem.getSeverity()) - existing.size() > MAX_MARKERS_PER_PROBLEM_CATEGORY && !currentlyEditedFiles.contains(iFile)) continue;
                            String myHash = null;
                            if (!existing.isEmpty() && existing.containsKey(myHash = this.myHash(problem))) {
                                existing.remove(myHash);
                                continue;
                            }
                            DVTMarkerFactory.createMarker(problem, (IResource)iFile);
                            this.setNofMarkers(project, problem.getSeverity(), this.getNofMarkers(project, problem.getSeverity()) + 1);
                        }
                        for (IMarker marker : existing.values()) {
                            Severity sev = DVTMarkerFactory.toProblemSeverity(marker.getAttribute("severity", 0));
                            this.setNofMarkers(project, sev, this.getNofMarkers(project, sev) - 1);
                            marker.delete();
                        }
                    }
                    if (!project.isOpen()) {
                        return;
                    }
                    project.deleteMarkers(fCategory.getMarkerId(), true, 0);
                    for (Severity severity : this.outsideProjectSeverities) {
                        if (severity == Severity.WARNING) continue;
                        if (!project.isOpen()) {
                            return;
                        }
                        IMarker marker = project.createMarker(fCategory.getMarkerId());
                        marker.setAttribute("severity", DVTMarkerFactory.toMarkerSeverity(severity));
                        marker.setAttribute("message", (Object)("There are " + fCategory.getDescription() + " " + severity.name().toLowerCase() + "s reported on files outside the project;\n" + "to see individual markers, remove +dvt_auto_link+false build configuration directive"));
                    }
                }

                private void reportOutsideProject(IProject project2, Collection<DVTProblem> fileProblems) {
                    for (DVTProblem p : fileProblems) {
                        this.outsideProjectSeverities.add(p.getSeverity());
                    }
                }
            };
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void clean(final IProject project) {
        try {
            new Update(this, "Clean", (IResource)project){

                @Override
                public void update() throws Exception {
                    block3: {
                        if (!project.isOpen() || !project.isAccessible()) {
                            return;
                        }
                        try {
                            project.deleteMarkers(fCategory.getMarkerId(), true, 2);
                        }
                        catch (CoreException e) {
                            String message = e.getMessage();
                            if (message.startsWith("Resource '/" + project.getName() + "' is not open.") || message.startsWith("Resource '/" + project.getName() + "' does not exist.")) break block3;
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    this.resetNofMarkers(project);
                }
            };
            if (!project.isOpen() || !project.isAccessible()) {
                return;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void update(final IFile file, final boolean useMarkerLimits) {
        try {
            if (file == null) {
                return;
            }
            IPath filePath = file.getLocation();
            if (filePath == null) {
                return;
            }
            final Collection<DVTProblem> fileProblems = DVTProblemManager.getInstance().getProblemsWithCategoryAndPath(file.getProject(), this.fCategory, filePath.toOSString());
            new Update(this, "Update", (IResource)file){

                @Override
                public void update() throws Exception {
                    IProject project = file.getProject();
                    if (project == null || !project.isOpen() || !file.isAccessible()) {
                        return;
                    }
                    HashMap<String, IMarker> existing = new HashMap<String, IMarker>();
                    IMarker[] iMarkerArray = file.findMarkers(fCategory.getMarkerId(), true, 0);
                    int n = iMarkerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        existing.put(this.myHash(marker), marker);
                        ++n2;
                    }
                    for (DVTProblem fileProblem : fileProblems) {
                        if (fileProblem == null || useMarkerLimits && this.getNofMarkers(project, fileProblem.getSeverity()) > MAX_MARKERS_PER_PROBLEM_CATEGORY) continue;
                        if (existing.containsKey(this.myHash(fileProblem))) {
                            existing.remove(this.myHash(fileProblem));
                            continue;
                        }
                        DVTMarkerFactory.createMarker(fileProblem, (IResource)file);
                        this.setNofMarkers(project, fileProblem.getSeverity(), this.getNofMarkers(project, fileProblem.getSeverity()) + 1);
                    }
                    for (IMarker marker : existing.values()) {
                        Severity sev = DVTMarkerFactory.toProblemSeverity(marker.getAttribute("severity", 0));
                        this.setNofMarkers(project, sev, this.getNofMarkers(project, sev) - 1);
                        marker.delete();
                    }
                }
            };
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateOutsideErrors(final IProject project) {
        try {
            new Update(this, "Update Outside Errors", (IResource)project){

                @Override
                public void update() throws Exception {
                    if (!project.isOpen() || !project.isAccessible()) {
                        return;
                    }
                    project.deleteMarkers(fCategory.getMarkerId(), true, 0);
                    IMarker marker = project.createMarker(fCategory.getMarkerId());
                    marker.setAttribute("severity", DVTMarkerFactory.toMarkerSeverity(Severity.ERROR));
                    marker.setAttribute("message", (Object)("There are " + fCategory.getDescription() + " " + Severity.ERROR.name().toLowerCase() + "s reported on files outside the project;\n" + "to see individual markers, remove +dvt_auto_link+false build configuration directive"));
                }
            };
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public int getNofMarkers(IProject project, Severity severity) {
        Map<Severity, Integer> nofMarkersMap = this.fNofMarkers.get(project.getName());
        if (nofMarkersMap == null) {
            return 0;
        }
        if (nofMarkersMap.get((Object)severity) == null) {
            return 0;
        }
        return nofMarkersMap.get((Object)severity);
    }

    public void setNofMarkers(IProject project, Severity severity, int nofMarkers) {
        Map<Severity, Integer> nofMarkersMap = this.fNofMarkers.get(project.getName());
        if (nofMarkersMap == null) {
            nofMarkersMap = new EnumMap<Severity, Integer>(Severity.class);
            this.fNofMarkers.put(project.getName(), nofMarkersMap);
        }
        nofMarkersMap.put(severity, nofMarkers);
    }

    public void resetNofMarkers(IProject project) {
        this.fNofMarkers.put(project.getName(), new EnumMap(Severity.class));
        Iterator<String> iterator = this.fNofMarkers.keySet().iterator();
        while (iterator.hasNext()) {
            String projectName = iterator.next();
            if (ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) continue;
            iterator.remove();
        }
    }

    private String myHash(DVTProblem problem) {
        return problem == null ? "" : DVTStringUtil.appendString(problem.getLine(), "__#__", problem.getMessage());
    }

    private String myHash(IMarker marker) {
        return marker == null ? "" : String.valueOf(marker.getAttribute("lineNumber", -1)) + "__#__" + marker.getAttribute("message", "");
    }

    public synchronized void scheduleObjectionsClear(IProject project) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        this.fUpdateQueue.offer(new Runnable(){

            @Override
            public void run() {
                ObjectionManager.getInstance().clear(DVTProblemsUiUpdater.this.fCategory);
            }
        });
    }

    private abstract class Update
    implements Runnable {
        public String fJobName;

        public Update(String action, IResource resource) {
            this.fJobName = String.valueOf(action) + " " + DVTProblemsUiUpdater.this.fCategory.getDescription() + " markers for " + resource.getFullPath().toOSString();
            DVTProblemsUiUpdater.this.fUpdateQueue.offer(this);
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public abstract void update() throws Exception;
    }
}

