/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DummyDVTProblemsUiUpdater;

public class DVTProblemsUiUpdaterRegistry {
    private static Map<String, DVTProblemsUiUpdater> fRegistry = new ConcurrentHashMap<String, DVTProblemsUiUpdater>();
    private static DVTProblemsUiUpdater fDummyUpdater = new DummyDVTProblemsUiUpdater();

    public static void register(DVTProblemsUiUpdater updater) {
        if (updater.getCategory() == null) {
            return;
        }
        fRegistry.put(updater.getCategory().getId(), updater);
    }

    public static DVTProblemsUiUpdater get(String problemCategory) {
        DVTProblemsUiUpdater problemsUpdater = fRegistry.get(problemCategory);
        if (problemsUpdater == null) {
            return fDummyUpdater;
        }
        return problemsUpdater;
    }

    public static Collection<DVTProblemsUiUpdater> getAll() {
        return fRegistry.values();
    }

    public static void stopAll() {
        fRegistry.clear();
    }
}

