/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversConstants;
import ro.amiq.dvt.ui.Utils;

public class EditWaiversHandler
extends AbstractHandler
implements IHandler {
    public static final String ID = "org.eclipse.ui.views.problems.editDVTProblemWaivers";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String overwriteStringParameter;
        IFile waiversFile;
        block5: {
            try {
                waiversFile = this.getWaiversFile(event);
                if (waiversFile != null) break block5;
                return null;
            }
            catch (Exception e) {
                throw new ExecutionException("Unable to edit waivers file", (Throwable)e);
            }
        }
        waiversFile.refreshLocal(0, null);
        if (!waiversFile.exists()) {
            InputStream stream = EditWaiversHandler.class.getResource("waivers.xml").openStream();
            waiversFile.create(stream, false, null);
            stream.close();
        }
        if ((overwriteStringParameter = event.getParameter("overwrite")) != null && Boolean.parseBoolean(overwriteStringParameter)) {
            InputStream stream = EditWaiversHandler.class.getResource("waivers.xml").openStream();
            waiversFile.setContents(stream, 0, null);
            stream.close();
        }
        IDE.openEditor((IWorkbenchPage)Utils.getActiveWorkbenchWindow().getActivePage(), (IFile)waiversFile);
        return null;
    }

    private IFile getWaiversFile(ExecutionEvent event) {
        String filePath = event.getParameter("filePath");
        if (filePath != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)filePath));
        }
        IProject project = Utils.selectProject(new String[]{"ro.amiq.vhdldt.VhdlNature", "ro.amiq.vlogdt.VlogNature", "ro.amiq.edt.enature", "ro.amiq.slndt.slnnature", "ro.amiq.msdldt.msdlnature", "ro.amiq.pssdt.pssnature", "ro.amiq.dvt.dvtnature"}, "For which projects do you want to edit waivers?", null, DVTPlugin.getSelectionManager().getLastSelectedProject() == null ? null : DVTPlugin.getSelectionManager().getLastSelectedProject());
        return project.getFile(CompileWaiversConstants.XML_PROJECT_RELATIVE_PATH);
    }
}

