/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.MarkerViewUtil;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.problems.PreviousProblem;

public class NextProblem
extends AbstractHandler {
    public static final String PROBLEMS_VIEW_ID = "org.eclipse.ui.views.ProblemView";

    IStructuredSelection getSelection(ExecutionEvent event) {
        IWorkbenchSite wbSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (wbSite == null) {
            return null;
        }
        ISelectionProvider selProvider = wbSite.getSelectionProvider();
        if (selProvider == null) {
            return null;
        }
        ISelection sel = selProvider.getSelection();
        if (sel instanceof IStructuredSelection) {
            return (IStructuredSelection)sel;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block5: {
            List<IMarker> visibleMarkers;
            block4: {
                visibleMarkers = NextProblem.getCurrentlyVisibleMarkersFromView(PROBLEMS_VIEW_ID);
                if (visibleMarkers != null && !visibleMarkers.isEmpty()) break block4;
                return null;
            }
            try {
                IMarker initialMarker = this.getInitialMarker(event);
                if (initialMarker == null) {
                    IMarker firstMarker = visibleMarkers.stream().filter(m -> m.getAttribute("severity", -1) == 2).findFirst().orElse(visibleMarkers.get(0));
                    this.openMarker(firstMarker);
                    break block5;
                }
                String direction = event.getParameter("direction");
                direction = direction == null ? (this instanceof PreviousProblem ? "previous" : "next") : direction;
                int idxCurrMarker = visibleMarkers.indexOf(initialMarker);
                int idxNextMarker = idxCurrMarker + (direction.equals("next") ? 1 : -1);
                idxNextMarker = (idxNextMarker + visibleMarkers.size()) % visibleMarkers.size();
                this.openMarker(visibleMarkers.get(idxNextMarker));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e.toString());
            }
        }
        return null;
    }

    private void openMarker(IMarker marker) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
        MarkerViewUtil.showMarker((IWorkbenchPage)page, (IMarker)marker, (boolean)true);
    }

    private IMarker getInitialMarker(ExecutionEvent event) {
        IStructuredSelection selection = this.getSelection(event);
        if (selection == null || selection.getFirstElement() == null) {
            return null;
        }
        return ((MarkerItem)selection.getFirstElement()).getMarker();
    }

    public static List<IMarker> getCurrentlyVisibleMarkersFromView(String viewId) {
        List<Object> elements;
        block8: {
            IContentProvider contentProvider;
            block7: {
                Object viewer;
                block6: {
                    IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
                    viewer = NextProblem.invokePrivateMethod(view, "getViewer", new Class[0]);
                    if (viewer instanceof TreeViewer) break block6;
                    return null;
                }
                contentProvider = ((TreeViewer)viewer).getContentProvider();
                if (contentProvider instanceof ITreeContentProvider) break block7;
                return null;
            }
            elements = NextProblem.collectLeaves((ITreeContentProvider)contentProvider);
            if (elements != null) break block8;
            return null;
        }
        try {
            ArrayList<IMarker> visibleMarkers = new ArrayList<IMarker>();
            for (Object element : elements) {
                if (!(element instanceof MarkerItem)) continue;
                visibleMarkers.add(((MarkerItem)element).getMarker());
            }
            return visibleMarkers;
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
            return null;
        }
    }

    private static List<Object> collectLeaves(ITreeContentProvider contentProvider) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Object> elements = new ArrayList<Object>(Arrays.asList(contentProvider.getElements(null)));
        while (!elements.isEmpty()) {
            Object currElem = elements.remove(0);
            if (contentProvider.hasChildren(currElem)) {
                elements.addAll(Arrays.asList(contentProvider.getChildren(currElem)));
                continue;
            }
            result.add(currElem);
        }
        return result;
    }

    public static Object invokePrivateMethod(Object o, String methodName, Class<?>[] params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        if (o == null || methodName == null || params == null) {
            return null;
        }
        Class<?> c = o.getClass();
        while (c != null) {
            try {
                Method m = c.getDeclaredMethod(methodName, params);
                m.setAccessible(true);
                return m.invoke(o, (Object[])params);
            }
            catch (Throwable throwable) {
                c = c.getSuperclass();
            }
        }
        return null;
    }
}

