/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.problems;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.views.DVTQuickViewersUtil;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.problems.ReapplyWaiversHandlerCommon;

public class ReapplyWaiversHandler
extends ReapplyWaiversHandlerCommon {
    public static final String ID = "org.eclipse.ui.views.problems.reapplyDVTProblemWaivers";
    private static final String DIALOG_TITLE = "Cannot reapply waivers";
    private static final String WAIVERS_REAPPLYING_HEADER = "Waivers are already being applied for the following project(s).";
    private static final String FULL_BUILD_HEADER = "Project build for the following project(s). Waivers will be automatically applied afterwards.";
    private static final String INCREMENTAL_BUILD_HEADER = "Project incremental build for the following project(s). Please reapply waivers afterwards.";

    public static void reapplyWaivers(IProject project) {
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)activeWorkbenchWindow.getService(ICommandService.class);
        ParameterizedCommand reapplyWaiversCommand = ParameterizedCommand.generateCommand((Command)commandService.getCommand(ID), (Map)ImmutableMap.of((Object)"projectsList", (Object)project.getName()));
        try {
            handlerService.executeCommand(reapplyWaiversCommand, null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IProject> projects = new ArrayList<IProject>(4);
        String projectsNamesParameter = event.getParameter("projectsList");
        if (projectsNamesParameter != null) {
            String[] projectsNames;
            String[] stringArray = projectsNames = projectsNamesParameter.split(";");
            int n = projectsNames.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName = stringArray[n2];
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                projects.add(project);
                ++n2;
            }
        }
        if (projects.isEmpty()) {
            IProject lastSelectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
            if (!TestHelper.isTestMode() || TestHelper.isSWTBotSuite()) {
                IProject[] iProjectArray;
                String[] stringArray = new String[]{"ro.amiq.edt.enature", "ro.amiq.slndt.slnnature", "ro.amiq.msdldt.msdlnature", "ro.amiq.pssdt.pssnature", "ro.amiq.vlogdt.VlogNature", "ro.amiq.vhdldt.VhdlNature", "ro.amiq.dvt.dvtnature"};
                if (lastSelectedProject == null) {
                    iProjectArray = null;
                } else {
                    IProject[] iProjectArray2 = new IProject[1];
                    iProjectArray = iProjectArray2;
                    iProjectArray2[0] = lastSelectedProject;
                }
                projects = Utils.selectProjects(stringArray, "For which projects do you want to reapply waivers?", null, iProjectArray);
            } else if (lastSelectedProject != null) {
                projects.add(lastSelectedProject);
            }
        }
        if (projects == null || projects.isEmpty()) {
            return null;
        }
        this.reapplyWaivers(this.computeEnabledProjects(projects));
        return null;
    }

    private List<IProject> computeEnabledProjects(List<IProject> projects) {
        EnumMap<ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus, List<IProject>> disabledProjectsMap = new EnumMap<ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus, List<IProject>>(ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus.class);
        ArrayList<IProject> enabledProjects = new ArrayList<IProject>();
        for (IProject project : projects) {
            ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus projectEnableStatus = ReapplyWaiversHandler.getEnableStatus(project);
            if (projectEnableStatus == null || projectEnableStatus == ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus.ENABLED) {
                enabledProjects.add(project);
                continue;
            }
            ArrayList<IProject> disabledProjects = (ArrayList<IProject>)disabledProjectsMap.get((Object)projectEnableStatus);
            if (disabledProjects == null) {
                disabledProjects = new ArrayList<IProject>();
            }
            disabledProjects.add(project);
            disabledProjectsMap.put(projectEnableStatus, disabledProjects);
        }
        if (!disabledProjectsMap.isEmpty()) {
            this.displayDisabledProjects(disabledProjectsMap);
        }
        return enabledProjects;
    }

    private void displayDisabledProjects(Map<ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus, List<IProject>> disabledReasons) {
        StringBuilder message = new StringBuilder();
        block5: for (Map.Entry<ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus, List<IProject>> entry : disabledReasons.entrySet()) {
            ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus reason = entry.getKey();
            List<IProject> disabledProjects = entry.getValue();
            String messageHeader = "";
            switch (reason) {
                case DISABLED_WAIVERS_REAPPLYING: {
                    messageHeader = WAIVERS_REAPPLYING_HEADER;
                    break;
                }
                case DISABLED_FULL_BUILD: {
                    messageHeader = FULL_BUILD_HEADER;
                    break;
                }
                case DISABLED_INCREMENTAL_BUILD: {
                    messageHeader = INCREMENTAL_BUILD_HEADER;
                    break;
                }
                default: {
                    continue block5;
                }
            }
            message.append(messageHeader).append("\n\t").append(disabledProjects.stream().map(project -> "'" + project.getName() + "'").collect(Collectors.joining("\n\t"))).append("\n\n");
        }
        if (message.length() != 0) {
            MessageDialog dialog = new MessageDialog(Utils.getActiveShell(), DIALOG_TITLE, null, message.toString().trim(), 4, 0, new String[]{IDialogConstants.OK_LABEL});
            dialog.open();
        }
    }

    private void reapplyWaivers(List<IProject> enabledProjects) {
        for (IProject project : enabledProjects) {
            ReapplyWaiversHandler.setEnableStatus(project, ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus.DISABLED_WAIVERS_REAPPLYING);
            Job job = new Job("Reapply Waivers"){
                private IProject project;

                protected IStatus run(IProgressMonitor monitor) {
                    long startTimestamp = System.currentTimeMillis();
                    DVTProblemManager.getInstance().clearWaivers(this.project);
                    CompileWaiversManager.INSTANCE.loadWaivers(this.project);
                    DVTProblemManager.getInstance().applyWaivers(this.project);
                    for (DVTProblemsUiUpdater updater : DVTProblemsUiUpdaterRegistry.getAll()) {
                        if (!ReapplyWaiversHandler.this.updaterAppliesToProject(updater, this.project)) continue;
                        updater.clean(this.project);
                    }
                    for (DVTProblemsUiUpdater updater : DVTProblemsUiUpdaterRegistry.getAll()) {
                        if (!ReapplyWaiversHandler.this.updaterAppliesToProject(updater, this.project)) continue;
                        updater.update(this.project);
                        updater.scheduleObjectionsClear(this.project);
                    }
                    DVTBuildConsoleRegistry.getConsole(this.project).print("Reapply waivers [" + (System.currentTimeMillis() - startTimestamp) + "ms]");
                    DVTQuickViewersUtil.updateErrorsInCompileOrder(this.project);
                    ReapplyWaiversHandler.setEnableStatus(this.project, ReapplyWaiversHandlerCommon.ReapplyWaiversEnableStatus.ENABLED);
                    return Status.OK_STATUS;
                }

                public Job setProject(IProject project) {
                    this.project = project;
                    return this;
                }
            }.setProject(project);
            job.schedule();
        }
    }

    private boolean updaterAppliesToProject(DVTProblemsUiUpdater updater, IProject project) {
        LanguageKind languageKind;
        block4: {
            languageKind = updater.getCategory().getLanguageKind();
            if (languageKind != null && !languageKind.equals((Object)LanguageKind.BC)) break block4;
            return true;
        }
        try {
            if (project.hasNature(languageKind.NATURE_ID)) {
                return true;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }
}

