/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.projectcolors;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.projectcolors.ProjectColorDialog;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;

public class PickAColorForProjectCommand
extends AbstractHandler {
    public static final String COMMAND_ID = "ro.amiq.dvt.ui.PickAColorForProjectCommand";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!DVTPlugin.getDefault().getPreferenceStore().getBoolean("perProjectColors")) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object element = structuredSelection.getFirstElement();
        if (!(element instanceof IResource)) {
            return null;
        }
        IProject project = ((IResource)element).getProject();
        ProjectColorDialog cd = new ProjectColorDialog(project.getName());
        int status = cd.open();
        if (status != 0) {
            return null;
        }
        ProjectColorUtils.setCustomColor(project.getName(), cd.getHue());
        ProjectColorUtils.refreshViewsWithNewColors();
        return null;
    }
}

