/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.projectcolors;

import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class ProjectColorDialog
extends Dialog {
    private static final String MSG_TITLE = "Select Color for ''{0}''";
    private static final String MSG_MESSAGE = "Drag the slider to preview available colors:";
    private String fProjectName;
    private float fHue;
    private String fFgOrBgPreference;
    private Label fProjectPreveiewLabel;
    private Map<IconType, Label> fIconLabels = new EnumMap<IconType, Label>(IconType.class);
    SelectionAdapter fSliderListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!(e.widget instanceof Slider)) {
                return;
            }
            ProjectColorDialog.this.fHue = ((Slider)e.widget).getSelection();
            ProjectColorDialog.this.updateColors();
        }
    };

    public ProjectColorDialog(String projectName) {
        super(Utils.getActiveShell());
        this.fProjectName = projectName;
        this.fHue = ProjectColorUtils.getBackgroundColor(this.fProjectName).getRGB().getHSB()[0];
        this.fFgOrBgPreference = DVTPlugin.getDefault().getPreferenceStore().getString("perProjectColorsFgBg");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageFormat.format(MSG_TITLE, this.fProjectName));
    }

    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Label messageLabel = new Label(superComposite, 0);
        messageLabel.setText(MSG_MESSAGE);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)messageLabel);
        Slider slider = new Slider(superComposite, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)slider);
        slider.setMaximum(360);
        Group previewGroup = new Group(superComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)previewGroup);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)previewGroup);
        previewGroup.setText("Preview");
        new Label((Composite)previewGroup, 0).setText("Project " + this.fFgOrBgPreference + ":");
        this.fProjectPreveiewLabel = new Label((Composite)previewGroup, 0);
        this.fProjectPreveiewLabel.setText(" " + this.fProjectName + " ");
        new Label((Composite)previewGroup, 0).setText("Editor icons:");
        Composite iconsComposite = new Composite((Composite)previewGroup, 0);
        RowLayoutFactory.fillDefaults().margins(0, 0).applyTo(iconsComposite);
        IconType[] iconTypeArray = IconType.values();
        int n = iconTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconType iconType = iconTypeArray[n2];
            Label iconLabel = new Label(iconsComposite, 0);
            iconLabel.setImage(DVTImages.imageCache.getImage(iconType.imageDescriptor));
            this.fIconLabels.put(iconType, iconLabel);
            ++n2;
        }
        slider.setSelection((int)this.fHue);
        this.updateColors();
        slider.addSelectionListener((SelectionListener)this.fSliderListener);
        return superComposite;
    }

    private void updateColors() {
        Color[] fgBg = ProjectColorUtils.computeFgBgColors(this.fHue, this.fProjectName);
        if (this.fFgOrBgPreference.equals("background")) {
            DVTColorUtil.INSTANCE.setBackground((Control)this.fProjectPreveiewLabel, fgBg[1]);
        } else if (this.fFgOrBgPreference.equals("text")) {
            DVTColorUtil.INSTANCE.setForeground((Control)this.fProjectPreveiewLabel, fgBg[0]);
        }
        for (Map.Entry<IconType, Label> entry : this.fIconLabels.entrySet()) {
            IconType iconType = entry.getKey();
            Image newImage = ProjectColorUtils.transformImage(iconType.imageDescriptor, fgBg[1]);
            entry.getValue().setImage(newImage);
        }
    }

    public float getHue() {
        return this.fHue;
    }

    private static enum IconType {
        E(DVTImages.DESC_E_MODULE_BLACK_TRANSPARENT),
        SLN(DVTImages.DESC_SLN_MODULE_BLACK_TRANSPARENT),
        V(DVTImages.DESC_VLOG_MODULE_BLACK_TRANSPARENT),
        BC(DVTImages.DESC_BC_MODULE_BLACK_TRANSPARENT);

        private ImageDescriptor imageDescriptor;

        private IconType(ImageDescriptor imageDescriptor) {
            this.imageDescriptor = imageDescriptor;
        }
    }
}

