/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.projectcolors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorsRGBUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTColoredView;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.utils.DVTImageColorUtil;

public class ProjectColorUtils {
    private static final Map<String, Color[]> COLOR_MAP = new HashMap<String, Color[]>();
    public static final String OVERRIDE_ICON_IMAGE_KEY = "e4_override_icon_image_key";
    private static final String ICON_URI = "IconUriForPart";
    private static final String EDITOR_REFERENCE_KEY = "org.eclipse.ui.IWorkbenchPartReference";
    private static Map<String, String> transparentNameMap = new HashMap<String, String>();

    static {
        transparentNameMap.put("vlog_file_obj.png", "vlog_file_obj_black_transparent.png");
        transparentNameMap.put("e_file_obj.png", "e_file_obj_black_transparent.png");
        transparentNameMap.put("buildfile.png", "buildfile_black_transparent.png");
        transparentNameMap.put("pvlog_file_obj.png", "pvlog_file_obj_black_transparent.png");
    }

    public static void injectCustomColors() {
        Map<String, Color[]> prefColors = PrefConst.getAllCustomColorsForProjects();
        COLOR_MAP.putAll(prefColors);
    }

    public static void resetColor(String projectName) {
        PrefConst.removeCustomColorForProject(projectName);
        COLOR_MAP.remove(projectName);
    }

    public static void setCustomColor(String projectName, float hue) {
        Color[] fgBg = ProjectColorUtils.computeFgBgColors(hue, projectName);
        PrefConst.setCustomColorForProject(projectName, fgBg);
        COLOR_MAP.put(projectName, fgBg);
    }

    public static void setRandomColor(String projectName) {
        float newHue = ProjectColorUtils.getRandomHue();
        Color[] fgBg = ProjectColorUtils.computeFgBgColors(newHue, projectName);
        PrefConst.setCustomColorForProject(projectName, fgBg);
        COLOR_MAP.put(projectName, fgBg);
    }

    public static Color getBackgroundColor(String projectName) {
        Boolean enable = DVTPlugin.getDefault().getPreferenceStore().getBoolean("perProjectColors");
        if (!enable.booleanValue() || projectName == null) {
            return null;
        }
        ProjectColorUtils.computeColorAndUpdateMap(projectName);
        return COLOR_MAP.get(projectName)[1];
    }

    public static Color getForegroundColor(String projectName) {
        Boolean enable = DVTPlugin.getDefault().getPreferenceStore().getBoolean("perProjectColors");
        if (!enable.booleanValue() || projectName == null) {
            return null;
        }
        ProjectColorUtils.computeColorAndUpdateMap(projectName);
        return COLOR_MAP.get(projectName)[0];
    }

    public static void refreshViewsWithNewColors() {
        ProjectColorUtils.colorFiles();
        ProjectColorUtils.updateViews();
        IWorkbenchPage activePage = Utils.getActivePage();
        if (activePage == null) {
            return;
        }
        IViewPart viewPart = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (!(viewPart instanceof CommonNavigator)) {
            return;
        }
        INavigatorContentService navigatorContentService = ((CommonNavigator)viewPart).getNavigatorContentService();
        if (navigatorContentService == null) {
            return;
        }
        navigatorContentService.update();
    }

    public static Color[] computeFgBgColors(float hue, String projectName) {
        Color colorT = DVTColorUtil.INSTANCE.getColor(ProjectColorsRGBUtils.customizeForegroundRGB(projectName, hue));
        Color colorB = DVTColorUtil.INSTANCE.getColor(ProjectColorsRGBUtils.customizeBackgroundRGB(projectName, hue));
        return new Color[]{colorT, colorB};
    }

    public static Image transformImage(ImageDescriptor transparentImageDesc, String projectName) {
        if (projectName == null) {
            return null;
        }
        if (!DVTPlugin.getDefault().getPreferenceStore().getBoolean("perProjectColors")) {
            return null;
        }
        return ProjectColorUtils.transformImage(transparentImageDesc, ProjectColorUtils.getBackgroundColor(projectName));
    }

    public static Image transformImage(ImageDescriptor transparentImageDesc, Color color) {
        if (transparentImageDesc == null) {
            return null;
        }
        if (color == null) {
            return null;
        }
        if (!EclipseUtils.isEclipse4x()) {
            return null;
        }
        Image result = DVTImageColorUtil.getInstance().getImage(transparentImageDesc, color.getRGB());
        GC gc = new GC((Drawable)result);
        gc.setBackground(color);
        if (transparentImageDesc.equals(DVTImages.DESC_PVLOG_MODULE_BLACK_TRANSPARENT)) {
            int[] nArray = new int[20];
            nArray[1] = 7;
            nArray[2] = 4;
            nArray[3] = 7;
            nArray[4] = 4;
            nArray[6] = 9;
            nArray[8] = 9;
            nArray[9] = 2;
            nArray[10] = 11;
            nArray[11] = 2;
            nArray[12] = 11;
            nArray[13] = 9;
            nArray[14] = 6;
            nArray[15] = 9;
            nArray[16] = 6;
            nArray[17] = 15;
            nArray[19] = 15;
            gc.fillPolygon(nArray);
        } else {
            gc.fillPolygon(new int[]{3, 1, 8, 1, 8, 5, 12, 5, 12, 14, 3, 14});
        }
        gc.drawImage(DVTImages.imageCache.getImage(transparentImageDesc), 0, 0);
        gc.dispose();
        return result;
    }

    public static void setFgBg(IDVTColoredView view, String projectName) {
        if (view == null) {
            return;
        }
        Control background = view.getControlToColorBg();
        Control foreground = view.getControlToColorFg();
        ProjectColorUtils.setFgBg(foreground, background, projectName);
    }

    private static void setFgBg(Control foreground, Control background, String projectName) {
        Color color;
        if (foreground == null || background == null) {
            return;
        }
        String fgOrBg = DVTPlugin.getDefault().getPreferenceStore().getString("perProjectColorsFgBg");
        if ("background".equals(fgOrBg) && (color = ProjectColorUtils.getBackgroundColor(projectName)) != null) {
            DVTColorUtil.INSTANCE.setBackground(background, color);
            DVTColorUtil.INSTANCE.setForeground(foreground, DVTColorUtil.INSTANCE.getDefaultForeground(foreground));
            return;
        }
        if ("text".equals(fgOrBg) && (color = ProjectColorUtils.getForegroundColor(projectName)) != null) {
            DVTColorUtil.INSTANCE.setBackground(background, DVTColorUtil.INSTANCE.getBackground((Control)background.getParent()));
            DVTColorUtil.INSTANCE.setForeground(foreground, color);
            return;
        }
        DVTColorUtil.INSTANCE.setBackground(background, DVTColorUtil.INSTANCE.getDefaultBackground(background));
        DVTColorUtil.INSTANCE.setForeground(foreground, DVTColorUtil.INSTANCE.getDefaultForeground(foreground));
    }

    private static float getRandomHue() {
        TreeSet<Float> values = new TreeSet<Float>();
        COLOR_MAP.values().forEach(colors -> {
            boolean bl = values.add(Float.valueOf(colors[0].getRGB().getHSB()[0]));
        });
        values.add(Float.valueOf(360.0f));
        float offset = 0.0f;
        float lastEl = 0.0f;
        float maxDiff = 0.0f;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            float curentEl = ((Float)it.next()).floatValue();
            float curentDiff = curentEl - lastEl;
            if (curentDiff > maxDiff) {
                maxDiff = curentDiff;
                offset = lastEl;
            }
            lastEl = curentEl;
        }
        return offset + maxDiff / 2.0f;
    }

    private static void computeColorAndUpdateMap(String projectName) {
        if (COLOR_MAP.containsKey(projectName)) {
            return;
        }
        Color foreground = DVTColorUtil.INSTANCE.getColor(ProjectColorsRGBUtils.makeForegroundRGB(projectName));
        Color background = DVTColorUtil.INSTANCE.getColor(ProjectColorsRGBUtils.makeBackgroundRGB(projectName));
        COLOR_MAP.put(projectName, new Color[]{foreground, background});
    }

    public static void updateViews() {
        Set<IDVTView> views = DVTViewManager.getInstanceByCurrentWorkbenchWindow().getViews();
        for (IDVTView view : views) {
            IProject project = view.getProject();
            if (project == null || !project.isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(project)) {
                ProjectColorUtils.setFgBg(view, null);
                continue;
            }
            ProjectColorUtils.setFgBg(view, project.getName());
        }
    }

    public static void colorFiles() {
        block7: {
            try {
                boolean doIt = DVTPlugin.getDefault().getPreferenceStore().getBoolean("perProjectColors");
                if (doIt) {
                    for (IEditorReference ref : Utils.getCurrentlyOpenEditorReferences()) {
                        Map<String, Object> transientData = ProjectColorUtils.safeSetPartIcon(ref);
                        if (transientData != null) {
                            String newIconName;
                            String pathToIcon = (String)transientData.get(ICON_URI);
                            if (pathToIcon == null || (newIconName = ProjectColorUtils.getBlackTransparentIconName(pathToIcon)) == null) continue;
                            ImageDescriptor transparentID = Utils.createDescriptor("obj16", newIconName);
                            String projectName = ProjectColorUtils.getProjectName(ref);
                            if (projectName == null) continue;
                            Image newImage = ProjectColorUtils.transformImage(transparentID, projectName);
                            transientData.put(OVERRIDE_ICON_IMAGE_KEY, newImage);
                            continue;
                        }
                        break block7;
                    }
                    break block7;
                }
                for (IEditorReference ref : Utils.getCurrentlyOpenEditorReferences()) {
                    Map<String, Object> transientData = ProjectColorUtils.safeSetPartIcon(ref);
                    if (transientData != null) {
                        transientData.remove(OVERRIDE_ICON_IMAGE_KEY);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                DVTLogger.INSTANCE.logError(t);
            }
        }
    }

    private static Map<String, Object> safeSetPartIcon(IEditorReference ref) {
        Object transientData;
        block9: {
            Method getTransientDataMethod;
            Object part;
            block8: {
                block7: {
                    Method getModelMethod;
                    block6: {
                        try {
                            getModelMethod = ProjectColorUtils.getDeclaredMethodRecursive(ref, "getModel", new Class[0]);
                            if (getModelMethod != null) break block6;
                            return null;
                        }
                        catch (Throwable t) {
                            DVTLogger.INSTANCE.logError(t);
                            return null;
                        }
                    }
                    part = getModelMethod.invoke((Object)ref, new Object[0]);
                    if (part != null) break block7;
                    return null;
                }
                getTransientDataMethod = ProjectColorUtils.getDeclaredMethodRecursive(part, "getTransientData", new Class[0]);
                if (getTransientDataMethod != null) break block8;
                return null;
            }
            transientData = getTransientDataMethod.invoke(part, new Object[0]);
            if (transientData != null && transientData instanceof Map) break block9;
            return null;
        }
        return (Map)transientData;
    }

    public static Method getDeclaredMethodRecursive(Object o, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        if (o == null || methodName == null) {
            return null;
        }
        Class<?> objectClass = o.getClass();
        while (objectClass != null) {
            Method result = null;
            try {
                result = objectClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Throwable throwable) {}
            if (result != null) {
                return result;
            }
            objectClass = objectClass.getSuperclass();
        }
        return null;
    }

    private static String getProjectName(IEditorReference editorRef) {
        IProject project;
        block7: {
            IFile iFile;
            block6: {
                block5: {
                    try {
                        if (editorRef.getEditorInput() instanceof FileEditorInput) break block5;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                iFile = ((FileEditorInput)editorRef.getEditorInput()).getFile();
                if (iFile != null) break block6;
                return null;
            }
            project = iFile.getProject();
            if (project != null) break block7;
            return null;
        }
        return project.getName();
    }

    private static String getBlackTransparentIconName(String path) {
        String fileName = Path.fromOSString((String)path).lastSegment();
        return fileName == null ? null : transparentNameMap.get(fileName);
    }
}

