/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.projectcolors;

import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;

public class ProjectColorsRGBUtils {
    private static final int NOF_PREDEFINED_COLORS = 16;
    private static final float FG_BRIGHTNESS = 0.5f;
    private static final float BG_BRIGHTNESS = 0.9f;
    private static final float FG_SAT_OFFSET = 0.4f;
    private static final float BG_SAT_OFFSET = 0.2f;

    public static RGB makeBackgroundRGB(String name) {
        Integer[] hashes = ProjectColorsRGBUtils.myHashes(name);
        float bri = DVTThemeUtils.isDarkUI() ? 0.5f : 0.9f;
        float satOffset = DVTThemeUtils.isDarkUI() ? 0.4f : 0.2f;
        float hue = 360.0f * (float)hashes[0].intValue() / 16.0f;
        float sat = satOffset + (float)hashes[1].intValue() / 16.0f * (1.0f - Math.max(0.4f, 0.2f));
        return new RGB(hue, sat, bri);
    }

    public static RGB makeForegroundRGB(String name) {
        Integer[] hashes = ProjectColorsRGBUtils.myHashes(name);
        float bri = DVTThemeUtils.isDarkUI() ? 0.9f : 0.5f;
        float satOffset = DVTThemeUtils.isDarkUI() ? 0.2f : 0.4f;
        float hue = 360.0f * (float)hashes[0].intValue() / 16.0f;
        float sat = satOffset + (float)hashes[1].intValue() / 16.0f * (1.0f - Math.max(0.4f, 0.2f));
        return new RGB(hue, sat, bri);
    }

    public static RGB customizeBackgroundRGB(String name, float hue) {
        Integer[] hashes = ProjectColorsRGBUtils.myHashes(name);
        float bri = DVTThemeUtils.isDarkUI() ? 0.5f : 0.9f;
        float satOffset = DVTThemeUtils.isDarkUI() ? 0.4f : 0.2f;
        return new RGB(hue, satOffset += (float)hashes[1].intValue() / 16.0f * 0.4f, bri);
    }

    public static RGB customizeForegroundRGB(String name, float hue) {
        Integer[] hashes = ProjectColorsRGBUtils.myHashes(name);
        float bri = DVTThemeUtils.isDarkUI() ? 0.9f : 0.5f;
        float satOffset = DVTThemeUtils.isDarkUI() ? 0.2f : 0.4f;
        return new RGB(hue, satOffset += (float)hashes[1].intValue() / 16.0f * 0.4f, bri);
    }

    private static Integer[] myHashes(String s) {
        int hash1 = ProjectColorsRGBUtils.spread(s.chars().sum() % 16);
        int hash2 = ProjectColorsRGBUtils.spread(s.length() % 16);
        return new Integer[]{hash1, hash2};
    }

    private static int spread(int i) {
        return (i * 4 + i / 4) % 16;
    }
}

