/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.properties;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaStoreUtil;
import ro.amiq.dvt.ui.properties.CustomPragmasEditorMessages;
import ro.amiq.dvt.ui.properties.EditCustomPragmaDialog;
import ro.amiq.dvt.ui.properties.RebuildOnCustomPragmasChangeDialog;

public class CustomPragmasPrefPage
extends PreferencePage
implements IWorkbenchPropertyPage {
    private IProject fProject;
    protected List<CustomPragma> fGlobalCustomPragmasList;
    private List<CustomPragma> fLocalCustomPragmasList;
    private List<CustomPragma> fAllCustomPragmasList;
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fDuplicateButton;
    private Button fRemoveButton;
    private SourceViewer fPatternViewer;
    private IAdaptable fElement;
    private boolean fCustomPragmasChanged;
    private boolean fPerformedApply;

    public CustomPragmasPrefPage() {
        this.setMessage(CustomPragmasEditorMessages.PragmaPreferencePage_title_prj);
        this.setDescription(CustomPragmasEditorMessages.PragmaPreferencePage_message);
        this.fGlobalCustomPragmasList = new ArrayList<CustomPragma>();
        this.fLocalCustomPragmasList = new ArrayList<CustomPragma>();
        this.fAllCustomPragmasList = new ArrayList<CustomPragma>();
        this.fCustomPragmasChanged = false;
        this.fPerformedApply = false;
    }

    protected Control createContents(Composite ancestor) {
        this.fProject = (IProject)this.getElement().getAdapter(IProject.class);
        CustomPragmaStoreUtil.loadGlobal(this.fGlobalCustomPragmasList);
        CustomPragmaStoreUtil.loadLocal(this.fLocalCustomPragmasList, this.fProject);
        this.fAllCustomPragmasList.clear();
        this.fAllCustomPragmasList.addAll(this.fGlobalCustomPragmasList);
        CustomPragmaStoreUtil.addAll(this.fAllCustomPragmasList, this.fLocalCustomPragmasList);
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        final Table table = new Table(innerParent, 67618);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new CheckboxTableViewer(table);
        TableViewerColumn startTokenColumn = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        startTokenColumn.setLabelProvider((CellLabelProvider)new CustomPragmaLabelProvider());
        startTokenColumn.getColumn().setText(CustomPragmasEditorMessages.RulePreferencePage_column_start);
        TableViewerColumn endTokenColumn = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        endTokenColumn.setLabelProvider((CellLabelProvider)new CustomPragmaLabelProvider());
        endTokenColumn.getColumn().setText(CustomPragmasEditorMessages.RulePreferencePage_column_end);
        TableViewerColumn readOnlyColumn = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        readOnlyColumn.setLabelProvider((CellLabelProvider)new CustomPragmaLabelProvider());
        readOnlyColumn.getColumn().setText(CustomPragmasEditorMessages.RulePreferencePage_column_read_only);
        final TableViewerColumn colorColumn = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        colorColumn.setLabelProvider((CellLabelProvider)new CustomPragmaLabelProvider());
        colorColumn.getColumn().setText(CustomPragmasEditorMessages.RulePreferencePage_column_color);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    Object element = event.item.getData();
                    if (!(element instanceof CustomPragma)) {
                        return;
                    }
                    if (((CustomPragma)element).isGlobal()) {
                        event.detail = 0;
                        event.type = 0;
                        event.doit = false;
                        try {
                            table.setRedraw(false);
                            TableItem item = (TableItem)event.item;
                            item.setChecked(!item.getChecked());
                        }
                        finally {
                            table.setRedraw(true);
                        }
                    }
                }
            }
        });
        this.fTableViewer.setContentProvider((IContentProvider)new CustomPragmasContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof CustomPragma && object2 instanceof CustomPragma) {
                    CustomPragma left = (CustomPragma)object1;
                    CustomPragma right = (CustomPragma)object2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                StructuredSelection selection = (StructuredSelection)e.getSelection();
                Object customPragma = selection.getFirstElement();
                if (!(customPragma instanceof CustomPragma)) {
                    return;
                }
                if (!((CustomPragma)customPragma).isGlobal()) {
                    CustomPragmasPrefPage.this.edit();
                }
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CustomPragmasPrefPage.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (!(element instanceof CustomPragma)) {
                    return;
                }
                CustomPragma pragma = (CustomPragma)element;
                if (!pragma.isGlobal()) {
                    pragma.setEnabled(event.getChecked());
                    CustomPragmasPrefPage.this.customPragmasChanged();
                }
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(CustomPragmasEditorMessages.RulePreferencePage_new);
        this.fAddButton.setLayoutData((Object)CustomPragmasPrefPage.getButtonGridData());
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CustomPragmasPrefPage.this.add();
            }
        });
        this.fDuplicateButton = new Button(buttons, 8);
        this.fDuplicateButton.setText(CustomPragmasEditorMessages.RulePreferencePage_duplicate);
        this.fDuplicateButton.setLayoutData((Object)CustomPragmasPrefPage.getButtonGridData());
        this.fDuplicateButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (!(CustomPragmasPrefPage.this.fTableViewer.getSelection() instanceof StructuredSelection)) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)CustomPragmasPrefPage.this.fTableViewer.getSelection();
                if (!(selection.getFirstElement() instanceof CustomPragma)) {
                    return;
                }
                CustomPragma customPragma = (CustomPragma)selection.getFirstElement();
                CustomPragmasPrefPage.this.add(customPragma);
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(CustomPragmasEditorMessages.RulePreferencePage_edit);
        this.fEditButton.setLayoutData((Object)CustomPragmasPrefPage.getButtonGridData());
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CustomPragmasPrefPage.this.edit();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText(CustomPragmasEditorMessages.RulePreferencePage_remove);
        this.fRemoveButton.setLayoutData((Object)CustomPragmasPrefPage.getButtonGridData());
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CustomPragmasPrefPage.this.remove();
            }
        });
        this.createSeparator(buttons);
        Label font_description_note = new Label(parent, 0);
        font_description_note.setText(CustomPragmasEditorMessages.RulePreferencePage_font_description_note);
        data = new GridData();
        data.horizontalSpan = 2;
        font_description_note.setLayoutData((Object)data);
        this.fPatternViewer = this.doCreateViewer(parent);
        this.fTableViewer.setInput(this.fAllCustomPragmasList);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledCustomPragmas());
        this.updateButtons();
        CustomPragmasPrefPage.configureTableResizing(table);
        this.fTableViewer.getTable().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index != 3 || !(event.item.getData() instanceof CustomPragma)) {
                    return;
                }
                CustomPragma customPragma = (CustomPragma)event.item.getData();
                GC gc = event.gc;
                if (!customPragma.isColorEnabled()) {
                    return;
                }
                gc.setBackground(customPragma.getColor());
                gc.fillRectangle(event.x, event.y, colorColumn.getColumn().getWidth(), event.height);
            }
        });
        Dialog.applyDialogFont((Control)parent);
        table.getHorizontalBar().setVisible(true);
        return parent;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    private static void configureTableResizing(final Table table) {
        ControlAdapter resizer = new ControlAdapter(){
            private boolean fIsResizing = false;
            private final int[] fWidths = new int[]{90, 90, 70, 50};
            private int fSum = 300;

            public void controlResized(ControlEvent e) {
                if (this.fIsResizing) {
                    return;
                }
                try {
                    this.fIsResizing = true;
                    int tableWidth = 0;
                    int clientAreaWidth = table.getClientArea().width;
                    if (e.widget == table) {
                        int toDistribute;
                        TableColumn[] columns = table.getColumns();
                        int[] initial = new int[]{90, 90, 70, 50};
                        int[] minimums = new int[columns.length];
                        int minSum = 0;
                        int i = 0;
                        while (i < columns.length) {
                            minimums[i] = Math.min(this.fWidths[i], initial[i]);
                            minSum += minimums[i];
                            ++i;
                        }
                        int newWidth = this.fSum < clientAreaWidth ? clientAreaWidth : Math.max(clientAreaWidth, minSum);
                        int lastPart = toDistribute = newWidth - this.fSum;
                        if (toDistribute != 0) {
                            int[] nArray = new int[4];
                            nArray[0] = 3;
                            nArray[1] = 2;
                            nArray[2] = 1;
                            int[] iteration = nArray;
                            int i2 = 0;
                            while (i2 < iteration.length) {
                                int width;
                                int c = iteration[i2];
                                if (this.fSum > 0) {
                                    int part = i2 == iteration.length - 1 ? lastPart : toDistribute * this.fWidths[c] / this.fSum;
                                    lastPart -= part;
                                    width = Math.max(minimums[c], this.fWidths[c] + part);
                                } else {
                                    width = toDistribute * initial[c] / 300;
                                }
                                columns[c].setWidth(width);
                                this.fWidths[c] = width;
                                tableWidth += width;
                                ++i2;
                            }
                            this.fSum = tableWidth;
                        }
                        table.getHorizontalBar().setVisible(tableWidth > clientAreaWidth);
                    }
                }
                finally {
                    this.fIsResizing = false;
                    table.redraw();
                }
            }
        };
        table.addControlListener((ControlListener)resizer);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].addControlListener((ControlListener)resizer);
            ++i;
        }
    }

    private CustomPragma[] getEnabledCustomPragmas() {
        TableItem[] items;
        ArrayList<CustomPragma> enabled = new ArrayList<CustomPragma>();
        TableItem[] tableItemArray = items = this.fTableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            CustomPragma element = (CustomPragma)item.getData();
            if (element.isEnabled()) {
                enabled.add(element);
            }
            ++n2;
        }
        return enabled.toArray(new CustomPragma[enabled.size()]);
    }

    private SourceViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(CustomPragmasEditorMessages.RulePreferencePage_preview);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        Font textFont = JFaceResources.getTextFont();
        viewer.getTextWidget().setFont(textFont);
        return viewer;
    }

    private SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration();
        viewer.configure(configuration);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private static GridData getButtonGridData() {
        GridData data = new GridData(768);
        return data;
    }

    private void selectionChanged1() {
        this.updateViewerInput();
        this.updateButtons();
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            CustomPragma customPragma = (CustomPragma)selection.getFirstElement();
            this.fPatternViewer.getDocument().set(customPragma.toString());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection == null) {
            return;
        }
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        CustomPragma data = (CustomPragma)selection.getFirstElement();
        this.fDuplicateButton.setEnabled(selectionCount == 1);
        this.fEditButton.setEnabled(selectionCount == 1 && !data.isGlobal());
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount && !data.isGlobal());
    }

    private void add(CustomPragma customPragma) {
        CustomPragma newCustomPragma = this.editCustomPragma(customPragma, false);
        if (newCustomPragma != null) {
            CustomPragmaStoreUtil.add(this.fLocalCustomPragmasList, newCustomPragma);
            CustomPragmaStoreUtil.add(this.fAllCustomPragmasList, newCustomPragma);
            this.fTableViewer.refresh();
            this.fTableViewer.setChecked((Object)newCustomPragma, newCustomPragma.isEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newCustomPragma));
            this.customPragmasChanged();
        }
    }

    private void add() {
        this.add(new CustomPragma("", "", "", true, false, "", false));
    }

    private CustomPragma editCustomPragma(CustomPragma customPragma, boolean edit) {
        EditCustomPragmaDialog dialog = new EditCustomPragmaDialog(this.getShell(), customPragma, edit);
        if (dialog.open() == 0) {
            return dialog.getPragma();
        }
        return null;
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        CustomPragma data = (CustomPragma)selection.getFirstElement();
        this.edit(data);
    }

    private void edit(CustomPragma oldCustomPragma) {
        CustomPragma newCustomPragma = this.editCustomPragma(oldCustomPragma, true);
        if (newCustomPragma != null) {
            if (!newCustomPragma.getName().equals(oldCustomPragma.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)CustomPragmasEditorMessages.RulePreferencePage_question_create_new_title, (String)CustomPragmasEditorMessages.RulePreferencePage_question_create_new_message)) {
                CustomPragmaStoreUtil.add(this.fLocalCustomPragmasList, newCustomPragma);
                this.customPragmasChanged();
                this.fTableViewer.refresh();
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newCustomPragma));
                this.fTableViewer.setChecked((Object)newCustomPragma, newCustomPragma.isEnabled());
                this.fTableViewer.refresh();
            } else {
                if (!oldCustomPragma.equals(newCustomPragma)) {
                    this.customPragmasChanged();
                }
                oldCustomPragma.setEnabled(newCustomPragma.isEnabled());
                oldCustomPragma.setStartPragma(newCustomPragma.getStartPragma());
                oldCustomPragma.setEndPragma(newCustomPragma.getEndPragma());
                oldCustomPragma.setColorEnabled(newCustomPragma.isColorEnabled());
                oldCustomPragma.setColor(newCustomPragma.getColorString());
                oldCustomPragma.setReadOnly(newCustomPragma.isReadOnly());
                oldCustomPragma.setDescription(newCustomPragma.getDescription());
                this.fTableViewer.refresh((Object)oldCustomPragma);
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)oldCustomPragma));
                this.fTableViewer.setChecked((Object)oldCustomPragma, oldCustomPragma.isEnabled());
                this.fTableViewer.refresh();
            }
            this.selectionChanged1();
        }
    }

    public static String messageFormat(String message, Object argument) {
        return MessageFormat.format(message, argument);
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (CustomPragma data : selection) {
            CustomPragmaStoreUtil.delete(data);
        }
        this.customPragmasChanged();
        this.fTableViewer.refresh();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(CustomPragmasEditorMessages.PragmaPreferencePage_title_prj);
        }
    }

    private void openWriteErrorDialog() {
        String title = CustomPragmasEditorMessages.RulePreferencePage_error_write_title;
        String message = CustomPragmasEditorMessages.RulePreferencePage_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    protected SourceViewer getViewer() {
        return this.fPatternViewer;
    }

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element;
    }

    public void performApply() {
        if (!this.fCustomPragmasChanged) {
            super.performOk();
            return;
        }
        try {
            CustomPragmaStoreUtil.save(this.fLocalCustomPragmasList, this.fProject);
            IResource dvtDirectory = this.fProject.findMember(".dvt");
            dvtDirectory.refreshLocal(1, null);
            this.fPerformedApply = true;
        }
        catch (IOException iOException) {
            this.openWriteErrorDialog();
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fLocalCustomPragmasList.clear();
        this.fGlobalCustomPragmasList.clear();
        this.fAllCustomPragmasList.clear();
        CustomPragmaStoreUtil.loadGlobal(this.fGlobalCustomPragmasList);
        CustomPragmaStoreUtil.loadLocal(this.fLocalCustomPragmasList, this.fProject);
        this.fAllCustomPragmasList.addAll(this.fGlobalCustomPragmasList);
        CustomPragmaStoreUtil.addAll(this.fAllCustomPragmasList, this.fLocalCustomPragmasList);
        this.fTableViewer.refresh();
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledCustomPragmas());
        this.fTableViewer.refresh();
        super.performOk();
    }

    public boolean performCancel() {
        if (this.fPerformedApply && this.fProject != null) {
            RebuildOnCustomPragmasChangeDialog.getInstance().setChanged(1, this.fProject);
            RebuildOnCustomPragmasChangeDialog.getInstance().sendNotification();
        }
        return super.performCancel();
    }

    public boolean performOk() {
        if (!this.fCustomPragmasChanged) {
            return super.performOk();
        }
        if (this.fCustomPragmasChanged && this.fProject != null) {
            RebuildOnCustomPragmasChangeDialog.getInstance().setChanged(1, this.fProject);
            RebuildOnCustomPragmasChangeDialog.getInstance().sendNotification();
        }
        try {
            CustomPragmaStoreUtil.save(this.fLocalCustomPragmasList, this.fProject);
            if (this.fProject != null) {
                IResource dvtDirectory = this.fProject.findMember(".dvt");
                dvtDirectory.refreshLocal(1, null);
            }
        }
        catch (IOException iOException) {
            this.openWriteErrorDialog();
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return super.performOk();
    }

    public void customPragmasChanged() {
        this.fCustomPragmasChanged = true;
    }

    private static class CustomPragmaLabelProvider
    extends StyledCellLabelProvider {
        private CustomPragmaLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            CustomPragma customPragma = (CustomPragma)element;
            switch (columnIndex) {
                case 0: {
                    return customPragma.getStartPragma();
                }
                case 1: {
                    return customPragma.getEndPragma();
                }
                case 2: {
                    return customPragma.isReadOnly() ? "YES" : "NO";
                }
                case 3: {
                    return customPragma.isColorEnabled() ? "" : "NONE";
                }
            }
            return "";
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            int columnIndex = cell.getColumnIndex();
            String text = this.getColumnText(element, columnIndex);
            final CustomPragma customPragma = (CustomPragma)element;
            if (columnIndex == 3 && customPragma.isColorEnabled()) {
                cell.setBackground(customPragma.getColor());
            } else {
                cell.setBackground(Display.getDefault().getSystemColor(22));
            }
            StyledString styledString = new StyledString(text);
            StyledString.Styler styler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    if (customPragma.isOverriden()) {
                        textStyle.strikeout = true;
                    }
                    if (customPragma.isGlobal()) {
                        textStyle.foreground = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.prefpages.settingsManagementCustomPragmasForegroundColor");
                    }
                }
            };
            styledString.setStyle(0, text.length(), styler);
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(null);
        }
    }

    static class CustomPragmasContentProvider
    implements IStructuredContentProvider {
        CustomPragmasContentProvider() {
        }

        public Object[] getElements(Object input) {
            List inputList = (List)input;
            ArrayList<CustomPragma> customPragmas = new ArrayList<CustomPragma>();
            int i = 0;
            while (i < inputList.size()) {
                Object inputElement = inputList.get(i);
                if (inputElement instanceof CustomPragma && !((CustomPragma)inputElement).isDeleted()) {
                    customPragmas.add((CustomPragma)inputElement);
                }
                ++i;
            }
            return customPragmas.toArray(new CustomPragma[customPragmas.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

