/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.properties;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.preferences.StatusInfo;
import ro.amiq.dvt.ui.properties.CustomPragmasEditorMessages;

public class EditCustomPragmaDialog
extends StatusDialog {
    private final CustomPragma fOriginalPragma;
    private CustomPragma fNewPragma;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private Text fStartToken;
    private Text fEndToken;
    private Text fDescriptionText;
    private Button fEnabledCheckbox;
    private Button fEnableColor;
    private ColorSelector fgEditor;
    private Button fEnabledReadOnly;

    public EditCustomPragmaDialog(Shell parent, CustomPragma pragma, boolean edit) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String title = edit ? CustomPragmasEditorMessages.EditRuleDialog_title_edit : CustomPragmasEditorMessages.EditRuleDialog_title_new;
        this.setTitle(title);
        this.fOriginalPragma = pragma;
        this.fValidationStatus = new StatusInfo();
        this.setHelpAvailable(false);
    }

    public void create() {
        boolean valid;
        super.create();
        boolean bl = valid = this.fStartToken == null || this.fStartToken.getText().trim().length() != 0 || this.fEndToken == null || this.fEndToken.getText().trim().length() != 0;
        if (!valid) {
            StatusInfo status = new StatusInfo();
            status.setError(CustomPragmasEditorMessages.EditRuleDialog_error_noname);
            this.updateButtonsEnableState(status);
        }
        this.getShell().setSize(550, 350);
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditCustomPragmaDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (EditCustomPragmaDialog.this.fSuppressError) {
                    EditCustomPragmaDialog.this.fSuppressError = false;
                    EditCustomPragmaDialog.this.updateButtons();
                }
            }
        };
        EditCustomPragmaDialog.createLabel(parent, "Start Pragma");
        this.fStartToken = EditCustomPragmaDialog.createText(EditCustomPragmaDialog.createComposite(parent, layout));
        this.fStartToken.addModifyListener(listener);
        this.fStartToken.addFocusListener(focusListener);
        this.fStartToken.setText(this.fOriginalPragma.getStartPragma());
        EditCustomPragmaDialog.createLabel(parent, "End Pragma");
        this.fEndToken = EditCustomPragmaDialog.createText(EditCustomPragmaDialog.createComposite(parent, layout));
        this.fEndToken.addModifyListener(listener);
        this.fEndToken.addFocusListener(focusListener);
        this.fEndToken.setText(this.fOriginalPragma.getEndPragma());
        EditCustomPragmaDialog.createLabel(parent, "Enable");
        this.fEnabledCheckbox = EditCustomPragmaDialog.createCheckbox(EditCustomPragmaDialog.createComposite(parent, layout), "");
        this.fEnabledCheckbox.setToolTipText("The code inside the custom pragma is read-only.\nA warning pop-up will appear when the code is modified.");
        this.fEnabledCheckbox.setSelection(this.fOriginalPragma.isEnabled());
        EditCustomPragmaDialog.createLabel(parent, "Read-only");
        this.fEnabledReadOnly = EditCustomPragmaDialog.createCheckbox(EditCustomPragmaDialog.createComposite(parent, layout), "");
        this.fEnabledReadOnly.setToolTipText("The code inside the custom pragma is read-only.\nA warning pop-up will appear when the code is modified.");
        this.fEnabledReadOnly.setSelection(this.fOriginalPragma.isReadOnly());
        EditCustomPragmaDialog.createLabel(parent, "Color");
        Composite composite2 = EditCustomPragmaDialog.createComposite(parent, layout);
        this.fEnableColor = EditCustomPragmaDialog.createCheckbox(composite2, "");
        this.fEnableColor.setToolTipText("The background for code inside the custom pragma is colored.");
        this.fEnableColor.setSelection(this.fOriginalPragma.isColorEnabled());
        this.fEnableColor.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditCustomPragmaDialog.this.fgEditor.setEnabled(EditCustomPragmaDialog.this.fEnableColor.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EditCustomPragmaDialog.this.fgEditor.setEnabled(EditCustomPragmaDialog.this.fEnableColor.getSelection());
            }
        });
        this.fgEditor = new ColorSelector(composite2);
        this.fgEditor.setEnabled(this.fEnableColor.getSelection());
        this.fgEditor.setColorValue(this.fOriginalPragma.getColor().getRGB());
        EditCustomPragmaDialog.createLabel(parent, "Description");
        this.fDescriptionText = EditCustomPragmaDialog.createText(EditCustomPragmaDialog.createComposite(parent, layout));
        this.fDescriptionText.setText(this.fOriginalPragma.getDescription());
        EditCustomPragmaDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void doTextWidgetChanged(Widget w) {
        if (w == this.fStartToken || w == this.fEndToken) {
            if (this.fStartToken != null && this.fStartToken.getText().length() == 0) {
                this.fSuppressError = true;
            } else if (this.fEndToken != null && this.fEndToken.getText().length() == 0) {
                this.fSuppressError = true;
            } else {
                this.fSuppressError = false;
                this.updateButtons();
            }
        }
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Composite createComposite(Composite parent, GridLayout layout) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)layout);
        return composite;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private static Button createCheckbox(Composite parent, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    private void updateButtons() {
        StatusInfo status;
        boolean valid;
        boolean bl = valid = this.fStartToken != null && this.fStartToken.getText().trim().length() != 0 && this.fEndToken != null && this.fEndToken.getText().trim().length() != 0;
        if (!valid) {
            status = new StatusInfo();
            if (!this.fSuppressError) {
                status.setError(CustomPragmasEditorMessages.EditRuleDialog_error_noname);
            }
        } else {
            status = this.fValidationStatus;
        }
        this.updateStatus(status);
    }

    protected void okPressed() {
        String startToken = this.fStartToken.getText();
        String endToken = this.fEndToken.getText();
        StatusInfo status = new StatusInfo();
        status.setError(CustomPragmasEditorMessages.EditRuleDialog_error_duplicatetoken);
        if (startToken.equals(endToken)) {
            this.updateStatus(status);
            return;
        }
        this.fNewPragma = new CustomPragma(this.fDescriptionText.getText(), this.fStartToken.getText(), this.fEndToken.getText(), this.fEnabledCheckbox.getSelection(), this.fEnableColor.getSelection(), this.fgEditor.getColorValue(), this.fEnabledReadOnly.getSelection());
        super.okPressed();
    }

    public CustomPragma getPragma() {
        return this.fNewPragma;
    }
}

