/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.namechecker.Convention;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.preferences.StatusInfo;
import ro.amiq.dvt.ui.properties.NamingConventionsEditorMessages;

public class EditNamingConventionsRuleDialog
extends StatusDialog {
    private final Convention fOriginalConvention;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fKindCombo;
    private Combo fMatchCombo;
    private Combo fLanguageCombo;
    private Text fPatternEditor;
    private Button fEnabledCheckbox;
    private boolean fIsNameModifiable;
    private IProject fProject;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private Convention fNewConvention;

    public EditNamingConventionsRuleDialog(Shell parent, Convention convention, boolean edit, boolean isNameModifiable, IProject project) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String title = edit ? NamingConventionsEditorMessages.EditRuleDialog_title_edit : NamingConventionsEditorMessages.EditRuleDialog_title_new;
        this.setTitle(title);
        this.fOriginalConvention = convention;
        this.fIsNameModifiable = isNameModifiable;
        this.fProject = project;
        this.fValidationStatus = new StatusInfo();
        this.setHelpAvailable(false);
    }

    public void create() {
        boolean valid;
        super.create();
        boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!valid) {
            StatusInfo status = new StatusInfo();
            status.setError(NamingConventionsEditorMessages.EditRuleDialog_error_noname);
            this.updateButtonsEnableState(status);
        }
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditNamingConventionsRuleDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditNamingConventionsRuleDialog.createLabel(parent, NamingConventionsEditorMessages.EditRuleDialog_name);
            Composite composite1 = new Composite(parent, 0);
            composite1.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite1.setLayout((Layout)layout);
            this.fNameText = EditNamingConventionsRuleDialog.createText(composite1);
            this.fNameText.addModifyListener(listener);
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditNamingConventionsRuleDialog.this.fSuppressError) {
                        EditNamingConventionsRuleDialog.this.fSuppressError = false;
                        EditNamingConventionsRuleDialog.this.updateButtons();
                    }
                }
            });
            EditNamingConventionsRuleDialog.createLabel(composite1, NamingConventionsEditorMessages.EditRuleDialog_context);
            this.fKindCombo = new Combo(composite1, 8);
            EditNamingConventionsRuleDialog.createLabel(parent, NamingConventionsEditorMessages.EditRuleDialog_match);
            Composite composite2 = new Composite(parent, 0);
            composite2.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite2.setLayout((Layout)layout);
            this.fMatchCombo = new Combo(composite2, 8);
            int i = 0;
            while (i < PrefConst.NAMECHECKER_CONVENTION_MATCH.length) {
                this.fMatchCombo.add(PrefConst.NAMECHECKER_CONVENTION_MATCH[i]);
                ++i;
            }
            this.fMatchCombo.select(0);
            EditNamingConventionsRuleDialog.createLabel(composite2, NamingConventionsEditorMessages.EditRuleDialog_language);
            this.fLanguageCombo = new Combo(composite2, 8);
            this.fLanguageCombo.addModifyListener(listener);
            try {
                if (this.fProject.hasNature("ro.amiq.edt.enature")) {
                    this.fLanguageCombo.add("e Language");
                }
                if (this.fProject.hasNature("ro.amiq.slndt.slnnature")) {
                    this.fLanguageCombo.add("SLN");
                }
                if (this.fProject.hasNature("ro.amiq.msdldt.msdlnature")) {
                    this.fLanguageCombo.add("MSDL");
                }
                if (this.fProject.hasNature("ro.amiq.pssdt.pssnature")) {
                    this.fLanguageCombo.add("PSS");
                }
                if (this.fProject.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                    this.fLanguageCombo.add("VHDL");
                }
            }
            catch (CoreException e1) {
                DVTLogger.INSTANCE.logError((Throwable)e1);
            }
            this.fLanguageCombo.select(0);
            this.fEnabledCheckbox = EditNamingConventionsRuleDialog.createCheckbox(composite2, NamingConventionsEditorMessages.EditRuleDialog_enabled);
            this.fEnabledCheckbox.setSelection(this.fOriginalConvention.getEnabled());
        }
        Label patternLabel = EditNamingConventionsRuleDialog.createLabel(parent, NamingConventionsEditorMessages.EditRuleDialog_pattern);
        patternLabel.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = EditNamingConventionsRuleDialog.createText(parent);
        TextContentAdapter contentAdapter = new TextContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        new ContentAssistCommandAdapter((Control)this.fPatternEditor, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[]{'\\', '[', '('}, true);
        this.fPatternEditor.setText(this.fOriginalConvention.getPatternString());
        Label descriptionLabel = EditNamingConventionsRuleDialog.createLabel(parent, NamingConventionsEditorMessages.EditRuleDialog_description);
        descriptionLabel.setLayoutData((Object)new GridData(2));
        this.fDescriptionText = EditNamingConventionsRuleDialog.createText(parent);
        this.fDescriptionText.setText(this.fOriginalConvention.getDescription());
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fOriginalConvention.getName());
            this.fNameText.addModifyListener(listener);
            this.fLanguageCombo.select(this.getLanguageIndex(this.fOriginalConvention.getLanguage()));
            this.fKindCombo.select(this.getContextIdIndex(this.fOriginalConvention.getKind(), this.fOriginalConvention.getLanguage()));
            this.fMatchCombo.select(this.getMatchIndex(this.fOriginalConvention.getMatch()));
        } else {
            this.fPatternEditor.setFocus();
        }
        this.fNameText.setSelection(this.fNameText.getText().length());
        EditNamingConventionsRuleDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void doTextWidgetChanged(Widget w) {
        if (w == this.fNameText) {
            if (this.fNameText.getText().length() == 0) {
                this.fSuppressError = true;
            } else {
                this.fSuppressError = false;
                this.updateButtons();
            }
        } else if (w != this.fKindCombo && w == this.fLanguageCombo) {
            this.fKindCombo.removeAll();
            if (this.fLanguageCombo.getText().equals("e Language")) {
                int i = 0;
                while (i < PrefConst.E_NAMECHECKER_CONVENTION_TYPES.length) {
                    this.fKindCombo.add(PrefConst.E_NAMECHECKER_CONVENTION_TYPES[i]);
                    ++i;
                }
            } else if (this.fLanguageCombo.getText().equals("VHDL")) {
                int i = 0;
                while (i < PrefConst.VHDL_NAMECHECKER_CONVENTION_TYPES.length) {
                    this.fKindCombo.add(PrefConst.VHDL_NAMECHECKER_CONVENTION_TYPES[i]);
                    ++i;
                }
            } else if (this.fLanguageCombo.getText().equals("SLN")) {
                int i = 0;
                while (i < PrefConst.SLN_NAMECHECKER_CONVENTION_TYPES.length) {
                    this.fKindCombo.add(PrefConst.SLN_NAMECHECKER_CONVENTION_TYPES[i]);
                    ++i;
                }
            } else if (this.fLanguageCombo.getText().equals("SDL")) {
                int i = 0;
                while (i < PrefConst.E_NAMECHECKER_CONVENTION_TYPES.length) {
                    this.fKindCombo.add(PrefConst.E_NAMECHECKER_CONVENTION_TYPES[i]);
                    ++i;
                }
            } else if (this.fLanguageCombo.getText().equals("MSDL")) {
                int i = 0;
                while (i < PrefConst.MSDL_NAMECHECKER_CONVENTION_TYPES.length) {
                    this.fKindCombo.add(PrefConst.MSDL_NAMECHECKER_CONVENTION_TYPES[i]);
                    ++i;
                }
            } else if (this.fLanguageCombo.getText().equals("PSS")) {
                int i = 0;
                while (i < PrefConst.PSS_NAMECHECKER_CONVENTION_TYPES.length) {
                    this.fKindCombo.add(PrefConst.PSS_NAMECHECKER_CONVENTION_TYPES[i]);
                    ++i;
                }
            }
            this.fKindCombo.select(0);
        }
    }

    private String getName() {
        if (this.fNameText != null && !this.fNameText.isDisposed()) {
            return this.fNameText.getText();
        }
        return this.fOriginalConvention.getName();
    }

    private boolean getEnabled() {
        if (this.fEnabledCheckbox != null) {
            return this.fEnabledCheckbox.getSelection();
        }
        return this.fOriginalConvention.getEnabled();
    }

    private String getLanguage() {
        if (this.fLanguageCombo != null && !this.fLanguageCombo.isDisposed()) {
            return this.fLanguageCombo.getText();
        }
        return this.fOriginalConvention.getLanguage();
    }

    private String getKind() {
        if (this.fKindCombo != null && !this.fKindCombo.isDisposed()) {
            return this.fKindCombo.getText();
        }
        return this.fOriginalConvention.getKind();
    }

    private String getMatch() {
        if (this.fMatchCombo != null && !this.fMatchCombo.isDisposed()) {
            return this.fMatchCombo.getText();
        }
        return this.fOriginalConvention.getMatch();
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private static Button createCheckbox(Composite parent, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    private int getContextIdIndex(String contextid, String language) {
        block12: {
            block15: {
                block14: {
                    block13: {
                        block11: {
                            if (contextid == null) {
                                return -1;
                            }
                            if (!language.equals("e Language")) break block11;
                            int i = 0;
                            while (i < PrefConst.E_NAMECHECKER_CONVENTION_TYPES.length) {
                                if (contextid.equals(PrefConst.E_NAMECHECKER_CONVENTION_TYPES[i])) {
                                    return i;
                                }
                                ++i;
                            }
                            break block12;
                        }
                        if (!language.equals("VHDL")) break block13;
                        int i = 0;
                        while (i < PrefConst.VHDL_NAMECHECKER_CONVENTION_TYPES.length) {
                            if (contextid.equals(PrefConst.VHDL_NAMECHECKER_CONVENTION_TYPES[i])) {
                                return i;
                            }
                            ++i;
                        }
                        break block12;
                    }
                    if (!language.equals("SLN")) break block14;
                    int i = 0;
                    while (i < PrefConst.SLN_NAMECHECKER_CONVENTION_TYPES.length) {
                        if (contextid.equals(PrefConst.SLN_NAMECHECKER_CONVENTION_TYPES[i])) {
                            return i;
                        }
                        ++i;
                    }
                    break block12;
                }
                if (!language.equals("PSS")) break block15;
                int i = 0;
                while (i < PrefConst.PSS_NAMECHECKER_CONVENTION_TYPES.length) {
                    if (contextid.equals(PrefConst.PSS_NAMECHECKER_CONVENTION_TYPES[i])) {
                        return i;
                    }
                    ++i;
                }
                break block12;
            }
            if (!language.equals("MSDL")) break block12;
            int i = 0;
            while (i < PrefConst.MSDL_NAMECHECKER_CONVENTION_TYPES.length) {
                if (contextid.equals(PrefConst.MSDL_NAMECHECKER_CONVENTION_TYPES[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private int getLanguageIndex(String language) {
        if (language == null) {
            return -1;
        }
        String[] languages = this.fLanguageCombo.getItems();
        int i = 0;
        while (i < languages.length) {
            if (language.equals(languages[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getMatchIndex(String match) {
        if (match == null) {
            return -1;
        }
        int i = 0;
        while (i < PrefConst.NAMECHECKER_CONVENTION_MATCH.length) {
            if (match.equals(PrefConst.NAMECHECKER_CONVENTION_MATCH[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateButtons() {
        StatusInfo status;
        boolean valid;
        boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!valid) {
            status = new StatusInfo();
            if (!this.fSuppressError) {
                status.setError(NamingConventionsEditorMessages.EditRuleDialog_error_noname);
            }
        } else {
            status = this.fValidationStatus;
        }
        this.updateStatus(status);
    }

    protected void okPressed() {
        this.fNewConvention = new Convention(this.getLanguage(), this.getKind(), this.getName(), this.getDescription(), this.getMatch(), this.fPatternEditor.getText(), this.getEnabled());
        super.okPressed();
    }

    private String getDescription() {
        return this.fDescriptionText.getText();
    }

    public Convention getConvention() {
        return this.fNewConvention;
    }
}

