/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.properties;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.namechecker.Convention;
import ro.amiq.dvt.ui.namechecker.ConventionStoreUtil;
import ro.amiq.dvt.ui.properties.EditNamingConventionsRuleDialog;
import ro.amiq.dvt.ui.properties.NamingConventionsEditorMessages;
import ro.amiq.dvt.ui.properties.RebuildOnNameChecksChangeDialog;
import ro.amiq.dvt.utils.DVTStringUtil;

public class NamingConventionsPrefPage
extends PreferencePage
implements IWorkbenchPropertyPage {
    private static final int MAX_FORMAT_TOKEN_LENGTH = 15;
    private static final Pattern TOKEN_SEPARATOR_PATTERN = Pattern.compile("[\\n:]");
    private IProject fProject;
    protected boolean fPerProject = false;
    protected List<Convention> fGlobalConventionList;
    private List<Convention> fLocalConventionList;
    private List<Convention> fAllConventionList;
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fDuplicateButton;
    private Button fRemoveButton;
    private SourceViewer fPatternViewer;
    private IAdaptable fElement;
    private boolean fConvensionChanged;
    private boolean fPerformedApply;

    public NamingConventionsPrefPage() {
        this.setMessage(NamingConventionsEditorMessages.RulePreferencePage_title_prj);
        this.setDescription(NamingConventionsEditorMessages.RulePreferencePage_message);
        this.fPerProject = true;
        this.fGlobalConventionList = new ArrayList<Convention>();
        this.fLocalConventionList = new ArrayList<Convention>();
        this.fAllConventionList = new ArrayList<Convention>();
        this.fConvensionChanged = false;
        this.fPerformedApply = false;
    }

    protected Control createContents(Composite ancestor) {
        this.fProject = (IProject)this.getElement().getAdapter(IProject.class);
        try {
            ConventionStoreUtil.loadGlobal(this.fGlobalConventionList, this.fProject);
            ConventionStoreUtil.loadLocal(this.fLocalConventionList, this.fProject);
            this.fAllConventionList.clear();
            this.fAllConventionList.addAll(this.fGlobalConventionList);
            ConventionStoreUtil.addAll(this.fAllConventionList, this.fLocalConventionList);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        final Table table = new Table(innerParent, 67618);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new CheckboxTableViewer(table);
        TableViewerColumn newTVC = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        newTVC.setLabelProvider((CellLabelProvider)new NameCheckerLabelProvider());
        newTVC.getColumn().setText(NamingConventionsEditorMessages.RulePreferencePage_column_language);
        newTVC = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        newTVC.setLabelProvider((CellLabelProvider)new NameCheckerLabelProvider());
        newTVC.getColumn().setText(NamingConventionsEditorMessages.RulePreferencePage_column_name);
        newTVC = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        newTVC.setLabelProvider((CellLabelProvider)new NameCheckerLabelProvider());
        newTVC.getColumn().setText(NamingConventionsEditorMessages.RulePreferencePage_column_context);
        newTVC = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        newTVC.setLabelProvider((CellLabelProvider)new NameCheckerLabelProvider());
        newTVC.getColumn().setText(NamingConventionsEditorMessages.RulePreferencePage_column_match);
        newTVC = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        newTVC.setLabelProvider((CellLabelProvider)new NameCheckerLabelProvider());
        newTVC.getColumn().setText(NamingConventionsEditorMessages.RulePreferencePage_column_location);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32 && ((Convention)event.item.getData()).isGlobal()) {
                    event.detail = 0;
                    event.type = 0;
                    event.doit = false;
                    try {
                        table.setRedraw(false);
                        TableItem item = (TableItem)event.item;
                        item.setChecked(!item.getChecked());
                    }
                    finally {
                        table.setRedraw(true);
                    }
                }
            }
        });
        this.fTableViewer.setContentProvider((IContentProvider)new NameCheckerContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof Convention && object2 instanceof Convention) {
                    Convention left = (Convention)object1;
                    Convention right = (Convention)object2;
                    int result = left.getLanguage().compareToIgnoreCase(right.getLanguage());
                    if (result != 0) {
                        return result;
                    }
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                StructuredSelection selection = (StructuredSelection)e.getSelection();
                Convention convention = (Convention)selection.getFirstElement();
                if (!convention.isGlobal()) {
                    NamingConventionsPrefPage.this.edit();
                }
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                NamingConventionsPrefPage.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Convention d = (Convention)event.getElement();
                if (!d.isGlobal()) {
                    d.setEnabled(event.getChecked());
                    NamingConventionsPrefPage.this.convensionsChanged();
                }
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(NamingConventionsEditorMessages.RulePreferencePage_new);
        this.fAddButton.setLayoutData((Object)NamingConventionsPrefPage.getButtonGridData());
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamingConventionsPrefPage.this.add();
            }
        });
        this.fDuplicateButton = new Button(buttons, 8);
        this.fDuplicateButton.setText(NamingConventionsEditorMessages.RulePreferencePage_duplicate);
        this.fDuplicateButton.setLayoutData((Object)NamingConventionsPrefPage.getButtonGridData());
        this.fDuplicateButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (!(NamingConventionsPrefPage.this.fTableViewer.getSelection() instanceof StructuredSelection)) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)NamingConventionsPrefPage.this.fTableViewer.getSelection();
                if (!(selection.getFirstElement() instanceof Convention)) {
                    return;
                }
                Convention convention = (Convention)selection.getFirstElement();
                NamingConventionsPrefPage.this.add(convention);
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(NamingConventionsEditorMessages.RulePreferencePage_edit);
        this.fEditButton.setLayoutData((Object)NamingConventionsPrefPage.getButtonGridData());
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamingConventionsPrefPage.this.edit();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText(NamingConventionsEditorMessages.RulePreferencePage_remove);
        this.fRemoveButton.setLayoutData((Object)NamingConventionsPrefPage.getButtonGridData());
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamingConventionsPrefPage.this.remove();
            }
        });
        this.createSeparator(buttons);
        Label font_description_note = new Label(parent, 0);
        font_description_note.setText(NamingConventionsEditorMessages.RulePreferencePage_font_description_note);
        data = new GridData();
        data.horizontalSpan = 2;
        font_description_note.setLayoutData((Object)data);
        this.fPatternViewer = this.doCreateViewer(parent);
        Label case_sensitivity_note = new Label(parent, 0);
        case_sensitivity_note.setText(NamingConventionsEditorMessages.RulePreferencePage_case_sensitivity_note);
        data = new GridData();
        data.horizontalSpan = 2;
        case_sensitivity_note.setLayoutData((Object)data);
        this.fTableViewer.setInput(this.fAllConventionList);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledConventions());
        this.updateButtons();
        NamingConventionsPrefPage.configureTableResizing(table);
        Dialog.applyDialogFont((Control)parent);
        table.getHorizontalBar().setVisible(true);
        return parent;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    private static void configureTableResizing(final Table table) {
        ControlAdapter resizer = new ControlAdapter(){
            private boolean fIsResizing = false;
            private final int[] fWidths = new int[]{50, 190, 40, 40, 120};
            private int fSum = 440;

            public void controlResized(ControlEvent e) {
                if (this.fIsResizing) {
                    return;
                }
                try {
                    this.fIsResizing = true;
                    int tableWidth = 0;
                    int clientAreaWidth = table.getClientArea().width;
                    if (e.widget == table) {
                        int toDistribute;
                        TableColumn[] columns = table.getColumns();
                        int[] initial = new int[]{70, 140, 70, 70, 90};
                        int[] minimums = new int[columns.length];
                        int minSum = 0;
                        int i = 0;
                        while (i < columns.length) {
                            minimums[i] = Math.min(this.fWidths[i], initial[i]);
                            minSum += minimums[i];
                            ++i;
                        }
                        int newWidth = this.fSum < clientAreaWidth ? clientAreaWidth : Math.max(clientAreaWidth, minSum);
                        int lastPart = toDistribute = newWidth - this.fSum;
                        if (toDistribute != 0) {
                            int[] nArray = new int[5];
                            nArray[0] = 4;
                            nArray[1] = 3;
                            nArray[2] = 2;
                            nArray[3] = 1;
                            int[] iteration = nArray;
                            int i2 = 0;
                            while (i2 < iteration.length) {
                                int width;
                                int c = iteration[i2];
                                if (this.fSum > 0) {
                                    int part = i2 == iteration.length - 1 ? lastPart : toDistribute * this.fWidths[c] / this.fSum;
                                    lastPart -= part;
                                    width = Math.max(minimums[c], this.fWidths[c] + part);
                                } else {
                                    width = toDistribute * initial[c] / 280;
                                }
                                columns[c].setWidth(width);
                                this.fWidths[c] = width;
                                tableWidth += width;
                                ++i2;
                            }
                            this.fSum = tableWidth;
                        }
                        table.getHorizontalBar().setVisible(tableWidth > clientAreaWidth);
                    }
                }
                finally {
                    this.fIsResizing = false;
                    table.redraw();
                }
            }
        };
        table.addControlListener((ControlListener)resizer);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].addControlListener((ControlListener)resizer);
            ++i;
        }
    }

    private Convention[] getEnabledConventions() {
        TableItem[] items;
        ArrayList<Convention> enabled = new ArrayList<Convention>();
        TableItem[] tableItemArray = items = this.fTableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Convention element = (Convention)item.getData();
            if (element.getEnabled()) {
                enabled.add(element);
            }
            ++n2;
        }
        return enabled.toArray(new Convention[enabled.size()]);
    }

    private SourceViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(NamingConventionsEditorMessages.RulePreferencePage_preview);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        Font textFont = JFaceResources.getTextFont();
        viewer.getTextWidget().setFont(textFont);
        return viewer;
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration();
        viewer.configure(configuration);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private static GridData getButtonGridData() {
        GridData data = new GridData(768);
        return data;
    }

    private void selectionChanged1() {
        this.updateViewerInput();
        this.updateButtons();
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            Convention convention = (Convention)selection.getFirstElement();
            this.fPatternViewer.getDocument().set(this.formatPreviewText(convention.toString()));
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection == null) {
            return;
        }
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        Convention data = (Convention)selection.getFirstElement();
        this.fDuplicateButton.setEnabled(selectionCount == 1);
        this.fEditButton.setEnabled(selectionCount == 1 && !data.isGlobal());
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount && !data.isGlobal());
    }

    private void add(Convention convention) {
        Convention newConvention = this.editConvention(convention, false, true);
        if (newConvention != null) {
            ConventionStoreUtil.add(this.fLocalConventionList, newConvention);
            ConventionStoreUtil.add(this.fAllConventionList, newConvention);
            this.fTableViewer.refresh();
            this.fTableViewer.setChecked((Object)newConvention, newConvention.getEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newConvention));
            this.convensionsChanged();
        }
    }

    private void add() {
        this.add(new Convention("", "", "", "", "", "", true));
    }

    protected Convention editConvention(Convention convention, boolean edit, boolean isNameModifiable) {
        EditNamingConventionsRuleDialog dialog = new EditNamingConventionsRuleDialog(this.getShell(), convention, edit, isNameModifiable, this.fProject);
        if (dialog.open() == 0) {
            return dialog.getConvention();
        }
        return null;
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        Convention data = (Convention)selection.getFirstElement();
        this.edit(data);
    }

    private void edit(Convention oldConvention) {
        Convention newConvention = this.editConvention(oldConvention, true, true);
        if (newConvention != null) {
            if (!newConvention.getName().equals(oldConvention.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)NamingConventionsEditorMessages.RulePreferencePage_question_create_new_title, (String)NamingConventionsEditorMessages.RulePreferencePage_question_create_new_message)) {
                ConventionStoreUtil.add(this.fLocalConventionList, newConvention);
                this.convensionsChanged();
                ConventionStoreUtil.add(this.fAllConventionList, newConvention);
                this.fTableViewer.refresh();
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newConvention));
                this.fTableViewer.setChecked((Object)newConvention, newConvention.getEnabled());
                this.fTableViewer.refresh();
            } else {
                if (!oldConvention.equals(newConvention)) {
                    this.convensionsChanged();
                }
                oldConvention.setName(newConvention.getName());
                oldConvention.setKind(newConvention.getKind());
                oldConvention.setDescription(newConvention.getDescription());
                oldConvention.setPatternString(newConvention.getPatternString());
                oldConvention.setMatch(newConvention.getMatch());
                oldConvention.setEnabled(newConvention.getEnabled());
                this.fTableViewer.refresh((Object)oldConvention);
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)oldConvention));
                this.fTableViewer.setChecked((Object)oldConvention, oldConvention.getEnabled());
                this.fTableViewer.refresh();
            }
            this.selectionChanged1();
        }
    }

    public static String messageFormat(String message, Object argument) {
        return MessageFormat.format(message, argument);
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (Convention data : selection) {
            ConventionStoreUtil.delete(data);
        }
        this.convensionsChanged();
        this.fTableViewer.refresh();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.fPerProject) {
                this.setTitle(NamingConventionsEditorMessages.RulePreferencePage_title_prj);
            } else {
                this.setTitle(NamingConventionsEditorMessages.RulePreferencePage_title_glb);
            }
        }
    }

    private void openWriteErrorDialog() {
        String title = NamingConventionsEditorMessages.RulePreferencePage_error_write_title;
        String message = NamingConventionsEditorMessages.RulePreferencePage_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    protected SourceViewer getViewer() {
        return this.fPatternViewer;
    }

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element;
    }

    public void performApply() {
        if (!this.fConvensionChanged) {
            super.performOk();
            return;
        }
        try {
            ConventionStoreUtil.save(this.fLocalConventionList, this.fProject);
            IResource dvtDirectory = this.fProject.findMember(".dvt");
            dvtDirectory.refreshLocal(1, null);
            this.fPerformedApply = true;
        }
        catch (IOException iOException) {
            this.openWriteErrorDialog();
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fLocalConventionList.clear();
        this.fGlobalConventionList.clear();
        this.fAllConventionList.clear();
        try {
            ConventionStoreUtil.loadGlobal(this.fGlobalConventionList, this.fProject);
            ConventionStoreUtil.loadLocal(this.fLocalConventionList, this.fProject);
            this.fAllConventionList.addAll(this.fGlobalConventionList);
            ConventionStoreUtil.addAll(this.fAllConventionList, this.fLocalConventionList);
        }
        catch (IOException | CoreException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        this.fTableViewer.refresh();
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledConventions());
        this.fTableViewer.refresh();
        super.performOk();
    }

    public boolean performCancel() {
        if (this.fPerformedApply && this.fProject != null) {
            RebuildOnNameChecksChangeDialog.getInstance().setChanged(1, this.fProject);
            RebuildOnNameChecksChangeDialog.getInstance().sendNotification();
        }
        return super.performCancel();
    }

    public boolean performOk() {
        if (!this.fConvensionChanged) {
            return super.performOk();
        }
        if (this.fConvensionChanged && this.fProject != null) {
            RebuildOnNameChecksChangeDialog.getInstance().setChanged(1, this.fProject);
            RebuildOnNameChecksChangeDialog.getInstance().sendNotification();
        }
        try {
            ConventionStoreUtil.save(this.fLocalConventionList, this.fProject);
            if (this.fProject != null) {
                IResource dvtDirectory = this.fProject.findMember(".dvt");
                dvtDirectory.refreshLocal(1, null);
            }
        }
        catch (IOException iOException) {
            this.openWriteErrorDialog();
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return super.performOk();
    }

    public void convensionsChanged() {
        this.fConvensionChanged = true;
    }

    private String formatPreviewText(String previewText) {
        StringBuilder result = new StringBuilder();
        String[] tokens = DVTStringUtil.split(TOKEN_SEPARATOR_PATTERN, previewText);
        int i = 0;
        while (i < tokens.length - 1) {
            result.append(tokens[i]).append(":");
            int j = tokens[i].length();
            while (j < 15) {
                result.append(" ");
                ++j;
            }
            result.append(tokens[i + 1]).append("\n");
            i += 2;
        }
        return result.toString();
    }

    static class NameCheckerContentProvider
    implements IStructuredContentProvider {
        NameCheckerContentProvider() {
        }

        public Object[] getElements(Object input) {
            List inputList = (List)input;
            ArrayList<Convention> conventions = new ArrayList<Convention>();
            int i = 0;
            while (i < inputList.size()) {
                Convention convention = (Convention)inputList.get(i);
                if (!convention.getDeleted()) {
                    conventions.add(convention);
                }
                ++i;
            }
            return conventions.toArray(new Convention[conventions.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class NameCheckerLabelProvider
    extends StyledCellLabelProvider {
        private NameCheckerLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            Convention convention = (Convention)element;
            switch (columnIndex) {
                case 0: {
                    return convention.getLanguage();
                }
                case 1: {
                    return convention.getName();
                }
                case 2: {
                    return convention.getKind();
                }
                case 3: {
                    return convention.getMatch();
                }
            }
            return convention.getLocation(false);
        }

        public void update(ViewerCell cell) {
            final Object element = cell.getElement();
            int columnIndex = cell.getColumnIndex();
            String text = this.getColumnText(element, columnIndex);
            StyledString styledString = new StyledString(text);
            StyledString.Styler styler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    Convention convention = (Convention)element;
                    if (convention.isOverriden()) {
                        textStyle.strikeout = true;
                    }
                    if (convention.isGlobal()) {
                        textStyle.foreground = Display.getCurrent().getSystemColor(18);
                    }
                }
            };
            styledString.setStyle(0, text.length(), styler);
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(null);
        }
    }
}

